
static char rcsid[] = 
	"$Id: util.c,v 3.20 1995/07/27 14:48:45 kohl Exp $";

#include "xpvm.h"

TRIE create_triestack()
{
	TRIE tptr;
	TRIE tmp;

	int i;

	tmp = (TRIE) malloc( (unsigned) TRIE_SIZE
		* sizeof( struct trie_struct ) );
	memcheck( tmp, "Trie Structure" );

	for ( i=0 ; i < TRIE_SIZE ; i++ )
	{
		tptr = &(tmp[i]);

		tptr->valid = FALSE;

		tptr->str = (char *) NULL;

		tptr->value = (void *) NULL;

		tptr->next = (TRIE) NULL;
	}

	return( tmp );
}

free_triestack( ptr )
TRIE *ptr;
{
	TRIE T;
	TRIE tptr;

	int i;

	T = *ptr;

	for ( i=0 ; i < TRIE_SIZE ; i++ )
	{
		tptr = &(T[i]);

		tptr->valid = FALSE;

		if ( tptr->str != NULL )
			free( tptr->str );

		tptr->str = (char *) NULL;

		tptr->value = (void *) NULL;

		if ( tptr->next != NULL )
			free_triestack( &(tptr->next) );
	}

	free( T );

	*ptr = (TRIE) NULL;
}

add_to_trie( T, str, value )
TRIE T;
char *str;
void *value;
{
	TRIE tptr;

	char *bump;

	int bumpindex;
	int marked;
	int index;
	int len;
	int i;

	if ( T == NULL )
		return;

	if ( str == NULL || !strcmp( str, "" ) )
		return;

	len = strlen( str ) - 1;

	marked = 0;

	for ( i=0 ; i < len && !marked ; i++ )
	{
		index = trie_index( str[i] );

		tptr = &(T[index]);

		if ( tptr->next != NULL )
			T = tptr->next;

		else
		{
			if ( !tptr->valid )
			{
				tptr->valid = TRUE;

				tptr->str = copy_str( str );

				tptr->value = value;

				marked++;
			}

			else
			{
				tptr->next = create_triestack();

				T = tptr->next;

				bump = tptr->str;

				if ( strlen( bump ) > i + 1 )
				{
					bumpindex = trie_index( bump[ i + 1 ] );

					T[bumpindex].valid = TRUE;
					T[bumpindex].str = bump;
					T[bumpindex].value = tptr->value;

					tptr->valid = FALSE;
					tptr->str = (char *) NULL;
					tptr->value = (void *) NULL;
				}
			}
		}
	}

	if ( !marked )
	{
		index = trie_index( str[len] );

		tptr = &(T[index]);

		if ( tptr->valid )
		{
			bump = tptr->str;

			if ( strlen( bump ) > len + 1 )
			{
				if ( tptr->next == NULL )
					tptr->next = create_triestack();

				T = tptr->next;

				bumpindex = trie_index( bump[ len + 1 ] );

				T[bumpindex].valid = TRUE;
				T[bumpindex].str = bump;
				T[bumpindex].value = tptr->value;
			}

			else
			{
				printf( "\nError: Duplicate %s (%x)\n\n",
					bump, tptr->value );

				error_exit();
			}
		}

		tptr->valid = TRUE;

		tptr->str = copy_str( str );

		tptr->value = value;
	}
}

void *lookup_trie( T, str )
TRIE T;
char *str;
{
	TRIE tptr;

	char *ptr;

	int len;
	int i;

	len = strlen( str ) - 1;

	ptr = str;

	for ( i=0 ; i < len ; i++ )
	{
		tptr = &(T[ trie_index( *ptr++ ) ]);

		if ( tptr->next != NULL )
			T = tptr->next;

		else
		{
			if ( tptr->valid && !strcmp( tptr->str, str ) )
				return( tptr->value );

			else
				return( (void *) NULL );
		}
	}

	tptr = &(T[ trie_index( *ptr ) ]);

	if ( tptr->valid && !strcmp( tptr->str, str ) )
		return( tptr->value );

	else
		return( (void *) NULL );
}

trie_index( c )
char c;
{
	int index;

	if ( c >= 'a' && c <= 'z' )
		index = (int) ( c - 'a' );

	else if ( c >= 'A' && c <= 'Z' )
		index = (int) ( c - 'A' );
	
	else if ( c >= '0' && c <= '9' )
		index = 26 + (int) ( c - '0' );

	else
		index = TRIE_SIZE - 1;

	return( index );
}

TCL_GLOBAL create_tcl_global()
{
	TCL_GLOBAL tmp;

	int i;

	tmp = (TCL_GLOBAL) malloc( sizeof( struct tcl_glob_struct ) );
	memcheck( tmp, "TCL Global Structure" );

	tmp->name = (char *) NULL;

	tmp->type = -1;

	tmp->char_value = (char *) NULL;

	tmp->int_value = -1;

	return( tmp );
}

free_tcl_global( ptr )
TCL_GLOBAL *ptr;
{
	TCL_GLOBAL G;

	G = *ptr;

	G->name = (char *) NULL;

	G->type = -1;

	G->char_value = (char *) NULL;

	G->int_value = -1;

	free( G );

	*ptr = (TCL_GLOBAL) NULL;
}

TRACE_MASK_GROUP create_trace_mask_group()
{
	TRACE_MASK_GROUP tmp;

	tmp = (TRACE_MASK_GROUP) malloc(
		sizeof( struct trace_mask_group_struct ) );
	memcheck( tmp, "Trace Mask Group Structure" );

	tmp->name = (char *) NULL;

	tmp->tmask = (char *) NULL;

	tmp->next = (TRACE_MASK_GROUP) NULL;

	return( tmp );
}

TRACE_MASK_GROUP lookup_trace_mask_group( TMG_LIST, name )
TRACE_MASK_GROUP TMG_LIST;
char *name;
{
	TRACE_MASK_GROUP TMG;

	TMG = TMG_LIST;

	while ( TMG != NULL )
	{
		if ( !strcmp( name, TMG->name ) )
			return( TMG );

		TMG = TMG->next;
	}

	return( (TRACE_MASK_GROUP) NULL );
}

set_trace_format( fmt, interface )
int fmt;
int interface;
{
	char cmd[255];

	TRACE_FORMAT = fmt;

	if ( fmt == TEV_FMT_33 )
	{
		CURRENT_GROUP_LIST = &TM33_GROUP_LIST;

		CURRENT_INDEX_LIST = &TM33_INDEX_LIST;

		CURRENT_TRACE_MASK = TRACE33_MASK;

		if ( interface )
			strcpy( cmd, "set_trace_format 3.3" );
	}

	else
	{
		CURRENT_GROUP_LIST = &TM_GROUP_LIST;

		CURRENT_INDEX_LIST = &TM_INDEX_LIST;

		CURRENT_TRACE_MASK = TRACE_MASK;

		if ( interface )
			strcpy( cmd, "set_trace_format 3.3" );
	}

	if ( interface )
	{
		pvm_settmask( PvmTaskChild, CURRENT_TRACE_MASK );

		Tcl_Eval( interp, cmd );
	}
}

set_trace_mask_buttons( itp, TMASK, TMG_LIST, TMI_LIST, fmt )
Tcl_Interp *itp;
char *TMASK;
TRACE_MASK_GROUP TMG_LIST;
TRACE_MASK_INDEX TMI_LIST;
int fmt;
{
	TRACE_MASK_GROUP TMG;

	TRACE_MASK_INDEX TMI;

	char *TM;

	char result[2048];
	char tmp[4096];

	int nope;
	int j;

	strcpy( result, "" );

	/* Set Regular Event Buttons */

	TMI = TMI_LIST;

	while ( TMI != NULL )
	{
		if ( CHECK_TRACE_MASK( TMASK, fmt, TMI->index ) )
			sprintf( tmp, "{ %s ON } ", TMI->name );

		else
			sprintf( tmp, "{ %s OFF } ", TMI->name );

		append_cmd_str( result, tmp, 2048, "trace_mask_result",
			TRUE );

		TMI = TMI->next;
	}

	/* Check Group Event Buttons */

	TMG = TMG_LIST;

	while ( TMG != NULL )
	{
		TM = TMG->tmask;

		nope = FALSE;

		for ( j=FIRST_EVENT( fmt ) ; j <= LAST_EVENT( fmt ) && !nope ;
			j += EVENT_INCR( fmt ) )
		{
			if ( CHECK_TRACE_MASK( TM, fmt, j )
				&& !CHECK_TRACE_MASK( TMASK, fmt, j ) )
			{
				nope = TRUE;
			}
		}

		if ( nope )
			sprintf( tmp, "{ %s OFF } ", TMG->name );

		else
			sprintf( tmp, "{ %s ON } ", TMG->name );

		append_cmd_str( result, tmp, 2048, "trace_mask_result",
			TRUE );

		TMG = TMG->next;
	}

	sprintf( tmp, "trace_mask_result { %s }", result );

	Tcl_Eval( itp, tmp );
}

TRACE_MASK_INDEX create_trace_mask_index()
{
	TRACE_MASK_INDEX tmp;

	tmp = (TRACE_MASK_INDEX) malloc(
		sizeof( struct trace_mask_index_struct ) );
	memcheck( tmp, "Trace Mask Index Structure" );

	tmp->name = (char *) NULL;

	tmp->index = -1;

	tmp->next = (TRACE_MASK_INDEX) NULL;

	return( tmp );
}

set_trace_mask_index( TMI_LIST, name, index )
TRACE_MASK_INDEX *TMI_LIST;
char *name;
int index;
{
	TRACE_MASK_INDEX TMI;

	TMI = create_trace_mask_index();

	if ( *TMI_LIST == NULL )
		*TMI_LIST = TMI;

	else
	{
		TMI->next = *TMI_LIST;

		*TMI_LIST = TMI;
	}

	TMI->name = name;
	TMI->index = index;
}

TRACE_MASK_INDEX lookup_trace_mask_name( TMI_LIST, name )
TRACE_MASK_INDEX TMI_LIST;
char *name;
{
	TRACE_MASK_INDEX TMI;

	TMI = TMI_LIST;

	while ( TMI != NULL && strcmp( name, TMI->name ) )
		TMI = TMI->next;

	return( TMI );
}

DID create_did()
{
	DID tmp;

	tmp = (DID) malloc( sizeof( struct did_struct ) );
	memcheck( tmp, "Semantic Data ID Structure" );

	sprintf( tmp->name, "\0\0\0\0" );

	tmp->desc = (char *) NULL;

	tmp->next = (DID) NULL;

	return( tmp );
}

cmp_did( did1, did2 )
DID did1, did2;
{
	if ( strcmp( did1->name, did2->name ) )
		return( FALSE );
	
	if ( strcmp( did1->desc, did2->desc ) )
		return( FALSE );
	
	return( TRUE );
}

DATADESC create_datadesc()
{
	DATADESC tmp;

	tmp = (DATADESC) malloc( sizeof( struct datadesc_struct ) );
	memcheck( tmp, "Data Description Structure" );

	tmp->did = (DID) NULL;

	tmp->dt = -1;

	tmp->array = -1;

	tmp->next = (DATADESC) NULL;

	return( tmp );
}

free_datadesc( ptr )
DATADESC *ptr;
{
	DATADESC DD;

	DD = *ptr;

	DD->did = (DID) NULL;

	DD->dt = -1;

	DD->array = -1;

	DD->next = (DATADESC) NULL;

	free( DD );

	*ptr = (DATADESC) NULL;
}

cmp_datadesc( DD1, DD2 )
DATADESC DD1, DD2;
{
	if ( !cmp_did( DD1->did, DD2->did ) )
		return( FALSE );

	if ( DD1->dt != DD2->dt || DD1->array != DD2->array )
		return( FALSE );

	return( TRUE );
}

get_dt_str( dtstr )
char *dtstr;
{
	int i;

	for ( i=0 ; i < 16 ; i++ )
	{
		if ( !strcmp( TYPE_STRS[i], dtstr ) )
			return( i );
	}

	return( -1 );
}

TEVDESC create_tevdesc()
{
	TEVDESC tmp;

	tmp = (TEVDESC) malloc( sizeof( struct tevdesc_struct ) );
	memcheck( tmp, "Trace Event Descriptor Structure" );

	tmp->name = (char *) NULL;

	tmp->eid = -1;

	tmp->entry_exit = -1;

	tmp->index = -1;

	tmp->hid = -1;

	tmp->dump = -1;

	tmp->ddesc = (DATADESC) NULL;

	tmp->next = (TEVDESC) NULL;

	return( tmp );
}

free_tevdesc( ptr )
TEVDESC *ptr;
{
	TEVDESC TD;

	DATADESC DD;
	DATADESC DDnext;

	TD = *ptr;

	if ( TD->name != NULL )
		free( TD->name );

	TD->name = (char *) NULL;

	TD->eid = -1;

	TD->entry_exit = -1;

	TD->index = -1;

	TD->hid = -1;

	TD->dump = -1;

	DD = TD->ddesc;

	while ( DD != NULL )
	{
		DDnext = DD->next;

		free_datadesc( &DD );

		DD = DDnext;
	}

	TD->ddesc = (DATADESC) NULL;

	TD->next = (TEVDESC) NULL;

	free( TD );

	*ptr = (TEVDESC) NULL;
}

cmp_tevdesc( TD1, TD2 )
TEVDESC TD1, TD2;
{
	DATADESC DD1, DD2;

	if ( strcmp( TD1->name, TD2->name ) )
		return( FALSE );

	if ( TD1->eid != TD2->eid || TD1->entry_exit != TD2->entry_exit )
		return( FALSE );

	/* Ignore index & hid & dump */

	DD1 = TD1->ddesc;
	DD2 = TD2->ddesc;

	while ( DD1 != NULL && DD2 != NULL )
	{
		if ( !cmp_datadesc( DD1, DD2 ) )
			return( FALSE );

		DD1 = DD1->next;
		DD2 = DD2->next;
	}

	if ( DD1 != NULL || DD2 != NULL )
		return( FALSE );

	return( TRUE );
}

TEVREC create_tevrec()
{
	TEVREC tmp;

	tmp = (TEVREC) malloc( sizeof( struct tevrec_struct ) );
	memcheck( tmp, "Trace Event Record Structure" );

	tmp->ddesc = (DATADESC) NULL;

	tmp->value = (VALUE) NULL;

	tmp->num = -1;

	tmp->next = (TEVREC) NULL;

	return( tmp );
}

free_tevrec( ptr )
TEVREC *ptr;
{
	TEVREC TR;

	TR = *ptr;

	TR->ddesc = (DATADESC) NULL;

	if ( TR->value != NULL )
		free( TR->value );
	
	TR->value = (VALUE) NULL;

	TR->num = -1;

	TR->next = (TEVREC) NULL;

	free( *ptr );

	*ptr = (TEVREC) NULL;
}

TEVREC get_tevrec( TR, did )
TEVREC TR;
char *did;
{
	TEVREC trptr;

	trptr = TR;

	while ( trptr != NULL )
	{
		if ( compare( did, trptr->ddesc->did->name ) )
			return( trptr );

		trptr = trptr->next;
	}

	return( trptr );
}

char *tevrec_string( TD, TR, tid, tsec, tusec )
TEVDESC TD;
TEVREC TR;
int tid;
int tsec;
int tusec;
{
	DATADESC DD;

	TEVREC trptr;

	char event_str[2048];
	char tmp[2048];

	char *tusec_pad;
	char *ptr;

	int first;
	int i;

	/* Dump Header Text */

	tusec_pad = pad_num( tusec, 6 );

	sprintf( event_str, "%s.%d @ %d.%s",
		TD->name, TD->entry_exit, tsec, tusec_pad );

	free( tusec_pad );

	/* Dump Event Data */

	first = TRUE;

	trptr = TR;

	while ( trptr != NULL )
	{
		DD = trptr->ddesc;

		/* Skip Over TS, TU, and TID */

		if ( strcmp( DD->did->name, "TS " )
			&& strcmp( DD->did->name, "TU " )
			&& strcmp( DD->did->name, "TID" ) )
		{
			/* Check for first data item -> put out : */

			if ( first )
			{
				append_cmd_str( event_str, ": ", 2048,
					(char *) NULL, FALSE );

				first = FALSE;
			}

			/* Get Data Name */

			ptr = DD->did->name;

			i = 0;

			while ( *ptr != ' ' && *ptr != '\0' )
				tmp[i++] = *ptr++;

			tmp[i++] = '=';
			tmp[i++] = '\0';

			append_cmd_str( event_str, tmp, 2048,
				(char *) NULL, FALSE );

			/* Get Data Itself */

			switch( DD->dt )
			{
				case TEV_DATA_NULL: break;

				case TEV_DATA_BYTE:
				{
					sprintf( tmp, "{%s}", (char *) trptr->value );

					append_cmd_str( event_str, tmp, 2048,
						(char *) NULL, FALSE );

					break;
				}

				case TEV_DATA_CPLX:
				case TEV_DATA_FLOAT:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%f, ", 
							ARR_VALUE_OF( trptr->value, float, i ) );
						}

						else
						{
							sprintf( tmp, "%f", 
							ARR_VALUE_OF( trptr->value, float, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_DCPLX:
				case TEV_DATA_DOUBLE:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%lf, ", 
							ARR_VALUE_OF( trptr->value, double, i ) );
						}

						else
						{
							sprintf( tmp, "%lf", 
							ARR_VALUE_OF( trptr->value, double, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_INT:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%d, ", 
								ARR_VALUE_OF( trptr->value, int, i ) );
						}

						else
						{
							sprintf( tmp, "%d", 
								ARR_VALUE_OF( trptr->value, int, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_UINT:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%u, ", 
							ARR_VALUE_OF( trptr->value, unsigned, i ) );
						}

						else
						{
							sprintf( tmp, "%u", 
							ARR_VALUE_OF( trptr->value, unsigned, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_LONG:
				case TEV_DATA_ULONG:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%ld, ", 
								ARR_VALUE_OF( trptr->value, long, i ) );
						}

						else
						{
							sprintf( tmp, "%ld", 
								ARR_VALUE_OF( trptr->value, long, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_SHORT:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%d, ", 
							ARR_VALUE_OF( trptr->value, short, i ) );
						}

						else
						{
							sprintf( tmp, "%d", 
							ARR_VALUE_OF( trptr->value, short, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_USHORT:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "%d, ", 
							ARR_VALUE_OF( trptr->value, short, i ) );
						}

						else
						{
							sprintf( tmp, "%d", 
							ARR_VALUE_OF( trptr->value, short, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_STRING:
				{
					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, "{ ", 2048,
							(char *) NULL, FALSE );
					}

					for ( i=0 ; i < trptr->num ; i++ )
					{
						if ( i < trptr->num - 1 )
						{
							sprintf( tmp, "{%s}, ",
							ARR_VALUE_OF( trptr->value, char *, i ) );
						}

						else
						{
							sprintf( tmp, "{%s}",
							ARR_VALUE_OF( trptr->value, char *, i ) );
						}

						append_cmd_str( event_str, tmp, 2048,
							(char *) NULL, FALSE );
					}

					if ( trptr->num > 1 )
					{
						append_cmd_str( event_str, " }", 2048,
							(char *) NULL, FALSE );
					}

					break;
				}

				case TEV_DATA_STRUCT_START:
				case TEV_DATA_STRUCT_END:
				case TEV_DATA_DEFERRED:
				{
					sprintf( tmp, "<DT Not Impl>" );

					append_cmd_str( event_str, tmp, 2048,
						(char *) NULL, FALSE );
				}

				default:
				{
					sprintf( tmp, "<DT Unknown>" );

					append_cmd_str( event_str, tmp, 2048,
						(char *) NULL, FALSE );
				}
			}

			if ( trptr->next != NULL )
			{
				sprintf( tmp, ", " );

				append_cmd_str( event_str, tmp, 2048,
					(char *) NULL, FALSE );
			}
		}

		trptr = trptr->next;
	}

	append_cmd_str( event_str, ".", 2048, (char *) NULL, FALSE );

	return( copy_str( event_str ) );
}

dump_tevrec( name, entry_exit, index, TR )
char *name;
int entry_exit;
int index;
TEVREC TR;
{
	DATADESC DD;

	TEVREC trptr;

	int i;

	printf( "%s(%d,%d): ", name, entry_exit, index );

	trptr = TR;

	while ( trptr != NULL )
	{
		DD = trptr->ddesc;

		printf( "{ %s = ", DD->did->name );

		/* matching } */

		switch( DD->dt )
		{
			case TEV_DATA_NULL: break;

			case TEV_DATA_BYTE:
			{
				printf( "\"%s\"", (char *) trptr->value );

				break;
			}

			case TEV_DATA_CPLX:
			case TEV_DATA_FLOAT:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%f", 
						ARR_VALUE_OF( trptr->value, float, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_DCPLX:
			case TEV_DATA_DOUBLE:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%lf", 
						ARR_VALUE_OF( trptr->value, double, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_INT:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%d", 
						ARR_VALUE_OF( trptr->value, int, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_UINT:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%u", 
						ARR_VALUE_OF( trptr->value, unsigned, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_LONG:
			case TEV_DATA_ULONG:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%ld", 
						ARR_VALUE_OF( trptr->value, long, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_SHORT:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%d", 
						ARR_VALUE_OF( trptr->value, short, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_USHORT:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "%d", 
						ARR_VALUE_OF( trptr->value, short, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_STRING:
			{
				for ( i=0 ; i < trptr->num ; i++ )
				{
					printf( "\"%s\"",
						ARR_VALUE_OF( trptr->value, char *, i ) );

					if ( i < trptr->num - 1 )
						printf( "," );
				}

				break;
			}

			case TEV_DATA_STRUCT_START:
			case TEV_DATA_STRUCT_END:
			case TEV_DATA_DEFERRED:
			{
				printf( "DT Not Impl" );
			}

			default:
				printf( "DT Unknown" );
		}

		/* matching { */

		printf( " }" );

		if ( trptr->next != NULL )
			printf( ", " );
		
		else
			printf( "\n" );

		trptr = trptr->next;
	}
}

VALUE make_value( dt, num )
int dt;
int num;
{
	VALUE tmp;

	int i;

	if ( num < 1 )
		return( (VALUE) NULL );

	tmp = (VALUE) NULL;

	switch ( dt )
	{
		case TEV_DATA_NULL: break;

		case TEV_DATA_BYTE:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( char ) );
			memcheck( tmp, "Character Data Pointer" );

			break;
		}

		case TEV_DATA_STRING:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( char * ) );
			memcheck( tmp, "String Data Pointer" );

			break;
		}

		case TEV_DATA_DCPLX:
		case TEV_DATA_DOUBLE:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( double ) );
			memcheck( tmp, "Double Data Pointer" );

			break;
		}

		case TEV_DATA_CPLX:
		case TEV_DATA_FLOAT:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( float ) );
			memcheck( tmp, "Float Data Pointer" );

			break;
		}

		case TEV_DATA_INT:
		case TEV_DATA_UINT:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( int ) );
			memcheck( tmp, "Integer Data Pointer" );

			break;
		}

		case TEV_DATA_LONG:
		case TEV_DATA_ULONG:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( long ) );
			memcheck( tmp, "Long Integer Data Pointer" );

			break;
		}

		case TEV_DATA_SHORT:
		case TEV_DATA_USHORT:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( short ) );
			memcheck( tmp, "Short Integer Data Pointer" );

			break;
		}

		case TEV_DATA_STRUCT_START:
		case TEV_DATA_STRUCT_END:
		case TEV_DATA_DEFERRED:
		{
			printf( "Value Data Type %d Not Implemented\n", dt );

			break;
		}

		default:
			printf( "Warning: Unknown Value Data Type %d\n", dt );
	}

	return( tmp );
}

VALUE copy_value( V, dt, num )
VALUE V;
int dt;
int num;
{
	VALUE tmp;

	int i;

	if ( V == NULL || num < 1 )
		return( (VALUE) NULL );

	tmp = (VALUE) NULL;

	switch ( dt )
	{
		case TEV_DATA_NULL: break;

		case TEV_DATA_BYTE:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( char ) );
			memcheck( tmp, "Character Data Pointer" );

			for ( i=0 ; i < num ; i++ )
			{
				ARR_VALUE_OF( tmp, char, i ) =
					ARR_VALUE_OF( V, char, i );
			}

			break;
		}

		case TEV_DATA_STRING:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( char * ) );
			memcheck( tmp, "String Data Pointer" );

			for ( i=0 ; i < num ; i++ )
			{
				ARR_VALUE_OF( tmp, char *, i ) =
					copy_str( ARR_VALUE_OF( V, char *, i ) );
			}

			break;
		}

		case TEV_DATA_DCPLX:
		case TEV_DATA_DOUBLE:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( double ) );
			memcheck( tmp, "Double Data Pointer" );

			for ( i=0 ; i < num ; i++ )
			{
				ARR_VALUE_OF( tmp, double, i ) =
					ARR_VALUE_OF( V, double, i );
			}

			break;
		}

		case TEV_DATA_CPLX:
		case TEV_DATA_FLOAT:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( float ) );
			memcheck( tmp, "Float Data Pointer" );

			for ( i=0 ; i < num ; i++ )
			{
				ARR_VALUE_OF( tmp, float, i ) =
					ARR_VALUE_OF( V, float, i );
			}

			break;
		}

		case TEV_DATA_INT:
		case TEV_DATA_UINT:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( int ) );
			memcheck( tmp, "Integer Data Pointer" );

			for ( i=0 ; i < num ; i++ )
				ARR_VALUE_OF( tmp, int, i ) = ARR_VALUE_OF( V, int, i );

			break;
		}

		case TEV_DATA_LONG:
		case TEV_DATA_ULONG:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( long ) );
			memcheck( tmp, "Long Integer Data Pointer" );

			for ( i=0 ; i < num ; i++ )
			{
				ARR_VALUE_OF( tmp, long, i ) =
					ARR_VALUE_OF( V, long, i );
			}

			break;
		}

		case TEV_DATA_SHORT:
		case TEV_DATA_USHORT:
		{
			tmp = (VALUE) malloc( (unsigned) num * sizeof( short ) );
			memcheck( tmp, "Short Integer Data Pointer" );

			for ( i=0 ; i < num ; i++ )
			{
				ARR_VALUE_OF( tmp, short, i ) =
					ARR_VALUE_OF( V, short, i );
			}

			break;
		}

		case TEV_DATA_STRUCT_START:
		case TEV_DATA_STRUCT_END:
		case TEV_DATA_DEFERRED:
		{
			printf( "Value Data Type %d Not Implemented\n", dt );

			break;
		}

		default:
			printf( "Warning: Unknown Value Data Type %d\n", dt );
	}

	return( tmp );
}

GOBJ create_gobj()
{
	GOBJ tmp;

	int i;

	tmp = (GOBJ) malloc( sizeof( struct gobj_struct ) );
	memcheck( tmp, "Graphical Object Structure" );

	tmp->id = -1;

	for ( i=0 ; i < MAX_GOBJ_COORDS ; i++ )
		tmp->coords[i] = -1;

	tmp->color = (char *) NULL;

	return( tmp );
}

free_gobj( ptr )
GOBJ *ptr;
{
	GOBJ G;

	int i;

	G = *ptr;

	G->id = -1;

	for ( i=0 ; i < MAX_GOBJ_COORDS ; i++ )
		G->coords[i] = -1;

	G->color = (char *) NULL;

	free( G );

	*ptr = (GOBJ) NULL;
}

MSG create_msg()
{
	MSG tmp;

	tmp = (MSG) malloc( sizeof( struct msg_struct ) );
	memcheck( tmp, "Message Structure" );

	tmp->ST = (TASK) NULL;
	tmp->DT = (TASK) NULL;

	tmp->src_tid = -1;
	tmp->dst_tid = -1;
	tmp->msgtag = -1;
	tmp->nbytes = -1;
	tmp->assbytes = -1;

	tmp->sendtime.tv_sec = -1;
	tmp->sendtime.tv_usec = -1;

	tmp->recvtime.tv_sec = -1;
	tmp->recvtime.tv_usec = -1;

	tmp->line = (GOBJ) NULL;

	tmp->prev = (MSG) NULL;
	tmp->next = (MSG) NULL;

	return( tmp );
}

free_msg( ptr )
MSG *ptr;
{
	MSG M;

	M = *ptr;

	M->ST = (TASK) NULL;
	M->DT = (TASK) NULL;

	M->src_tid = -1;
	M->dst_tid = -1;
	M->msgtag = -1;
	M->nbytes = -1;
	M->assbytes = -1;

	M->sendtime.tv_sec = -1;
	M->sendtime.tv_usec = -1;

	M->recvtime.tv_sec = -1;
	M->recvtime.tv_usec = -1;

	M->line = (GOBJ) NULL;

	M->prev = (MSG) NULL;
	M->next = (MSG) NULL;

	free( M );

	*ptr = (MSG) NULL;
}

MSGQ create_msgq()
{
	MSGQ tmp;

	tmp = (MSGQ) malloc( sizeof( struct msgq_struct ) );
	memcheck( tmp, "Message Queue Structure" );

	tmp->msg = (MSG) NULL;

	tmp->rect = (GOBJ) NULL;

	tmp->next = (MSGQ) NULL;

	return( tmp );
}

free_msgq( ptr )
MSGQ *ptr;
{
	MSGQ Q;

	Q = *ptr;

	Q->msg = (MSG) NULL;

	Q->rect = (GOBJ) NULL;

	Q->next = (MSGQ) NULL;

	free( Q );

	*ptr = (MSGQ) NULL;
}

MSG_GRID create_msg_grid()
{
	MSG_GRID tmp;

	tmp = (MSG_GRID) malloc( sizeof( struct msg_grid_struct ) );
	memcheck( tmp, "Message Grid Structure" );

	tmp->msg = (MSG) NULL;

	tmp->next = (MSG_GRID) NULL;

	return( tmp );
}

free_msg_grid( ptr )
MSG_GRID *ptr;
{
	MSG_GRID G;

	G = *ptr;

	G->msg = (MSG) NULL;

	G->next = (MSG_GRID) NULL;

	free( G );

	*ptr = (MSG_GRID) NULL;
}

TEVTASK create_tevtask()
{
	TEVTASK tmp;

	tmp = (TEVTASK) malloc( sizeof( struct tevtask_struct ) );
	memcheck( tmp, "TEV Task Structure" );

	tmp->tid = -1;
	tmp->tevstatus = -1;
	tmp->outstatus = -1;

	tmp->tevlist = (int *) NULL;
	tmp->tevsize = -1;

	tmp->next = (TEVTASK) NULL;

	return( tmp );
}

free_tevtask( ptr )
TEVTASK *ptr;
{
	TEVTASK T;

	T = *ptr;

	T->tid = -1;
	T->tevstatus = -1;
	T->outstatus = -1;

	if ( T->tevlist != NULL )
		free( T->tevlist );

	T->tevlist = (int *) NULL;
	T->tevsize = -1;

	T->next = (TEVTASK) NULL;

	free( T );

	*ptr = (TEVTASK) NULL;
}

free_tevtasklist()
{
	TEVTASK TT;
	TEVTASK next;

	TT = TEVTASK_LIST;

	while ( TT != NULL )
	{
		next = TT->next;

		free_tevtask( &TT );

		TT = next;
	}

	TEVTASK_LIST = (TEVTASK) NULL;
}

TEVTASK get_tevtask_tid( tid )
int tid;
{
	TEVTASK T;

	T = TEVTASK_LIST;

	while ( T != NULL )
	{
		/* printf( "E" ); fflush( stdout ); */

		if ( T->tid == tid )
			return( T );

		T = T->next;
	}

	return( (TEVTASK) NULL );
}

tevtasks_alive()
{
	TEVTASK T;

	T = TEVTASK_LIST;

	while ( T != NULL )
	{
		/* printf( "a" ); fflush( stdout ); */

		if ( T->tevstatus == TASK_ALIVE || T->outstatus == TASK_OUT )
			return( TRUE );

		T = T->next;
	}

	return( FALSE );
}

STATE create_state()
{
	STATE tmp;

	tmp = (STATE) malloc( sizeof( struct state_struct ) );
	memcheck( tmp, "Task State Structure" );

	tmp->status = -1;

	tmp->callstr = (char *) NULL;

	tmp->rect = (GOBJ) NULL;

	tmp->starttime.tv_sec = -1;
	tmp->starttime.tv_usec = -1;

	tmp->endtime.tv_sec = -1;
	tmp->endtime.tv_usec = -1;

	tmp->next = (STATE) NULL;

	return( tmp );
}

free_state( ptr )
STATE *ptr;
{
	STATE S;

	S = *ptr;

	S->status = -1;

	S->callstr = (char *) NULL;

	S->rect = (GOBJ) NULL;

	S->starttime.tv_sec = -1;
	S->starttime.tv_usec = -1;

	S->endtime.tv_sec = -1;
	S->endtime.tv_usec = -1;

	S->next = (STATE) NULL;

	free( S );

	*ptr = (STATE) NULL;
}

TASK create_task()
{
	TASK tmp;

	tmp = (TASK) malloc( sizeof( struct task_struct ) );
	memcheck( tmp, "Task Structure" );

	tmp->name = (char *) NULL;

	tmp->tid = -1;
	tmp->ptid = -1;
	tmp->pvmd_tid = -1;

	tmp->host = (HOST) NULL;

	tmp->flags = -1;
	tmp->status = -1;

	tmp->index = -1;

	tmp->y1 = tmp->y2 = -1;

	tmp->st_label = (GOBJ) NULL;

	tmp->ct_label = (GOBJ) NULL;
	tmp->ct_callstr = (GOBJ) NULL;

	tmp->states = (STATE) NULL;

	tmp->msgq = (MSGQ) NULL;

	tmp->mqmark = (GOBJ) NULL;

	tmp->mqcnt = -1;
	tmp->mqbytes = -1;

	tmp->next = (TASK) NULL;

	return( tmp );
}

free_task( ptr )
TASK *ptr;
{
	TASK T;

	STATE S;
	STATE stmp;

	T = *ptr;

	if ( T->name != NULL )
		free( T->name );
	
	T->tid = -1;
	T->ptid = -1;
	T->pvmd_tid = -1;

	T->host = (HOST) NULL;

	T->flags = -1;
	T->status = -1;

	T->index = -1;

	T->y1 = T->y2 = -1;

	T->st_label = (GOBJ) NULL;

	T->ct_label = (GOBJ) NULL;

	T->ct_callstr = (GOBJ) NULL;

	if ( T->states != NULL )
	{
		S = T->states;

		while ( S != NULL )
		{
			stmp = S->next;

			free_state( &S );

			S = stmp;
		}
	}

	T->states = (STATE) NULL;

	T->msgq = (MSGQ) NULL;

	T->mqmark = (GOBJ) NULL;

	T->mqcnt = -1;
	T->mqbytes = -1;

	T->next = (TASK) NULL;

	free( T );

	*ptr = (TASK) NULL;
}

TASK get_task_tid( tid )
int tid;
{
	TASK T;

	T = TASK_LIST;

	while ( T != NULL )
	{
		/* printf( "T" ); fflush( stdout ); */

		if ( T->tid == tid )
			return( T );

		T = T->next;
	}

	return( (TASK) NULL );
}

tasks_alive()
{
	TASK T;

	T = TASK_LIST;

	while ( T != NULL )
	{
		/* printf( "A" ); fflush( stdout ); */

		if ( T->status == TASK_ALIVE )
			return( TRUE );

		T = T->next;
	}

	return( FALSE );
}

UT_STATE create_ut_state()
{
	UT_STATE tmp;

	int i;

	tmp = (UT_STATE) malloc( sizeof( struct ut_state_struct ) );
	memcheck( tmp, "Utilization State Structure" );

	tmp->valid = -1;

	tmp->running = (GOBJ) NULL;
	tmp->system = (GOBJ) NULL;
	tmp->idle = (GOBJ) NULL;

	for ( i=0 ; i < MAX_STATE ; i++ )
		tmp->counts[i] = -1;

	tmp->starttime.tv_sec = -1;
	tmp->starttime.tv_usec = -1;

	tmp->endtime.tv_sec = -1;
	tmp->endtime.tv_usec = -1;

	tmp->next = (UT_STATE) NULL;

	return( tmp );
}

free_ut_state( ptr )
UT_STATE *ptr;
{
	UT_STATE U;

	int i;

	U = *ptr;

	U->valid = -1;

	U->running = (GOBJ) NULL;
	U->system = (GOBJ) NULL;
	U->idle = (GOBJ) NULL;

	for ( i=0 ; i < MAX_STATE ; i++ )
		U->counts[i] = -1;

	U->starttime.tv_sec = -1;
	U->starttime.tv_usec = -1;

	U->endtime.tv_sec = -1;
	U->endtime.tv_usec = -1;

	U->next = (UT_STATE) NULL;

	free( U );

	*ptr = (UT_STATE) NULL;
}

ARCH create_arch()
{
	ARCH tmp;

	tmp = (ARCH) malloc( sizeof( struct arch_struct ) );
	memcheck( tmp, "Architecture Structure" );

	tmp->code = (char *) NULL;

	tmp->name = (char *) NULL;

	tmp->height = -1;
	tmp->width = -1;

	tmp->next = (ARCH) NULL;

	return( tmp );
}

ARCH get_arch_code( name )
char *name;
{
	ARCH A;
	ARCH last;

	ARCH dummy;
	ARCH tmp;

	if ( name == NULL )
		return( (ARCH) NULL );

	tmp = (ARCH) NULL;

	A = ARCH_LIST;

	last = (ARCH) NULL;

	while ( A != NULL && tmp == NULL )
	{
		if ( !strcmp( name, A->code ) )
			tmp = A;

		else
		{
			last = A;

			A = A->next;
		}
	}

	if ( tmp == NULL )
	{
		printf( "\nWarning: Missing Architecture Icon for %s\n\n",
			name );

		dummy = get_arch_code( "DUMMY" );

		if ( last == NULL )
			tmp = ARCH_LIST = create_arch();
		
		else
			tmp = last->next = create_arch();

		tmp->code = copy_str( name );

		tmp->name = copy_str( dummy->name );

		tmp->height = dummy->height;
		tmp->width = dummy->width;
	}

	return( tmp );
}

NETLINK create_netlink()
{
	NETLINK tmp;

	tmp = (NETLINK) malloc( sizeof( struct netlink_struct ) );
	memcheck( tmp, "Network Link Structure" );

	tmp->link = (GOBJ) NULL;

	tmp->msg_bytes = 0;

	tmp->msg_bw = 0;

	tmp->bw_start.tv_usec = 0;
	tmp->bw_start.tv_sec = 0;

	tmp->bw_end.tv_usec = 0;
	tmp->bw_end.tv_sec = 0;

	return( tmp );
}

free_netlink( ptr )
NETLINK *ptr;
{
	NETLINK L;

	L = *ptr;

	L->link = (GOBJ) NULL;

	L->msg_bytes = -1;

	L->msg_bw = -1;

	L->bw_start.tv_usec = -1;
	L->bw_start.tv_sec = -1;

	L->bw_end.tv_usec = -1;
	L->bw_end.tv_sec = -1;

	free( *ptr );

	*ptr = (NETLINK) NULL;
}

HOST create_host()
{
	HOST tmp;

	int i;

	tmp = (HOST) malloc( sizeof( struct host_struct ) );
	memcheck( tmp, "Host Structure" );

	tmp->name = (char *) NULL;
	tmp->alias = (char *) NULL;
	tmp->refname = (char *) NULL;

	tmp->arch = (ARCH) NULL;

	tmp->delta.tv_usec = 0;
	tmp->delta.tv_sec = 0;

	tmp->pvmd_tid = -1;
	tmp->in_pvm = -1;
	tmp->speed = -1;

	/* Tracing Info */

	tmp->tevlist = (int *) NULL;
	tmp->tevsize = -1;

	/* Network Fields */

	tmp->index = -1;

	tmp->status = -1;

	for ( i=0 ; i < MAX_STATE ; i++ )
		tmp->counts[i] = -1;

	tmp->color = (char *) NULL;
	tmp->menuvar = (char *) NULL;

	tmp->icon = (GOBJ) NULL;
	tmp->nme = (GOBJ) NULL;
	tmp->box = (GOBJ) NULL;

	for ( i=0 ; i < MAX_LINK ; i++ )
		tmp->links[i] = (NETLINK) NULL;

	tmp->subnet = (NETWORK) NULL;

	tmp->next = (HOST) NULL;

	return( tmp );
}

HOST get_host_name( name )
char *name;
{
	HOST H;

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( HOST_COMPARE( H, name ) )
			return( H );

		H = H->next;
	}

	return( (HOST) NULL );
}

HOST get_host_index( index )
int index;
{
	HOST H;

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->index == index )
			return( H );

		H = H->next;
	}

	return( (HOST) NULL );
}

HOST get_host_tid( tid, type )
int tid;
int type;
{
	HOST H;

	H = MAIN_NET->host_list;

	if ( type == IN_PVM )
	{
		while ( H != NULL )
		{
			if ( H->pvmd_tid == tid
				&& ( H->in_pvm == IN_PVM
					|| H->status == HOST_DELETED
					|| H->status == HOST_NOTIFY_DEL ) )
			{
				return( H );
			}

			H = H->next;
		}
	}

	else if ( type == PLAYBACK_ADDED )
	{
		while ( H != NULL )
		{
			if ( H->pvmd_tid == tid
				&& ( ( (H->in_pvm == IN_PVM || H->in_pvm == NOT_IN_PVM)
					&& TRACE_FILE_STATUS == TRACE_FILE_OVERWRITE )
				|| ( H->in_pvm == PLAYBACK_ADDED
					&& TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK ) ) )
			{
				return( H );
			}

			H = H->next;
		}
	}

	return( (HOST) NULL );
}

NETWORK create_network()
{
	NETWORK tmp;

	int i;

	tmp = (NETWORK) malloc( sizeof( struct network_struct ) );
	memcheck( tmp, "Network Structure" );

	tmp->type = -1;

	tmp->NET_C = (char *) NULL;

	tmp->host_list = (HOST) NULL;

	tmp->links = (NETLINK *) NULL;

	tmp->nlinks = -1;

	return( tmp );
}

free_network( ptr )
NETWORK *ptr;
{
	NETWORK N;

	int i;

	N = *ptr;

	N->type = -1;

	N->NET_C = (char *) NULL;

	N->host_list = (HOST) NULL;

	N->links = (NETLINK *) NULL;

	N->nlinks = -1;

	free( *ptr );

	*ptr = (NETWORK) NULL;
}

read_hostfile()
{
	HOST H;

	FILE *fp;

	char globline[1024];
	char hostline[1024];
	char reftmp[1024];
	char msg[1024];
	char tmp[1024];

	int in_pvm;
	int done;
	int i, j;

	/* Add local host to list */

	if ( NEW_PVM && HOST_NAME != NULL )
	{
		H = MAIN_NET->host_list = create_host();

		H->index = 0;

		H->name = copy_str( HOST_NAME );

		H->alias = copy_str( HOST_ALIAS );

		H->refname = copy_str( H->name );

		H->in_pvm = TO_BE_ADDED;

		H->status = HOST_OFF;

		for ( i=0 ; i < MAX_STATE ; i++ )
			H->counts[i] = 0;

		NHOSTS = 1;
	}

	/* Initialize Global Options Line */

	strcpy( globline, "" );

	/* Get list of hosts */

	fp = fopen( HOSTFILE, "r" );

	if ( fp != NULL )
	{
		done = 0;

		do
		{
			i = 0;

			while ( (hostline[i] = getc( fp )) != (char) EOF
				&& hostline[i] != '\n' )
			{
				i++;
			}

			if ( hostline[i] != '\n' )
				done++;

			else
			{
				hostline[i] = '\0';

				if ( hostline[0] != '#' && strcmp( hostline, "" ) )
				{
					if ( hostline[0] == '*' )
						sprintf( globline, " %s", hostline + 1 );

					else
					{
						if ( hostline[0] == '&' )
						{
							sprintf( reftmp, "%s%s",
								hostline + 1, globline );
		
							in_pvm = NOT_IN_PVM;
						}
		
						else
						{
							sprintf( reftmp, "%s%s",
								hostline, globline );
		
							in_pvm = TO_BE_ADDED;
						}
		
						sscanf( reftmp, "%s", tmp );
	
						if ( !NEW_PVM || !LOCALHOST( tmp ) )
						{
							if ( MAIN_NET->host_list == NULL )
							{
								H = MAIN_NET->host_list = create_host();
		
								NHOSTS = 0;
							}
		
							else
							{
								H->next = create_host();
		
								H = H->next;
							}
		
							H->index = NHOSTS;
		
							H->name = copy_str( tmp );
		
							H->alias = host_alias_str( H->name );
		
							H->refname = copy_str( reftmp );
		
							H->in_pvm = in_pvm;
	
							H->status = HOST_OFF;
	
							for ( j=0 ; j < MAX_STATE ; j++ )
								H->counts[j] = 0;
	
							NHOSTS++;
						}
					}
				}
			}
		}
		while ( !done );

		fclose( fp );
	}

	else
	{
		sprintf( tmp, "Error Opening Hostfile \"%s\"", HOSTFILE );

		sprintf( msg, "setMsg { %s }", tmp );

		Tcl_Eval( interp, msg );

		fprintf( stderr, "\n%s\n\n", tmp );
	}
}

initialize_hosts()
{
	HOST H;

	ARCH A;

	HOST last;

	struct pvmhostinfo *HP;

	struct pvmhostinfo *hostp;

	char cmd[1024];
	char tmp[1024];
	char tmp2[1024];

	int refresh;
	int localck;
	int found;
	int narch;
	int nhost;
	int host;
	int i, j;

	/* Get Existing Configuration */

	PVMCKERR( pvm_config( &nhost, &narch, &hostp ),
		"Error Checking Existing Configuration", exit( -1 ) );

	/* Set up Host Delete Notify's */

	for ( i=0 ; i < nhost ; i++ )
		pvm_notify( PvmHostDelete, 100, 1, &(hostp[i].hi_tid) );

	/* Check Existing List Against Host File */

	refresh = 0;

	for ( i=0 ; i < nhost ; i++ )
	{
		HP = &(hostp[i]);

		/* Update Host List */

		H = MAIN_NET->host_list;

		last = (HOST) NULL;

		found = 0;

		while ( H != NULL && !found )
		{
			if ( HOST_COMPARE( H, HP->hi_name ) )
				found++;

			else
			{
				last = H;

				H = H->next;
			}
		}

		/* Host Already in Host List, Set Fields */

		if ( found )
		{
			if ( strlen( HP->hi_name ) > strlen( H->name ) )
			{
				free( H->name );

				H->name = copy_str( HP->hi_name );
			}

			sscanf( H->refname, "%s", tmp );
			sscanf( HP->hi_name, "%s", tmp2 );

			if ( strcmp( tmp, tmp2 ) )
			{
				free( H->refname );

				H->refname = copy_str( HP->hi_name );
			}
		}

		/* Host Not Found, Add to Hosts List */

		else
		{
			if ( last != NULL )
				H = last->next = create_host();
			
			else
			{
				H = MAIN_NET->host_list = create_host();

				NHOSTS = 0;
			}

			H->index = NHOSTS;

			H->name = copy_str( HP->hi_name );

			H->alias = host_alias_str( H->name );

			H->refname = copy_str( HP->hi_name );

			refresh++;

			NHOSTS++;
		}

		H->arch = check_arch( H, HP->hi_arch );

		H->pvmd_tid = HP->hi_tid;

		H->speed = HP->hi_speed;

		H->in_pvm = IN_PVM;

		for ( j=0 ; j < MAX_STATE ; j++ )
			H->counts[j] = 0;

		/* Turn Host On */

		H->status = HOST_ON;

		create_network_host( H );

		/* Set Host Delay */

		if ( !LOCALHOST( H->name ) )
		{
			PVMCKERR( pvm_hostsync( H->pvmd_tid,
				(struct timeval *) NULL, &(H->delta) ),
				"Host Sync", NOP );
		}
	}

	if ( refresh )
		Tcl_Eval( interp, "refreshHostsMenu" );

	/* Add in Any Missed Hosts from Host File */

	localck = 0;

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->in_pvm == TO_BE_ADDED )
		{
			if ( !LOCALHOST( H->name ) )
			{
				H->in_pvm = NOT_IN_PVM;

				do_add_host( H );
			}

			else
			{
				H->in_pvm = IN_PVM;

				localck++;
			}
		}

		H = H->next;
	}

	/* Fix LOCALHOST / HOST_NAME - Network Name in use... */
	if ( !localck )
	{
		host = pvm_tidtohost( MYTID );

		H = get_host_tid( host, IN_PVM );

		if ( H != NULL )
		{
			if ( HOST_NAME != NULL )
				free( HOST_NAME );

			HOST_NAME = copy_str( H->name );

			if ( HOST_ALIAS != NULL )
				free( HOST_ALIAS );

			HOST_ALIAS = copy_str( H->alias );

			/* Verify Host Delay Cleared */

			H->delta.tv_sec = H->delta.tv_usec = 0;
		}
	}

	arrange_network_hosts( MAIN_NET );
}

update_hosts( tids, num )
int *tids;
int num;
{
	HOST H;

	ARCH A;

	HOST last;

	struct pvmhostinfo *HP;

	struct pvmhostinfo *hostp;

	char cmd[1024];
	char tmp[1024];
	char tmp2[1024];

	int origstatus;
	int refresh;
	int arrange;
	int quick;
	int found;
	int narch;
	int nhost;
	int ecnt;
	int i, j;

	REFRESH_GLOBAL( NET_ALIVE_COLOR );

	PVMCKERR( pvm_config( &nhost, &narch, &hostp ),
		"Error Checking Existing Configuration", exit( -1 ) );

	/* Look For New Hosts */

	refresh = 0;

	arrange = 0;

	for ( i=0 ; i < num ; i++ )
	{
		/* Find Hostinfo Struct */

		quick = 0;

		found = 0;

		for ( j=0 ; j < nhost && !found ; j++ )
		{
			HP = &(hostp[j]);

			if ( HP->hi_tid == tids[i] )
				found++;
		}

		if ( !found )
			quick++;

		/* Update Host List */

		H = MAIN_NET->host_list;

		last = (HOST) NULL;

		found = 0;

		if ( !quick )
		{
			while ( H != NULL && !found )
			{
				if ( HOST_COMPARE( H, HP->hi_name ) )
					found++;

				else
				{
					last = H;

					H = H->next;
				}
			}
		}

		else
		{
			while ( H != NULL )
			{
				last = H;

				H = H->next;
			}
		}

		/* Host Already in Host File */

		if ( found )
		{
			if ( strlen( HP->hi_name ) > strlen( H->name ) )
			{
				free( H->name );
			
				H->name = copy_str( HP->hi_name );
			}

			sscanf( H->refname, "%s", tmp );
			sscanf( HP->hi_name, "%s", tmp2 );

			if ( strcmp( tmp, tmp2 ) )
			{
				free( H->refname );

				H->refname = copy_str( HP->hi_name );
			}
		}

		/* Host Not Found, Add to Hosts List */

		else
		{
			if ( last != NULL )
				H = last->next = create_host();
			
			else
			{
				H = MAIN_NET->host_list = create_host();

				NHOSTS = 0;
			}

			H->index = NHOSTS;

			if ( !quick )
			{
				H->name = copy_str( HP->hi_name );

				H->alias = host_alias_str( H->name );

				H->refname = copy_str( HP->hi_name );
			}

			else
			{
				sprintf( tmp, "t%x", tids[i] );

				H->name = copy_str( tmp );

				H->alias = copy_str( tmp );

				H->refname = copy_str( "" );
			}

			H->status = HOST_OFF;

			refresh++;

			NHOSTS++;
		}

		/* Update Fields */

		if ( !quick )
		{
			H->arch = check_arch( H, HP->hi_arch );

			H->pvmd_tid = HP->hi_tid;

			H->speed = HP->hi_speed;
		}

		else
		{
			H->arch = check_arch( H, "DUMMY" );

			H->pvmd_tid = tids[i];

			H->speed = 0;
		}

		for ( j=0 ; j < MAX_STATE ; j++ )
			H->counts[j] = 0;

		H->in_pvm = IN_PVM;

		/* (Re)Draw Host */

		if ( TRACE_FILE_STATUS != TRACE_FILE_PLAYBACK )
		{
			if ( H->status != HOST_DELETED )
			{
				origstatus = H->status;

				H->status = HOST_NOTIFY_ADD;

				if ( origstatus == HOST_OFF || H->box == NULL )
				{
					create_network_host( H );

					arrange++;
				}

				SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
					CHAR_GLOBVAL( NET_ALIVE_COLOR ), 2 );
			}
		}

		else
			H->status = HOST_OFF;

		/* Set Host Delay */

		if ( !LOCALHOST( H->name ) )
		{
			PVMCKERR( pvm_hostsync( H->pvmd_tid,
				(struct timeval *) NULL, &(H->delta) ),
				"Host Sync", NOP );
		}

		/* Save Host Add Event to Trace File */

		if ( TRACE_OUT != NULL )
		{
			update_trace_time( -1, -1 );

			write_host_add_event( H );

			ecnt = 1;

			if ( H->delta.tv_sec != 0 || H->delta.tv_usec != 0 )
			{
				write_host_sync_event( H );

				ecnt++;
			}

			fflush( TRACE_OUT );

			TRACE_PENDING += ecnt;
		}
	}

	if ( refresh )
		Tcl_Eval( interp, "refreshHostsMenu" );

	if ( arrange )
		arrange_network_hosts( MAIN_NET );
}

set_trace_controls()
{
	char *str;

	switch ( TRACE_STATUS )
	{
		case TRACE_REWIND:	str = "trace_controls rewind";	break;

		case TRACE_STOP:	str = "trace_controls stop";	break;

		case TRACE_FWD:		str = "trace_controls fwd";		break;

		case TRACE_FWDSTEP:	str = "trace_controls fwdstep";	break;
	}

	Tcl_Eval( interp, str );
}

check_mode_pending()
{
	if ( TRACE_MODE_PENDING == TRACE_MODE_NONE )
		return( FALSE );

	else if ( TRACE_MODE_PENDING == TRACE_MODE_RESET )
	{
		do_reset_views( interp );

		TRACE_MODE_PENDING = TRACE_MODE_NONE;

		return( TRUE );
	}

	else
	{
		printf( "\nError: Unknown Trace Mode Pending - %d\n\n",
			TRACE_MODE_PENDING );
		
		TRACE_MODE_PENDING = TRACE_MODE_NONE;

		return( FALSE );
	}
}

signal_by_name( name )
char *name;
{
	int i;

	for ( i=0 ; i < NUM_SIGNALS ; i++ )
	{
		if ( compare( SIGNAL_STRS[i], name ) )
			return( i + 1 );
	}

	return( -1 );
}

char *date_str()
{
	char tmp[255];

	char *result;

	time_t t;

	time( &t );

	sprintf( tmp, "%s", ctime( &t ) );

	result = tmp;

	while ( *result != '\n' && *result != '\0' )
		result++;
	
	*result = '\0';

	result = copy_str( tmp );

	return( result );
}

double distance( x1, y1, x2, y2 )
double x1, y1, x2, y2;
{
	return( sqrt(((x2 - x1) * (x2 - x1)) + ((y2 - y1) * (y2 - y1))) );
}

double angle_of( x1, y1, x2, y2 )
double x1, y1, x2, y2;
{
	double slope;
	double at;

	if ( x2 == x1 )
	{
		if ( y2 > y1 )
			return( PI / 2.0 );

		else
			return( -1.0 * PI / 2.0 );
	}

	slope = (y2 - y1) / (x2 - x1);

	at = atan(slope);

	if ( x1 > x2 )
	{
		if ( y2 > y1 )
			at += PI;

		else
			at -= PI;
	}

	return( at );
}

ipwr( x, y )
int x, y;
{
	int z;
	int i;

	z = x;

	for ( i=1 ; i < y ; i++ )
		z *= x;
	
	return( z );
}

char *host_alias_str( name )
char *name;
{
	char *ptr;
	char *tmp;

	char c;

	if ( name == NULL )
		return( (char *) NULL );

	ptr = name;

	while ( *ptr != '\0' && *ptr != '.' )
		ptr++;

	if ( *ptr == '.' )
	{
		c = *ptr;

		*ptr = '\0';

		tmp = copy_str( name );

		*ptr = c;
	}

	else
		tmp = copy_str( name );
	
	return( tmp );
}

char *center_str( str, width )
char *str;
int width;
{
	char *tmp;

	int i, j;
	int len;

	tmp = (char *) malloc( (unsigned) (width + 1) * sizeof(char) );
	memcheck( tmp, "Center String" );

	len = strlen( str );

	if ( len > width )
	{
		strcpy( tmp, (char *) ( str + ( len - width ) ) );

		tmp[0] = '<';
	}

	else
	{
		j = ( width - len ) / 2;

		for ( i=0 ; i < j ; i++ )
			tmp[i] = ' ';

		strcpy( (char *) ( tmp + j ), str );

		for ( i=(j + len) ; i < width ; i++ )
			tmp[i] = ' ';

		tmp[width] = '\0';
	}

	return( tmp );
}

char *pad_num( num, max )
long num;
long max;
{
	char tmp[1024];

	char *ptr;
	char *str;

	int nd;
	int nz;
	int i;

	sprintf( tmp, "%ld", num );

	nd = strlen( tmp );

	nz = max - nd;

	str = (char *) malloc( (unsigned) (max + 1) * sizeof(char) );
	memcheck( str, "Numerical Pad String" );

	ptr = str;

	for ( i=0 ; i < nz ; i++ )
		*ptr++ = '0';

	sprintf( (char *) (str + nz), "%ld", num );

	return( str );
}

char *trunc_str( str, len )
char *str;
int len;
{
	char tmp[1024];

	int slen;

	slen = strlen( str );

	sprintf( tmp, "%s", str );

	if ( slen > len )
		sprintf( tmp + len - 1, "*" );

	return( copy_str( tmp ) );
}

char *upper_str( str )
char *str;
{
	char *ptr;
	char *tmp;

	tmp = copy_str( str );

	ptr = tmp;

	while ( *ptr != '\0' )
	{
		if ( *ptr >= 'a' && *ptr <= 'z' )
			*ptr += 'A' - 'a';

		ptr++;
	}

	return( tmp );
}

char *copy_str( str )
char *str;
{
	char *tmp;

	tmp = (char *) malloc( (unsigned) (strlen(str) + 1)
		* sizeof(char) );
	memcheck(tmp,"Copy String");

	strcpy( tmp, str );

	return( tmp );
}

append_cmd_str( result, str, length, err, cmd_flag )
char *result;
char *str;
int length;
char *err;
int cmd_flag;
{
	char *strcat();

	char *errstr;

	int elen;
	int rlen;
	int len;
	int rc;
	int i;

	rlen = strlen( result );

	len = rlen + strlen( str ) + 1;

	if ( len <= length )
		strcat( result, str );

	else
	{
		if ( cmd_flag == TRUE )
		{
			if ( err == NULL )
			{
				printf( "\nError in Append Cmd String: Null Cmd\n\n" );

				return( TCL_ERROR );
			}

			elen = len + strlen( err ) + 5;

			errstr = (char *) malloc( (unsigned) elen * sizeof(char) );
			memcheck( errstr, "Append Cmd String Err String" );

			sprintf( errstr, "%s { %s }", err, result );

			rc = Tcl_Eval( interp, errstr );

			if ( rc == TCL_ERROR )
				printf( "\nError Executing \"%s\"\n\n", errstr );

			free( errstr );

			if ( strlen( str ) <= length )
				strcpy( result, str );

			else
			{
				printf( "\nError Append Cmd String \"%s\" Too Long\n\n",
					str );

				strcpy( result, "" );
			}

			return( rc );
		}

		else
		{
			if ( err != NULL )
				printf( "\nError in Append Cmd String: %s\n\n", err );

			i = rlen;

			while ( i < length - 4 )
			{
				result[i] = str[ i - rlen ];

				i++;
			}

			sprintf( (char *) (result + (length - 4)), "..." );
		}
	}

	return( TCL_OK );
}

filecheck( fp, name )
FILE *fp;
char *name;
{
	char msg[1024];
	char tmp[1024];

	if ( fp == NULL )
	{
		sprintf( tmp, "Error Opening File \"%s\"", name );

		sprintf( msg, "setMsg { %s }", tmp );

		Tcl_Eval( interp, msg );

		fprintf( stderr, "\n%s\n\n", tmp );

		return( FALSE );
	}

	return( TRUE );
}

memcheck( ptr, name )
char *ptr;
char *name;
{
	if ( ptr == NULL )
	{
		fprintf( stderr, "\nError Allocating Memory for \"%s\"\n\n",
			name );

		error_exit();
	}
}

compare( x, y )
char *x, *y;
{
	while ( *x != '\0' )
	{
		if ( *x != *y )
			return( FALSE );

		x++; y++;
	}

	return( TRUE );
}

error_exit()
{
	int cc;

	if ( MYTID > 0 && GROUPS_ALIVE )
	{
		cc = pvm_getinst( "xpvm", MYTID );

		if ( cc >= 0 )
		{
			cc = pvm_lvgroup( "xpvm" );

			if ( cc < 0 )
			{
				printf( "\nError Leaving XPVM Group, cc=%d\n\n",
					cc );
			}
		}
	}

	exit( -1 );
}

