
/* $Id: trace.h,v 3.20 1995/07/27 14:48:59 kohl Exp $ */

/* Internal Trace Event Constants */

#define TRACE_RESERVED_INTERNAL    0x0400

#define TRACE_HOST_ADD		(TRACE_RESERVED_INTERNAL + 1)
#define TRACE_HOST_DEL		(TRACE_RESERVED_INTERNAL + 2)
#define TRACE_HOST_SYNC		(TRACE_RESERVED_INTERNAL + 3)
#define TRACE_OUTPUT		(TRACE_RESERVED_INTERNAL + 4)
#define TRACE_MAX			(TRACE_RESERVED_INTERNAL + 5)

/* Trace Handling Constants */

#define HANDLE_FIRST		1
#define HANDLE_NEWTASK		1
#define HANDLE_SPNTASK		2
#define HANDLE_ENDTASK		3
#define HANDLE_HOST_ADD		4
#define HANDLE_HOST_DEL		5
#define HANDLE_HOST_SYNC	6
#define HANDLE_OUTPUT		7
#define HANDLE_EXIT			8
#define HANDLE_SEND			9
#define HANDLE_MCAST		10
#define HANDLE_PSEND		11
#define HANDLE_RECV			12
#define HANDLE_NRECV		13
#define HANDLE_PRECV		14
#define HANDLE_TRECV		15
#define HANDLE_MAX			15

/* Trace Handling Macros */

#define GET_TEVREC( _tr, _trptr, _did ) \
\
	if ( (_trptr = get_tevrec( _tr, _did )) == NULL ) \
		return \
\

#define GET_TEVREC_VALUE( _tr, _did, _dtype ) \
\
	( (TMP_TR = get_tevrec( _tr, _did )) != NULL ? \
		VALUE_OF( TMP_TR->value, _dtype ) : -1 ) \
\

/* Trace Mask Compatibility Macros */

#define INIT_TRACE_MASK( _mask, _fmt ) \
{ \
	if ( (_fmt) == TEV_FMT_33 ) \
	{ \
		TEV33_MASK_INIT( _mask ); \
	} \
\
	else if ( (_fmt) == TEV_FMT_34 ) \
	{ \
		TEV_MASK_INIT( _mask ); \
	} \
} \
\

#define SET_TRACE_MASK( _mask, _fmt, _index ) \
{ \
	if ( (_fmt) == TEV_FMT_33 ) \
	{ \
		TEV33_MASK_SET( _mask, _index ); \
	} \
\
	else if ( (_fmt) == TEV_FMT_34 ) \
	{ \
		TEV_MASK_SET( _mask, _index ); \
	} \
} \
\

#define UNSET_TRACE_MASK( _mask, _fmt, _index ) \
{ \
	if ( (_fmt) == TEV_FMT_33 ) \
	{ \
		TEV33_MASK_UNSET( _mask, _index ); \
	} \
\
	else if ( (_fmt) == TEV_FMT_34 ) \
	{ \
		TEV_MASK_UNSET( _mask, _index ); \
	} \
} \
\

#define CHECK_TRACE_MASK( _mask, _fmt, _index ) \
( \
	(_fmt) == TEV_FMT_33 ? \
		TEV33_MASK_CHECK( _mask, _index ) : \
		TEV_MASK_CHECK( _mask, _index ) \
) \
\

#define FIRST_EVENT( _fmt ) \
	( (_fmt) == TEV_FMT_33 ? TEV33_FIRST : TEV_FIRST )

#define LAST_EVENT( _fmt ) \
	( (_fmt) == TEV_FMT_33 ? TEV33_MAX : TEV_MAX )

#define EVENT_INCR( _fmt )    ( (_fmt) == TEV_FMT_33 ? 2 : 1 )

#define TRACE_MASK_LENGTH( _fmt ) \
	( (_fmt) == TEV_FMT_33 ? TEV33_MASK_LENGTH : TEV_MASK_LENGTH )

