
static char rcsid[] = 
	"$Id: tevsort.c,v 3.20 1995/07/27 14:48:39 kohl Exp $";

#include <stdio.h>

#include <malloc.h>

struct host_struct
{
	int pvmd_tid;
	int delay_sec;
	int delay_usec;
	/* HOST */ struct host_struct *next;
};

typedef struct host_struct *HOST;

struct tev_struct
{
	char *line;
	char *name;
	int tsec;
	int tusec;
	int tid;
	/* TEV */ struct tev_struct *prev;
	/* TEV */ struct tev_struct *next;
};

typedef struct tev_struct *TEV;

HOST HOST_LIST;

TEV HEAD;
TEV TAIL;

FILE *TRACE_OUT;
FILE *TRACE_IN;

int RE_SORT;
int NTEV;

HOST Create_host();

TEV read_tev_line();
TEV Create_tev();

char *Copy_str();

main()
{
	TEV ptr;

	char c;

	int done;
	int flag;
	int i;

	TRACE_OUT = stdout;

	TRACE_IN = stdin;

	HOST_LIST = (HOST) NULL;

	HEAD = (TEV) NULL;
	TAIL = (TEV) NULL;

	RE_SORT = 0;

	NTEV = 0;

	done = 0;

	while ( !done )
	{
		flag = fscanf( TRACE_IN, "%c", &c );
	
		if ( flag == 1 )
		{
			/* printf( "<%c>", c ); */

			switch ( c )
			{
				/* Command Packet '%' */
				/* Record Descriptor Packet '#' */
	
				case '%':
				case '#':
				{
					fprintf( TRACE_OUT, "%c", c );

					if ( (flag = Dump_event_end()) != 1 )
						done--;

					break;
				}
	
				/* Stream Attribute Packet */
	
				case '/':
				{
					flag = fscanf( TRACE_IN, "%c", &c );

					if ( flag == 1 )
					{
						if ( c != '*' )
						{
							printf( "\nError Reading Trace File\n" );
							printf( "\t- '*' expected (/* */)\n\n" );

							if ( (flag = Find_event_end()) != 1 )
								done--;
						}

						else
						{
							fprintf( TRACE_OUT, "/*" );

							if ( (flag = Dump_event_end()) != 1 )
								done--;
						}
					}

					else
						done--;

					break;
				}
	
				/* White Space */

				case ' ':
				case '\t':
				case '\n':
				{
					break;
				}

				/* Record Data Packet */
	
				case '"':
				{
					ptr = read_tev_line();

					insert_sort( ptr );

					break;
				}
			}
		}

		else
			done++;
	}

	if ( done < 0 )
		fprintf( stderr, "\nError Reading Trace File\n\n" );

	dump_events( NTEV );

	exit( 0 );
}

insert_sort( T )
TEV T;
{
	TEV ptr;

	if ( TAIL != NULL )
	{
		ptr = TAIL;

		while ( ptr != NULL &&
			( ptr->tsec > T->tsec ||
				( ptr->tsec == T->tsec &&
					( ptr->tusec > T->tusec ||
						( ptr->tusec == T->tusec &&
							ptr->tid > T->tid ) ) ) ) )
		{
			ptr = ptr->prev;
		}

		if ( ptr != NULL )
		{
			T->next = ptr->next;
			T->prev = ptr;

			ptr->next = T;

			if ( T->next != NULL )
				T->next->prev = T;

			if ( TAIL == ptr )
				TAIL = T;
		}

		else
		{
			T->next = HEAD;

			HEAD->prev = T;

			HEAD = T;

			if ( RE_SORT )
			{
				fprintf( stderr,
					"\nWarning: Large Time Delta - Re-Sort Trace\n\n" );
			}
		}
	}

	else
		HEAD = TAIL = T;

	NTEV++;
}

HOST Create_host()
{
	HOST tmp;

	tmp = (HOST) malloc( sizeof( struct host_struct ) );
	Memcheck( &tmp, sizeof( struct host_struct ) );

	tmp->pvmd_tid = -1;
	tmp->delay_sec = -1;
	tmp->delay_usec = -1;

	tmp->next = (HOST) NULL;

	return( tmp );
}

TEV Create_tev()
{
	TEV tmp;

	tmp = (TEV) malloc( sizeof( struct tev_struct ) );
	Memcheck( &tmp, sizeof( struct tev_struct ) );

	tmp->line = (char *) NULL;
	tmp->name = (char *) NULL;

	tmp->tsec = -1;
	tmp->tusec = -1;
	tmp->tid = -1;

	tmp->prev = (TEV) NULL;
	tmp->next = (TEV) NULL;

	return( tmp );
}

Free_tev( ptr )
TEV *ptr;
{
	free( (*ptr)->line );
	free( (*ptr)->name );

	(*ptr)->tsec = -1;
	(*ptr)->tusec = -1;
	(*ptr)->tid = -1;

	(*ptr)->prev = (TEV) NULL;
	(*ptr)->next = (TEV) NULL;

	free( *ptr );
	*ptr = (TEV) NULL;
}

TEV read_tev_line()
{
	TEV tmp;

	char line[2048];
	char name[256];

	char *ptr;
	char *p2;

	char last;
	char c;

	int flag;

	tmp = Create_tev();

	line[0] = '"';

	ptr = &(line[1]);

	last = '\0';

	while ( (flag = fscanf( TRACE_IN, "%c", &c )) == 1 )
	{
		*ptr++ = c;

		if ( c == ';' && last == ';' )
			break;

		last = c;
	}

	*ptr = '\0';

	tmp->line = Copy_str( line );

	ptr = &(line[1]);

	p2 = name;

	while ( *ptr != '"' )
		*p2++ = *ptr++;

	*p2 = '\0';

	tmp->name = Copy_str( name );

	sscanf( line, "%*s { %d, %d, %d",
		&(tmp->tsec), &(tmp->tusec), &(tmp->tid) );

	/* } to match above */

	return( tmp );
}

dump_events( ntev )
int ntev;
{
	TEV ptr;
	TEV tmp;

	int i;

	ptr = HEAD;

	for ( i=0 ; i < ntev && ptr != NULL ; i++ )
	{
		fprintf( TRACE_OUT, "%s\n", ptr->line );

		tmp = ptr->next;

		Free_tev( &ptr );

		if ( tmp != NULL )
			tmp->prev = (TEV) NULL;

		ptr = tmp;
	}

	HEAD = ptr;

	if ( HEAD == NULL )
		TAIL = (TEV) NULL;

	NTEV -= ntev;
}

Dump_event_end()
{
	char last;
	char c;

	int flag;

	last = '\0';

	while ( (flag = fscanf( TRACE_IN, "%c", &c )) == 1 )
	{
		fprintf( TRACE_OUT, "%c", c );

		if ( c == ';' && last == ';' )
			break;

		last = c;
	}

	fprintf( TRACE_OUT, "\n\n" );

	return( flag );
}

Find_event_end()
{
	char last;
	char c;

	int flag;

	last = '\0';

	while ( (flag = fscanf( TRACE_IN, "%c", &c )) == 1 )
	{
		/* printf( "[%c]", c ); */

		if ( c == ';' && last == ';' )
			return( 1 );

		last = c;
	}

	return( flag );
}

char *Copy_str( str )
char *str;
{
	char *tmp;

	tmp = (char *) malloc( (unsigned) (strlen(str) + 1)
		* sizeof(char) );
	Memcheck( &tmp, (unsigned) (strlen(str) + 1) * sizeof(char) );

	strcpy( tmp, str );

	return( tmp );
}

Memcheck( ptr, size )
char **ptr;
unsigned size;
{
	if ( *ptr == NULL )
	{
		fprintf( stderr, "Dumping partial sort... " );

		dump_events( NTEV / 4 );

		fprintf( stderr, "done.\n" );

		RE_SORT++;

		*ptr = (char *) malloc( size );

		if ( *ptr == NULL )
		{
			fprintf( stderr, "\nError: Out of Memory, Bailing...\n\n" );

			exit( 1 );
		}
	}
}

