
static char rcsid[] = 
	"$Id: tevmess.c,v 3.20 1995/07/27 14:48:37 kohl Exp $";

#include "xpvm.h"

handle_trace_message( src )
int src;
{
	DATADESC DD;

	TEVDESC TD;

	TEVTASK TT;

	HOST H;

	DID dptr;

	char diddesc[1024];
	char tmp[1024];
	char did[4];

	int desc_done;
	int did_done;
	int done;

	int entry_exit;
	int did_int;
	int index;
	int tusec;
	int tsec;
	int ecnt;
	int eid;
	int tid;
	int dt;

	int marker;
	int nest;

	PVMCKERR( pvm_upkint( &marker, 1, 1 ),
		"Unpacking Trace Message", return );

	/* Old PVM 3.3 Trace Format */

	if ( marker > 0 )
	{
		tsec = marker;

		PVMCKERR( pvm_upkint( &tusec, 1, 1 ),
			"Event Parse Error", return );

		PVMCKERR( pvm_upkint( &tid, 1, 1 ),
			"Event Parse Error", return );

		PVMCKERR( pvm_upkint( &eid, 1, 1 ),
			"Event Parse Error", return );

		update_trace_time( tsec, tusec );

		store_trace33_event( tsec, tusec, tid, eid );

		TRACE_OVERWRITE_FLAG = FALSE;

		TRACE_PENDING++;

		return;
	}

	/* New PVM 3.4 Format */

	TT = get_tevtask_tid( src );

	if ( TT == NULL )
		H = get_host_tid( src, IN_PVM );

	ecnt = 0;

	nest = 0;

	done = 0;

	do
	{
		switch ( marker )
		{
			case TEV_MARK_EVENT_BUFFER:
			{
				nest++;

				break;
			}

			case TEV_MARK_EVENT_BUFFER_END:
			{
				if ( !(--nest) )
					done++;

				break;
			}

			case TEV_MARK_DATA_ID:
			{
				did_done = 0;

				do
				{
					PVMCKERR( pvm_upkint( &did_int, 1, 1 ),
						"Data ID Message", return );

					if ( did_int != TEV_MARK_DATA_ID_END )
					{
						TEV_DECODE_DID( did_int, did, dt );

						PVMCKERR( pvm_upkstr( diddesc ),
							"Data ID Description", return );

						dptr = (DID) lookup_trie( DID_TRIE, did );
						
						if ( dptr == NULL )
							printf( "ADD DID %s: %s\n", did, diddesc );

						else if ( strcmp( dptr->desc, diddesc ) )
							printf( "DIFF DID %s: %s\n", did, diddesc );
					}

					else
						did_done++;
				}
				while ( !did_done );

				if ( !nest )
					done++;

				break;
			}

			case TEV_MARK_EVENT_DESC:
			{
				TD = create_tevdesc();
				
				PVMCKERR( pvm_upkstr( tmp ),
					"Event Descriptor Name", return );

				TD->name = copy_str( tmp );
		
				PVMCKERR( pvm_upkint( &eid, 1, 1 ),
					"Event Descriptor ID", return );

				TD->eid = eid & ~( TEV_EVENT_ENTRY | TEV_EVENT_EXIT );

				if ( eid & TEV_EVENT_ENTRY )
					TD->entry_exit = ENTRY_TEV;

				else if ( eid & TEV_EVENT_EXIT )
					TD->entry_exit = EXIT_TEV;

				else
					TD->entry_exit = IGNORE_TEV;

				desc_done = 0;

				do
				{
					PVMCKERR( pvm_upkint( &did_int, 1, 1 ),
						"Semantic Data ID", return );

					if ( did_int != TEV_MARK_EVENT_DESC_END )
					{
						TEV_DECODE_DID( did_int, did, dt );

						if ( TD->ddesc == NULL )
							DD = TD->ddesc = create_datadesc();

						else
							DD = DD->next = create_datadesc();

						DD->dt = dt &
							~( TEV_DATA_SCALAR | TEV_DATA_ARRAY );

						DD->array = dt &
							( TEV_DATA_SCALAR | TEV_DATA_ARRAY );

						DD->did = lookup_trie( DID_TRIE, (void *) did );
					}

					else
						desc_done++;
				}
				while ( !desc_done );

				TD = add_tevdesc( TD );

				set_tevlist( TT, H, TD );

				if ( !nest )
					done++;

				break;
			}

			case TEV_MARK_EVENT_RECORD:
			{
				PVMCKERR( pvm_upkint( &eid, 1, 1 ),
					"Event ID", return );

				if ( eid & TEV_EVENT_ENTRY )
					entry_exit = ENTRY_TEV;

				else if ( eid & TEV_EVENT_EXIT )
					entry_exit = EXIT_TEV;

				else
					entry_exit = IGNORE_TEV;

				eid &= ~( TEV_EVENT_ENTRY | TEV_EVENT_EXIT );

				index = get_tevindex( TT, H, eid, entry_exit );

				TD = get_tevdesc( eid, entry_exit, index );

				if ( TD != NULL )
				{
					if ( store_trace_event( TD ) )
						ecnt++;
				}

				else
					printf( "Error: Descriptor Not Found\n\n" );

				if ( !nest )
					done++;

				break;
			}
		}

		if ( !done )
		{
			PVMCKERR( pvm_upkint( &marker, 1, 1 ),
				"Unpacking Trace Message", return );
		}
	}
	while ( !done );

	if ( ecnt )
	{
		fflush( TRACE_OUT );

		TRACE_OVERWRITE_FLAG = FALSE;

		TRACE_PENDING += ecnt;
	}
}

handle_output_message()
{
	TEVTASK TT;

	char tmp[255];
	char msg[255];

	char *output;

	int ecnt;
	int len;
	int tid;

	PVMCKERR( pvm_upkint( &tid, 1, 1 ),
		"Error Unpacking Output Message", return );
	
	PVMCKERR( pvm_upkint( &len, 1, 1 ),
		"Error Unpacking Output Length", return );

	ecnt = 0;

	if ( len > 0 )
	{
		output = (char *) malloc( (unsigned) ( len + 1 )
			* sizeof(char) );
		memcheck( output, "PVM Output String" );

		PVMCKERR( pvm_upkbyte( output, len, 1 ),
			"Error Unpacking Task Output", free(output); return );

		output[ len ] = '\0';

		ecnt = store_output_event( tid, output, len );

		free( output );
	}

	else
	{
		switch ( len )
		{
			case 0:
			{
				sprintf( tmp, "GOTEOF\n" );

				ecnt = store_output_event( tid, tmp, strlen(tmp) );

				TT = get_tevtask_tid( tid );

				if ( TT != NULL )
				{
					if ( TT->tevstatus != TASK_IGNORE )
					{
						TT->outstatus = TASK_EOF;

						if ( !tevtasks_alive() )
						{
							Tcl_Eval( interp,
								"setMsg \"Trace File Complete\"" );

							free_tevtasklist();
						}
					}
				}

				else
					printf( "\nWarning: GOTEOF Unknown Task.\n\n" );

				break;
			}

			case -1:
			{
				sprintf( tmp, "GOTSPAWN\n" );

				ecnt = store_output_event( tid, tmp, strlen(tmp) );

				TT = get_tevtask_tid( tid );

				if ( TT == NULL )
				{
					sprintf( msg,
						"setMsg \"Task TID=%x Connected to XPVM\"",
						tid );

					Tcl_Eval( interp, msg );

					TT = create_tevtask();

					TT->tid = tid;
					TT->tevstatus = TASK_DEAD;
					TT->outstatus = TASK_OUT;

					TT->next = TEVTASK_LIST;

					TEVTASK_LIST = TT;
				}

				break;
			}

			case -2:
			{
				sprintf( tmp, "CREATION\n" );

				ecnt = store_output_event( tid, tmp, strlen(tmp) );

				TT = get_tevtask_tid( tid );

				if ( TT == NULL )
				{
					sprintf( msg,
						"setMsg \"Task TID=%x Connected to XPVM\"",
						tid );

					Tcl_Eval( interp, msg );

					TT = create_tevtask();

					TT->tid = tid;
					TT->tevstatus = TASK_DEAD;
					TT->outstatus = TASK_OUT;

					TT->next = TEVTASK_LIST;

					TEVTASK_LIST = TT;
				}

				break;
			}

			default:
			{
				fprintf( stderr,
					"Console: unknown output msg t%x?\n", tid );
			}
		}
	}

	if ( ecnt )
	{
		fflush( TRACE_OUT );

		TRACE_OVERWRITE_FLAG = FALSE;

		TRACE_PENDING += ecnt;
	}
}

