
static char rcsid[] = 
	"$Id: task.c,v 3.20 1995/07/27 14:48:36 kohl Exp $";

#include "xpvm.h"

taskAdd( T, sec, usec, str )
TASK T;
int sec;
int usec;
char *str;
{
	TASK tptr;
	TASK last;

	STATE S;

	char cmd[1024];

	int host_cmp;
	int task_cmp;
	int index;
	int x;

	REFRESH_GLOBAL( ST_OUTLINE_COLOR );
	REFRESH_GLOBAL( ST_RUNNING_COLOR );
	REFRESH_GLOBAL( FG_COLOR );
	REFRESH_GLOBAL( SCALE );

	if ( T->host == NULL )
	{
		printf( "\nError: Missing Host for pvmd_tid=%x\n\n",
			T->pvmd_tid );

		free_task( &T );

		return;
	}

	/* Update Host Icon State */

	netUpdate( T->host, STATE_NONE, STATE_RUNNING );

	/* No Utilization View Update Here */
	/* (only call at end of states...) */

	/* Create Space-Time Task Label */

	sprintf( cmd,
		"%s create text 0 0 -text {%s:%s} -anchor w -fill %s",
		ST_L, host_name( T->host, FALSE ), T->name,
		CHAR_GLOBVAL( FG_COLOR ) );

	Tcl_Eval( interp, cmd );

	T->st_label = create_gobj();

	T->st_label->id = atoi( interp->result );

	/* Create First Space-Time Task State */

	S = create_state();

	S->status = STATE_RUNNING;

	S->callstr = copy_str( str );

	x = X_OF_TIME( sec, usec, INT_GLOBVAL( SCALE ) );

	CREATE_RECT( interp, ST_C, S->rect, x, 0, x, 0,
		CHAR_GLOBVAL( ST_RUNNING_COLOR ),
		CHAR_GLOBVAL( ST_OUTLINE_COLOR ) );

	S->starttime.tv_sec = sec;
	S->starttime.tv_usec = usec;

	S->endtime.tv_sec = sec;
	S->endtime.tv_usec = usec;

	T->states = S;

	/* Create Call Trace Task List Elements */

	sprintf( cmd,
		"%s create text 0 0 -text {%s:%s} -anchor w -fill %s",
		CT_L, host_name( T->host, FALSE ), T->name,
		CHAR_GLOBVAL( FG_COLOR ) );

	Tcl_Eval( interp, cmd );

	T->ct_label = create_gobj();

	T->ct_label->id = atoi( interp->result );

	sprintf( cmd, "%s create text 0 0 -text {%s} -anchor w -fill %s",
		CT_C, str, CHAR_GLOBVAL( FG_COLOR ) );

	Tcl_Eval( interp, cmd );

	T->ct_callstr = create_gobj();

	T->ct_callstr->id = atoi( interp->result );

	/* Order New Task in List */

	tptr = TASK_LIST;

	last = (TASK) NULL;

	index = 0;

	if ( tptr != NULL )
	{
		host_cmp = strcmp( tptr->host->name, T->host->name );

		task_cmp = strcmp( tptr->name, T->name );
	}

	while ( tptr != NULL
		&& ( host_cmp < 0
		|| ( host_cmp == 0 && task_cmp < 0 )
		|| ( host_cmp == 0 && task_cmp == 0 && tptr->tid < T->tid ) ) )
	{
		index++;

		last = tptr;

		tptr = tptr->next;

		if ( tptr != NULL )
		{
			host_cmp = strcmp( tptr->host->name, T->host->name );

			task_cmp = strcmp( tptr->name, T->name );
		}
	}

	if ( tptr != NULL )
	{
		T->next = tptr;

		if ( last != NULL )
			last->next = T;
		
		else
			TASK_LIST = T;

		T->index = index;

		/* Adjust remaining Task indices */

		tptr = T->next;

		while ( tptr != NULL )
		{
			(tptr->index)++;

			tptr = tptr->next;
		}
	}

	else
	{
		if ( last != NULL )
			last->next = T;

		else
			TASK_LIST = T;

		T->index = index;
	}

	NTASKS++;

	Tcl_Eval( interp, "taskArrange" );

	/* Re-Allocate Pending Message Grid */

	msg_grid_add_task( T );

	/* Re-Arrange Message Queue View */

	mqTaskAdd( T );

	return( TCL_OK );
}

taskState( T, sec, usec, status, call_str )
TASK T;
int sec, usec;
int status;
char *call_str;
{
	STATE S;
	STATE stmp;

	char value[1024];
	char cmd[1024];

	char *usec_pad;

	char *color;

	int xrange;
	int old;
	int x2;

	REFRESH_GLOBAL( ST_OUTLINE_COLOR );
	REFRESH_GLOBAL( ST_RUNNING_COLOR );
	REFRESH_GLOBAL( ST_SYSTEM_COLOR );
	REFRESH_GLOBAL( CT_QUERY_INDEX );
	REFRESH_GLOBAL( ST_IDLE_COLOR );
	REFRESH_GLOBAL( CT_ACTIVE );
	REFRESH_GLOBAL( ST_ACTIVE );
	REFRESH_GLOBAL( SCALE );
	REFRESH_GLOBAL( TIMEX );

	/* Update Call String for Task */

	if ( !strcmp( CHAR_GLOBVAL( CT_ACTIVE ), "TRUE" ) )
	{
		sprintf( cmd, "%s itemconfigure %d -text {%s}",
			CT_C, T->ct_callstr->id, call_str );

		Tcl_Eval( interp, cmd );

		if ( INT_GLOBVAL( CT_QUERY_INDEX ) == T->index )
		{
			usec_pad = pad_num( usec, 6 );

			sprintf( value, "Time Stamp: %d.%s", sec, usec_pad );

			free( usec_pad );

			sprintf( cmd, "%s.query configure -text {%s}",
				CT, value );

			Tcl_Eval( interp, cmd );
		}
	}

	/* Check for Task State Change */

	S = T->states;

	if ( S != NULL && S->status != status )
	{
		/* Update Host Icon State */

		netUpdate( T->host, S->status, status );

		/* Update Utilization View Counts */

		if ( S->next != NULL )
			old = S->next->status;
		
		else
			old = STATE_NONE;

		utUpdate( old, S->status,
			S->starttime.tv_sec, S->starttime.tv_usec, sec, usec );

		/* Set End of Last State */

		S->endtime.tv_sec = sec;
		S->endtime.tv_usec = usec;

		/* Create New State */

		stmp = create_state();

		stmp->status = status;

		stmp->callstr = copy_str( call_str );

		/* Determine Color for New State */

		if ( status == STATE_RUNNING )
			color = CHAR_GLOBVAL( ST_RUNNING_COLOR );

		else if ( status == STATE_SYSTEM )
			color = CHAR_GLOBVAL( ST_SYSTEM_COLOR );

		else if ( status == STATE_IDLE )
			color = CHAR_GLOBVAL( ST_IDLE_COLOR );

		/* Create / Steal New State Rectangle */

		x2 = X_OF_TIME( sec, usec, INT_GLOBVAL( SCALE ) );

		xrange = x2 - X1_COORD( S->rect );

		/* Steal It, Color It */

		if ( !xrange
			|| ( xrange == 1
				&& S->next != NULL && S->next->rect != NULL ) )
		{
			stmp->rect = S->rect;

			S->rect = (GOBJ) NULL;
			
			sprintf( cmd, "%s itemconfigure %d -fill %s",
				ST_C, stmp->rect->id, color );

			Tcl_Eval( interp, cmd );
		}

		/* Make a New One (Finish Off Old One) */

		else
		{
			X2_COORD( S->rect ) = x2;

			SET_COORDS( interp, ST_C, S->rect );

			CREATE_RECT( interp, ST_C, stmp->rect,
				X2_COORD( S->rect ), Y1_COORD( S->rect ),
				INT_GLOBVAL( TIMEX ), Y2_COORD( S->rect ),
				color, CHAR_GLOBVAL( ST_OUTLINE_COLOR ) );

				/* X2_COORD( S->rect ), Y2_COORD( S->rect ), */

			/* Move new state rectangle below comm lines */

			sprintf( cmd, "%s lower %d", ST_C, stmp->rect->id );

			Tcl_Eval( interp, cmd );
		}

		stmp->starttime.tv_sec = sec;
		stmp->starttime.tv_usec = usec;

		stmp->endtime.tv_sec = CURRENT_TIME.tv_sec;
		stmp->endtime.tv_usec = CURRENT_TIME.tv_usec;

		stmp->next = S;

		T->states = stmp;
	}
}

taskExit( T, sec, usec, str )
TASK T;
int sec, usec;
char *str;
{
	STATE S;

	char value[1024];
	char cmd[1024];

	char *usec_pad;

	int old;

	if ( tflag )
		return;

	REFRESH_GLOBAL( CT_QUERY_INDEX );
	REFRESH_GLOBAL( CT_ACTIVE );
	REFRESH_GLOBAL( SCALE );

	/* Update Call String for Task */

	if ( !strcmp( CHAR_GLOBVAL( CT_ACTIVE ), "TRUE" ) )
	{
		sprintf( cmd, "%s itemconfigure %d -text {%s}",
			CT_C, T->ct_callstr->id, str );

		Tcl_Eval( interp, cmd );

		if ( INT_GLOBVAL( CT_QUERY_INDEX ) == T->index )
		{
			usec_pad = pad_num( usec, 6 );

			sprintf( value, "Time Stamp: %d.%s", sec, usec_pad );

			free( usec_pad );

			sprintf( cmd, "%s.query configure -text {%s}",
				CT, value );

			Tcl_Eval( interp, cmd );
		}
	}

	/* Update Task Space-Time State */

	S = T->states;

	if ( S != NULL && S->status != STATE_DEAD )
	{
		/* Update Host Icon State */

		netUpdate( T->host, S->status, STATE_DEAD );

		/* Update Utilization View Counts */

		if ( S->next != NULL )
			old = S->next->status;
		
		else
			old = STATE_NONE;

		utUpdate( old, S->status,
			S->starttime.tv_sec, S->starttime.tv_usec, sec, usec );

		/* Finish Off Space-Time State Rectangle */

		X2_COORD( S->rect ) =
			X_OF_TIME( sec, usec, INT_GLOBVAL( SCALE ) );

		SET_COORDS( interp, ST_C, S->rect );

		S->status = STATE_DEAD;

		S->endtime.tv_sec = sec;
		S->endtime.tv_usec = usec;
	}

	T->status = TASK_DEAD;
}

/* ARGSUSED */
int task_arrange_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	STATE S;

	char value[1024];
	char cmd[1024];

	int delta_y;
	int tx, ty;
	int ly;
	int i;

	REFRESH_GLOBAL( BORDER_SPACE );
	REFRESH_GLOBAL( ST_LABEL_HT );
	REFRESH_GLOBAL( ST_CHEIGHT );
	REFRESH_GLOBAL( CT_CHEIGHT );
	REFRESH_GLOBAL( ST_RECT_HT );
	REFRESH_GLOBAL( STL_YVIEW );
	REFRESH_GLOBAL( CT_YVIEW );

	delta_y = ( INT_GLOBVAL( ST_LABEL_HT )
		- INT_GLOBVAL( ST_RECT_HT ) ) / 2;

	tx = ty = INT_GLOBVAL( BORDER_SPACE );

	T = TASK_LIST;

	while ( T != NULL )
	{
		ly = ty + ( INT_GLOBVAL( ST_LABEL_HT ) / 2 );

		/* Space-Time Label */

		sprintf( cmd, "%s coords %d %d %d",
			ST_L, T->st_label->id, tx, ly );

		Tcl_Eval( itp, cmd );

		/* Call Trace Label / Call String */

		sprintf( cmd, "%s coords %d %d %d",
			CT_L, T->ct_label->id, tx, ly );

		Tcl_Eval( itp, cmd );

		sprintf( cmd, "%s coords %d %d %d",
			CT_C, T->ct_callstr->id, tx, ly );

		Tcl_Eval( itp, cmd );

		/* Space-Time State Rectangles */

		T->y1 = ty + delta_y;
		T->y2 = T->y1 + INT_GLOBVAL( ST_RECT_HT );

		S = T->states;

		while ( S != NULL )
		{
			if ( S->rect != NULL )
			{
				Y1_COORD( S->rect ) = T->y1;
				Y2_COORD( S->rect ) = T->y2;

				SET_COORDS( itp, ST_C, S->rect );
			}

			S = S->next;
		}

		ty += INT_GLOBVAL( ST_LABEL_HT );

		T = T->next;
	}

	sprintf( value, "%d", ty + INT_GLOBVAL( BORDER_SPACE ) );

	SET_TCL_GLOBAL( itp, "tasks_height", value );

	Tcl_Eval( itp, "commArrange" );

	/* Set Scrollbars for Space-Time and Call Trace */

	sprintf( cmd, "scrollSet %s %s %d %d %d",
		ST_SBV, value, INT_GLOBVAL( ST_CHEIGHT ),
		INT_GLOBVAL( ST_LABEL_HT ), INT_GLOBVAL( STL_YVIEW ) );
	
	Tcl_Eval( itp, cmd );

	sprintf( cmd, "scrollSet %s %s %d %d %d",
		CT_SBV, value, INT_GLOBVAL( CT_CHEIGHT ),
		INT_GLOBVAL( ST_LABEL_HT ), INT_GLOBVAL( CT_YVIEW ) );
	
	Tcl_Eval( itp, cmd );
}

taskSTIncr( sec, usec )
int sec, usec;
{
	TASK T;

	STATE S;

	char cmd[1024];

	REFRESH_GLOBAL( ST_CANVAS_HEIGHT );
	REFRESH_GLOBAL( ST_TIMELINE );
	REFRESH_GLOBAL( ST_ACTIVE );
	REFRESH_GLOBAL( TIMEX );

	/* Check Space-Time View Active */

	if ( !strcmp( CHAR_GLOBVAL( ST_ACTIVE ), "FALSE" ) )
		return;

	/* Adjust Time Line */

	sprintf( cmd, "%s coords %d %d %d %d %d",
		ST_C, INT_GLOBVAL( ST_TIMELINE ),
		INT_GLOBVAL( TIMEX ), 0,
		INT_GLOBVAL( TIMEX ), INT_GLOBVAL( ST_CANVAS_HEIGHT ) );

	Tcl_Eval( interp, cmd );

	/* Adjust Task State Rectangles */

	T = TASK_LIST;

	while ( T != NULL )
	{
		if ( T->status == TASK_ALIVE )
		{
			S = T->states;

			if ( S != NULL )
			{
				X2_COORD( S->rect ) = INT_GLOBVAL( TIMEX );

				SET_COORDS( interp, ST_C, S->rect );

				S->endtime.tv_sec = sec;
				S->endtime.tv_usec = usec;
			}
		}

		T = T->next;
	}
}

/* ARGSUSED */
int task_label_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	char label[1024];

	int index;

	index = atoi( argv[1] );

	T = TASK_LIST;

	while ( T != NULL && T->index != index )
		T = T->next;

	if ( T != NULL )
	{
		sprintf( label, "%s:%s TID=%x",
			host_name( T->host, FALSE ), T->name, T->tid );
	}

	else
		strcpy( label, "" );

	Tcl_SetResult( itp, copy_str( label ), TCL_DYNAMIC );

	return( TCL_OK );
}

/* ARGSUSED */
int task_query_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	STATE S;

	char value[1024];
	char cmd[1024];

	char *susec_pad;
	char *eusec_pad;

	int tindex1, tindex2;
	int id;

	id = atoi( argv[1] );

	tindex1 = atoi( argv[2] );
	tindex2 = atoi( argv[3] );

	T = TASK_LIST;

	while ( T != NULL && T->index < tindex1 )
		T = T->next;

	while ( T != NULL && T->index <= tindex2 )
	{
		S = T->states;

		while ( S != NULL )
		{
			if ( S->rect != NULL && S->rect->id == id )
			{
				/* Highlight State Rectangle */

				sprintf( cmd, "%s itemconfigure %d -width 3",
					ST_C, id );
				
				Tcl_Eval( itp, cmd );

				SET_TCL_GLOBAL( itp, "st_highlight_type", "state" );

				sprintf( value, "%d", id );

				SET_TCL_GLOBAL( itp, "st_highlight_id", value );

				/* Construct Info Message */

				susec_pad = pad_num( S->starttime.tv_usec, 6 );
				eusec_pad = pad_num( S->endtime.tv_usec, 6 );

				sprintf( value, "TID=%x: %s <%d.%s - %d.%s>",
					T->tid, S->callstr,
					S->starttime.tv_sec, susec_pad,
					S->endtime.tv_sec, eusec_pad );

				free( susec_pad );
				free( eusec_pad );

				sprintf( cmd,
			"%s.query_frame.query configure -text {View Info:   %s}",
					ST, value );

				Tcl_Eval( itp, cmd );

				SET_TCL_GLOBAL( itp, "st_query_text_scroll", "0" );

				SET_TCL_GLOBAL( itp, "st_query_text", value );

				Tcl_SetResult( itp, "1", TCL_STATIC );

				return( TCL_OK );
			}

			S = S->next;
		}

		T = T->next;
	}

	Tcl_SetResult( itp, "0", TCL_STATIC );

	return( TCL_OK );
}

/* ARGSUSED */
int task_reset_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	STATE S;

	char cmd[1024];

	REFRESH_GLOBAL( FRAME_BORDER );
	REFRESH_GLOBAL( FRAME_OFFSET );

	T = TASK_LIST;

	while ( T != NULL )
	{
		/* Delete Space-Time Label */

		DELETE_GOBJ( itp, ST_L, T->st_label );

		/* Delete Call Trace Label / Call String */

		DELETE_GOBJ( itp, CT_L, T->ct_label );

		DELETE_GOBJ( itp, CT_C, T->ct_callstr );

		/* Delete Space-Time State Rectangles */

		S = T->states;

		while ( S != NULL )
		{
			if ( S->rect != NULL )
			{
				DELETE_GOBJ( itp, ST_C, S->rect );
			}

			S = S->next;
		}

		T = T->next;
	}

	ST_SCROLL_MARK = INT_GLOBVAL( FRAME_OFFSET )
		* INT_GLOBVAL( FRAME_BORDER );

	return( TCL_OK );
}

/* ARGSUSED */
int task_zoom_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	STATE S;
	STATE last;

	char cmd[1024];

	char *color;

	int new_scale;
	int xrange;
	int x1, x2;

	REFRESH_GLOBAL( ST_OUTLINE_COLOR );
	REFRESH_GLOBAL( ST_RUNNING_COLOR );
	REFRESH_GLOBAL( ST_SYSTEM_COLOR );
	REFRESH_GLOBAL( ST_IDLE_COLOR );

	new_scale = atoi( argv[1] );

	T = TASK_LIST;

	while ( T != NULL )
	{
		S = T->states;

		last = (STATE) NULL;

		while ( S != NULL )
		{
			x1 = X_OF_TIME( S->starttime.tv_sec, S->starttime.tv_usec,
				new_scale );

			x2 = X_OF_TIME( S->endtime.tv_sec, S->endtime.tv_usec,
				new_scale );
	
			/* Create or Modify Rectangle */

			xrange = x2 - x1;

			if ( xrange
				&& ( xrange != 1
					|| last == NULL || last->rect == NULL ) )
			{
				if ( S->rect != NULL )
				{
					X1_COORD( S->rect ) = x1;
					X2_COORD( S->rect ) = x2;
		
					SET_COORDS( itp, ST_C, S->rect );
				}

				else
				{
					if ( S->status == STATE_RUNNING )
						color = CHAR_GLOBVAL( ST_RUNNING_COLOR );

					else if ( S->status == STATE_SYSTEM )
						color = CHAR_GLOBVAL( ST_SYSTEM_COLOR );

					else if ( S->status == STATE_IDLE )
						color = CHAR_GLOBVAL( ST_IDLE_COLOR );

					CREATE_RECT( interp, ST_C, S->rect,
						x1, T->y1, x2, T->y2,
						color, CHAR_GLOBVAL( ST_OUTLINE_COLOR ) );
				}
			}

			/* No Rectangle, Destroy if Present */

			else if ( S->rect != NULL )
			{
				if ( S != T->states )
				{
					DELETE_GOBJ( itp, ST_C, S->rect );
				}

				else
				{
					X1_COORD( S->rect ) = x1;
					X2_COORD( S->rect ) = x2;
		
					SET_COORDS( itp, ST_C, S->rect );
				}
			}

			last = S;

			S = S->next;
		}

		T = T->next;
	}

	return( TCL_OK );
}

/* ARGSUSED */
int task_ct_update_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	char cmd[1024];

	char *str;

	T = TASK_LIST;

	while ( T != NULL )
	{
		if ( T->status == TASK_ALIVE && T->states != NULL )
			str = T->states->callstr;

		else
			str = "(Task Exited)";

		sprintf( cmd, "%s itemconfigure %d -text {%s}",
			CT_C, T->ct_callstr->id, str );
		
		Tcl_Eval( itp, cmd );

		T = T->next;
	}

	return( TCL_OK );
}

/* ARGSUSED */
int task_ct_query_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TASK T;

	STATE S;

	char value[1024];

	char *usec_pad;

	int index;

	index = atoi( argv[1] );

	T = TASK_LIST;

	while ( T != NULL && T->index != index )
		T = T->next;

	if ( T != NULL && T->states != NULL )
	{
		S = T->states;

		usec_pad = pad_num( S->starttime.tv_usec, 6 );

		sprintf( value, "Time Stamp: %d.%s",
			S->starttime.tv_sec, usec_pad );

		free( usec_pad );
	}

	else
		strcpy( value, "" );

	Tcl_SetResult( itp, copy_str( value ), TCL_DYNAMIC );

	return( TCL_OK );
}

