
static char rcsid[] = 
	"$Id: pvm.c,v 3.20 1995/07/27 14:48:32 kohl Exp $";

#include "xpvm.h"

Tk_TimerProc *process_timer_proc();
Tk_TimerProc *recv_timer_proc();

Tk_IdleProc *process_event_proc();
Tk_IdleProc *recv_event_proc();

Tk_IdleProc *delete_host();
Tk_IdleProc *add_host();

Tk_TimerProc *recv_timer_proc( clientData )
ClientData clientData;
{
	Tk_DoWhenIdle( (Tk_IdleProc *) recv_event_proc, clientData );
}

Tk_IdleProc *recv_event_proc( clientData )
ClientData clientData;
{
	HOST H;

	int tids[1000];

	int before;
	int msgtag;
	int cnt;
	int len;
	int mid;
	int num;
	int tid;
	int src;
	int cc;
	int i;

	int xxx;

	REFRESH_GLOBAL( NET_DEAD_COLOR );

	xxx = (int) clientData;

	/* printf( "+" ); fflush( stdout ); */

	if ( FALSE && !(xxx % 100) )
	{
		printf( "." );
		fflush( stdout );
	}

	/* Check for PVM Events */

	before = TRACE_PENDING;

	cnt = 0;

	while ( cnt < 10 &&
		( (mid = pvm_nrecv( -1, 99 )) > 0 ||
			(mid = pvm_nrecv( -1, 100 )) > 0 ) ||
			( TRACE_OUT != NULL && (mid = pvm_nrecv( -1, -1 )) > 0 ) )
	{
		PVMCKERR( pvm_bufinfo( mid, &len, &msgtag, &src ),
			"Error Checking Message Buffer", exit( -1 ) );

		/* Host Added */

		if ( msgtag == 99 && src == 0x80000000 )
		{
			/* printf( "Notify Add\n" ); */

			cc = pvm_upkint( &num, 1, 1 );

			if ( cc < 0 )
				pvm_perror( "Error Unpacking Host Add Notify" );

			else
			{
				if ( num >= 1000 )
				{
					printf( "\nError: Notify TID Array Overflow\n\n" );

					num = 1000;
				}

				cc = pvm_upkint( tids, num, 1 );

				if ( cc < 0 )
					pvm_perror( "Error Unpacking Host Add TIDs" );

				else
				{
					for ( i=0 ; i < num ; i++ )
						pvm_notify( PvmHostDelete, 100, 1, &(tids[i]) );

					update_hosts( tids, num );
				}
			}
		}

		/* Host Deleted */

		else if ( msgtag == 100 && src == 0x80000000 )
		{
			/* printf( "Notify Delete\n" ); */

			cc = pvm_upkint( &tid, 1, 1 );

			if ( cc < 0 )
				pvm_perror( "Error Unpacking Host Delete Notify" );

			else
			{
				H = get_host_tid( tid, IN_PVM );

				if ( H != NULL )
				{
					if ( H->in_pvm == IN_PVM )
						H->in_pvm = NOT_IN_PVM;

					if ( TRACE_OUT != NULL )
					{
						if ( H->status != HOST_ADDED )
						{
							H->status = HOST_NOTIFY_DEL;

							SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
								CHAR_GLOBVAL( NET_DEAD_COLOR ), 2 );
						}

						update_trace_time( -1, -1 );

						write_host_del_event( H, tid );

						TRACE_PENDING++;
					}

					else
						H->status = HOST_OFF;
				}

				else
				{
					printf( "Missing Host for Notify Delete, tid=%x\n",
						tid );
				}
			}
		}

		/* PVM Trace Event */

		else if ( msgtag == 666 )
		{
			tid = pvm_tidtohost( src );

			if ( !tid )
				tid = pvm_tidtohost( MYTID );

			if ( TRACE_OUT != NULL )
				handle_trace_message( tid );
		}

		/* PVM Output Event */

		else if ( msgtag == 667 )
		{
			if ( TRACE_OUT != NULL )
				handle_output_message();
		}

		/* Unknown Message */

		else
		{
			fprintf( stderr,
				"XPVM Console: msg from t%x code %d len %d ?\n",
				src, msgtag, len );
		}

		PVMCKERR( pvm_freebuf( mid ),
			"Error Freeing Message Buffer", NOP );

		/* printf( "%d", cnt ); fflush( stdout ); */

		cnt++;
	}

	if ( mid < 0 )
	{
		pvm_perror( "PVM System Failure" );

		printf( "XPVM exiting...\n" );

		exit( -1 );
	}

	if ( TRACE_PENDING != before )
	{
		/* printf( "(%d -> %d)", before, TRACE_PENDING ); */

		/* printf( "X" ); fflush( stdout ); */

		if ( TRACE_OUT != NULL )
			fflush( TRACE_OUT );

		TRACE_ACTIVE = TRUE;
	}

	/* Set Up Next Event Recv Handler */

	if ( TRACE_ACTIVE && ( TRACE_STATUS == TRACE_FWD
		|| TRACE_STATUS == TRACE_FWDSTEP ) )
	{
		if ( TRACE_PENDING
			|| TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK )
		{
			Tk_DoWhenIdle( (Tk_IdleProc *) process_event_proc,
				(ClientData) NULL );
		}

		else
		{
			Tk_CreateTimerHandler( RECV_TIMER_INTERVAL,
				(Tk_TimerProc *) process_timer_proc,
				(ClientData) NULL );
		}
	}

	else
	{
		Tk_CreateTimerHandler( RECV_TIMER_INTERVAL,
			(Tk_TimerProc *) recv_timer_proc,
			(ClientData) ( xxx + 1 ) );
	}

	/* printf( "W" ); fflush( stdout ); */
}

/* ARGSUSED */
Tk_TimerProc *process_timer_proc( clientData )
ClientData clientData;
{
	Tk_DoWhenIdle( (Tk_IdleProc *) process_event_proc,
		(ClientData) NULL );
}

/* ARGSUSED */
Tk_IdleProc *process_event_proc( clientData )
ClientData clientData;
{
	struct timeval tm;

	int valid;
	int done;
	int cnt;

	/* printf( "-" ); fflush( stdout ); */

	check_host_status();

	if ( TRACE_STATUS == TRACE_FWD || TRACE_STATUS == TRACE_FWDSTEP )
	{
		/* printf( "F" ); fflush( stdout ); */

		if ( TRACE_PENDING || TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK )
		{
			/* printf( "E" ); fflush( stdout ); */

			done = 0;

			cnt = 0;

			while ( cnt < PROCESS_COUNTER_INTERVAL && !done )
			{
				/* printf( "E(%d)", TRACE_PENDING ); */
				/* fflush( stdout ); */

				TRACE_PROCESS_LOCK = TRACE_LOCKED;

				valid = read_trace_event();

				TRACE_PROCESS_LOCK = TRACE_UNLOCKED;

				/* Check for Mode Pending, Return if Not None */

				if ( check_mode_pending() )
				{
					/* Set Up Next Event Receiving Proc */

					Tk_DoWhenIdle( (Tk_IdleProc *) recv_event_proc,
						(ClientData) NULL );

					return;
				}

				/* Handle Event Process Return Code */

				if ( valid )
				{
					/* Update Trace Globals */

					if ( TRACE_STATUS == TRACE_FWDSTEP )
					{
						TRACE_STATUS = TRACE_STOP;

						set_trace_controls();

						done++;
					}

					if ( TRACE_FILE_STATUS != TRACE_FILE_PLAYBACK )
					{
						if ( TRACE_PENDING > 0 )
							TRACE_PENDING--;

						if ( !TRACE_PENDING )
							done++;
					}

					/* printf( "(%d)", TRACE_PENDING ); */
					/* fflush( stdout ); */
				}

				else
				{
					if ( TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK )
					{
						TRACE_STATUS = TRACE_STOP;

						set_trace_controls();

						Tcl_Eval( interp,
							"setMsg \"Trace Playback Complete\"" );
					}

					TRACE_ACTIVE = FALSE;

					done++;
				}

				cnt++;
			}

			/* printf( "U" ); fflush( stdout ); */
		}

		/* Update Current Time */

		else
		{
			/* printf( "T" ); fflush( stdout ); */

			if ( tasks_alive() )
			{
				/* printf( "t" ); fflush( stdout ); */

				gettimeofday( &tm, (struct timezone *) NULL );

				normalize_time( (TASK) NULL,
					&(tm.tv_sec), &(tm.tv_usec) );

				check_time( tm.tv_sec, tm.tv_usec );
			}

			else
			{
				if ( TASK_LIST != NULL )
				{
					Tcl_Eval( interp,
						"setMsg \"Trace Play Complete\"" );
				}

				TRACE_ACTIVE = FALSE;
			}
		}
	}

	/* Set Up Next Event Receiving Proc */

	Tk_DoWhenIdle( (Tk_IdleProc *) recv_event_proc, (ClientData) NULL );

	/* printf( "_" ); fflush( stdout ); */
}

set_task_tracing( tids, ntasks, tstat )
int *tids;
int ntasks;
char *tstat;
{
	int i;

	pvm_initsend( PvmDataDefault );

	/* Set Modified Trace Mask */

	if ( !strcmp( tstat, "On" ) )
	{
		if ( TRACE_FORMAT == TEV_FMT_33 )
			pvm_pkstr( TRACE33_MASK );

		else
			pvm_pkstr( TRACE_MASK );
	}

	/* Set EMPTY Trace Mask */

	else
	{
		if ( TRACE_FORMAT == TEV_FMT_33 )
			pvm_pkstr( TRACE33_MASK_CLEAR );

		else
			pvm_pkstr( TRACE_MASK_CLEAR );
	}

	pvm_mcast( tids, ntasks, TC_SETTMASK );
}

set_trace_buffer( buf )
int buf;
{
#ifndef USE_PVM_33
	pvm_setopt( PvmTraceBuffer, buf );
#endif
}

/* Test Hack */
/*
hack( sec, usec )
int sec;
int usec;
{
	ARCH get_arch_id();

	ARCH A;

	Tk_Window tkwin;

	XGCValues gcv;

	Pixmap p;

	GC gc;

	int winid;
	int mask;
	int i;

	if ( sec >= 2 )
	{
		printf( "sec=%d\n", sec );

		gcv.foreground = BlackPixelOfScreen( Tk_Screen( Top ) );
		gcv.background = WhitePixelOfScreen( Tk_Screen( Top ) );

		gcv.function = GXcopy;

		mask = GCForeground | GCBackground | GCFunction;

		gc = Tk_GetGC( Top, mask, &gcv );

		A = get_arch_id( sec );

		if ( A != NULL )
		{
			p = Tk_GetBitmap( interp, Top, Tk_GetUid( A->name ) );

			tkwin = Tk_NameToWindow( interp,
				".xpvm.space_time.canvas", Top );

			winid = Tk_WindowId( tkwin );

			printf( "p=%ld tkwin=%x winid=%ld\n", p, tkwin, winid );

			for ( i=0 ; i < 10 ; i++ )
			{
				XCopyPlane( Disp, p, winid, gc,
					0, 0, A->width, A->height, 10 * sec, 100 * i, 1 );
			}
		}
	}
}
*/
/* End of Test Hack */


add_all_hosts()
{
	HOST H;

	struct pvmhostinfo *HP;

	struct pvmhostinfo *hostp;

	char result[4096];
	char tmp[4192];

	char **hosts;

	char *iconstr;

	int *infos;
	
	int arrange;
	int nhosts;
	int found;
	int narch;
	int nhost;
	int i, j;
	int chk;
	int cc;

	REFRESH_GLOBAL( NET_ALIVE_COLOR );

	Tcl_Eval( interp, "setMsg \"Adding All Hosts...\"" );

	H = MAIN_NET->host_list;

	nhosts = 0;

	while ( H != NULL )
	{
		if ( H->in_pvm == NOT_IN_PVM )
			nhosts++;

		H = H->next;
	}

	if ( nhosts )
	{
		hosts = (char **) malloc( (unsigned) nhosts * sizeof(char *) );
		memcheck( hosts, "Add All Hosts List" );

		infos = (int *) malloc( (unsigned) nhosts * sizeof(int) );
		memcheck( infos, "Add All Hosts Infos" );

		H = MAIN_NET->host_list;

		i = 0;

		while ( H != NULL )
		{
			if ( H->in_pvm == NOT_IN_PVM )
				hosts[i++] = copy_str( H->refname );

			H = H->next;
		}

		/* printf( "All Host Add\n" ); */

		cc = pvm_addhosts( hosts, nhosts, infos );

		if ( cc < 0 )
		{
			pvm_perror( "Error Adding Hosts" );

			Tcl_Eval( interp, "setMsg \"Error Adding All Hosts.\"" );
		}

		else
		{
			chk = nhosts - cc;

			if ( chk < nhosts )
			{
				PVMCKERR( pvm_config( &nhost, &narch, &hostp ),
					"Error Checking Configuration", exit( -1 ) );
			}

			if ( chk )
				strcpy( result, "Error Adding Hosts: " );

			else
				strcpy( result, "All Hosts Added. " );

			arrange = 0;

			for ( i=0 ; i < nhosts ; i++ )
			{
				H = MAIN_NET->host_list;

				while ( H != NULL && strcmp( H->refname, hosts[i] ) )
					H = H->next;

				if ( infos[i] < 0 )
				{
					sprintf( tmp, "%s ", hosts[i] );

					append_cmd_str( result, tmp, 4096,
						(char *) NULL, FALSE );
				}

				else
				{
					H->in_pvm = IN_PVM;

					if ( H != NULL && H->arch == NULL )
					{
						found = 0;

						for ( j=0 ; j < nhost && !found ; j++ )
						{
							HP = &(hostp[j]);

							if ( HOST_COMPARE( H, HP->hi_name ) )
							{
								if ( strlen( HP->hi_name )
									> strlen( H->name ) )
								{
									free( H->name );

									H->name = copy_str( HP->hi_name );
								}

								H->arch = check_arch( H, HP->hi_arch );

								H->pvmd_tid = HP->hi_tid;

								H->speed = HP->hi_speed;

								found++;
							}
						}

						if ( found )
						{
							PVMCKERR( pvm_hostsync( H->pvmd_tid,
								(struct timeval *) NULL, &(H->delta) ),
								"Host Sync", NOP );
						}
					}

					for ( j=0 ; j < MAX_STATE ; j++ )
						H->counts[j] = 0;

					H->status = HOST_ADDED;

					create_network_host( H );

					SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
						CHAR_GLOBVAL( NET_ALIVE_COLOR ), 2 );

					if ( H->menuvar != NULL )
						SET_TCL_GLOBAL( interp, H->menuvar, "ON" );

					arrange++;
				}
			}

			if ( arrange )
				arrange_network_hosts( MAIN_NET );

			sprintf( tmp, "setMsg \"%s\"", result );

			Tcl_Eval( interp, tmp );
		}

		for ( i=0 ; i < nhosts ; i++ )
			free( hosts[i] );

		free( hosts );

		free( infos );
	}
}

do_add_host( H )
HOST H;
{
	Tk_DoWhenIdle( (Tk_IdleProc *) add_host, (ClientData) H );
}

Tk_IdleProc *add_host( clientData )
ClientData clientData;
{
	HOST H;

	struct pvmhostinfo *HP;

	struct pvmhostinfo *hostp;

	char result[4096];

	char *iconstr;

	int found;
	int narch;
	int nhost;
	int infos;
	int cc;
	int i;

	REFRESH_GLOBAL( NET_ALIVE_COLOR );

	H = (HOST) clientData;

	sprintf( result, "setMsg \"Adding Host %s...\"",
		host_name( H, TRUE ) );

	Tcl_Eval( interp, result );

	/* printf( "Host Add\n" ); */

	cc = pvm_addhosts( &(H->refname), 1, &infos );

	if ( cc < 0 || infos < 0 )
	{
		pvm_perror( H->refname );

		sprintf( result, "setMsg \"Error Adding Host %s.\"",
			host_name( H, TRUE ) );

		Tcl_Eval( interp, result );

		if ( H->menuvar != NULL )
			SET_TCL_GLOBAL( interp, H->menuvar, "OFF" );
	}

	else
	{
		/* Mark Host as Added */

		H->in_pvm = IN_PVM;

		/* Update Configuration Info */

		PVMCKERR( pvm_config( &nhost, &narch, &hostp ),
			"Error Checking Configuration", exit( -1 ) );

		found = 0;

		for ( i=0 ; i < nhost && !found ; i++ )
		{
			HP = &(hostp[i]);

			if ( HOST_COMPARE( H, HP->hi_name ) )
			{
				if ( strlen( HP->hi_name ) > strlen( H->name ) )
				{
					free( H->name );

					H->name = copy_str( HP->hi_name );
				}

				H->arch = check_arch( H, HP->hi_arch );

				H->pvmd_tid = HP->hi_tid;

				H->speed = HP->hi_speed;

				PVMCKERR( pvm_hostsync( H->pvmd_tid,
					(struct timeval *) NULL, &(H->delta) ),
					"Host Sync", NOP );

				found++;
			}
		}

		for ( i=0 ; i < MAX_STATE ; i++ )
			H->counts[i] = 0;

		H->status = HOST_ADDED;

		if ( TRACE_FILE_STATUS != TRACE_FILE_PLAYBACK )
		{
			create_network_host( H );

			SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
				CHAR_GLOBVAL( NET_ALIVE_COLOR ), 2 );

			arrange_network_hosts( MAIN_NET );
		}

		if ( H->menuvar != NULL )
			SET_TCL_GLOBAL( interp, H->menuvar, "ON" );

		sprintf( result, "setMsg \"Host %s Added.\"",
			host_name( H, TRUE ) );

		Tcl_Eval( interp, result );
	}
}

do_delete_host( H )
HOST H;
{
	Tk_DoWhenIdle( (Tk_IdleProc *) delete_host, (ClientData) H );
}

Tk_IdleProc *delete_host( clientData )
ClientData clientData;
{
	HOST H;

	struct pvmhostinfo *HP;

	struct pvmhostinfo *hostp;

	char result[4096];
	char tmp[1024];

	char *tmpptr;

	char *strcat();

	int found;
	int infos;
	int narch;
	int nhost;
	int cc;
	int i;

	REFRESH_GLOBAL( NET_DEAD_COLOR );

	H = (HOST) clientData;

	if ( LOCALHOST( H->name ) )
	{
		sprintf( result, "setMsg \"Error Deleting XPVM's Host, %s.\"",
			host_name( H, TRUE ) );

		Tcl_Eval( interp, result );

		if ( H->menuvar != NULL )
			SET_TCL_GLOBAL( interp, H->menuvar, "ON" );
	}

	else
	{
		sprintf( result, "setMsg \"Deleting Host %s...\"",
			host_name( H, TRUE ) );
	
		Tcl_Eval( interp, result );
	
		/* printf( "Host Delete\n" ); */

		sscanf( H->refname, "%s", tmp );

		tmpptr = tmp;

		cc = pvm_delhosts( &tmpptr, 1, &infos );

		if ( cc < 0 || infos < 0 )
		{
			pvm_perror( H->name );
	
			sprintf( result, "setMsg \"Error Deleting Host %s.\"",
				host_name( H, TRUE ) );

			Tcl_Eval( interp, result );
	
			PVMCKERR( pvm_config( &nhost, &narch, &hostp ),
				"Error Checking Configuration", exit( -1 ) );
	
			found = 0;

			for ( i=0 ; i < nhost && !found ; i++ )
			{
				HP = &(hostp[i]);

				if ( HOST_COMPARE( H, HP->hi_name ) )
					found++;
			}

			if ( !found )
			{
				H->in_pvm = NOT_IN_PVM;

				H->status = HOST_DELETED;

				if ( H->box != NULL )
				{
					SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
						CHAR_GLOBVAL( NET_DEAD_COLOR ), 2 );
				}

				if ( H->menuvar != NULL )
					SET_TCL_GLOBAL( interp, H->menuvar, "OFF" );
			}

			else
			{
				if ( H->menuvar != NULL )
					SET_TCL_GLOBAL( interp, H->menuvar, "ON" );
			}
		}
	
		else
		{
			/* Mark Host as Deleted */

			H->in_pvm = NOT_IN_PVM;

			H->status = HOST_DELETED;

			if ( H->box != NULL )
			{
				SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
					CHAR_GLOBVAL( NET_DEAD_COLOR ), 2 );
			}

			if ( H->menuvar != NULL )
				SET_TCL_GLOBAL( interp, H->menuvar, "OFF" );

			sprintf( result, "setMsg \"Host %s Deleted.\"",
				host_name( H, TRUE ) );
	
			Tcl_Eval( interp, result );
		}
	}
}

clear_hosts_for_playback()
{
	HOST H;

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->in_pvm == PLAYBACK_ADDED )
			H->in_pvm = PLAYBACK_UNUSED;

		H->status = HOST_OFF;

		if ( H->box != NULL )
			destroy_network_host( H, FALSE );

		H = H->next;
	}

	arrange_network_hosts( MAIN_NET );
}

restore_hosts_from_playback()
{
	HOST H;

	int i;

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->in_pvm == IN_PVM )
		{
			for ( i=0 ; i < MAX_STATE ; i++ )
				H->counts[i] = 0;

			if ( H->status == HOST_OFF )
			{
				H->status = HOST_ON;

				create_network_host( H );
			}

			if ( !LOCALHOST( H->name ) )
			{
				PVMCKERR( pvm_hostsync( H->pvmd_tid,
					(struct timeval *) NULL, &(H->delta) ),
					"Host Sync", NOP );
			}
		}

		else if ( H->in_pvm == PLAYBACK_ADDED )
		{
			H->in_pvm = PLAYBACK_UNUSED;

			H->status = HOST_OFF;

			destroy_network_host( H, FALSE );
		}

		H = H->next;
	}

	arrange_network_hosts( MAIN_NET );
}

handle_playback_host_add( refname, alias, arch, tid, speed )
char *refname;
char *alias;
char *arch;
int tid;
int speed;
{
	HOST H;

	HOST last;

	ARCH A;

	char name[1024];
	char tmp[2048];

	char *iconstr;

	int found;
	int i;

	REFRESH_GLOBAL( NET_ALIVE_COLOR );

	sscanf( refname, "%s", name );

	H = MAIN_NET->host_list;

	last = (HOST) NULL;

	found = 0;

	while ( H != NULL && !found )
	{
		if ( H->pvmd_tid == tid 
			&& !strcmp( H->name, name ) && !strcmp( H->alias, alias )
			&& H->arch != NULL && !strcmp( H->arch->code, arch ) )
		{
			if ( H->in_pvm == PLAYBACK_UNUSED )
				found++;

			else if ( H->in_pvm == PLAYBACK_ADDED )
				return;

			else
			{
				last = H;

				H = H->next;
			}
		}

		else
		{
			last = H;

			H = H->next;
		}
	}

	if ( !found )
	{
		if ( last == NULL )
			H = MAIN_NET->host_list = create_host();

		else
			H = last->next = create_host();

		H->index = NHOSTS;

		H->refname = copy_str( refname );

		H->name = copy_str( name );

		H->alias = copy_str( alias );

		H->arch = get_arch_code( arch );

		H->pvmd_tid = tid;

		H->speed = speed;

		NHOSTS++;
	}

	/* Update Interface */

	H->in_pvm = PLAYBACK_ADDED;

	for ( i=0 ; i < MAX_STATE ; i++ )
		H->counts[i] = 0;

	H->status = HOST_ON;

	create_network_host( H );

	arrange_network_hosts( MAIN_NET );

	flash_host( H, CHAR_GLOBVAL( NET_ALIVE_COLOR ), TRUE );
}

handle_playback_host_del( name, tid, tsec, tusec )
char *name;
int tid;
int tsec, tusec;
{
	HOST H;

	TASK T;

	char result[4096];
	char tmp[2048];

	int found;
	int cktm;

	H = MAIN_NET->host_list;

	found = 0;

	while ( H != NULL && !found )
	{
		if ( H->pvmd_tid == tid
			&& H->in_pvm == PLAYBACK_ADDED
			&& ( !strcmp( H->name, name ) || !strcmp( name, "" ) ) )
		{
			found++;
		}

		else
			H = H->next;
	}

	if ( found )
	{
		/* Kill off any tasks */

		normalize_time( (TASK) NULL, &tsec, &tusec );

		cktm = 0;

		T = TASK_LIST;

		while ( T != NULL )
		{
			if ( T->pvmd_tid == tid
				&& T->status != TASK_DEAD )
			{
				if ( !cktm )
				{
					check_time( tsec, tusec );

					cktm++;
				}

				taskExit( T, tsec, tusec, "Dead Host" );
			}

			T = T->next;
		}

		H->in_pvm = PLAYBACK_UNUSED;

		H->status = HOST_OFF;

		flash_host( H, CHAR_GLOBVAL( NET_DEAD_COLOR ), TRUE );

		destroy_network_host( H, TRUE );

		arrange_network_hosts( MAIN_NET );
	}
}

ARCH check_arch( H, arch )
HOST H;
char *arch;
{
	char *tmp;

	if ( Xflag )
	{
		if ( !strcmp( H->alias, "msr" ) )
			tmp = "PGON";

		else if ( !strcmp( H->alias, "icarus" ) )
			tmp = "I860";

		else if ( !strcmp( H->alias, "sparky" ) )
			tmp = "KSR1";

		else if ( !strcmp( H->alias, "rigel" ) )
			tmp = "CRAY";

		else if ( !strcmp( H->alias, "ig" ) )
			tmp = "CM5";

		else if ( !strcmp( H->alias, "honk" ) )
			tmp = arch;

		else
			tmp = arch;
	}

	else
		tmp = arch;

	return( get_arch_code( tmp ) );
}

char *host_name( H, full )
HOST H;
int full;
{
	char str[1024];

	char *tmp;

	int hacked;

	hacked = 0;

	if ( Xflag )
	{
		if ( !strcmp( H->alias, "msr" ) )
			{ tmp = "xps5"; hacked++; }

		else if ( !strcmp( H->alias, "icarus" ) )
			{ tmp = "rx"; hacked++; }

		else if ( !strcmp( H->alias, "sparky" ) )
			{ tmp = "ksr"; hacked++; }

		else
			tmp = H->alias;
	}

	else
		tmp = H->alias;

	if ( full && !hacked && strcmp( H->name, tmp ) )
		sprintf( str, "%s (%s)", H->name, tmp );

	else
		sprintf( str, "%s", tmp );

	return( copy_str( str ) );
}

