
static char rcsid[] = 
	"$Id: network.c,v 3.20 1995/07/27 14:48:30 kohl Exp $";

#include "xpvm.h"

char *BUTTHEAD[] =
{
	"HOST_OFF",
	"HOST_ON",
	"HOST_NOTIFY_DEL",
	"HOST_NOTIFY_ADD",
	"HOST_DELETED",
	"HOST_ADDED"
};

check_host_status()
{
	static int cnt = 0;

	HOST H;

	if ( ++cnt < 5 )
		return;
	
	cnt = 0;

	REFRESH_GLOBAL( NET_ALIVE_COLOR );
	REFRESH_GLOBAL( NET_DEAD_COLOR );

	/* printf( "check_host_status:\n" ); */

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		/*
		if ( H->status != HOST_OFF )
		{
			printf( "\t%s: status = %s\n", H->name,
				BUTTHEAD[ H->status ] );
		}
		*/

		switch ( H->status )
		{
			case HOST_OFF: break;

			case HOST_ON: break;

			case HOST_NOTIFY_ADD:
			case HOST_ADDED:
			{
				flash_host( H, CHAR_GLOBVAL( NET_ALIVE_COLOR ),
					FALSE );

				break;
			}

			case HOST_NOTIFY_DEL:
			case HOST_DELETED:
			{
				flash_host( H, CHAR_GLOBVAL( NET_DEAD_COLOR ),
					FALSE );

				break;
			}
		}

		H = H->next;
	}
}

netUpdate( H, old, new )
HOST H;
int old;
int new;
{
	char *color;

	REFRESH_GLOBAL( NET_RUNNING_COLOR );
	REFRESH_GLOBAL( NET_SYSTEM_COLOR );
	REFRESH_GLOBAL( NET_IDLE_COLOR );
	REFRESH_GLOBAL( NET_EMPTY_COLOR );

	if ( H == NULL || H->status == HOST_OFF )
	{
		if ( H == NULL )
			printf( "\nError: Null Host to netUpdate()\n\n" );

		return( FALSE );
	}

	/* Calculate New Counts */

	(H->counts[old])--;

	(H->counts[new])++;

	/* Calculate New Icon Color */

	if ( H->counts[STATE_RUNNING] > 0 )
		color = CHAR_GLOBVAL( NET_RUNNING_COLOR );

	else if ( H->counts[STATE_SYSTEM] > 0 )
		color = CHAR_GLOBVAL( NET_SYSTEM_COLOR );

	else if ( H->counts[STATE_IDLE] > 0 )
		color = CHAR_GLOBVAL( NET_IDLE_COLOR );

	else
		color = CHAR_GLOBVAL( NET_EMPTY_COLOR );

	if ( H->color == NULL || strcmp( H->color, color ) )
		draw_network_host( H, color );

	H->color = color;

	return( TRUE );
}

/* ARGSUSED */
int network_reset_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	NETLINK L;

	HOST H;

	char cmd[1024];

	char *color;

	int i;

	REFRESH_GLOBAL( NET_EMPTY_COLOR );
	REFRESH_GLOBAL( NET_FG_COLOR );

	color = CHAR_GLOBVAL( NET_EMPTY_COLOR );

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->status != HOST_OFF )
			draw_network_host( H, color );

		for ( i=0 ; i < MAX_STATE ; i++ )
			H->counts[i] = 0;

		H->color = (char *) NULL;

		for ( i=0 ; i < MAX_LINK ; i++ )
		{
			if ( (L = H->links[i]) != NULL )
			{
				if ( L->link != NULL )
				{
					sprintf( cmd,
						"%s itemconfigure %d -fill %s -width 2",
						MAIN_NET->NET_C, L->link->id,
						CHAR_GLOBVAL( NET_FG_COLOR ) );

					Tcl_Eval( itp, cmd );
				}

				L->msg_bytes = 0;

				L->msg_bw = 0;

				L->bw_start.tv_usec = 0;
				L->bw_start.tv_sec = 0;

				L->bw_end.tv_usec = 0;
				L->bw_end.tv_sec = 0;
			}
		}

		H = H->next;
	}

	for ( i=0 ; i < MAIN_NET->nlinks ; i++ )
	{
		if ( (L = MAIN_NET->links[i]) != NULL )
		{
			if ( L->link != NULL )
			{
				sprintf( cmd, "%s itemconfigure %d -fill %s -width 2",
					MAIN_NET->NET_C, L->link->id,
					CHAR_GLOBVAL( NET_FG_COLOR ) );

				Tcl_Eval( itp, cmd );
			}

			L->msg_bytes = 0;

			L->msg_bw = 0;

			L->bw_start.tv_usec = 0;
			L->bw_start.tv_sec = 0;

			L->bw_end.tv_usec = 0;
			L->bw_end.tv_sec = 0;
		}
	}

	return( TCL_OK );
}

/* ARGSUSED */
int network_host_find( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	NETLINK L;

	HOST H;

	char value[1024];

	char *susec_pad;
	char *eusec_pad;

	int canvx, canvy;
	int id;
	int i;

	id = atoi( argv[1] );

	canvx = atoi( argv[2] );
	canvy = atoi( argv[3] );

	/* Check for Host Click */

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->status != HOST_OFF )
		{
			if ( canvx >= X1_COORD( H->box )
				&& canvx <= X2_COORD( H->box )
				&& canvy >= Y1_COORD( H->box )
				&& canvy <= Y2_COORD( H->box ) )
			{
				sprintf( value, "Host %s:  run=%d sys=%d idl=%d",
					H->refname,
					H->counts[STATE_RUNNING],
					H->counts[STATE_SYSTEM],
					H->counts[STATE_IDLE] );

				Tcl_SetResult( itp, copy_str( value ), TCL_DYNAMIC );

				return( TCL_OK );
			}
		}

		H = H->next;
	}

	/* Check for Host Link Click */

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->status != HOST_OFF )
		{
			L = H->links[MAIN_LINK];

			if ( L != NULL && L->link->id == id )
			{
				susec_pad = pad_num( L->bw_start.tv_usec, 6 );
				eusec_pad = pad_num( L->bw_end.tv_usec, 6 );

				sprintf( value,
					"Host %s Link:  V=%d, BW=%d (%d.%s - %d.%s)",
					H->alias,
					L->msg_bytes, L->msg_bw,
					L->bw_start.tv_sec, susec_pad,
					L->bw_end.tv_sec, eusec_pad );

				free( susec_pad );
				free( eusec_pad );

				Tcl_SetResult( itp, copy_str( value ), TCL_DYNAMIC );

				return( TCL_OK );
			}
		}

		H = H->next;
	}

	/* Check for Network Link Click */

	for ( i=0 ; i < MAIN_NET->nlinks ; i++ )
	{
		if ( (L = MAIN_NET->links[i]) != NULL && L->link != NULL )
		{
			if ( L->link->id == id )
			{
				susec_pad = pad_num( L->bw_start.tv_usec, 6 );
				eusec_pad = pad_num( L->bw_end.tv_usec, 6 );

				sprintf( value,
					"Network Link:  V=%d, BW=%d (%d.%s - %d.%s)",
					L->msg_bytes, L->msg_bw,
					L->bw_start.tv_sec, susec_pad,
					L->bw_end.tv_sec, eusec_pad );

				free( susec_pad );
				free( eusec_pad );

				Tcl_SetResult( itp, copy_str( value ), TCL_DYNAMIC );

				return( TCL_OK );
			}
		}
	}

	/* Nothing Found */

	Tcl_SetResult( itp, "", TCL_STATIC );

	return( TCL_OK );
}

/* ARGSUSED */
int network_set_menuvar( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	HOST H;

	char *menuvar;

	int index;

	index = atoi( argv[1] );

	index -= MAX_HID;

	menuvar = copy_str( argv[2] );

	H = MAIN_NET->host_list;

	while ( H != NULL )
	{
		if ( H->index == index )
		{
			H->menuvar = menuvar;

			return( TCL_OK );
		}

		H = H->next;
	}

	free( menuvar );

	return( TCL_OK );
}

create_network_host( H )
HOST H;
{
	GOBJ G;

	char *net_empty_color;
	char *net_fg_color;

	char cmdopts[1024];
	char cmd[1024];

	int net_size;
	int xy;

	REFRESH_GLOBAL( NET_EMPTY_COLOR );
	REFRESH_GLOBAL( NET_FG_COLOR );
	REFRESH_GLOBAL( NET_SIZE );

	xy = -2 * INT_GLOBVAL( NET_SIZE );

	/* Undraw Any Old Host */

	if ( H->box != NULL )
		destroy_network_host( H, FALSE );

	/* Create Box */

	CREATE_RECT( interp, NET_C, H->box, xy, xy, xy, xy,
		CHAR_GLOBVAL( NET_EMPTY_COLOR ),
		CHAR_GLOBVAL( NET_FG_COLOR ) );

	/* Create Icon */

	if ( H->arch == NULL )
		H->arch = get_arch_code( "DUMMY" );

	H->icon = create_gobj();

	sprintf( cmdopts,
		"-bitmap %s -anchor center -foreground %s -background %s",
		H->arch->name, CHAR_GLOBVAL( NET_FG_COLOR ),
		CHAR_GLOBVAL( NET_EMPTY_COLOR ) );

	sprintf( cmd, "%s create bitmap %d %d %s", NET_C, xy, xy, cmdopts );

	Tcl_Eval( interp, cmd );

	H->icon->id = atoi( interp->result );

	X_COORD( H->icon ) = Y_COORD( H->icon ) = xy;

	H->icon->color = CHAR_GLOBVAL( NET_EMPTY_COLOR );

	/* Create Name */

	H->nme = create_gobj();

	sprintf( cmd,
		"%s create text %d %d -text {%s} -anchor center -fill %s",
		NET_C, xy, xy, trunc_str( H->alias, 8 ),
		CHAR_GLOBVAL( NET_FG_COLOR ) );

	Tcl_Eval( interp, cmd );

	H->nme->id = atoi( interp->result );

	X_COORD( H->nme ) = Y_COORD( H->nme ) = xy;

	H->nme->color = CHAR_GLOBVAL( NET_FG_COLOR );

	/* Create Link */

	H->links[MAIN_LINK] = create_netlink();
	
	H->links[MAIN_LINK]->msg_bytes = 0;

	CREATE_NET_LINK( interp, MAIN_NET->NET_C,
		H->links[MAIN_LINK]->link,
		xy, xy, xy, xy, CHAR_GLOBVAL( NET_FG_COLOR ) );

	/* Set Menuvar & Arrange Hosts */

	if ( H->menuvar != NULL )
		SET_TCL_GLOBAL( interp, H->menuvar, "ON" );
}

destroy_network_host( H, flash )
HOST H;
int flash;
{
	char cmd[1024];

	char *color;

	REFRESH_GLOBAL( NET_DEAD_COLOR );

	if ( H->box != NULL )
	{
		/* Flash Dead Host */

		if ( flash )
		{
			flash_host( H, CHAR_GLOBVAL( NET_DEAD_COLOR ), TRUE );

			draw_network_host( H, CHAR_GLOBVAL( NET_DEAD_COLOR ) );
		}

		/* Remove Dead Host */

		if ( H->links[MAIN_LINK] != NULL )
		{
			sprintf( cmd, "%s delete %d %d %d %d",
				NET_C, H->box->id, H->icon->id, H->nme->id,
				H->links[MAIN_LINK]->link->id );
		}

		else
		{
			sprintf( cmd, "%s delete %d %d %d",
				NET_C, H->box->id, H->icon->id, H->nme->id );
		}

		Tcl_Eval( interp, cmd );

		free_gobj( &(H->box) );
		free_gobj( &(H->icon) );
		free_gobj( &(H->nme) );

		if ( H->links[MAIN_LINK] != NULL )
		{
			free_gobj( &(H->links[MAIN_LINK]->link) );

			free_netlink( &(H->links[MAIN_LINK]) );
		}
	}

	if ( H->menuvar != NULL )
		SET_TCL_GLOBAL( interp, H->menuvar, "OFF" );
}

flash_host( H, color, bigflash )
HOST H;
char *color;
int bigflash;
{
	char *orig_color;

	int orig_status;
	int num;
	int i;

	REFRESH_GLOBAL( NET_EMPTY_COLOR );

	if ( bigflash )
	{
		REFRESH_GLOBAL( NET_FLASH );

		num = INT_GLOBVAL( NET_FLASH );
	}

	else
		num = 1;

	orig_color = ( H->color != NULL ) ? H->color :
		CHAR_GLOBVAL( NET_EMPTY_COLOR );

	orig_status = H->status;

	for ( i=0 ; i < num && H->status == orig_status ; i++ )
	{
		if ( H->status == orig_status )
		{
			draw_network_host( H, color );

			Tcl_Eval( interp, "update" );
		}

		if ( H->status == orig_status )
		{
			draw_network_host( H, orig_color );

			Tcl_Eval( interp, "update" );
		}
	}
}

arrange_network_hosts( N )
NETWORK N;
{
	NETLINK L;

	HOST H;

	GOBJ G;

	MSG M;

	char value[1024];
	char cmd[1024];

	int net_hheight, net_hwidth;
	int startwt, endwt;
	int Xtop, Xbot;
	int hi_y, lo_y;
	int iwt, iht;
	int numlinks;
	int totalwt;
	int nactive;
	int x1, x2;
	int y1, y2;
	int ix, iy;
	int first;
	int lastx;
	int nlink;
	int vert;
	int ly;
	int ny;
	int cy;
	int i;

	REFRESH_GLOBAL( NET_FG_COLOR );
	REFRESH_GLOBAL( BORDER_SPACE );
	REFRESH_GLOBAL( ICON_BORDER );
	REFRESH_GLOBAL( ICON_SPACE );
	REFRESH_GLOBAL( ROW_HEIGHT );
	REFRESH_GLOBAL( NET_SPACE );

	/* Get Network Info */

	info_network_hosts( N, &totalwt, &startwt, &endwt, &nactive,
		&hi_y, &lo_y, &numlinks );

	/* Set Network Size Globals */

	hi_y -= INT_GLOBVAL( BORDER_SPACE );
	lo_y += INT_GLOBVAL( BORDER_SPACE );

	net_hheight = lo_y - hi_y;

	sprintf( value, "%d", net_hheight );

	SET_TCL_GLOBAL( interp, "net_hheight", value );

	if ( totalwt > 0 )
		net_hwidth = totalwt + (2 * INT_GLOBVAL( BORDER_SPACE ) );
	
	else
		net_hwidth = 0;

	sprintf( value, "%d", net_hwidth );

	SET_TCL_GLOBAL( interp, "net_hwidth", value );

	/* Initialize Working Vars */

	Xtop = -1 * ( totalwt / 2 );

	Xbot = -1 * ( totalwt / 2 );

	cy = ( (lo_y - hi_y) / 2 ) - lo_y;

	/* (Re)Allocate Network Links Storage */

	if ( N->links != NULL )
	{
		for ( i=0 ; i < N->nlinks ; i++ )
		{
			DELETE_GOBJ( interp, N->NET_C, N->links[i]->link );

			free_netlink( &(N->links[i]) );
		}

		free( N->links );

		N->links = (NETLINK *) NULL;
	}

	if ( numlinks > 0 )
	{
		N->links = (NETLINK *) malloc( (unsigned) numlinks
			* sizeof(NETLINK) );
		memcheck( N->links, "Network Links Array" );
	}

	N->nlinks = numlinks;

	/* Place Individual Hosts */

	vert = ARRANGE_TOP;

	first = TRUE;

	nlink = 0;

	H = N->host_list;

	while ( H != NULL )
	{
		/* If ON, Update Host Image */

		if ( H->status != HOST_OFF )
		{
			iht = H->arch->height;
			iwt = H->arch->width;

			/* Place Icon */

			if ( vert == ARRANGE_TOP )
			{
				ix = Xtop + ( iwt / 2 );

				iy = cy - ( ( iht / 2 ) + INT_GLOBVAL( ROW_HEIGHT )
					+ INT_GLOBVAL( ICON_BORDER )
					+ INT_GLOBVAL( NET_SPACE ) );
			}

			else
			{
				ix = Xbot + ( iwt / 2 );

				iy = cy + ( iht / 2 ) + INT_GLOBVAL( ICON_BORDER )
					+ INT_GLOBVAL( NET_SPACE );
			}

			sprintf( cmd, "%s coords %d %d %d",
				NET_C, H->icon->id, ix, iy );
			
			Tcl_Eval( interp, cmd );

			/* Place Host Name */

			ny = iy + ( iht / 2 ) + ( INT_GLOBVAL( ROW_HEIGHT ) / 2 );

			sprintf( cmd, "%s coords %d %d %d",
				NET_C, H->nme->id, ix, ny );
			
			Tcl_Eval( interp, cmd );

			/* Place Bounding Box */

			if ( vert == ARRANGE_TOP )
			{
				x1 = Xtop - INT_GLOBVAL( ICON_BORDER );

				x2 = Xtop + iwt + INT_GLOBVAL( ICON_BORDER );
			}

			else
			{
				x1 = Xbot - INT_GLOBVAL( ICON_BORDER );

				x2 = Xbot + iwt + INT_GLOBVAL( ICON_BORDER );
			}

			y1 = iy - ( iht / 2 ) - INT_GLOBVAL( ICON_BORDER );

			y2 = y1 + iht + INT_GLOBVAL( ROW_HEIGHT )
				+ INT_GLOBVAL( ICON_BORDER );

			X1_COORD( H->box ) = x1;
			Y1_COORD( H->box ) = y1;
			X2_COORD( H->box ) = x2;
			Y2_COORD( H->box ) = y2;

			SET_COORDS( interp, NET_C, H->box );

			/* Place Host Link */

			if ( nactive > 1 )
			{
				if ( vert == ARRANGE_TOP )
					ly = y2;

				else
					ly = y1;

				L = H->links[MAIN_LINK];

				/* Create New Link */

				if ( L == NULL )
				{
					L = H->links[MAIN_LINK] = create_netlink();
	
					CREATE_NET_LINK( interp, N->NET_C, L->link,
						ix, cy, ix, ly, CHAR_GLOBVAL( NET_FG_COLOR ) );
				}

				/* Reset & Place Old Link */

				else
				{
					sprintf( cmd,
						"%s itemconfigure %d -fill %s -width 2",
						N->NET_C, L->link->id,
						CHAR_GLOBVAL( NET_FG_COLOR ) );

					Tcl_Eval( interp, cmd );

					L->msg_bytes = 0;

					L->msg_bw = 0;

					L->bw_start.tv_usec = 0;
					L->bw_start.tv_sec = 0;

					L->bw_end.tv_usec = 0;
					L->bw_end.tv_sec = 0;

					X1_COORD( L->link ) = ix;
					Y1_COORD( L->link ) = cy;
	
					X2_COORD( L->link ) = ix;
					Y2_COORD( L->link ) = ly;
	
					SET_COORDS( interp, N->NET_C, L->link );
				}
			}

			else if ( H->links[MAIN_LINK] != NULL )
			{
				DELETE_GOBJ( interp, N->NET_C,
					H->links[MAIN_LINK]->link );

				free_netlink( &(H->links[MAIN_LINK]) );
			}

			/* Place Any Network Link */

			if ( first )
			{
				lastx = ix;

				first = FALSE;
			}

			else if ( ix > lastx )
			{
				/* Add New Link */

				N->links[nlink] = create_netlink();
				
				N->links[nlink]->msg_bytes = 0;

				CREATE_NET_LINK( interp, N->NET_C,
					N->links[nlink]->link,
					lastx, cy, ix, cy, CHAR_GLOBVAL( NET_FG_COLOR ) );

				nlink++;

				lastx = ix;
			}

			else if ( ix < lastx )
			{
				/* Split Old Link */

				G = N->links[ nlink - 1 ]->link;

				X2_COORD( G ) = ix;

				SET_COORDS( interp, N->NET_C, G );

				/* Add New Link */

				N->links[nlink] = create_netlink();
				
				N->links[nlink]->msg_bytes = 0;

				CREATE_NET_LINK( interp, N->NET_C,
					N->links[nlink]->link,
					ix, cy, lastx, cy, CHAR_GLOBVAL( NET_FG_COLOR ) );

				nlink++;

				lastx = ix;
			}

			/* Toggle TOP / BOT vert flag */

			if ( vert == ARRANGE_TOP )
			{
				Xtop = Xtop + iwt + INT_GLOBVAL( ICON_SPACE )
					+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

				vert = ARRANGE_BOT;
			}

			else
			{
				Xbot = Xbot + iwt + INT_GLOBVAL( ICON_SPACE )
					+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

				vert = ARRANGE_TOP;
			}
		}

		H = H->next;
	}

	/* Add Pending Message Volumes */

	M = PENDING_MSG_LIST;

	while ( M != NULL )
	{
		if ( M->recvtime.tv_sec == -1 && M->recvtime.tv_usec == -1 )
			net_add_message( M );
		
		M = M->next;
	}

	Tcl_Eval( interp, "setNetworkView" );
}

info_network_hosts( N, totalwt, startwt, endwt, nactive,
	high_y, low_y, num_links )
NETWORK N;
int *totalwt;
int *startwt;
int *endwt;
int *nactive;
int *high_y;
int *low_y;
int *num_links;
{
	HOST H;

	int startwt_top, startwt_bot;
	int endwt_top, endwt_bot;
	int topwt, botwt;
	int topx, botx;
	int hi_y, lo_y;
	int iwt, iht;
	int numlinks;
	int y1, y2;
	int first;
	int lastx;
	int vert;
	int ix;

	REFRESH_GLOBAL( ICON_BORDER );
	REFRESH_GLOBAL( ICON_SPACE );
	REFRESH_GLOBAL( ROW_HEIGHT );
	REFRESH_GLOBAL( NET_SPACE );

	/* Initialize Working Vars */

	startwt_top = -1;
	startwt_bot = -1;

	endwt_top = -1;
	endwt_bot = -1;

	vert = ARRANGE_TOP;

	*nactive = 0;

	numlinks = 0;

	first = TRUE;

	topwt = 0;
	botwt = 0;

	topx = 0;
	botx = 0;

	hi_y = 0;
	lo_y = 0;

	/* Process Host List */

	H = N->host_list;

	while ( H != NULL )
	{
		if ( H->status != HOST_OFF )
		{
			iht = H->arch->height;
			iwt = H->arch->width;

			if ( vert == ARRANGE_TOP )
			{
				topwt += iwt + INT_GLOBVAL( ICON_SPACE )
					+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

				if ( startwt_top == -1 )
					startwt_top = iwt;

				endwt_top = iwt;

				topx += iwt / 2;

				ix = topx;

				y1 = -1 * ( iht + INT_GLOBVAL( NET_SPACE )
					+ INT_GLOBVAL( ROW_HEIGHT )
					+ ( 2 * INT_GLOBVAL( ICON_BORDER ) ) );

				if ( y1 < hi_y )
					hi_y = y1;

				vert = ARRANGE_BOT;
			}

			else
			{
				botwt += iwt + INT_GLOBVAL( ICON_SPACE )
					+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

				if ( startwt_bot == -1 )
					startwt_bot = iwt;

				endwt_bot = iwt;

				botx += iwt / 2;

				ix = botx;

				y2 = iht + INT_GLOBVAL( NET_SPACE )
					+ INT_GLOBVAL( ROW_HEIGHT )
					+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

				if ( y2 > lo_y )
					lo_y = y2;

				vert = ARRANGE_TOP;
			}

			(*nactive)++;

			/* Count Network Links */

			if ( first )
			{
				lastx = ix;

				first = FALSE;
			}

			else if ( lastx != ix )
			{
				numlinks++;

				lastx = ix;
			}
		}

		H = H->next;
	}

	topwt -= INT_GLOBVAL( ICON_SPACE )
		+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

	botwt -= INT_GLOBVAL( ICON_SPACE )
		+ ( 2 * INT_GLOBVAL( ICON_BORDER ) );

	/* Determine Largest Total Width */

	if ( topwt > botwt )
		*totalwt = topwt;

	else
		*totalwt = botwt;

	/* Determine Smallest Starting Host Width */

	if ( startwt_bot != -1 )
	{
		if ( startwt_top < startwt_bot )
			*startwt = startwt_top;

		else
			*startwt = startwt_bot;
	}

	else
		*startwt = startwt_top;

	/* Determine Ending Host Width */

	topwt -= ( endwt_top / 2 );

	if ( startwt_bot != -1 )
	{
		botwt -= ( endwt_bot / 2 );

		if ( topwt > botwt )
			*endwt = endwt_top;

		else
			*endwt = endwt_bot;
	}

	else
		*endwt = endwt_top;

	/* Save High & Low Y */

	*high_y = hi_y;
	*low_y = lo_y;

	/* Save Number of Network Links */

	*num_links = numlinks;
}

draw_network_host( H, color )
HOST H;
char *color;
{
	char cmd[1024];

	REFRESH_GLOBAL( DEPTH );

	sprintf( cmd, "%s itemconfigure %d -background %s",
		NET_C, H->icon->id, color );
	Tcl_Eval( interp, cmd );

	if ( INT_GLOBVAL( DEPTH ) > 1 )
	{
		sprintf( cmd, "%s itemconfigure %d -fill %s",
			NET_C, H->box->id, color );
		Tcl_Eval( interp, cmd );
	}

	else
	{
		if ( !strcmp( color, "black" ) )
		{
			sprintf( cmd, "%s itemconfigure %d -foreground white",
				NET_C, H->icon->id );
			Tcl_Eval( interp, cmd );
		}

		else
		{
			sprintf( cmd, "%s itemconfigure %d -foreground black",
				NET_C, H->icon->id );
			Tcl_Eval( interp, cmd );
		}
	}
}

/* Network Message Routines */

net_add_message( M )
MSG M;
{
	HOST SH, DH;

	NETLINK LS, LD;
	NETLINK L;

	char cmd[1024];

	int nbytes;
	int xs, xd;
	int x1, x2;
	int i;

	REFRESH_NET_VOLUME_COLORS;

	if ( M->ST == NULL || M->DT == NULL )
		return;

	/* Get Source & Dest Host */

	SH = M->ST->host;
	DH = M->DT->host;

	/* Add Message to Network Volume */

	if ( SH != DH )
	{
		LS = SH->links[MAIN_LINK];
		LD = DH->links[MAIN_LINK];

		if ( LS == NULL || LD == NULL )
			return;

		xs = X2_COORD( LS->link );
		xd = X2_COORD( LD->link );

		x1 = xs < xd ? xs : xd;
		x2 = xs > xd ? xs : xd;

		nbytes = M->assbytes;

		/* Src Host Link */

		LS->msg_bytes += nbytes;

		NET_COLOR_LINK_VOLUME( interp, MAIN_NET->NET_C, LS );

		/* Dest Host Link */

		LD->msg_bytes += nbytes;

		NET_COLOR_LINK_VOLUME( interp, MAIN_NET->NET_C, LD );

		/* Network Links */

		for ( i=0 ; i < MAIN_NET->nlinks ; i++ )
		{
			L = MAIN_NET->links[i];

			if ( x1 <= X1_COORD( L->link )
				&& X2_COORD( L->link ) <= x2 )
			{
				L->msg_bytes += nbytes;

				NET_COLOR_LINK_VOLUME( interp, MAIN_NET->NET_C, L );
			}
		}
	}
}

net_del_message( M, queued )
MSG M;
int queued;
{
	HOST SH, DH;

	NETLINK LS, LD;
	NETLINK L;

	char cmd[1024];

	int elapsed;
	int nbytes;
	int xs, xd;
	int x1, x2;
	int bw;
	int i;

	REFRESH_NET_VOLUME_COLORS;

	if ( M->ST == NULL || M->DT == NULL )
		return;

	/* Get Source & Dest Host */

	SH = M->ST->host;
	DH = M->DT->host;

	/* Delete Message from Network Volume & Do Bandwidth */

	if ( SH != DH )
	{
		LS = SH->links[MAIN_LINK];
		LD = DH->links[MAIN_LINK];

		if ( LS == NULL || LD == NULL )
			return;

		xs = X2_COORD( LS->link );
		xd = X2_COORD( LD->link );

		x1 = xs < xd ? xs : xd;
		x2 = xs > xd ? xs : xd;

		/* Src & Dest Link Volumes */

		if ( queued )
		{
			nbytes = M->assbytes;

			LS->msg_bytes -= nbytes;

			NET_COLOR_LINK_VOLUME( interp, MAIN_NET->NET_C, LS );

			LD->msg_bytes -= nbytes;

			NET_COLOR_LINK_VOLUME( interp, MAIN_NET->NET_C, LD );
		}

		/* Src & Dest Link Bandwidth */

		elapsed = TIME_ELAPSED( M->sendtime, M->recvtime );

		if ( elapsed > 0 )
		{
			bw = 1000000 * M->nbytes / elapsed;

			NET_BANDWIDTH( interp, MAIN_NET->NET_C, LS, M, bw );

			NET_BANDWIDTH( interp, MAIN_NET->NET_C, LD, M, bw );
		}

		/* Network Links */

		for ( i=0 ; i < MAIN_NET->nlinks ; i++ )
		{
			L = MAIN_NET->links[i];

			if ( x1 <= X1_COORD( L->link )
				&& X2_COORD( L->link ) <= x2 )
			{
				if ( queued )
				{
					L->msg_bytes -= nbytes;

					NET_COLOR_LINK_VOLUME( interp, MAIN_NET->NET_C, L );
				}

				if ( elapsed > 0 )
					NET_BANDWIDTH( interp, MAIN_NET->NET_C, L, M, bw );
			}
		}
	}
}

