
/* $Id: const.h,v 3.20 1995/07/27 14:48:58 kohl Exp $ */

/* XPVM Version */

#define XPVM_VERSION "1.1.1"

/* Define Default Location of XPVM Main Directory */

#define XPVM_DEFAULT_DIR "pvm3/xpvm"

/* Define Default Location of Hostfile */

#define DEFAULT_HOSTFILE ".xpvm_hosts"

/* Define Maximum Trace Message Unpacking Array Size */

#define MAX_UNPACK_ARR_SIZE    1024

/* Hosts Console Command IDs */
#define ADD_ALL_HID    0
#define OTHER_HOST_HID 1
#define MAX_HID        2

/* Playback Controls Command IDs */
#define TRACE_REWIND     0
#define TRACE_STOP       1
#define TRACE_FWD        2
#define TRACE_FWDSTEP    3
#define MAX_TRACE        4

/* Trace File Status Flag Values */
#define TRACE_FILE_OVERWRITE    0
#define TRACE_FILE_PLAYBACK     1
#define MAX_TRACE_FILE          2

/* Trace Mode Pending Marker Values */
#define TRACE_MODE_NONE     0
#define TRACE_MODE_RESET    1

/* Trace Process Lock Constants */
#define TRACE_UNLOCKED    0
#define TRACE_LOCKED      1

/* Group Task Check Macro */
#define GROUPTASK( _name ) \
	( compare( "pvmg", _name ) || compare( "pvmcg", _name ) )

/* PVM Error Check Macro */

#define NOP    (TMP_CC = TMP_CC)

#define PVMCKERR( _cmd, _str, _handle ) \
{ \
	TMP_CC = _cmd; \
\
	if ( TMP_CC < 0 ) \
	{ \
		pvm_perror( _str ); \
\
		_handle; \
	} \
} \
\

/* Trace File EOF Check Macro */

#define CKEOF( _c, _str, _handle ) \
{ \
	if ( _c == (char) EOF ) \
	{ \
		printf( _str ); \
\
		_handle; \
	} \
} \
\

/* TEV Format Constants */
#define TEV_FMT_33    0
#define TEV_FMT_34    1

/* TEV Type Constants */
#define ENTRY_TEV    0
#define EXIT_TEV     1
#define IGNORE_TEV   2
#define MAX_TEV      3

/* In PVM Constants */
#define NOT_IN_PVM      0
#define IN_PVM          1
#define TO_BE_ADDED     2
#define PLAYBACK_ADDED  3
#define PLAYBACK_UNUSED 4

/* Network View Layout Types */
#define NETWORK_BUS     0
#define NETWORK_MESH    1
#define NETWORK_SWITCH  2

/* Network View Host Link ID Constants */
#define MAIN_LINK     0
#define LINK_NORTH    0
#define LINK_EAST     1
#define LINK_SOUTH    2
#define LINK_WEST     3
#define MAX_LINK      4

/* Host Drawn Status Constants */
#define HOST_OFF          0
#define HOST_ON           1
#define HOST_NOTIFY_DEL   2
#define HOST_NOTIFY_ADD   3
#define HOST_DELETED      4
#define HOST_ADDED        5

/* Task Status Constants */
#define TASK_DEAD    0
#define TASK_ALIVE   1
#define TASK_IGNORE  2

/* Task Output Status Constants */
#define TASK_NOOUT   0
#define TASK_OUT     1
#define TASK_EOF     2

/* Task State Constants */
#define STATE_RUNNING   0
#define STATE_SYSTEM    1
#define STATE_IDLE      2
#define STATE_DEAD      3
#define STATE_NONE      4
#define MAX_STATE       5

/* Network Layout Constants */
#define ARRANGE_TOP   0
#define ARRANGE_BOT   1

/* True / False Constants */
#define FALSE    0
#define TRUE     1

/* Number of Unix Signals */
#define NUM_SIGNALS    31

/* TRIE Size */
#define TRIE_SIZE 37

/* Max Number of Coordinates for GOBJs */
#define MAX_GOBJ_COORDS    4

/* Handy Byte References */
#define NBYTES_1K       1024
#define NBYTES_1M    1048576

/* Event Record Data Value Macro */

#define ARR_VALUE_OF( _ptr, _dtype, _index ) \
	( ((_dtype *) (_ptr))[_index] )

#define VALUE_OF( _ptr, _dtype )    ( *( (_dtype *) (_ptr) ) )

/* GOBJ Coordinate Identifiers */

#define X_COORD( _gobj )    ( (_gobj)->coords[0] )
#define Y_COORD( _gobj )    ( (_gobj)->coords[1] )

#define X1_COORD( _gobj )    ( (_gobj)->coords[0] )
#define Y1_COORD( _gobj )    ( (_gobj)->coords[1] )
#define X2_COORD( _gobj )    ( (_gobj)->coords[2] )
#define Y2_COORD( _gobj )    ( (_gobj)->coords[3] )

/* TCL Globals Constants & Macros */

#define TCL_GLOBAL_CHAR   0
#define TCL_GLOBAL_INT    1

#define MAKE_TCL_GLOBAL( _name, _type ) \
	( TMP_GLOBAL = create_tcl_global(), \
		TMP_GLOBAL->name = _name, \
		TMP_GLOBAL->type = _type, \
		TMP_GLOBAL )

#define GET_TCL_GLOBAL( _itp, _name ) \
	Tcl_GetVar( _itp, _name, TCL_GLOBAL_ONLY )

#define SET_TCL_GLOBAL( _itp, _name, _str ) \
	Tcl_SetVar( _itp, _name, _str, TCL_GLOBAL_ONLY )

#define REFRESH_GLOBAL( _glob ) \
{ \
	(_glob)->char_value = GET_TCL_GLOBAL( interp, (_glob)->name ); \
\
	if ( (_glob)->type == TCL_GLOBAL_INT ) \
		(_glob)->int_value = atoi( (_glob)->char_value ); \
} \
\

#define CHAR_GLOBVAL( _glob )    ( (_glob)->char_value )

#define INT_GLOBVAL( _glob )    ( (_glob)->int_value )

/* Timeval Manipulation Macros */

#define TIME_COMPARE( _sec1, _usec1, _sec2, _usec2 ) \
( \
	( (_sec1) > (_sec2) \
			|| ( (_sec1) == (_sec2) && (_usec1) > (_usec2) ) ) ? 1 : \
		( ( (_sec1) == (_sec2) && (_usec1) == (_usec2) ) ? 0 : -1 ) \
) \
\

#define TIME_ELAPSED( _t1, _t2 ) \
( \
	( ( (_t2).tv_sec - (_t1).tv_sec ) * 1000000 ) \
		+ ( (_t2).tv_usec - (_t1).tv_usec ) \
) \
\

#define TIME_OVERLAP( _t, _t1, _t2 ) \
\
	( TIME_COMPARE( (_t).tv_sec, (_t).tv_usec, \
			(_t1).tv_sec, (_t1).tv_usec ) >= 0 \
		&& TIME_COMPARE( (_t).tv_sec, (_t).tv_usec, \
			(_t2).tv_sec, (_t2).tv_usec ) <= 0 )  \
\

#define TIME_MIN( _t1, _t2, _t ) \
{ \
	if ( TIME_COMPARE( (_t1).tv_sec, (_t1).tv_usec, \
		(_t2).tv_sec, (_t2).tv_usec ) <= 0 ) \
	{ \
		(_t).tv_sec = (_t1).tv_sec; \
		(_t).tv_usec = (_t1).tv_usec; \
	} \
\
	else \
	{ \
		(_t).tv_sec = (_t2).tv_sec; \
		(_t).tv_usec = (_t2).tv_usec; \
	} \
} \
\

#define TIME_MAX( _t1, _t2, _t ) \
{ \
	if ( TIME_COMPARE( (_t1).tv_sec, (_t1).tv_usec, \
		(_t2).tv_sec, (_t2).tv_usec ) >= 0 ) \
	{ \
		(_t).tv_sec = (_t1).tv_sec; \
		(_t).tv_usec = (_t1).tv_usec; \
	} \
\
	else \
	{ \
		(_t).tv_sec = (_t2).tv_sec; \
		(_t).tv_usec = (_t2).tv_usec; \
	} \
} \
\

/* Time to Coordinate Macro */

#define X_OF_TIME( _sec, _usec, _scale ) \
	( ( ( ( (_sec) * 1000000 ) + (_usec) ) / (_scale) ) \
		+ ( INT_GLOBVAL( FRAME_BORDER ) \
			* ( 1 + INT_GLOBVAL( FRAME_OFFSET ) ) ) )

/* Network View Link Volume Coloring Macros */

#define REFRESH_NET_VOLUME_COLORS \
\
	REFRESH_GLOBAL( NET_VOLUME7_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME6_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME5_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME4_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME3_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME2_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME1_COLOR ); \
	REFRESH_GLOBAL( NET_VOLUME0_COLOR ); \
	REFRESH_GLOBAL( NET_FG_COLOR ); \
\

#define NET_COLOR_LINK_VOLUME( _itp, _netc, _netlink ) \
{ \
	if ( (_netlink)->msg_bytes > NBYTES_1M ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME7_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > NBYTES_1K * 100 ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME6_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > NBYTES_1K * 10 ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME5_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > NBYTES_1K ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME4_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > NBYTES_1K / 4 ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME3_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > NBYTES_1K / 8 ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME2_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > NBYTES_1K / 16 ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME1_COLOR ); \
\
	else if ( (_netlink)->msg_bytes > 0 ) \
		TMP_COLOR = CHAR_GLOBVAL( NET_VOLUME0_COLOR ); \
\
	else \
		TMP_COLOR = CHAR_GLOBVAL( NET_FG_COLOR ); \
\
	sprintf( TMP_CMD, "%s itemconfigure %d -fill %s", \
		_netc, (_netlink)->link->id, TMP_COLOR ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
} \
\

/* Network View Link Bandwidth Macro */

#define NET_BANDWIDTH( _itp, _netc, _netlink, _msg, _bw ) \
{ \
	if ( TIME_OVERLAP( (_netlink)->bw_start, \
			(_msg)->sendtime, (_msg)->recvtime ) \
		|| TIME_OVERLAP( (_netlink)->bw_end, \
			(_msg)->sendtime, (_msg)->recvtime ) ) \
	{ \
		(_netlink)->msg_bw += bw; \
\
		TIME_MIN( (_netlink)->bw_start, (_msg)->sendtime, \
			(_netlink)->bw_start ); \
\
		TIME_MAX( (_netlink)->bw_end, (_msg)->recvtime, \
			(_netlink)->bw_end ); \
	} \
\
	else \
	{ \
		(_netlink)->msg_bw = bw; \
\
		(_netlink)->bw_start.tv_sec = (_msg)->sendtime.tv_sec; \
		(_netlink)->bw_start.tv_usec = (_msg)->sendtime.tv_usec; \
\
		(_netlink)->bw_end.tv_sec = (_msg)->recvtime.tv_sec; \
		(_netlink)->bw_end.tv_usec = (_msg)->recvtime.tv_usec; \
	} \
\
	sprintf( TMP_CMD, "%s itemconfigure %d -width %d", \
		_netc, (_netlink)->link->id, \
		2 + (int) log10( (double) (_netlink)->msg_bw ) ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
} \
\

/* Create Canvas Rectangle Object Macro */

#define CREATE_RECT( _itp, _c, _gobj, _x1, _y1, _x2, _y2, _rc, _oc ) \
{ \
	(_gobj) = create_gobj(); \
\
	X1_COORD( _gobj ) = (_x1); \
	Y1_COORD( _gobj ) = (_y1); \
\
	X2_COORD( _gobj ) = (_x2); \
	Y2_COORD( _gobj ) = (_y2); \
\
	(_gobj)->color = _rc; \
\
	sprintf( TMP_CMD, \
	"%s create rectangle %d %d %d %d -fill \"%s\" -outline \"%s\"", \
		_c, _x1, _y1, _x2, _y2, _rc, _oc ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
\
	(_gobj)->id = atoi( (_itp)->result ); \
} \
\

/* Set Host Box Outline Color & Width */

#define SET_HOST_BOX( _itp, _c, _host, _color, _width ) \
{ \
	sprintf( TMP_CMD, "%s itemconfigure %d -outline %s -width %d", \
		_c, (_host)->box->id, _color, _width ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
} \
\

/* Create Network View Link Line Macro */

#define CREATE_NET_LINK( _itp, _c, _gobj, _x1, _y1, _x2, _y2, _clr ) \
{\
	(_gobj) = create_gobj(); \
\
	X1_COORD( _gobj ) = (_x1); \
	Y1_COORD( _gobj ) = (_y1); \
\
	X2_COORD( _gobj ) = (_x2); \
	Y2_COORD( _gobj ) = (_y2); \
\
	(_gobj)->color = _clr; \
\
	sprintf( TMP_CMD, \
	"%s create line %d %d %d %d -capstyle round -fill %s -width 2", \
		_c, _x1, _y1, _x2, _y2, _clr ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
\
	(_gobj)->id = atoi( (_itp)->result ); \
}\
\

/* Set Canvas Object Coordinates Macro */

#define SET_COORDS( _itp, _canvas, _gobj ) \
{ \
	sprintf( TMP_CMD, "%s coords %d %d %d %d %d", \
		(_canvas), (_gobj)->id, \
		X1_COORD( _gobj ), Y1_COORD( _gobj ),  \
		X2_COORD( _gobj ), Y2_COORD( _gobj ) ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
} \
\

/* Delete Canvas Object Macro */

#define DELETE_GOBJ( _itp, _canvas, _gobj ) \
{ \
	sprintf( TMP_CMD, "%s delete %d", (_canvas), (_gobj)->id ); \
\
	Tcl_Eval( _itp, TMP_CMD ); \
\
	free_gobj( &(_gobj) ); \
} \
\

/* Hostname Check Macro */

#define LOCALHOST( _name ) \
\
	( HOST_NAME != NULL && HOST_ALIAS != NULL \
		&& ( !strcmp( HOST_NAME, _name ) \
			|| !strcmp( HOST_ALIAS, _name ) \
		 	|| ( TMP_HOST = host_alias_str( _name ), \
				TMP_CMP = !strcmp( HOST_NAME, TMP_HOST ), \
				free( TMP_HOST ), \
				TMP_CMP ) ) ) \
\

/* Host Name Comparison Macro */

#define HOST_COMPARE( _host, _name ) \
\
	 ( !strcmp( (_host)->name, _name ) \
		 || !strcmp( (_host)->alias, _name ) \
		 || ( TMP_HOST = host_alias_str( _name ), \
			TMP_CMP = !strcmp( (_host)->name, TMP_HOST ), \
			free( TMP_HOST ), \
			TMP_CMP ) ) \
\

