
static char rcsid[] = 
	"$Id: compat.trace.c,v 3.20 1995/07/27 14:48:26 kohl Exp $";

#include "xpvm.h"

/* Trace Lookup Trie Init Routines */

init_event_trie33()
{
	int i;

	EVENT_TRIE33 = create_triestack();

	for ( i=TEV33_FIRST ; i < TRACE33_MAX ; i++ )
	{
		add_to_trie( EVENT_TRIE33, TEV33_TRACE_NAMES[i],
			(void *) ( ( i - TEV33_FIRST ) + 1 ) );
	}
}

/* Trace Processing Routines */

process_trace33_event( name )
char *name;
{
	TASK T;

	char c;

	int tusec;
	int tsec;
	int flag;
	int tid;
	int eid;

	if ( eid = (int) lookup_trie( EVENT_TRIE33, name ) )
	{
		eid = ( eid - 1 ) + TEV33_FIRST;

		if ( !find_event_str( "{" ) )
			return( FALSE );

		/* } to match above */

		flag = fscanf( TRACE_IN, "%d, %d, %d", &tsec, &tusec, &tid );

		if ( flag != 3 )
		{
			printf( "Incomplete Trace Record\n" );

			return( FALSE );
		}

		/* Time Adjustment Special Cases */

		if ( eid == TEV33_SPNTASK )
		{
			/* Just Ignore */
			find_event_end();
		}

		else if ( eid == TEV33_NEWTASK
			|| eid == TEV33_ENDTASK
			|| eid == TRACE33_OUTPUT
			|| eid == TRACE33_HOST_ADD
			|| eid == TRACE33_HOST_DEL
			|| eid == TRACE33_HOST_SYNC )
		{
			process_pvm_event( eid, tid, tsec, tusec, (TASK) NULL );
		}

		else
		{
			T = get_task_tid( tid );

			/* Normal Event */

			if ( T != NULL )
			{
				normalize_time( T, &tsec, &tusec );

				check_time( tsec, tusec );

				process_pvm_event( eid, tid, tsec, tusec, T );
			}

			/* Unknown Event */

			else
				find_event_end();
		}
	}

	else
	{
		printf( "Error: Event \"%s\" Not Found\n", name );

		find_event_end();

		return( FALSE );
	}

	return( TRUE );
}

process_pvm_event( eid, tid, tsec, tusec, T )
int eid;
int tid;
int tsec;
int tusec;
TASK T;
{
	HOST H;

	static char cmd[4200];

	char refname[1024];
	char result[4096];
	char alias[1024];
	char where[1024];
	char name[1024];
	char tmp[1024];

	char *u_usec_pad;
	char *s_usec_pad;

	char *str;

	char c;

	int u_sec, u_usec;
	int s_sec, s_usec;

	int do_state;
	int pvmd_tid;
	int msgtag;
	int nbytes;
	int count;
	int flags;
	int speed;
	int state;
	int cktm;
	int ptid;
	int dtid;
	int stid;
	int usec;
	int sec;
	int buf;
	int num;
	int cc;
	int i;

	REFRESH_GLOBAL( NET_ALIVE_COLOR );
	REFRESH_GLOBAL( NET_DEAD_COLOR );
	REFRESH_GLOBAL( NET_FG_COLOR );

	str = (char *) NULL;

	do_state = TRUE;

	switch ( eid )
	{
		case TRACE33_HOST_ADD:
		{
			/* printf( "Trace Host Add\n" ); */

			read_trace_str( refname, 1024, TRUE );

			read_trace_str( alias, 1024, TRUE );

			read_trace_str( tmp, 1024, TRUE );

			fscanf( TRACE_IN, ", %d", &speed );

			find_event_end();

			sprintf( result,
				"host %s (%s) added: arch=%s tid=0x%x speed=%d",
					refname, alias, tmp, tid, speed );

			if ( TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK )
			{
				handle_playback_host_add( refname, alias, tmp,
					tid, speed );
			}

			else
			{
				H = get_host_tid( tid, PLAYBACK_ADDED );

				if ( H != NULL && H->status == HOST_NOTIFY_ADD )
				{
					H->status = HOST_ON;

					flash_host( H, CHAR_GLOBVAL( NET_ALIVE_COLOR ),
						TRUE );

					SET_HOST_BOX( interp, MAIN_NET->NET_C, H,
						CHAR_GLOBVAL( NET_FG_COLOR ), 1 );
				}
			}

			str = result;

			break;
		}

		case TRACE33_HOST_DEL:
		{
			/* printf( "Trace Host Delete\n" ); */

			read_trace_str( name, 1024, TRUE );

			find_event_end();

			sprintf( result, "host %s deleted: tid=0x%x", name, tid );

			if ( TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK )
				handle_playback_host_del( name, tid, tsec, tusec );

			else
			{
				H = get_host_tid( tid, PLAYBACK_ADDED );

				if ( H != NULL )
				{
					/* Kill off any tasks */

					normalize_time( (TASK) NULL, &tsec, &tusec );

					cktm = 0;

					T = TASK_LIST;

					while ( T != NULL )
					{
						if ( T->pvmd_tid == tid
							&& T->status != TASK_DEAD )
						{
							if ( !cktm )
							{
								check_time( tsec, tusec );

								cktm++;
							}

							taskExit( T, tsec, tusec, "Dead Host" );
						}

						T = T->next;
					}

					/* Turn Off Host */

					if ( H->status == HOST_NOTIFY_DEL )
					{
						H->status = HOST_OFF;

						flash_host( H, CHAR_GLOBVAL( NET_DEAD_COLOR ),
							TRUE );

						destroy_network_host( H, TRUE );

						arrange_network_hosts( MAIN_NET );
					}
				}
			}

			str = result;

			break;
		}

		case TRACE33_HOST_SYNC:
		{
			fscanf( TRACE_IN, ", %d, %d", &sec, &usec );

			find_event_end();

			H = get_host_tid( tid, PLAYBACK_ADDED );

			if ( H != NULL )
			{
				sprintf( result, "host %s (%s) sync delta: %d %d",
						H->name, H->alias, sec, usec );

				if ( TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK )
				{
					/* Handle Playback Host Sync */

					H->delta.tv_sec = sec;
					H->delta.tv_usec = usec;
				}
			}

			else
			{
				sprintf( result,
					"host sync delta: %d %d -- error: tid=%x not found",
						sec, usec, tid );
			}

			str = result;

			break;
		}

		case TRACE33_OUTPUT:
		{
			T = get_task_tid( tid );

			if ( T != NULL )
			{
				read_trace_str( tmp, 1024, TRUE );

				find_event_end();

				sprintf( result, "task output: tid=%x str=\"%s\"",
					tid, tmp );

				normalize_time( T, &tsec, &tusec );

				task_output( tid, tmp );

				str = result;
			}

			else
			{
				find_event_end();

				return;
			}

			break;
		}

		case TEV33_NEWTASK:
		{
			fscanf( TRACE_IN, ", %d, %d, %d",
				&ptid, &pvmd_tid, &flags );

			read_trace_str( name, 1024, TRUE );

			find_event_end();

			if ( !TRACE_GROUP_TASKS && GROUPTASK( name ) )
				return;

			sprintf( result,
				"New Task %s: tid=%x ptid=%x pvmd_tid=%x flags=%d",
				name, tid, ptid, pvmd_tid, flags );

			/* Create New Task Structure */

			T = create_task();

			T->tid = tid;

			T->name = copy_str( name );

			T->ptid = ptid;

			T->pvmd_tid = pvmd_tid;

			T->host = get_host_tid( pvmd_tid, PLAYBACK_ADDED );

			T->flags = flags;

			T->status = TASK_ALIVE;

			/* Handle New Task Times */

			if ( BASE_TIME.tv_sec == -1 )
			{
				sync_time( T->host, &tsec, &tusec );

				BASE_TIME.tv_sec = tsec;
				BASE_TIME.tv_usec = tusec;

				update_time( 0, 0 );

				tsec = tusec = 0;
			}

			else
			{
				normalize_time( T, &tsec, &tusec );

				check_time( tsec, tusec );
			}

			taskAdd( T, tsec, tusec, result );

			str = result;

			break;
		}

		case TEV33_ENDTASK:
		{
			T = get_task_tid( tid );

			if ( T != NULL )
			{
				fscanf( TRACE_IN, ", %d, %d, %d, %d, %d",
					&flags, &u_sec, &u_usec, &s_sec, &s_usec );

				find_event_end();

				u_usec_pad = pad_num( u_usec, 6 );
				s_usec_pad = pad_num( s_usec, 6 );

				sprintf( result,
					"End Task tid=%x status=0x%x user=%d.%s sys=%d.%s",
						tid, flags, u_sec, u_usec_pad,
						s_sec, s_usec_pad );

				free( u_usec_pad );
				free( s_usec_pad );

				normalize_time( T, &tsec, &tusec );

				if ( T->status != TASK_DEAD )
					check_time( tsec, tusec );

				taskExit( T, tsec, tusec, result );

				do_state = FALSE;

				str = result;
			}

			else
			{
				find_event_end();

				return;
			}

			break;
		}

		case TEV33_ADDHOSTS0:
		{
			strcpy( result, "pvm_addhosts0()" );

			fscanf( TRACE_IN, ", %d", &num );

			if ( !find_event_str( "{" ) )
				return( FALSE );

			for ( i=0 ; i < num ; i++ )
			{
				read_trace_str( name, 1024, FALSE );

				sprintf( tmp, " %s", name );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );
			}

			if ( !find_event_str( "}" ) )
				return( FALSE );

			find_event_end();

			str = result;

			break;
		}

		case TEV33_ADDHOSTS1:
		{
			fscanf( TRACE_IN, ", %d", &cc );

			find_event_end();

			sprintf( result, "pvm_addhosts1() cc=%d", cc );

			str = result;

			break;
		}

		case TEV33_SPAWN0:
		{
			read_trace_str( name, 1024, TRUE );

			fscanf( TRACE_IN, ", %d", &flags );

			read_trace_str( where, 1024, TRUE );

			fscanf( TRACE_IN, ", %d", &count );

			find_event_end();

			sprintf( result, "pvm_spawn0() %d copies of %s",
				count, name );

			if ( *where != '\0' )
			{
				sprintf( tmp, " on %s", where );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE ); 
			}

			str = result;

			break;
		}

		case TEV33_SPAWN1:
		{
			fscanf( TRACE_IN, ", %d", &num );

			sprintf( result, "pvm_spawn1() %d successful", num );

			if ( !find_event_str( "{" ) )
				return( FALSE );

			if ( num > 0 )
			{
				append_cmd_str( result, ":", 4096,
					(char *) NULL, FALSE );

				for ( i=0 ; i < num ; i++ )
				{
					if ( i )
						fscanf( TRACE_IN, ", %d", &stid );

					else
						fscanf( TRACE_IN, "%d", &stid );

					sprintf( tmp, " %x", stid );

					append_cmd_str( result, tmp, 4096,
						(char *) NULL, FALSE );
				}
			}

			if ( !find_event_str( "}" ) )
				return( FALSE );

			find_event_end();

			str = result;

			break;
		}

		case TEV33_EXIT0:
		{
			find_event_end();

			strcpy( result, "pvm_exit()" );

			taskState( T, tsec, tusec, STATE_SYSTEM, result );

			taskExit( T, tsec, tusec + 1, result );

			do_state = FALSE;

			str = result;

			break;
		}

		case TEV33_SEND0:
		{
			fscanf( TRACE_IN, ", %d, %d", &dtid, &msgtag );

			nbytes = -1;

			/*
			{
				fscanf( TRACE_IN, ", %d, %d, %d",
					&dtid, &msgtag, &nbytes );
			}
			*/

			find_event_end();

			sprintf( result, "pvm_send0() to %x, msgtag=%d, nbytes=%d",
				dtid, msgtag, nbytes );

			send_message( T, tid, dtid, msgtag, nbytes, tsec, tusec );

			str = result;

			break;
		}

		case TEV33_MCAST0:
		{
			fscanf( TRACE_IN, ", %d, %d", &num, &msgtag );

			nbytes = -1;

			/*
			{
				fscanf( TRACE_IN, ", %d, %d, %d",
					&num, &msgtag, &nbytes );
			}
			*/

			sprintf( result, "pvm_mcast0() msgtag=%d, nbytes=%d",
				msgtag, nbytes );

			if ( !find_event_str( "{" ) )
				return( FALSE );

			if ( num > 0 )
			{
				append_cmd_str( result, " to:", 4096,
					(char *) NULL, FALSE );

				for ( i=0 ; i < num ; i++ )
				{
					if ( i )
						fscanf( TRACE_IN, ", %d", &dtid );

					else
						fscanf( TRACE_IN, "%d", &dtid );

					sprintf( tmp, " %x", dtid );

					append_cmd_str( result, tmp, 4096,
						(char *) NULL, FALSE );

					if ( dtid != tid )
					{
						send_message( T, tid, dtid, msgtag, nbytes,
							tsec, tusec );
					}
				}
			}

			if ( !find_event_str( "}" ) )
				return( FALSE );

			find_event_end();

			str = result;

			break;
		}

		case TEV33_PSEND0:
		{
			fscanf( TRACE_IN, ", %d, %d", &dtid, &msgtag );

			nbytes = -1;

			/*
			{
				fscanf( TRACE_IN, ", %d, %d, %d",
					&dtid, &msgtag, &nbytes );
			}
			*/

			find_event_end();

			sprintf( result, "pvm_psend0() to %x, msgtag=%d, nbytes=%d",
				dtid, msgtag, nbytes );

			send_message( T, tid, dtid, msgtag, nbytes, tsec, tusec );

			str = result;

			break;
		}

		case TEV33_RECV1:
		{
			fscanf( TRACE_IN, ", %d, %d, %d, %d",
				&buf, &nbytes, &msgtag, &stid );

			find_event_end();

			sprintf( result, "pvm_recv1() buf=%d", buf );

			if ( nbytes >= 0 )
			{
				sprintf( tmp, ", %d bytes from %x, msgtag=%d",
					nbytes, stid, msgtag );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );

				recv_message( T, tid, stid, msgtag, nbytes,
					tsec, tusec );
			}

			str = result;

			break;
		}

		case TEV33_NRECV1:
		{
			fscanf( TRACE_IN, ", %d, %d, %d, %d",
				&buf, &nbytes, &msgtag, &stid );

			find_event_end();

			strcpy( result, "pvm_nrecv1()" );

			if ( buf > 0 )
			{
				sprintf( tmp, " buf=%d", buf );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );

				if ( nbytes >= 0 )
				{
					sprintf( tmp, ", %d bytes from %x, msgtag=%d",
						nbytes, stid, msgtag );

					append_cmd_str( result, tmp, 4096,
						(char *) NULL, FALSE );

					recv_message( T, tid, stid, msgtag, nbytes,
						tsec, tusec );
				}
			}

			else
			{
				append_cmd_str( result, " no message", 4096,
					(char *) NULL, FALSE );
			}

			str = result;

			break;
		}

		case TEV33_PRECV1:
		{
			fscanf( TRACE_IN, ", %d, %d, %d, %d",
				&buf, &nbytes, &msgtag, &stid );

			find_event_end();

			sprintf( result, "pvm_precv1() buf=%d", buf );

			if ( nbytes >= 0 )
			{
				sprintf( tmp, ", %d bytes from %x, msgtag=%d",
					nbytes, stid, msgtag );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );

				recv_message( T, tid, stid, msgtag, nbytes,
					tsec, tusec );
			}

			str = result;

			break;
		}

		case TEV33_TRECV1:
		{
			fscanf( TRACE_IN, ", %d, %d, %d, %d",
				&buf, &nbytes, &msgtag, &stid );

			find_event_end();

			sprintf( result, "pvm_trecv1() buf=%d", buf );

			if ( nbytes >= 0 )
			{
				sprintf( tmp, ", %d bytes from %x, msgtag=%d",
					nbytes, stid, msgtag );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );

				recv_message( T, tid, stid, msgtag, nbytes,
					tsec, tusec );
			}

			str = result;

			break;
		}

		default:
			str = pvm_event_string( eid );
	}

	if ( !tflag && do_state )
	{
		switch ( TEV33_TYPE[ eid ] )
		{
			case ENTRY_TEV:
			{
				if ( eid == TEV33_RECV0
					|| eid == TEV33_PRECV0
					|| eid == TEV33_TRECV0 )
				{
					state = STATE_IDLE;
				}

				else
					state = STATE_SYSTEM;

				taskState( T, tsec, tusec, state, str );

				break;
			}

			case EXIT_TEV:
			{
				taskState( T, tsec, tusec, STATE_RUNNING, str );

				break;
			}

			case IGNORE_TEV:
				break;
		}
	}

	if ( eflag )
	{
		printf( "PVM Event: %d %d %x %s\n", tsec, tusec, tid, str );

		fflush( stdout );
	}

	if ( str != NULL && str != result )
		free( str );
}

char *pvm_event_string( eid )
int eid;
{
	char result[4096];
	char tmp[2048];
	char buf[1024];

	char *fmt;
	char *str;

	int keeplist[10];

	int vecflag;
	int veclen;
	int index;
	int nkeep;
	int keep;
	int ival;
	int sep;

	fmt = tev_formats[ eid ].fmt;

	if ( fmt != NULL )
	{
		nkeep = 0;

		if ( *fmt != '=' )
			sprintf( result, "%s", tev_formats[ eid ].name );

		else
			sprintf( result, "%s() ", tev_formats[ eid ].name );
	
		while ( *fmt )
		{
			if ( *fmt == '%' )
			{
				fmt++;

				if ( *fmt == '*' )
				{
					keep = TRUE;

					fmt++;
				}

				else
					keep = FALSE;

				if ( *fmt == '$' )
				{
					fmt++;

					index = *fmt - '0';

					fmt++;

					veclen = ( index >= 0 && index < nkeep )
						? keeplist[index] : 0;

					vecflag = TRUE;

					sep = FALSE;
				}

				else
				{
					veclen = 1;

					vecflag = FALSE;
				}

				while ( veclen > 0 )
				{
					veclen--;

					if ( vecflag )
					{
						if ( sep )
						{
							append_cmd_str( result, " ", 4096,
								(char *) NULL, FALSE );
						}

						sep = TRUE;
					}

					switch ( *fmt )
					{
						case 'd':
						{
							fscanf( TRACE_IN, ", %d", &ival );
		
							sprintf( tmp, " %d", ival );
		
							append_cmd_str( result, tmp, 4096,
								(char *) NULL, FALSE );
	
							break;
						}
		
						/* decimal result code */
						case 'R':
						{
							fscanf( TRACE_IN, ", %d", &ival );
		
							sprintf( tmp, " %d", ival );
	
							append_cmd_str( result, tmp, 4096,
								(char *) NULL, FALSE );
	
							if ( ival < 0 )
							{
								if ( ival <= 0 && ival > -pvm_nerr )
								{
									sprintf( tmp, " (%s)",
										pvm_errlist[ -ival ] );
								}
								
								else
								{
									sprintf( tmp, " %d (Unknown Error)",
										ival );
								}
	
								append_cmd_str( result, tmp, 4096,
									(char *) NULL, FALSE );
							}
		
							break;
						}
		
						/* hex result code / decimal if negative */
						case 'r':
						{
							fscanf( TRACE_IN, ", %d", &ival );
		
							if ( ival < 0 )
							{
								if ( ival <= 0 && ival > -pvm_nerr )
								{
									sprintf( tmp, " %d (%s)",
										ival, pvm_errlist[ -ival ] );
								}
	
								else
								{
									sprintf( tmp, " %d (Unknown Error)",
										ival );
								}
							}
							
							else
								sprintf( tmp, " 0x%x", ival );
		
							append_cmd_str( result, tmp, 4096,
								(char *) NULL, FALSE );
	
							break;
						}
		
						case 'x':
						{
							fscanf( TRACE_IN, ", %d", &ival );
		
							sprintf( tmp, " 0x%x", ival );
		
							append_cmd_str( result, tmp, 4096,
								(char *) NULL, FALSE );
		
							break;
						}
		
						case 'S':
						{
							read_trace_str( buf, 1024, TRUE );
		
							sprintf( tmp, " \"%s\"", buf );
		
							append_cmd_str( result, tmp, 4096,
								(char *) NULL, FALSE );
		
							break;
						}
		
						default:
						{
							sprintf( tmp, "%%%c", *fmt );
		
							append_cmd_str( result, tmp, 4096,
								(char *) NULL, FALSE );
	
							break;
						}
					}
				}
	
				if ( *fmt )
					fmt++;
				
				if ( keep )
				{
					keeplist[nkeep] = ival < 0 ? 0 : ival;

					nkeep++;
				}
			}
			
			else
			{
				sprintf( tmp, "%c", *fmt++ );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );
			}
		}
	}

	else
		sprintf( result, "%s()", tev_formats[ eid ].name );

	find_event_end();

	str = copy_str( result );

	return( str );
}

/* Trace File Generation Routines */

store_trace33_event( tsec, tusec, tid, eid )
int tsec;
int tusec;
int tid;
int eid;
{
	TEVTASK TT;

	char where[4096];
	char name[4096];
	char msg[255];

	int *tids;

	int msgtag;
	int nbytes;
	int ignore;
	int count;
	int flags;
	int addr;
	int host;
	int type;
	int ptid;
	int dtid;
	int stid;
	int len;
	int buf;
	int num;
	int cc;
	int i;

	/* Output Trace Event Descriptor (if necessary) */

	if ( !( TEV33_TRACE[ eid ] ) )
	{
		fprintf( TRACE_OUT, "\n#%d: %s\n", eid + 1,
			TEV33_TRACE_DESCRIPTORS[ eid ] );

		(TEV33_TRACE[ eid ])++;
	}

	/* Output Trace Event Header */

	fprintf( TRACE_OUT, "\"%s\" { %d, %d, %d",
		TEV33_TRACE_NAMES[ eid ], tsec, tusec, tid );  /* } */

	/* Convert Trace to Output File */

	switch ( eid )
	{
		case TEV33_NEWTASK:
		{
			pvm_upkint( &ptid, 1, 1 );
			pvm_upkint( &flags, 1, 1 );
			pvm_upkstr( name );

			if ( !strcmp( name, "" ) )
				strcpy( name, "-" );

			host = pvm_tidtohost( tid );

			fprintf( TRACE_OUT, ", %d, %d, %d",
				ptid, host, flags );

			dump_trace_str( name, TRUE );

			ignore = 0;

			if ( !TRACE_GROUP_TASKS && GROUPTASK( name ) )
				ignore++;

			TT = get_tevtask_tid( tid );

			if ( TT == NULL )
			{
				if ( !ignore )
				{
					sprintf( msg,
						"setMsg \"Task TID=%x Connected to XPVM\"",
						tid );

					Tcl_Eval( interp, msg );
				}

				TT = create_tevtask();

				TT->tid = tid;
				TT->outstatus = TASK_NOOUT;

				TT->next = TEVTASK_LIST;

				TEVTASK_LIST = TT;
			}

			if ( !ignore )
				TT->tevstatus = TASK_ALIVE;
			
			else
				TT->tevstatus = TASK_IGNORE;

			break;
		}

		case TEV33_SPNTASK:
		{
			dump_pvm_event_fmt( eid );

			TT = get_tevtask_tid( tid );

			if ( TT == NULL )
			{
				sprintf( msg,
					"setMsg \"Task TID=%x Connected to XPVM\"",
					tid );

				Tcl_Eval( interp, msg );

				TT = create_tevtask();

				TT->tid = tid;
				TT->tevstatus = TASK_ALIVE;
				TT->outstatus = TASK_NOOUT;

				TT->next = TEVTASK_LIST;

				TEVTASK_LIST = TT;
			}

			break;
		}

		case TEV33_ENDTASK:
		{
			dump_pvm_event_fmt( eid );

			TT = get_tevtask_tid( tid );

			if ( TT != NULL )
			{
				if ( TT->tevstatus != TASK_IGNORE )
				{
					TT->tevstatus = TASK_DEAD;

					if ( !tevtasks_alive() )
					{
						Tcl_Eval( interp,
							"setMsg \"Trace File Complete\"" );

						free_tevtasklist();
					}
				}
			}

			else
				printf( "\nWarning: ENDTASK Unknown Task.\n\n" );

			break;
		}

		case TEV33_ADDHOSTS0:
		{
			pvm_upkint( &num, 1, 1 );

			fprintf( TRACE_OUT, ", %d, [%d][100] { ", num, num );

			for ( i=0 ; i < num ; i++ )
			{
				pvm_upkstr( name );

				if ( i != num - 1 )
					fprintf( TRACE_OUT, "\"%s\", ", name );
				
				else
					fprintf( TRACE_OUT, "\"%s\" }", name );
			}

			break;
		}

		case TEV33_ADDHOSTS1:
		{
			pvm_upkint( &cc, 1, 1 );

			fprintf( TRACE_OUT, ", %d", cc );

			break;
		}

		case TEV33_SPAWN0:
		{
			pvm_upkstr( name );
			pvm_upkint( &flags, 1, 1 );
			pvm_upkstr( where );
			pvm_upkint( &count, 1, 1 );

			dump_trace_str( name, TRUE );

			fprintf( TRACE_OUT, ", %d", flags );

			dump_trace_str( where, TRUE );

			fprintf( TRACE_OUT, ", %d", count );

			break;
		}

		case TEV33_SPAWN1:
		{
			pvm_upkint( &num, 1, 1 );

			fprintf( TRACE_OUT, ", %d, [%d] {", num, num );

			if ( num > 0 )
			{
				tids = (int *) malloc( (unsigned) num * sizeof(int) );
				memcheck( tids, "Spawn TIDs" );

				pvm_upkint( tids, num, 1 );

				for ( i=0 ; i < num ; i++ )
				{
					if ( i )
						fprintf( TRACE_OUT, ", %d", tids[i] );
					
					else
						fprintf( TRACE_OUT, " %d", tids[i] );
				}

				free( tids );
			}

			fprintf( TRACE_OUT, " }" );

			break;
		}

		case TEV33_SEND0:
		{
			pvm_upkint( &dtid, 1, 1 );
			pvm_upkint( &msgtag, 1, 1 );

			fprintf( TRACE_OUT, ", %d, %d", dtid, msgtag );

			/*
			{
				pvm_upkint( &nbytes, 1, 1 );

				fprintf( TRACE_OUT, ", %d, %d, %d",
					dtid, msgtag, nbytes );
			}
			*/

			break;
		}

		case TEV33_MCAST0:
		{
			pvm_upkint( &num, 1, 1 );
			pvm_upkint( &msgtag, 1, 1 );

			if ( num > 0 )
			{
				tids = (int *) malloc( (unsigned) num * sizeof(int) );
				memcheck( tids, "Spawn TIDs" );
			}

			fprintf( TRACE_OUT, ", %d, %d, [%d] {", num, msgtag, num );

			if ( num > 0 )
				pvm_upkint( tids, num, 1 );

			/*
			{
				if ( num > 0 )
					pvm_upkint( tids, num, 1 );

				pvm_upkint( &nbytes, 1, 1 );

				fprintf( TRACE_OUT, ", %d, %d, %d, [%d] {",
					num, msgtag, nbytes, num );
				/- matching } -/
			}
			*/

			if ( num > 0 )
			{
				for ( i=0 ; i < num ; i++ )
				{
					if ( i )
						fprintf( TRACE_OUT, ", %d", tids[i] );
				
					else
						fprintf( TRACE_OUT, " %d", tids[i] );
				}

				free( tids );
			}

			fprintf( TRACE_OUT, " }" );

			break;
		}

		case TEV33_PSEND0:
		{
			pvm_upkint( &dtid, 1, 1 );
			pvm_upkint( &msgtag, 1, 1 );
			pvm_upkint( &addr, 1, 1 );
			pvm_upkint( &len, 1, 1 );
			pvm_upkint( &type, 1, 1 );

			fprintf( TRACE_OUT, ", %d, %d, %d, %d, %d",
				dtid, msgtag, addr, len, type );

			/*
			{
				pvm_upkint( &nbytes, 1, 1 );

				fprintf( TRACE_OUT, ", %d, %d, %d, %d, %d, %d",
					dtid, msgtag, nbytes, addr, len, type );
			}
			*/

			break;
		}

		case TEV33_RECV1:
		case TEV33_TRECV1:
		{
			pvm_upkint( &buf, 1, 1 );
			pvm_upkint( &nbytes, 1, 1 );

			if ( nbytes >= 0 )
			{
				pvm_upkint( &msgtag, 1, 1 );
				pvm_upkint( &stid, 1, 1 );
			}

			else
				msgtag = stid = -1;

			fprintf( TRACE_OUT, ", %d, %d, %d, %d",
				buf, nbytes, msgtag, stid );

			break;
		}

		case TEV33_PRECV1:
		/* temporary handler til precv1 has proper contents */
		{
			pvm_upkint( &buf, 1, 1 );

			fprintf( TRACE_OUT, ", %d, 0, 0, 0", buf );

			break;
		}


		case TEV33_NRECV1:
		{
			pvm_upkint( &buf, 1, 1 );

			if ( buf > 0 )
			{
				pvm_upkint( &nbytes, 1, 1 );

				if ( nbytes >= 0 )
				{
					pvm_upkint( &msgtag, 1, 1 );
					pvm_upkint( &stid, 1, 1 );
				}

				else
					msgtag = stid = -1;
			}

			else
				nbytes = msgtag = stid = -1;

			fprintf( TRACE_OUT, ", %d, %d, %d, %d",
				buf, nbytes, msgtag, stid );

			break;
		}

		default:
			dump_pvm_event_fmt( eid );
	}

	/* Finish Off Trace Event ({) */

	fprintf( TRACE_OUT, " };;\n" );

	fflush( TRACE_OUT );
}

dump_pvm_event_fmt( eid )
int eid;
{
	char buf[4096];

	char *fmt;

	int keeplist[10];

	int vecflag;
	int veclen;
	int index;
	int nkeep;
	int keep;
	int ival;

	fmt = tev_formats[ eid ].fmt;

	if ( fmt != NULL )
	{
		nkeep = 0;

		while ( *fmt )
		{
			if ( *fmt == '%' )
			{
				fmt++;

				if ( *fmt == '*' )
				{
					keep = TRUE;

					fmt++;
				}

				else
					keep = FALSE;

				if ( *fmt == '$' )
				{
					fmt++;

					index = *fmt - '0';

					fmt++;

					veclen = ( index >= 0 && index < nkeep )
						? keeplist[index] : 0;

					vecflag = TRUE;
				}

				else
				{
					veclen = 1;

					vecflag = FALSE;
				}

				while ( veclen > 0 )
				{
					veclen--;

					switch ( *fmt )
					{
						case 'R':
						case 'd':
						case 'r':
						case 'x':
						{
							pvm_upkint( &ival, 1, 1 );
		
							fprintf( TRACE_OUT, ", %d", ival );
		
							break;
						}
		
						case 'S':
						{
							pvm_upkstr( buf );
		
							dump_trace_str( buf, TRUE );
		
							break;
						}
		
						default:
							break;
					}
				}
	
				if ( *fmt )
					fmt++;

				if ( keep )
				{
					keeplist[nkeep] = ival < 0 ? 0 : ival;

					nkeep++;
				}
			}
			
			else
				fmt++;
		}
	}
}

/* Trace Utility Routines */

char *strip33_name( name, entry_exit )
char *name;
int *entry_exit;
{
	char *tmp;
	char *ptr;

	*entry_exit = IGNORE_TEV;

	tmp = copy_str( name );

	ptr = tmp;

	while ( *ptr != '\0' )
	{
		if ( *ptr >= 'a' && *ptr <= 'z' )
			*ptr += 'A' - 'a';

		else if ( ( *ptr == '0' || *ptr == '1' ) && *(ptr + 1) == '\0' )
		{
			if ( *ptr == '0' )
				*entry_exit = ENTRY_TEV;
			
			else
				*entry_exit = EXIT_TEV;

			*ptr = '\0';
		}

		ptr++;
	}

	return( tmp );
}

