
/* $Id: compat.reverse.h,v 3.20 1995/07/27 14:48:56 kohl Exp $ */

/*
 *	compat.reverse.h
 *
 *	New PVM 3.4 Libpvm tracing includes for 3.3 compilation.
 *
 */

#define TEV_FIRST			0
#define TEV_MAX				0

#define TEV_HEADER			0

#define TEV_DID_FIRST		0
#define TEV_DID_MAX			0

#define TEV_EVENT_ENTRY     0x4000
#define TEV_EVENT_EXIT      0x8000

struct Pvmtevinfo
{
	char *name;
	int desc_status;
};

static struct Pvmtevinfo pvmtevinfo[] =
{
	"dummy", 0
};

struct Pvmtevdid
{
	char *did;
	char *desc;
};

static struct Pvmtevdid pvmtevdidlist[] =
{
	"XXX", "Dummy"
};

/* Trace Markers */

#define TEV_MARK_EVENT_BUFFER       -1
#define TEV_MARK_EVENT_BUFFER_END   -2
#define TEV_MARK_DATA_ID            -3
#define TEV_MARK_DATA_ID_END        -4
#define TEV_MARK_EVENT_DESC         -5
#define TEV_MARK_EVENT_DESC_END     -6
#define TEV_MARK_EVENT_RECORD       -7
#define TEV_MARK_EVENT_RECORD_END   -8

/* Trace Event Data Types */

#define TEV_DATA_NULL           0
#define TEV_DATA_BYTE           1
#define TEV_DATA_CPLX           2
#define TEV_DATA_DCPLX          3
#define TEV_DATA_DOUBLE         4
#define TEV_DATA_FLOAT          5
#define TEV_DATA_INT            6
#define TEV_DATA_UINT           7
#define TEV_DATA_LONG           8
#define TEV_DATA_ULONG          9
#define TEV_DATA_SHORT         10
#define TEV_DATA_USHORT        11
#define TEV_DATA_STRING        12
#define TEV_DATA_STRUCT_START  13
#define TEV_DATA_STRUCT_END    14
#define TEV_DATA_DEFERRED      15

#define TEV_DATA_SCALAR      0x00
#define TEV_DATA_ARRAY       0x80

#define TEV_ENCODE_DID( _did, _dt, _ivar ) \
{ \
	_ivar = 0; \
	_ivar |= ( (_did)[0] << 24 ) & 0xff000000; \
	_ivar |= ( (_did)[1] << 16 ) & 0x00ff0000; \
	_ivar |= ( (_did)[2] <<  8 ) & 0x0000ff00; \
	_ivar |= (_dt) & 0xff; \
} \
\

#define TEV_DECODE_DID( _ivar, _did, _dt ) \
{ \
	(_did)[0] = ( (_ivar) >> 24 ) & 0xff; \
	(_did)[1] = ( (_ivar) >> 16 ) & 0xff; \
	(_did)[2] = ( (_ivar) >>  8 ) & 0xff; \
	(_did)[3] = '\0'; \
	_dt = (_ivar) & 0xff; \
} \
\

#define TEV_MASK_LENGTH 32

typedef char Pvmtmask[TEV_MASK_LENGTH];

#define TEV_MASK_SET( m, k )    ( m[ (k) / 4 ] |= ( 1 << ((k) & 3) ) )

#define TEV_MASK_UNSET( m, k )  ( m[ (k) / 4 ] &= ~( 1 << ((k) & 3) ) )

#define TEV_MASK_CHECK( m, k )  ( m[ (k) / 4 ] & (1  << ((k) & 3) ) )

#define TEV_MASK_INIT( m ) \
{ \
	int tev_init_mask_i = TEV_MASK_LENGTH - 1; \
	m[ tev_init_mask_i ] = 0; \
	while ( tev_init_mask_i-- > 0 ) \
		m[ tev_init_mask_i ] = '@'; \
}

