
/* $Id: compat.pvmtev.h,v 3.20 1995/07/27 14:48:54 kohl Exp $ */

/*
 *	compat.pvmtev.h
 *
 *	Old PVM 3.3 Libpvm tracing includes.
 *
 */

/* Trace Event Constants */

#define	TEV33_FIRST				0
#define	TEV33_ADDHOSTS0			0
#define	TEV33_ADDHOSTS1			1
#define	TEV33_BARRIER0			2
#define	TEV33_BARRIER1			3
#define	TEV33_BCAST0			4
#define	TEV33_BCAST1			5
#define	TEV33_BUFINFO0			6
#define	TEV33_BUFINFO1			7
#define	TEV33_CONFIG0			8
#define	TEV33_CONFIG1			9
#define	TEV33_DELETE0			10
#define	TEV33_DELETE1			11
#define	TEV33_DELHOSTS0			12
#define	TEV33_DELHOSTS1			13
#define	TEV33_EXIT0				14
#define	TEV33_EXIT1				15
#define	TEV33_FREEBUF0			16
#define	TEV33_FREEBUF1			17
#define	TEV33_GETFDS0			18
#define	TEV33_GETFDS1			19
#define	TEV33_GETINST0			20
#define	TEV33_GETINST1			21
#define	TEV33_GETOPT0			22
#define	TEV33_GETOPT1			23
#define	TEV33_GETRBUF0			24
#define	TEV33_GETRBUF1			25
#define	TEV33_GETSBUF0			26
#define	TEV33_GETSBUF1			27
#define	TEV33_GETTID0			28
#define	TEV33_GETTID1			29
#define	TEV33_GSIZE0			30
#define	TEV33_GSIZE1			31
#define	TEV33_HALT0				32
#define	TEV33_HALT1				33
#define	TEV33_INITSEND0			34
#define	TEV33_INITSEND1			35
#define	TEV33_INSERT0			36
#define	TEV33_INSERT1			37
#define	TEV33_JOINGROUP0		38
#define	TEV33_JOINGROUP1		39
#define	TEV33_KILL0				40
#define	TEV33_KILL1				41
#define	TEV33_LOOKUP0			42
#define	TEV33_LOOKUP1			43
#define	TEV33_LVGROUP0			44
#define	TEV33_LVGROUP1			45
#define	TEV33_MCAST0			46
#define	TEV33_MCAST1			47
#define	TEV33_MKBUF0			48
#define	TEV33_MKBUF1			49
#define	TEV33_MSTAT0			50
#define	TEV33_MSTAT1			51
#define	TEV33_MYTID0			52
#define	TEV33_MYTID1			53
#define	TEV33_NOTIFY0			54
#define	TEV33_NOTIFY1			55
#define	TEV33_NRECV0			56
#define	TEV33_NRECV1			57
#define	TEV33_PARENT0			58
#define	TEV33_PARENT1			59
#define	TEV33_PERROR0			60
#define	TEV33_PERROR1			61
#define	TEV33_PKBYTE0			62
#define	TEV33_PKBYTE1			63
#define	TEV33_PKCPLX0			64
#define	TEV33_PKCPLX1			65
#define	TEV33_PKDCPLX0			66
#define	TEV33_PKDCPLX1			67
#define	TEV33_PKDOUBLE0			68
#define	TEV33_PKDOUBLE1			69
#define	TEV33_PKFLOAT0			70
#define	TEV33_PKFLOAT1			71
#define	TEV33_PKINT0			72
#define	TEV33_PKINT1			73
#define	TEV33_PKUINT0			74
#define	TEV33_PKUINT1			75
#define	TEV33_PKLONG0			76
#define	TEV33_PKLONG1			77
#define	TEV33_PKULONG0			78
#define	TEV33_PKULONG1			79
#define	TEV33_PKSHORT0			80
#define	TEV33_PKSHORT1			81
#define	TEV33_PKUSHORT0			82
#define	TEV33_PKUSHORT1			83
#define	TEV33_PKSTR0			84
#define	TEV33_PKSTR1			85
#define	TEV33_PROBE0			86
#define	TEV33_PROBE1			87
#define	TEV33_PSTAT0			88
#define	TEV33_PSTAT1			89
#define	TEV33_RECV0				90
#define	TEV33_RECV1				91
#define	TEV33_RECVF0			92
#define	TEV33_RECVF1			93
#define	TEV33_SEND0				94
#define	TEV33_SEND1				95
#define	TEV33_SENDSIG0			96
#define	TEV33_SENDSIG1			97
#define	TEV33_SETOPT0			98
#define	TEV33_SETOPT1			99
#define	TEV33_SETRBUF0			100
#define	TEV33_SETRBUF1			101
#define	TEV33_SETSBUF0			102
#define	TEV33_SETSBUF1			103
#define	TEV33_SPAWN0			104
#define	TEV33_SPAWN1			105
#define	TEV33_START_PVMD0		106
#define	TEV33_START_PVMD1		107
#define	TEV33_TASKS0			108
#define	TEV33_TASKS1			109
#define	TEV33_TICKLE0			110
#define	TEV33_TICKLE1			111
#define	TEV33_TIDTOHOST0		112
#define	TEV33_TIDTOHOST1		113
#define	TEV33_TRECV0			114
#define	TEV33_TRECV1			115
#define	TEV33_UPKBYTE0			116
#define	TEV33_UPKBYTE1			117
#define	TEV33_UPKCPLX0			118
#define	TEV33_UPKCPLX1			119
#define	TEV33_UPKDCPLX0			120
#define	TEV33_UPKDCPLX1			121
#define	TEV33_UPKDOUBLE0		122
#define	TEV33_UPKDOUBLE1		123
#define	TEV33_UPKFLOAT0			124
#define	TEV33_UPKFLOAT1			125
#define	TEV33_UPKINT0			126
#define	TEV33_UPKINT1			127
#define	TEV33_UPKUINT0			128
#define	TEV33_UPKUINT1			129
#define	TEV33_UPKLONG0			130
#define	TEV33_UPKLONG1			131
#define	TEV33_UPKULONG0			132
#define	TEV33_UPKULONG1			133
#define	TEV33_UPKSHORT0			134
#define	TEV33_UPKSHORT1			135
#define	TEV33_UPKUSHORT0		136
#define	TEV33_UPKUSHORT1		137
#define	TEV33_UPKSTR0			138
#define	TEV33_UPKSTR1			139
#define	TEV33_VERSION0			140
#define	TEV33_VERSION1			141
#define	TEV33_REG_HOSTER0		142
#define	TEV33_REG_HOSTER1		143
#define	TEV33_REG_RM0			144
#define	TEV33_REG_RM1			145
#define	TEV33_REG_TASKER0		146
#define	TEV33_REG_TASKER1		147
#define	TEV33_NEWTASK			148
#define	TEV33_ENDTASK			150
#define	TEV33_SPNTASK			152
#define	TEV33_ARCHCODE0			154
#define	TEV33_ARCHCODE1			155
#define	TEV33_CATCHOUT0			156
#define	TEV33_CATCHOUT1			157
#define	TEV33_GETMWID0			158
#define	TEV33_GETMWID1			159
#define	TEV33_GETTMASK0			160
#define	TEV33_GETTMASK1			161
#define	TEV33_HOSTSYNC0			162
#define	TEV33_HOSTSYNC1			163
#define	TEV33_PACKF0			164
#define	TEV33_PACKF1			165
#define	TEV33_PRECV0			166
#define	TEV33_PRECV1			167
#define	TEV33_PSEND0			168
#define	TEV33_PSEND1			169
#define	TEV33_REDUCE0			170
#define	TEV33_REDUCE1			171
#define	TEV33_SETMWID0			172
#define	TEV33_SETMWID1			173
#define	TEV33_SETTMASK0			174
#define	TEV33_SETTMASK1			175
#define	TEV33_UNPACKF0			176
#define	TEV33_UNPACKF1			177
#define	TEV33_GATHER0			178
#define	TEV33_GATHER1			179
#define	TEV33_SCATTER0			180
#define	TEV33_SCATTER1			181
#define	TEV33_MAX				181

#define TRACE33_OUTPUT		(TEV33_MAX + 1)
#define TRACE33_HOST_ADD	(TEV33_MAX + 2)
#define TRACE33_HOST_DEL	(TEV33_MAX + 3)
#define TRACE33_HOST_SYNC	(TEV33_MAX + 4)
#define TRACE33_MAX			(TEV33_MAX + 5)

/* event mask kept as ascii string */

#define	TEV33_MASK_LENGTH	(TEV33_MAX / 8 + 2)

typedef char Pvmtmask33[TEV33_MASK_LENGTH];

#define	TEV33_MASK_SET(m, k) (m[(k) / 8] |= (1 << (((k) / 2) & 3)))

#define	TEV33_MASK_UNSET(m, k) (m[(k) / 8] &= ~(1 << (((k) / 2) & 3)))

#define	TEV33_MASK_CHECK(m, k) (m[(k) / 8] & (1 << (((k) / 2) & 3)))

#define	TEV33_MASK_INIT(m) { \
	int tev_init_mask_i = TEV33_MASK_LENGTH-1; \
	m[tev_init_mask_i] = 0; \
	while (tev_init_mask_i-- > 0) \
		m[tev_init_mask_i] = '@'; \
	}

/* PVM 3.3 Event Format Structure */

struct tevfmt
{
	char *name;
	char *fmt;
};

/* Globals */

#ifndef DO_GLOBALS

extern char *TEV33_TRACE_DESCRIPTORS[];

extern char *TEV33_TRACE_NAMES[];

extern struct tevfmt tev_formats[];

#else

char *TEV33_TRACE_DESCRIPTORS[TRACE33_MAX] =
{

"\"addhosts0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Count\" \"Number of Hosts to Add\"\n\
	int \"count\";\n\
	// \"Names\" \"Names of Hosts to Add\"\n\
	char \"names\"[][];\n\
};;\n",

"\"addhosts1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"barrier0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Count\" \"Number of Members to Wait\"\n\
	int \"count\";\n\
};;\n",

"\"barrier1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"bcast0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"bcast1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"bufinfo0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"MID\" \"Message Buffer\"\n\
	int \"mid\";\n\
};;\n",

"\"bufinfo1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Length\" \"Number of Bytes\"\n\
	int \"length\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
};;\n",

"\"config0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"config1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Nhost\" \"Number of Hosts\"\n\
	int \"nhost\";\n\
	// \"Narch\" \"Number of Architectures\"\n\
	int \"narch\";\n\
};;\n",

"\"delete0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Name\" \"Class Name\"\n\
	char \"name\"[];\n\
	// \"Req\" \"Class Index\"\n\
	int \"req\";\n\
};;\n",

"\"delete1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"delhosts0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Count\" \"Number of Hosts to Delete\"\n\
	int \"count\";\n\
	// \"Names\" \"Names of Hosts to Delete\"\n\
	char \"names\"[][];\n\
};;\n",

"\"delhosts1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"exit0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"exit1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"freebuf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"MID\" \"Message Buffer\"\n\
	int \"mid\";\n\
};;\n",

"\"freebuf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"getfds0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"getfds1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"NFDS\" \"# of File Descriptors\"\n\
	int \"nfds\";\n\
	// \"FDS\" \"File Descriptors\"\n\
	int \"fds\"[];\n\
};;\n",

"\"getinst0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Instance\" \"Instance Number in Group\"\n\
	int \"instance\";\n\
};;\n",

"\"getinst1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"getopt0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Option\" \"Option Code\"\n\
	int \"option\";\n\
};;\n",

"\"getopt1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"getrbuf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"getrbuf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"getsbuf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"getsbuf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"gettid0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Instance\" \"Instance Number in Group\"\n\
	int \"instance\";\n\
};;\n",

"\"gettid1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"gsize0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
};;\n",

"\"gsize1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"halt0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"halt1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"initsend0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Encoding\" \"Message Encoding\"\n\
	int \"encoding\";\n\
};;\n",

"\"initsend1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"insert0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Name\" \"Class Name\"\n\
	char \"name\"[];\n\
	// \"Req\" \"Class Index\"\n\
	int \"req\";\n\
	// \"Data\" \"Data for Insert\"\n\
	int \"data\";\n\
};;\n",

"\"insert1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"joingroup0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
};;\n",

"\"joingroup1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"kill0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Dst\" \"Destination Task ID\"\n\
	int \"dst\";\n\
};;\n",

"\"kill1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"lookup0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Name\" \"Class Name\"\n\
	char \"name\"[];\n\
	// \"Req\" \"Class Index\"\n\
	int \"req\";\n\
};;\n",

"\"lookup1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"lvgroup0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
};;\n",

"\"lvgroup1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"mcast0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Count\" \"Number of Tasks\"\n\
	int \"count\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"TIDs\" \"Destination Task IDs\"\n\
	int \"tids\"[];\n\
};;\n",

"\"mcast1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"mkbuf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Encoding\" \"Message Encoding\"\n\
	int \"encoding\";\n\
};;\n",

"\"mkbuf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"mstat0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Host\" \"Name of Host\"\n\
	char \"host\"[];\n\
};;\n",

"\"mstat1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"mytid0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"mytid1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"notify0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"What\" \"Specific Notify Event\"\n\
	int \"what\";\n\
	// \"Code\" \"Notify Code\"\n\
	int \"code\";\n\
	// \"Count\" \"Notify Count\"\n\
	int \"count\";\n\
	// \"Val\" \"Notify Values\"\n\
	int \"vals\"[];\n\
};;\n",

"\"notify1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"nrecv0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"nrecv1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Nbytes\" \"Number of Bytes Received\"\n\
	int \"nbytes\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
};;\n",

"\"parent0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"parent1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"perror0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"LocStr\" \"Error Location String\"\n\
	char \"locstr\"[];\n\
};;\n",

"\"perror1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"pkbyte0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkbyte1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkcplx0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkcplx1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkdcplx0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkdcplx1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkdouble0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkdouble1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkfloat0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkfloat1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkint0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkint1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkuint0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkuint1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pklong0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pklong1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkulong0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkulong1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkshort0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkshort1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkushort0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Pack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"pkushort1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pkstr0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
};;\n",

"\"pkstr1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"probe0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"probe1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"pstat0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Dst\" \"TID of Task to Pstat\"\n\
	int \"dst\";\n\
};;\n",

"\"pstat1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"recv0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"recv1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Nbytes\" \"Number of Bytes Received\"\n\
	int \"nbytes\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
};;\n",

"\"recvf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"recvf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"send0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Dst\" \"Message Destination TID\"\n\
	int \"dst\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"send1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"sendsig0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Dst\" \"Signal Destination TID\"\n\
	int \"dst\";\n\
	// \"Sig\" \"Signal Number to Raise\"\n\
	int \"sig\";\n\
};;\n",

"\"sendsig1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"setopt0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"What\" \"Option to Set\"\n\
	int \"what\";\n\
	// \"Value\" \"Value to Set Option\"\n\
	int \"val\";\n\
};;\n",

"\"setopt1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"setrbuf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"MID\" \"Message Buffer\"\n\
	int \"mid\";\n\
};;\n",

"\"setrbuf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"setsbuf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"MID\" \"Message Buffer\"\n\
	int \"mid\";\n\
};;\n",

"\"setsbuf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"spawn0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"File\" \"Executable File\"\n\
	char \"file\"[];\n\
	// \"Flags\" \"Spawn Flags\"\n\
	int \"flags\";\n\
	// \"Where\" \"Host or Arch for Spawn\"\n\
	char \"where\"[];\n\
	// \"Count\" \"Number of Tasks to Spawn\"\n\
	int \"count\";\n\
};;\n",

"\"spawn1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"NTID\" \"Number of TIDs Spawned\"\n\
	int \"cc\";\n\
	// \"TIDs\" \"Task IDs of Spawned Tasks\"\n\
	int \"tids\"[];\n\
};;\n",

"\"start_pvmd0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Argc\" \"Number of Args\"\n\
	int \"argc\";\n\
	// \"Argv\" \"Argument Strings\"\n\
	char \"argv\"[][];\n\
	// \"Block\" \"Block Flag\"\n\
	int \"block\";\n\
};;\n",

"\"start_pvmd1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"tasks0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Where\" \"Which Hosts to Check\"\n\
	int \"where\";\n\
};;\n",

"\"tasks1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Ntask\" \"Number of Tasks Found\"\n\
	int \"ntask\";\n\
};;\n",

"\"tickle0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Narg\" \"Number of Arguments\"\n\
	int \"narg\";\n\
	// \"Args\" \"Argument Array\"\n\
	int \"args\"[];\n\
};;\n",

"\"tickle1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Nres\" \"Number of Responses\"\n\
	int \"nres\";\n\
};;\n",

"\"tidtohost0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"tidtohost1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"trecv0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"trecv1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
	// \"Nbytes\" \"Number of Bytes Received\"\n\
	int \"nbytes\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
};;\n",

"\"upkbyte0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkbyte1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkcplx0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkcplx1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkdcplx0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkdcplx1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkdouble0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkdouble1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkfloat0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkfloat1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkint0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkint1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkuint0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkuint1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upklong0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upklong1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkulong0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkulong1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkshort0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkshort1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkushort0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
	// \"Count\" \"Number of Items to Unpack\"\n\
	int \"count\";\n\
	// \"Stride\" \"Stride Among Items\"\n\
	int \"stride\";\n\
};;\n",

"\"upkushort1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"upkstr0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Address\" \"Address of Stuff to Unpack\"\n\
	int \"addr\";\n\
};;\n",

"\"upkstr1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"version0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"version1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Version\" \"PVM Version String\"\n\
	char \"version\"[];\n\
};;\n",

"\"reg_hoster0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"reg_hoster1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"reg_rm0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"reg_rm1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"reg_tasker0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"reg_tasker1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"newtask\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"PTID\" \"Parent Task ID\"\n\
	int \"ptid\";\n\
	// \"Host\" \"PVMD TID of Host\"\n\
	int \"host\";\n\
	// \"Flags\" \"Task Spawn Flags\"\n\
	int \"flags\";\n\
	// \"Aout\" \"Executable File\"\n\
	char \"aout\"[];\n\
};;\n",

"",

"\"endtask\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Status\" \"Task Exit Status\"\n\
	int \"status\";\n\
	// \"Usec\" \"User Usage Secs\"\n\
	int \"usec\";\n\
	// \"Uusec\" \"User Usage Usecs\"\n\
	int \"uusec\";\n\
	// \"Ssec\" \"System Usage Secs\"\n\
	int \"ssec\";\n\
	// \"Susec\" \"System Usage Usecs\"\n\
	int \"susec\";\n\
};;\n",

"",

"\"spntask\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Parent\" \"Parent Task ID\"\n\
	int \"parent\";\n\
};;\n",

"",

"\"archcode0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"archcode1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"catchout0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"catchout1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"getmwid0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"MID\" \"Message Buffer\"\n\
	int \"mid\";\n\
};;\n",

"\"getmwid1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"gettmask0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"gettmask1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"hostsync0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"hostsync1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"packf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Format\" \"Format String\"\n\
	char \"fmt\"[];\n\
};;\n",

"\"packf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"precv0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Src\" \"Message Source TID\"\n\
	int \"src\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Length\" \"Number of Bytes\"\n\
	int \"length\";\n\
	// \"Type\" \"Data Type to Which Buffer Points\"\n\
	int \"type\";\n\
};;\n",

"\"precv1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"psend0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Dst\" \"Message Destination TID\"\n\
	int \"dst\";\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
	// \"Address\" \"Address of Stuff to Pack\"\n\
	int \"addr\";\n\
	// \"Length\" \"Number of Bytes\"\n\
	int \"length\";\n\
	// \"Type\" \"Data Type to Which Buffer Points\"\n\
	int \"type\";\n\
};;\n",

"\"psend1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"reduce0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"reduce1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"setmwid0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"MID\" \"Message Buffer\"\n\
	int \"mid\";\n\
	// \"WID\" \"Wait Message ID\"\n\
	int \"wid\";\n\
};;\n",

"\"setmwid1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"settmask0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"settmask1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
};;\n",

"\"unpackf0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Format\" \"Format String\"\n\
	char \"fmt\"[];\n\
};;\n",

"\"unpackf1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"gather0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"gather1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"scatter0\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Group\" \"Name of Group\"\n\
	char \"group\"[];\n\
	// \"Code\" \"Message Type\"\n\
	int \"code\";\n\
};;\n",

"\"scatter1\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"CC\" \"Condition Code\"\n\
	int \"cc\";\n\
};;\n",

"\"output\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Task ID\"\n\
	int \"tid\";\n\
	// \"Out\" \"Task Output\"\n\
	char \"out\"[];\n\
};;\n",

"\"host_add\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Host PVMD Task ID\"\n\
	int \"tid\";\n\
	// \"Name\" \"Host Name\"\n\
	char \"name\"[];\n\
	// \"Alias\" \"Host Alias\"\n\
	char \"alias\"[];\n\
	// \"Arch\" \"Host Arch\"\n\
	char \"arch\"[];\n\
	// \"Speed\" \"Relative Host Speed\"\n\
	int \"speed\";\n\
};;\n",

"\"host_del\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Host PVMD Task ID\"\n\
	int \"tid\";\n\
	// \"Name\" \"Host Name\"\n\
	char \"name\"[];\n\
};;\n",

"\"host_sync\"\n\
{\n\
	// \"Time\" \"Seconds\"\n\
	int \"sec\";\n\
	// \"Time\" \"Micro Seconds\"\n\
	int \"usec\";\n\
	// \"TID\" \"Host PVMD Task ID\"\n\
	int \"tid\";\n\
	// \"Sec\" \"Host Clock Synchronization Delta Seconds\"\n\
	int \"sec\";\n\
	// \"USec\" \"Host Clock Synchronization Delta Microseconds\"\n\
	int \"usec\";\n\
};;\n"

};

char *TEV33_TRACE_NAMES[TRACE33_MAX] =
{
	"addhosts0",
	"addhosts1",
	"barrier0",
	"barrier1",
	"bcast0",
	"bcast1",
	"bufinfo0",
	"bufinfo1",
	"config0",
	"config1",
	"delete0",
	"delete1",
	"delhosts0",
	"delhosts1",
	"exit0",
	"exit1",
	"freebuf0",
	"freebuf1",
	"getfds0",
	"getfds1",
	"getinst0",
	"getinst1",
	"getopt0",
	"getopt1",
	"getrbuf0",
	"getrbuf1",
	"getsbuf0",
	"getsbuf1",
	"gettid0",
	"gettid1",
	"gsize0",
	"gsize1",
	"halt0",
	"halt1",
	"initsend0",
	"initsend1",
	"insert0",
	"insert1",
	"joingroup0",
	"joingroup1",
	"kill0",
	"kill1",
	"lookup0",
	"lookup1",
	"lvgroup0",
	"lvgroup1",
	"mcast0",
	"mcast1",
	"mkbuf0",
	"mkbuf1",
	"mstat0",
	"mstat1",
	"mytid0",
	"mytid1",
	"notify0",
	"notify1",
	"nrecv0",
	"nrecv1",
	"parent0",
	"parent1",
	"perror0",
	"perror1",
	"pkbyte0",
	"pkbyte1",
	"pkcplx0",
	"pkcplx1",
	"pkdcplx0",
	"pkdcplx1",
	"pkdouble0",
	"pkdouble1",
	"pkfloat0",
	"pkfloat1",
	"pkint0",
	"pkint1",
	"pkuint0",
	"pkuint1",
	"pklong0",
	"pklong1",
	"pkulong0",
	"pkulong1",
	"pkshort0",
	"pkshort1",
	"pkushort0",
	"pkushort1",
	"pkstr0",
	"pkstr1",
	"probe0",
	"probe1",
	"pstat0",
	"pstat1",
	"recv0",
	"recv1",
	"recvf0",
	"recvf1",
	"send0",
	"send1",
	"sendsig0",
	"sendsig1",
	"setopt0",
	"setopt1",
	"setrbuf0",
	"setrbuf1",
	"setsbuf0",
	"setsbuf1",
	"spawn0",
	"spawn1",
	"start_pvmd0",
	"start_pvmd1",
	"tasks0",
	"tasks1",
	"tickle0",
	"tickle1",
	"tidtohost0",
	"tidtohost1",
	"trecv0",
	"trecv1",
	"upkbyte0",
	"upkbyte1",
	"upkcplx0",
	"upkcplx1",
	"upkdcplx0",
	"upkdcplx1",
	"upkdouble0",
	"upkdouble1",
	"upkfloat0",
	"upkfloat1",
	"upkint0",
	"upkint1",
	"upkuint0",
	"upkuint1",
	"upklong0",
	"upklong1",
	"upkulong0",
	"upkulong1",
	"upkshort0",
	"upkshort1",
	"upkushort0",
	"upkushort1",
	"upkstr0",
	"upkstr1",
	"version0",
	"version1",
	"reg_hoster0",
	"reg_hoster1",
	"reg_rm0",
	"reg_rm1",
	"reg_tasker0",
	"reg_tasker1",
	"newtask",
	"",
	"endtask",
	"",
	"spntask",
	"",
	"archcode0",
	"archcode1",
	"catchout0",
	"catchout1",
	"getmwid0",
	"getmwid1",
	"gettmask0",
	"gettmask1",
	"hostsync0",
	"hostsync1",
	"packf0",
	"packf1",
	"precv0",
	"precv1",
	"psend0",
	"psend1",
	"reduce0",
	"reduce1",
	"setmwid0",
	"setmwid1",
	"settmask0",
	"settmask1",
	"unpackf0",
	"unpackf1",
	"gather0",
	"gather1",
	"scatter0",
	"scatter1",
	"output",
	"host_add",
	"host_del",
	"host_sync",
};

struct tevfmt tev_formats[] =
{
	{ "pvm_addhosts0",		"(%*d, [%$0S])" },
	{ "pvm_addhosts1",		"=%R" },
	{ "pvm_barrier0",		"(%S, %d)" },
	{ "pvm_barrier1",		"=%R" },
	{ "pvm_bcast0",			"(%S, %d)" },
	{ "pvm_bcast1",			"=%R" },
	{ "pvm_bufinfo0",		"(%d)" },
	{ "pvm_bufinfo1",		"=%R, %d, %d, %d" },
	{ "pvm_config0",		"()" },
	{ "pvm_config1",		"=%R, %d, %d" },
	{ "pvm_delete0",		"(%S, %d)" },
	{ "pvm_delete1",		"=%R" },
	{ "pvm_delhosts0",		"(%*d, [%$0S])" },
	{ "pvm_delhosts1",		"=%R" },
	{ "pvm_exit0",			"()" },
	{ "pvm_exit1",			0 },
	{ "pvm_freebuf0",		"(%d)" },
	{ "pvm_freebuf1",		"=%R" },
	{ "pvm_getfds0",		"()" },
	{ "pvm_getfds1",		"=%*R [%$0d]" },
	{ "pvm_getinst0",		"(%S, %d)" },
	{ "pvm_getinst1",		"=%R" },
	{ "pvm_getopt0",		"(%d)" },
	{ "pvm_getopt1",		"=%R" },
	{ "pvm_getrbuf0",		"()" },
	{ "pvm_getrbuf1",		"=%R" },
	{ "pvm_getsbuf0",		"()" },
	{ "pvm_getsbuf1",		"=%R" },
	{ "pvm_gettid0",		"(%S, %d)" },
	{ "pvm_gettid1",		"=%R" },
	{ "pvm_gsize0",			"(%S)" },
	{ "pvm_gsize1",			"=%R" },
	{ "pvm_halt0",			"()" },
	{ "pvm_halt1",			0 },
	{ "pvm_initsend0",		"(%d)" },
	{ "pvm_initsend1",		"=%R" },
	{ "pvm_insert0",		"(%S, %d, %x)" },
	{ "pvm_insert1",		"=%R" },
	{ "pvm_joingroup0",		"(%S)" },
	{ "pvm_joingroup1",		"=%R" },
	{ "pvm_kill0",			"(%x)" },
	{ "pvm_kill1",			"=%R" },
	{ "pvm_lookup0",		"(%S, %d)" },
	{ "pvm_lookup1",		"=%R" },
	{ "pvm_lvgroup0",		"(%S)" },
	{ "pvm_lvgroup1",		"=%R" },
	{ "pvm_mcast0",			"(%*d, %d, [%$0x])" },
	{ "pvm_mcast1",			"=%R" },
	{ "pvm_mkbuf0",			"(%d)" },
	{ "pvm_mkbuf1",			"=%R" },
	{ "pvm_mstat0",			"(%S)" },
	{ "pvm_mstat1",			"=%R" },
	{ "pvm_mytid0",			"()" },
	{ "pvm_mytid1",			"=%r" },
	{ "pvm_notify0",		"(%d, %d, %d, ...)" },
	{ "pvm_notify1",		"=%R" },
	{ "pvm_nrecv0",			"(%x, %d)" },
	{ "pvm_nrecv1",			"=%R, ..." },
	{ "pvm_parent0",		"()" },
	{ "pvm_parent1",		"=%r" },
	{ "pvm_perror0",		"(%S %d)" },
	{ "pvm_perror1",		0 },
	{ "pvm_pkbyte0",		"(%x, %d, %d)" },
	{ "pvm_pkbyte1",		"=%R" },
	{ "pvm_pkcplx0",		"(%x, %d, %d)" },
	{ "pvm_pkcplx1",		"=%R" },
	{ "pvm_pkdcplx0",		"(%x, %d, %d)" },
	{ "pvm_pkdcplx1",		"=%R" },
	{ "pvm_pkdouble0",		"(%x, %d, %d)" },
	{ "pvm_pkdouble1",		"=%R" },
	{ "pvm_pkfloat0",		"(%x, %d, %d)" },
	{ "pvm_pkfloat1",		"=%R" },
	{ "pvm_pkint0",			"(%x, %d, %d)" },
	{ "pvm_pkint1",			"=%R" },
	{ "pvm_pkuint0",		"(%x, %d, %d)" },
	{ "pvm_pkuint1",		"=%R" },
	{ "pvm_pklong0",		"(%x, %d, %d)" },
	{ "pvm_pklong1",		"=%R" },
	{ "pvm_pkulong0",		"(%x, %d, %d)" },
	{ "pvm_pkulong1",		"=%R" },
	{ "pvm_pkshort0",		"(%x, %d, %d)" },
	{ "pvm_pkshort1",		"=%R" },
	{ "pvm_pkushort0",		"(%x, %d, %d)" },
	{ "pvm_pkushort1",		"=%R" },
	{ "pvm_pkstr0",			"(%x)" },
	{ "pvm_pkstr1",			"=%R" },
	{ "pvm_probe0",			"(%x, %d)" },
	{ "pvm_probe1",			"=%R" },
	{ "pvm_pstat0",			"(%x)" },
	{ "pvm_pstat1",			"=%R" },
	{ "pvm_recv0",			"(%x, %d)" },
	{ "pvm_recv1",			"=%R, %d, ..." },
	{ "pvm_recvf0",			"(...)" },
	{ "pvm_recvf1",			0 },
	{ "pvm_send0",			"(%x, %d)" },
	{ "pvm_send1",			"=%R" },
	{ "pvm_sendsig0",		"(%x, %d)" },
	{ "pvm_sendsig1",		"=%R" },
	{ "pvm_setopt0",		"(%d, %d)" },
	{ "pvm_setopt1",		"=%R" },
	{ "pvm_setrbuf0",		"(%d)" },
	{ "pvm_setrbuf1",		"=%R" },
	{ "pvm_setsbuf0",		"(%d)" },
	{ "pvm_setsbuf1",		"=%R" },
	{ "pvm_spawn0",			"(%S, ?, %d, %S, %d, ...)" },
	{ "pvm_spawn1",			"=%*R [%$0r]" },
	{ "pvm_start_pvmd0","%d, %d, ..." },
	{ "pvm_start_pvmd1","=%R" },
	{ "pvm_tasks0",			"(%x)" },
	{ "pvm_tasks1",			"=%R, %d" },
	{ "pvm_tickle0",		"(%*d, [%$0d])" },
	{ "pvm_tickle1",		"=%R, %d" },
	{ "pvm_tidtohost0",		"(%x)" },
	{ "pvm_tidtohost1",		"=%r" },
	{ "pvm_trecv0",			"(%x, %d, [%d %d])" },
	{ "pvm_trecv1",			"=%R, %d, ..." },
	{ "pvm_upkbyte0",		"(%x, %d, %d)" },
	{ "pvm_upkbyte1",		"=%R" },
	{ "pvm_upkcplx0",		"(%x, %d, %d)" },
	{ "pvm_upkcplx1",		"=%R" },
	{ "pvm_upkdcplx0",		"(%x, %d, %d)" },
	{ "pvm_upkdcplx1",		"=%R" },
	{ "pvm_upkdouble0",		"(%x, %d, %d)" },
	{ "pvm_upkdouble1",		"=%R" },
	{ "pvm_upkfloat0",		"(%x, %d, %d)" },
	{ "pvm_upkfloat1",		"=%R" },
	{ "pvm_upkint0",		"(%x, %d, %d)" },
	{ "pvm_upkint1",		"=%R" },
	{ "pvm_upkuint0",		"(%x, %d, %d)" },
	{ "pvm_upkuint1",		"=%R" },
	{ "pvm_upklong0",		"(%x, %d, %d)" },
	{ "pvm_upklong1",		"=%R" },
	{ "pvm_upkulong0",		"(%x, %d, %d)" },
	{ "pvm_upkulong1",		"=%R" },
	{ "pvm_upkshort0",		"(%x, %d, %d)" },
	{ "pvm_upkshort1",		"=%R" },
	{ "pvm_upkushort0",		"(%x, %d, %d)" },
	{ "pvm_upkushort1",		"=%R" },
	{ "pvm_upkstr0",		"(%x)" },
	{ "pvm_upkstr1",		"=%R" },
	{ "pvm_version0",		"()" },
	{ "pvm_version1",		"=%S" },
	{ "pvm_reg_hoster0",	"()" },
	{ "pvm_reg_hoster1",	"=%R" },
	{ "pvm_reg_rm0",		"()" },
	{ "pvm_reg_rm1",		"=%R" },
	{ "pvm_reg_tasker0",	"()" },
	{ "pvm_reg_tasker1",	"=%R" },
	{ "newtask",			" %x, %d, %S" },
	{ "",					0 },
	{ "endtask",			" %x u %d,%d s %d,%d" },
	{ "",					0 },
	{ "spntask",			" %x" },
	{ "",					0 },
	{ "pvm_archcode0",		0 /*"(%S)"*/ },
	{ "pvm_archcode1",		0 /*"=%R"*/ },
	{ "pvm_catchout0",		0 /*"(...)"*/ },
	{ "pvm_catchout1",		0 /*"=%R"*/ },
	{ "pvm_getmwid0",		"(%d)" },
	{ "pvm_getmwid1",		"=%R" },
	{ "pvm_gettmask0",		0 /*"(%d, )"*/ },
	{ "pvm_gettmask1",		0 /*"=%R"*/ },
	{ "pvm_hostsync0",		0 /*"(%d, ...)"*/ },
	{ "pvm_hostsync1",		0 /*"=%R"*/ },
	{ "pvm_packf0",			"(%S, ...)" },
	{ "pvm_packf1",			"=%R" },
	{ "pvm_precv0",			"(%x, %d, %x, %d, %d, ...)" },
	{ "pvm_precv1",			"=%R" },
	{ "pvm_psend0",			"(%x, %d, %x, %d, %d)" },
	{ "pvm_psend1",			"=%R" },
	{ "pvm_reduce0",		0 /*"(...)"*/ },
	{ "pvm_reduce1",		0 /*"=%R"*/ },
	{ "pvm_setmwid0",		"(%d, %d)" },
	{ "pvm_setmwid1",		"=%R" },
	{ "pvm_settmask0",		0 /*"(%d, %S)"*/ },
	{ "pvm_settmask1",		0 /*"=%R"*/ },
	{ "pvm_unpackf0",		"(%S, ...)" },
	{ "pvm_unpackf1",		"=%R" },
	{ "pvm_gather0",		0 },
	{ "pvm_gather1",		0 },
	{ "pvm_scatter0",		0 },
	{ "pvm_scatter1",		0 }
};

#endif

