
static char rcsid[] = 
	"$Id: commands.c,v 3.20 1995/07/27 14:48:22 kohl Exp $";

#include "xpvm.h"

extern int gstid;

/* ARGSUSED */
int hosts_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	HOST H;

	HOST last;

	char msg[1024];
	char tmp[1024];

	char *refname;

	int hindex;
	int found;
	int hid;
	int i;

	if ( argc < 2 )
	{
		Tcl_SetResult( itp,
			"usage: pvm_hosts [ <button_index> | 1 <other_host> ]",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	REFRESH_GLOBAL( NET_ALIVE_COLOR );

	hid = atoi( argv[1] );

	switch ( hid )
	{
		/* Add All Hosts */

		case ADD_ALL_HID:
		{
			add_all_hosts();

			break;
		}

		/* Add Other Host */

		case OTHER_HOST_HID:
		{
			/* Extract Regular Host Name */

			refname = copy_str( argv[2] );

			sscanf( refname, "%s", tmp );

			/* Look for Host in Host List (D-Oh!) */

			H = MAIN_NET->host_list;

			last = (HOST) NULL;

			found = 0;

			while ( H != NULL && !found )
			{
				if ( HOST_COMPARE( H, tmp ) )
					found++;

				else
				{
					last = H;

					H = H->next;
				}
			}

			/* Host already present, add normally... */

			if ( found )
			{
				if ( H->in_pvm == NOT_IN_PVM )
				{
					if ( strlen( tmp ) > strlen( H->name ) )
					{
						free( H->name );

						H->name = copy_str( tmp );
					}

					free( H->refname );

					H->refname = refname;

					do_add_host( H );
				}

				else
				{
					sprintf( msg,
					   "setMsg { Error: Host %s Already Present! }",
					   tmp );

					Tcl_Eval( itp, msg );

					free( refname );
				}
			}

			/* Add Host to Host List */

			else
			{
				last->next = create_host();

				H = last->next;

				H->index = NHOSTS;

				H->refname = refname;

				H->name = copy_str( tmp );

				H->alias = host_alias_str( H->name );

				H->status = HOST_OFF;

				for ( i=0 ; i < MAX_STATE ; i++ )
					H->counts[i] = 0;

				NHOSTS++;

				H->in_pvm = NOT_IN_PVM;

				Tcl_Eval( interp, "refreshHostsMenu" );

				/* Add Host to PVM */

				do_add_host( H );
			}
		}

		/* Add Specific Host */

		default:
		{
			hindex = hid - MAX_HID;

			H = get_host_index( hindex );

			if ( H != NULL )
			{
				if ( H->in_pvm == IN_PVM )
					do_delete_host( H );

				else if ( H->in_pvm == NOT_IN_PVM )
					do_add_host( H );
			}
		}
	}

	return( TCL_OK );
}

/* ARGSUSED */
int tasks_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	struct pvmtaskinfo *T;
	struct pvmtaskinfo *tip;

	HOST H;

	char result[4096];
	char msg[4096];
	char tmp[1024];
	char trc[255];

	char *strcat();

	char **av;
	int ac;

	char *where;
	char *tstat;
	char *args;
	char *name;
	char *host;
	char *init;

	int *tids;

	int ntasks;
	int tmptid;
	int signal;
	int ntask;
	int stval;
	int flag;
	int buf;
	int err;
	int tid;
	int cc;
	int n;
	int i;

	if ( !strcmp( argv[1], "spawn" ) )
	{
		init = copy_str( argv[2] );

		name = copy_str( argv[3] );

		args = copy_str( argv[4] );

		buf = atoi( argv[5] );

		ntasks = atoi( argv[6] );

		/* Extract Args */

		Tcl_SplitList( interp, args, &ac, &av );

		/* Check Spawn Command Line Args */

		if ( buf != TRACE_BUF )
		{
			TRACE_BUF = buf;

			set_trace_buffer( TRACE_BUF );
		}

		strcpy( tmp, "" );

		where = (char *) NULL;

		flag = 0;

		for ( i=6 ; i < argc ; i++ )
		{
			if ( !strcmp( argv[i], "debug" ) )
				flag |= PvmTaskDebug;

			else if ( !strcmp( argv[i], "trace" ) )
				flag |= PvmTaskTrace;

			else if ( !strcmp( argv[i], "front" ) )
				flag |= PvmMppFront;

			else if ( !strcmp( argv[i], "compl" ) )
				flag |= PvmHostCompl;

			else if ( !strcmp( argv[i], "host" ) )
			{
				flag |= PvmTaskHost;

				host = copy_str( argv[i+1] );

				H = get_host_name( host );

				if ( H != NULL )
				{
					where = copy_str( H->refname );

					free( host );
				}

				else
					where = host;

				sprintf( tmp, " on %s", where );

				i++;
			}

			else if ( !strcmp( argv[i], "arch" ) )
			{
				flag |= PvmTaskArch;

				where = copy_str( argv[i+1] );

				sprintf( tmp, " on %s", where );

				i++;
			}
		}

		sprintf( msg, "setMsg \"Spawning %d cop%s of %s%s...\"",
			ntasks, ( ntasks > 1 ? "ies" : "y" ), name, tmp );

		Tcl_Eval( interp, msg );

		/* Set Up Trace Stuff for Auto Play */

		if ( !TRACE_DO_SPAWN
			&& ( !strcmp( init, "fresh" )
				|| ( !strcmp( init, "append" )
					&& ( TRACE_FILE_STATUS == TRACE_FILE_PLAYBACK
						|| TRACE_OUT == NULL ) ) ) )
		{
			if ( do_reset_views( itp ) == TCL_ERROR )
				return( TCL_ERROR );

			TRACE_FILE_STATUS = TRACE_FILE_OVERWRITE;

			PROCESS_COUNTER_INTERVAL = PROCESS_COUNTER_OVERWRITE;
			RECV_TIMER_INTERVAL = RECV_TIMER_OVERWRITE;

			strcpy( trc, "global trace_file_status; " );

			strcat( trc, "set trace_file_status \"OverWrite\"" );

			if ( Tcl_Eval( interp, trc ) == TCL_ERROR )
				return( TCL_ERROR );

			TRACE_DO_SPAWN = TRUE;

			if ( !setup_trace( itp ) )
				return( TCL_OK );
		}

		TRACE_DO_SPAWN = FALSE;

		/* Spawn Task(s) */

		tids = (int *) malloc( (unsigned) ntasks * sizeof(int) );
		memcheck( tids, "Spawn Return TIDs Array" );

		if ( !( flag & PvmTaskTrace ) )
			pvm_setopt( PvmTraceTid, 0 );

		cc = pvm_spawn( name, av, flag, where, ntasks, tids );

		if ( !( flag & PvmTaskTrace ) )
			pvm_setopt( PvmTraceTid, MYTID );

		if ( cc <= 0 )
		{
			if ( cc < 0 )
				pvm_perror( "Error Spawning" );

			sprintf( msg, "setMsg \"Error Spawning %s\"", name );
		}

		else
		{
			sprintf( result, "%d Task%s of %s Spawned%s%s",
				cc, ( cc != 1 ? "s" : "" ), name, tmp,
				( cc > 0 ? ":" : "" ) );

			for ( i=0 ; i < cc ; i++ )
			{
				sprintf( tmp, " 0x%x", tids[i] );

				append_cmd_str( result, tmp, 4096,
					(char *) NULL, FALSE );
			}

			sprintf( msg, "setMsg \"%s\"", result );
		}

		free( tids );

		free( init );

		free( name );

		Tcl_Eval( interp, msg );
	}

	else if ( !strcmp( argv[1], "otf" ) )
	{
		sscanf( argv[2], "%x", &tid );

		tstat = copy_str( argv[3] );

		if ( !tid )
		{
			if ( !pvm_tasks( 0, &ntask, &tip ) && ntask > 0 )
			{
				tids = (int *) malloc( (unsigned) ntask * sizeof(int) );
				memcheck( tids, "pvm_tasks() TIDs Array" );

				n = 0;

				for ( i=0 ; i < ntask ; i++ )
				{
					if ( (tmptid = tip[i].ti_tid) != MYTID )
						tids[n++] = tmptid;
				}

				set_task_tracing( tids, n, tstat );

				sprintf( tmp,
					"setMsg \"All Tasks Tracing Adjusted.\"" );

				free( tids );
			}
		}

		else
		{
			set_task_tracing( &tid, 1, tstat );

			sprintf( tmp,
				"setMsg \"Task t%x Tracing Adjusted.\"", tid );
		}

		free( tstat );

		Tcl_Eval( itp, tmp );
	}

	else if ( !strcmp( argv[1], "kill" ) )
	{
		sscanf( argv[2], "%x", &tid );

		name = copy_str( argv[3] );

		if ( !tid )
		{
			if ( !pvm_tasks( 0, &ntask, &tip ) && ntask > 0 )
			{
				tids = (int *) malloc( (unsigned) ntask * sizeof(int) );
				memcheck( tids, "pvm_tasks() TIDs Array" );

				for ( i=0 ; i < ntask ; i++ )
				{
					tids[i] = tip[i].ti_tid;

					if ( tids[i] != MYTID )
					{
						pvm_kill( tids[i] );

						if ( GROUPTASK( tip[i].ti_a_out ) )
							reset_groups();
					}
				}

				sprintf( tmp, "setMsg \"All Tasks Killed.\"" );

				for ( i=0 ; i < ntask ; i++ )
				{
					if ( tids[i] != MYTID )
						wait_kill( tids[i] );
				}

				free( tids );
			}
		}

		else
		{
			cc = pvm_kill( tid );

			if ( !cc )
			{
				sprintf( tmp, "setMsg \"Task t%x Killed.\"", tid );

				if ( GROUPTASK( name ) )
					reset_groups();

				wait_kill( tid );
			}

			else
			{
				pvm_perror( "Error Killing Task" );

				sprintf( tmp,
					"setMsg \"Error Killing Task t%x\"", tid );
			}
		}

		free( name );

		Tcl_Eval( itp, tmp );
	}

	else if ( !strcmp( argv[1], "signal" ) )
	{
		sscanf( argv[2], "%x", &tid );

		signal = signal_by_name( argv[3] );

		if ( !tid )
		{
			if ( !pvm_tasks( 0, &ntask, &tip ) )
			{
				err = 0;

				for ( i=0 ; i < ntask ; i++ )
				{
					T = &(tip[i]);

					if ( T->ti_tid != MYTID )
					{
						PVMCKERR( pvm_sendsig( T->ti_tid, signal ),
							"Error Signaling Task", err++ );
					}
				}

				if ( err )
					sprintf( tmp, "setMsg \"Error Signaling Tasks.\"" );

				else
					sprintf( tmp, "setMsg \"All Tasks Signaled.\"" );
			}
		}

		else
		{
			cc = pvm_sendsig( tid, signal );

			if ( cc < 0 )
			{
				pvm_perror( "Error Signaling Task" );

				sprintf( tmp,
					"setMsg \"Error Signaling Task t%x %s (%d)\"",
					tid, argv[3], signal );
			}

			else
			{
				sprintf( tmp, "setMsg \"Task t%x Signaled %s (%d)\"",
					tid, argv[3], signal );
			}
		}

		Tcl_Eval( itp, tmp );
	}

	else if ( !strcmp( argv[1], "systasks" ) )
	{
		if ( !strcmp( argv[3], "ON" ) )
			stval = TRUE;

		else
			stval = FALSE;

		if ( !strcmp( argv[2], "group" ) )
			TRACE_GROUP_TASKS = stval;
	}

	return( TCL_OK );
}

/* ARGSUSED */
int get_tasks_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	HOST H;

	struct pvmtaskinfo *T;
	struct pvmtaskinfo *tip;

	char tmp[1024];

	char *a_out;
	char *type;

	int ntask;
	int i;

	if ( argc < 2 )
	{
		Tcl_SetResult( itp,
			"usage: get_tasks_proc <type>", TCL_STATIC );

		return( TCL_ERROR );
	}

	type = copy_str( argv[1] );

	PVMCKERR( pvm_tasks( 0, &ntask, &tip ),
		"Error Obtaining Task Information", exit( -1 ) );

	for ( i=0 ; i < ntask ; i++ )
	{
		T = &(tip[i]);

		if ( T->ti_tid != MYTID )
		{
			if ( strcmp( T->ti_a_out, "" ) )
				a_out = T->ti_a_out;

			else
				a_out = "-";

			H = get_host_tid( T->ti_host, IN_PVM );

			if ( H != NULL )
			{
				sprintf( tmp, "add_list_task %s %s %s %x",
					type, H->alias, a_out, T->ti_tid );
			}

			else
			{
				sprintf( tmp, "add_list_task %s ??? %s %x",
					type, a_out, T->ti_tid );
			}

			Tcl_Eval( itp, tmp );
		}
	}

	return( TCL_OK );
}

wait_kill( tid )
int tid;
{
	struct pvmtaskinfo *T;
	struct pvmtaskinfo *tip;

	int found;
	int ntask;
	int cnt;
	int i;

	cnt = 0;

	do
	{
		found = 0;

		PVMCKERR( pvm_tasks( 0, &ntask, &tip ),
			"Error Waiting for Tasks to Die", exit( -1 ) );

		for ( i=0 ; i < ntask && !found ; i++ )
		{
			T = &(tip[i]);

			if ( T->ti_tid == tid )
			{
				found++;

				if ( !strcmp( T->ti_a_out, "" ) )
					cnt++;
			}
		}
	}
	while ( found && cnt < 10 );
}

/* ARGSUSED */
int reset_pvm_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	struct pvmtaskinfo *tip;

	int ntask;
	int inum;
	int tid;
	int i;

	Tcl_Eval( itp, "setMsg \"Resetting PVM...\"" );

	/* Copied from console code - cons.c */

	PVMCKERR( pvm_tasks( 0, &ntask, &tip ),
		"Error Obtaining Task Information", exit( -1 ) );

	for ( i=0 ; i < ntask ; i++ )
	{
		tid = tip[i].ti_tid;

		if ( tid != 0 && tid != MYTID )
			pvm_kill( tid );
	}

	reset_groups();

	/* Re-add XPVM to "xpvm" group */

	inum = pvm_joingroup( "xpvm" );

	if ( inum < 0 )
		pvm_perror( "Error Joining XPVM Group" );

	else if ( inum != 0 )
	{
		printf( "\nWarning: XPVM Group Already Present, inum=%d\n\n",
			inum );
	}

	GROUPS_ALIVE = TRUE;

	/* Done */

	Tcl_Eval( itp, "setMsg \"PVM Reset Done.\"" );

	return( TCL_OK );
}

reset_groups()
{
	int i, j;

	while ( (i = pvm_lookup( "pvmgs", -1, &j )) >= 0 )
		pvm_delete( "pvmgs", i );

	gstid = -1;    /* Hack to force re-start of group servers... */

	GROUPS_ALIVE = FALSE;
}

/* ARGSUSED */
int reset_views_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	int ret;

	ret = do_reset_views( itp );

	return( ret );
}

do_reset_views( itp )
Tcl_Interp *itp;
{
	TEVDESC TDnext;
	TEVDESC TDlast;
	TEVDESC TD;

	UT_STATE Unext;
	UT_STATE U;

	TASK Tnext;
	TASK T;

	MSG_GRID Gnext;
	MSG_GRID G;

	MSG Mnext;
	MSG M;

	char cmd[1024];

	int i, j;

	if ( TRACE_PROCESS_LOCK == TRACE_LOCKED )
	{
		TRACE_MODE_PENDING = TRACE_MODE_RESET;

		return( TCL_OK );
	}

	Tcl_Eval( itp, "setMsg \"Resetting XPVM Views...\"" );

	/* Reset Interface */

	Tcl_Eval( itp, "reset_interface" );

	/* Reset Time Vars */

	CURRENT_TIME.tv_sec = -1;
	CURRENT_TIME.tv_usec = -1;

	BASE_TIME.tv_sec = -1;
	BASE_TIME.tv_usec = -1;

	/* Reset Pending Message List */

	M = PENDING_MSG_LIST;

	while ( M != NULL )
	{
		Mnext = M->next;

		free_msg( &M );

		M = Mnext;
	}

	PENDING_MSG_LIST = (MSG) NULL;

	/* Reset Pending Message Grid */

	for ( i=0 ; i < NTASKS ; i++ )
	{
		for ( j=0 ; j < NTASKS ; j++ )
		{
			G = PENDING_MSG_GRID[i][j];

			while ( G != NULL )
			{
				Gnext = G->next;

				free_msg_grid( &G );

				G = Gnext;
			}

			PENDING_MSG_GRID[i][j] = (MSG_GRID) NULL;
		}
	}

	/* Clear Space-Time Message Lines */

	M = MSG_LIST;

	while ( M != NULL )
	{
		DELETE_GOBJ( itp, ST_C, M->line );

		Mnext = M->next;

		free_msg( &M );

		M = Mnext;
	}

	MSG_LIST = (MSG) NULL;

	/* Reset Task List */

	T = TASK_LIST;

	while ( T != NULL )
	{
		Tnext = T->next;

		free_task( &T );

		T = Tnext;
	}

	TASK_LIST = (TASK) NULL;

	NTASKS = 0;

	/* Reset Utilization State List */

	U = UT_LIST;

	while ( U != NULL )
	{
		Unext = U->next;

		free_ut_state( &U );

		U = Unext;
	}

	UT_LIST = (UT_STATE) NULL;

	/* Event Name Lookup Trie for 3.4 */

	free_triestack( &EVENT_TRIE );

	EVENT_TRIE = create_triestack();

	/* Trace Descriptors */

	for ( i=0 ; i < TEVDESC_SIZE ; i++ )
	{
		TD = TEVDESC_LIST[i];

		TDlast = (TEVDESC) NULL;

		while ( TD != NULL )
		{
			TDnext = TD->next;

			if ( strcmp( TD->name, "newtask" )
				&& strcmp( TD->name, "spntask" )
				&& strcmp( TD->name, "endtask" ) )
			{
				free_tevdesc( &TD );

				if ( TDlast == NULL )
					TEVDESC_LIST[i] = TDnext;

				else
					TDlast->next = TDnext;
			}

			else
			{
				TD->dump = TRUE;

				TDlast = TD;
			}

			TD = TDnext;
		}
	}

	/* Set Result Message */

	Tcl_Eval( itp, "setMsg \"XPVM Views Reset Done.\"" );

	return( TCL_OK );
}

/* ARGSUSED */
int reset_trace_file_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	setup_trace( itp );

	return( TCL_OK );
}

/* ARGSUSED */
int quit_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	struct pvmtaskinfo *taskp;

	int ntasks;
	int found;
	int cc;
	int i;

	if ( MYTID > 0 )
	{
		if ( GROUPS_ALIVE )
		{
			PVMCKERR( pvm_tasks( 0, &ntasks, &taskp ),
				"Error Cleaning up XPVM Group", exit( -1 ) );

			found = 0;

			for ( i=0 ; i < ntasks && !found ; i++ )
			{
				if ( GROUPTASK( taskp[i].ti_a_out ) )
					found++;
			}

			if ( found )
			{
				cc = pvm_getinst( "xpvm", MYTID );

				if ( cc >= 0 )
				{
					cc = pvm_lvgroup( "xpvm" );

					if ( cc < 0 )
					{
						printf(
							"\nError Leaving XPVM Group, cc=%d\n\n",
							cc );
					}
				}
			}

			else
				printf( "Warning: Group Server Not Found...\n" );
		}

		printf( "Quitting xpvm - pvmd still running.\n" );

		pvm_exit();
	}

	exit( 0 );
}

/* ARGSUSED */
int halt_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	pvm_halt();

	exit( 0 );
}

/* ARGSUSED */
int playback_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char *strcat();

	char tmp[255];

	int index;

	index = (int) clientData;

	TRACE_STATUS = index;

	set_trace_controls();

	switch ( index )
	{
		case TRACE_REWIND:
		{
			if ( TRACE_FILE_STATUS == TRACE_FILE_OVERWRITE )
			{
				TRACE_FILE_STATUS = TRACE_FILE_PLAYBACK;

				PROCESS_COUNTER_INTERVAL = PROCESS_COUNTER_PLAYBACK;
				RECV_TIMER_INTERVAL = RECV_TIMER_PLAYBACK;

				strcpy( tmp, "global trace_file_status; " );

				strcat( tmp, "set trace_file_status \"PlayBack\"" );

				Tcl_Eval( interp, tmp );
			}

			if ( TRACE_IN != NULL )
				fclose( TRACE_IN );

			do_trace_playback();

			if ( do_reset_views( itp ) == TCL_ERROR )
				return( TCL_ERROR );

			break;
		}

		case TRACE_STOP:
		{
			break;
		}

		case TRACE_FWD:
		case TRACE_FWDSTEP:
		{
			TRACE_ACTIVE = TRUE;

			break;
		}
	}

	return( TCL_OK );
}

/* ARGSUSED */
int trace_overwrite_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	if ( argc != 2 )
	{
		Tcl_SetResult( itp,
			"arg count - usage: trace_overwrite_result (TRUE/FALSE)",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	if ( TRACE_OUT != NULL )
		fclose( TRACE_OUT );

	if ( TRACE_IN != NULL )
		fclose( TRACE_IN );

	if ( !strcmp( argv[1], "TRUE" ) )
	{
		do_trace_overwrite();

		if ( TRACE_DO_SPAWN )
			Tcl_Eval( itp, "do_spawn again" );
	}

	else
	{
		TRACE_FILE_STATUS = TRACE_FILE_PLAYBACK;

		PROCESS_COUNTER_INTERVAL = PROCESS_COUNTER_PLAYBACK;
		RECV_TIMER_INTERVAL = RECV_TIMER_PLAYBACK;

		SET_TCL_GLOBAL( itp, "trace_file_status", "PlayBack" );

		do_trace_playback();

		TRACE_DO_SPAWN = FALSE;
	}

	return( TCL_OK );
}

/* ARGSUSED */
int trace_file_status_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	if ( argc != 2 )
	{
		Tcl_SetResult( itp,
			"arg count - usage: trace_file_status_handle <status>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	if ( !strcmp( argv[1], "OverWrite" ) )
	{
		TRACE_FILE_STATUS = TRACE_FILE_OVERWRITE;

		PROCESS_COUNTER_INTERVAL = PROCESS_COUNTER_OVERWRITE;
		RECV_TIMER_INTERVAL = RECV_TIMER_OVERWRITE;
	}

	else if ( !strcmp( argv[1], "PlayBack" ) )
	{
		TRACE_FILE_STATUS = TRACE_FILE_PLAYBACK;

		PROCESS_COUNTER_INTERVAL = PROCESS_COUNTER_PLAYBACK;
		RECV_TIMER_INTERVAL = RECV_TIMER_PLAYBACK;
	}

	if ( do_reset_views( itp ) == TCL_ERROR )
		return( TCL_ERROR );

	setup_trace( itp );

	return( TCL_OK );
}

/* ARGSUSED */
int trace_file_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	if ( argc != 2 )
	{
		Tcl_SetResult( itp,
			"arg count - usage: trace_file_handle <file_name>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	if ( strcmp( argv[1], TRACE_FILE ) )
	{
		strcpy( TRACE_FILE, argv[1] );

		TRACE_OVERWRITE_FLAG = FALSE;

		if ( do_reset_views( itp ) == TCL_ERROR )
			return( TCL_ERROR );

		setup_trace( itp );
	}

	return( TCL_OK );
}

setup_trace( itp )
Tcl_Interp *itp;
{
	int ret;

	ret = TRUE;

	if ( TRACE_OUT != NULL )
	{
		fclose( TRACE_OUT );

		TRACE_OUT = (FILE *) NULL;
	}

	if ( TRACE_IN != NULL )
	{
		fclose( TRACE_IN );

		TRACE_IN = (FILE *) NULL;
	}

	TRACE_PENDING = 0;

	if ( strcmp( TRACE_FILE, "" ) )
	{
		switch ( TRACE_FILE_STATUS )
		{
			case TRACE_FILE_OVERWRITE:
			{
				if ( check_overwrite_exists( itp ) )
					do_trace_overwrite();

				else
					ret = FALSE;

				break;
			}

			case TRACE_FILE_PLAYBACK:
			{
				do_trace_playback();

				break;
			}
		}
	}

	return( ret );
}

do_trace_overwrite()
{
	int ecnt;
	int fck;
	int i;

	TRACE_OUT = fopen( TRACE_FILE, "w" );
	fck = filecheck( TRACE_OUT, TRACE_FILE );

	if ( fck )
	{
		TRACE_IN = fopen( TRACE_FILE, "r" );
		filecheck( TRACE_IN, TRACE_FILE );
	}

	else
		TRACE_IN = (FILE *) NULL;

	dump_trace_header();

	restore_hosts_from_playback();

	for ( i=TEV33_FIRST ; i < TRACE33_MAX ; i++ )
		TEV33_TRACE[i] = 0;

	gettimeofday( &TRACE_TIME, (struct timezone *) NULL );

	ecnt = save_host_status_events();

	TRACE_OVERWRITE_FLAG = TRUE;

	TRACE_STATUS = TRACE_FWD;

	set_trace_controls();

	TRACE_PENDING = ecnt;
}

do_trace_playback()
{
	TRACE_OUT = (FILE *) NULL;

	TRACE_IN = fopen( TRACE_FILE, "r" );
	filecheck( TRACE_IN, TRACE_FILE );

	clear_hosts_for_playback();

	TRACE_STATUS = TRACE_STOP;

	set_trace_controls();

	TRACE_PENDING = 0;
}

/* ARGSUSED */
int get_trace_format_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char *result;

	if ( TRACE_FORMAT == TEV_FMT_33 )
		result = copy_str( "3.3" );

	else if ( TRACE_FORMAT == TEV_FMT_34 )
		result = copy_str( "3.4" );

	else
		result = copy_str( "Unknown" );

	Tcl_SetResult( itp, result, TCL_DYNAMIC );

	return( TCL_OK );
}

/* ARGSUSED */
int define_trace_mask_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TRACE_MASK_GROUP *TMG_LIST;
	TRACE_MASK_GROUP TMG;

	TRACE_MASK_INDEX *TMI_LIST;
	TRACE_MASK_INDEX TMI;

	char *TM;

	char *formatstr;
	char *maskstr;
	char *liststr;

	char **av;
	int ac;

	int fmt;
	int set;
	int i;

	if ( argc < 3 )
	{
		Tcl_SetResult( itp,
		"usage: define_trace_mask [ 3.3 | 3.4 ] <name> <event_list>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	formatstr = argv[1];

	maskstr = argv[2];

	liststr = argv[3];

	if ( !strcmp( formatstr, "3.3" ) )
	{
		fmt = TEV_FMT_33;

		TMG_LIST = &TM33_GROUP_LIST;

		TMI_LIST = &TM33_INDEX_LIST;
	}

	else if ( !strcmp( formatstr, "3.4" ) )
	{
		fmt = TEV_FMT_34;

		TMG_LIST = &TM_GROUP_LIST;

		TMI_LIST = &TM_INDEX_LIST;
	}

	else
	{
		printf( "\nError: Unknown PVM format \"%s\"...\n\n",
			formatstr );

		return( TCL_OK );
	}

	set = FALSE;

	if ( !strcmp( maskstr, "DEFAULT" ) )
	{
		if ( fmt == TEV_FMT_33 )
			TM = TRACE33_MASK;

		else if ( fmt == TEV_FMT_34 )
			TM = TRACE_MASK;

		if ( TRACE_FORMAT == fmt )
			set = TRUE;
	}

	else
	{
		TMG = lookup_trace_mask_group( *TMG_LIST, maskstr );

		if ( TMG == NULL )
		{
			/* GROUP_LIST always starts non-null - w/ALL_EVENTS */

			TMG = create_trace_mask_group();

			TMG->next = *TMG_LIST;

			*TMG_LIST = TMG;

			TMG->name = copy_str( maskstr );

			TMG->tmask = (char *) malloc( (unsigned)
				TRACE_MASK_LENGTH( fmt ) * sizeof(char) );
			memcheck( TMG->tmask, "Group Trace Mask" );
		}

		else
		{
			printf( "\nError: Trace Mask Group %s Already Exists.\n\n",
				maskstr );
		}

		TM = TMG->tmask;
	}

	INIT_TRACE_MASK( TM, fmt );

	Tcl_SplitList( itp, liststr, &ac, &av );

	for ( i=0 ; i < ac ; i++ )
	{
		TMI = lookup_trace_mask_name( *TMI_LIST, av[i] );

		if ( TMI != NULL )
		{
			SET_TRACE_MASK( TM, fmt, TMI->index );
		}

#ifndef USE_PVM_33
		else
			printf( "Error: Trace Mask For \"%s\" Not Found\n", av[i] );
#endif
	}

	if ( set )
	{
		pvm_settmask( PvmTaskChild, TM );

		set_trace_mask_buttons( itp, TM, *TMG_LIST, *TMI_LIST, fmt );
	}

	return( TCL_OK );
}

/* ARGSUSED */
int trace_mask_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	TRACE_MASK_GROUP TMG;

	TRACE_MASK_INDEX TMI;

	char result[2048];
	char tmp[4096];

	char *onoffstr;
	char *evstr;

	int index;
	int onoff;
	int set;
	int i;

	if ( argc < 3 )
	{
		Tcl_SetResult( itp,
			"usage: pvm_trace_mask <event> [ ON | OFF ]",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	evstr = argv[1];

	onoffstr = argv[2];

	if ( !strcmp( onoffstr, "ON" ) )
		onoff = TRUE;

	else
		onoff = FALSE;

	set = FALSE;

	TMI = lookup_trace_mask_name( *CURRENT_INDEX_LIST, evstr );

	if ( TMI != NULL )
	{
		index = TMI->index;

		if ( onoff )
		{
			SET_TRACE_MASK( CURRENT_TRACE_MASK, TRACE_FORMAT, index );
		}

		else
		{
			UNSET_TRACE_MASK( CURRENT_TRACE_MASK, TRACE_FORMAT, index );
		}

		pvm_settmask( PvmTaskChild, CURRENT_TRACE_MASK );

		set = TRUE;
	}

	else
	{
		TMG = lookup_trace_mask_group( *CURRENT_GROUP_LIST, evstr );

		if ( TMG != NULL )
		{
			for ( i=FIRST_EVENT( TRACE_FORMAT ) ;
				i <= LAST_EVENT( TRACE_FORMAT ) ;
				i += EVENT_INCR( TRACE_FORMAT ) )
			{
				if ( CHECK_TRACE_MASK( TMG->tmask, TRACE_FORMAT, i ) )
				{
					if ( onoff )
					{
						SET_TRACE_MASK( CURRENT_TRACE_MASK,
							TRACE_FORMAT, i );
					}

					else
					{
						UNSET_TRACE_MASK( CURRENT_TRACE_MASK,
							TRACE_FORMAT, i );
					}
				}
			}

			pvm_settmask( PvmTaskChild, CURRENT_TRACE_MASK );

			set = TRUE;
		}

		else
			printf( "Trace Event %s Not Found In Mask\n", evstr );
	}

	if ( set )
	{
		set_trace_mask_buttons( itp, CURRENT_TRACE_MASK,
			*CURRENT_GROUP_LIST, *CURRENT_INDEX_LIST, TRACE_FORMAT );
	}

	return( TCL_OK );
}

/* ARGSUSED */
int output_file_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	if ( argc != 2 )
	{
		Tcl_SetResult( itp,
			"arg count - usage: output_file_handle <file_name>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	if ( strcmp( argv[1], OUTPUT_FILE ) )
	{
		strcpy( OUTPUT_FILE, argv[1] );

		if ( OUTPUT_FP != NULL )
			fclose( OUTPUT_FP );

		if ( strcmp( OUTPUT_FILE, "" ) )
		{
			OUTPUT_FP = fopen( OUTPUT_FILE, "w" );
			filecheck( OUTPUT_FP, OUTPUT_FILE );
		}
	}

	return( TCL_OK );
}

/* ARGSUSED */
int get_hosts_menu_list( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	HOST H;

	char *cmd_argv[MAX_HID];
	char *merge[2];

	char **list_argv;

	char *label;
	char *state;
	char *help;

	char *result;
	char *hosts;
	char *cmds;

	char tmp[1024];

	int i;

	/* Host Commands */

	for ( i=0 ; i < MAX_HID ; i++ )
	{
		sprintf( tmp, "\"%s\" %d \"%s\"",
			HOST_CMD_STRS[i], i, HOST_CMD_HELP[i] );

		cmd_argv[i] = copy_str( tmp );
	}

	cmds = Tcl_Merge( MAX_HID, cmd_argv );

	/* Hosts */

	if ( NHOSTS > 0 )
	{
		list_argv = (char **) malloc( (unsigned) NHOSTS
			* sizeof(char *) );
		memcheck( list_argv, "Menu List Argv" );

		H = MAIN_NET->host_list;

		i = 0;

		while ( H != NULL )
		{
			label = host_name( H, FALSE );

			if ( H->in_pvm == IN_PVM )
				state = copy_str( "ON" );

			else
				state = copy_str( "OFF" );

			help = host_name( H, TRUE );

			sprintf( tmp, "\"%s\" %d %s \"%s %s\"",
				label, MAX_HID + i, state, HOST_MENU_HELP_STR, help );

			list_argv[i] = copy_str( tmp );

			free( label );
			free( state );
			free( help );

			H = H->next;

			i++;
		}

		hosts = Tcl_Merge( NHOSTS, list_argv );
	}

	else
		hosts = "{}";

	/* Return Combined List as Result */

	merge[0] = cmds;
	merge[1] = hosts;

	result = Tcl_Merge( 2, merge );

	Tcl_SetResult( itp, result, TCL_DYNAMIC );

	return( TCL_OK );
}

/* ARGSUSED */
int load_bitmap_file( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	Pixmap bitmap;

	char tmp[1024];

	if ( argc != 2 )
	{
		Tcl_SetResult( itp, "usage: load_bitmap_file <file>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	sprintf( tmp, "@%s", argv[1] );

	bitmap = Tk_GetBitmap( itp, Top, Tk_GetUid( tmp ) );

	if ( bitmap <= 0 )
	{
		sprintf( tmp, "Error Opening Bitmap %s", argv[1] );

		Tcl_SetResult( itp, copy_str( tmp ), TCL_DYNAMIC );

		return( TCL_ERROR );
	}

	return( TCL_OK );
}

/* ARGSUSED */
int title_info_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char tmp[255];

	sprintf( tmp, "%s  (PVM %s)  [TID 0x%x]",
		XPVM_VERSION, pvm_version(), MYTID );

	Tcl_SetResult( itp, tmp, TCL_STATIC );

	return( TCL_OK );
}

/* ARGSUSED */
int define_arch( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	ARCH A;

	Pixmap bitmap;

	char tmp[1024];

	int height;
	int width;

	if ( argc != 3 )
	{
		Tcl_SetResult( itp, "usage: define_arch <code> <file>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	if ( ARCH_LIST == NULL )
		A = ARCH_LIST = create_arch();

	else
	{
		A = ARCH_LIST;

		while ( A->next != NULL )
			A = A->next;

		A->next = create_arch();

		A = A->next;
	}

	A->code = copy_str( argv[1] );

	sprintf( tmp, "@%s", argv[2] );

	A->name = copy_str( tmp );

	bitmap = Tk_GetBitmap( itp, Top, Tk_GetUid( tmp ) );

	if ( bitmap <= 0 )
	{
		sprintf( tmp, "Error Opening Bitmap %s", argv[2] );

		Tcl_SetResult( itp, copy_str( tmp ), TCL_DYNAMIC );

		return( TCL_ERROR );
	}

#ifdef USE_TCL73_TK36
	Tk_SizeOfBitmap( Disp, bitmap,
		(unsigned *) &width, (unsigned *) &height );
#else
	Tk_SizeOfBitmap( Disp, bitmap,
		(int *) &width, (int *) &height );
#endif

	A->height = height;
	A->width = width;

	return( TCL_OK );
}

/* ARGSUSED */
int pad_cmd( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char *result;
	char *ptr;
	char *str;

	int len;
	int nd;
	int nz;
	int i;

	if ( argc < 3 )
	{
		Tcl_SetResult( itp,
			"usage: pad <number_str> <desired_length>",
			TCL_STATIC );

		return( TCL_ERROR );
	}

	str = argv[1];

	len = atoi( argv[2] );

	nd = strlen( str );

	nz = len - nd;

	result = (char *) malloc( (unsigned) (len + 1) * sizeof(char) );
	memcheck( result, "Numerical Pad String" );

	ptr = result;

	for ( i=0 ; i < nz ; i++ )
		*ptr++ = '0';

	sprintf( (char *) (result + nz), "%s", str );

	Tcl_SetResult( itp, result, TCL_DYNAMIC );

	return( TCL_OK );
}

/* ARGSUSED */
int strip_label_cmd( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char tmp[1024];

	char *result;
	char *ptr;
	char *str;

	int len;

	if ( argc != 2 )
	{
		Tcl_SetResult( itp, "usage: strip_label <str>", TCL_STATIC );

		return( TCL_ERROR );
	}

	str = argv[1];

	ptr = tmp;

	while ( *str != '\0' )
	{
		if ( *str == '-' || *str == ' ' || *str == '.' )
			*ptr++ = '_';

		else
			*ptr++ = *str;

		str++;
	}

	*ptr = '\0';

	result = copy_str( tmp );

	Tcl_SetResult( itp, result, TCL_DYNAMIC );

	return( TCL_OK );
}

/* ARGSUSED */
int fix_help_line_cmd( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char tmp[1024];

	char *result;
	char *ptr;
	char *str;

	int len;

	if ( argc != 2 )
	{
		Tcl_SetResult( itp, "usage: fix_help_line <line>", TCL_STATIC );

		return( TCL_ERROR );
	}

	str = argv[1];

	ptr = tmp;

	while ( *str != '\0' )
	{
		if ( *str == '' )
			*ptr++ = '{';

		else if ( *str == '' )
			*ptr++ = '}';

		else
			*ptr++ = *str;

		str++;
	}

	*ptr = '\0';

	result = copy_str( tmp );

	Tcl_SetResult( itp, result, TCL_DYNAMIC );

	return( TCL_OK );
}

/* ARGSUSED */
int set_query_time_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	char cmd[1024];
	char tmp[255];

	char *usec_pad;

	int qt_usec;
	int qt_sec;
	int qt;
	int x;

	REFRESH_GLOBAL( SCALE );

	x = atoi( argv[1] );

	TIMEIDX = x;

	if ( x != -1 )
	{
		qt = x * INT_GLOBVAL( SCALE );

		qt_sec = qt / 1000000;

		qt_usec = qt % 1000000;

		usec_pad = pad_num( qt_usec, 6 );

		sprintf( tmp, "Query Time: %d.%s", qt_sec, usec_pad );

		free( usec_pad );
	}

	else
		tmp[0] = '\0';

	sprintf( cmd,
		"%s.query_frame.query configure -text {View Info:   %s}",
		ST, tmp );

	Tcl_Eval( itp, cmd );

	SET_TCL_GLOBAL( itp, "st_query_text_scroll", "0" );

	SET_TCL_GLOBAL( itp, "st_query_text", tmp );

	return( TCL_OK );
}

/* ARGSUSED */
int time_zoom_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	int new_scale;
	int timex;

	new_scale = atoi( argv[1] );

	timex = X_OF_TIME( CURRENT_TIME.tv_sec, CURRENT_TIME.tv_usec,
		new_scale );

	set_view_time( timex );

	return( TCL_OK );
}

/* ARGSUSED */
int check_max_scale_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	int new_scale;
	int max_int;

	new_scale = atoi( argv[1] );

	/* Generate Maximum Positive Integer */

	max_int = ipwr( 2, ( ((int) sizeof( int )) * 8 ) - 1 ) - 1;

	/* Assume maximum canvas width of 1280 */

	if ( new_scale >= max_int / 1280 )
		Tcl_SetResult( itp, "0", TCL_STATIC );

	else
		Tcl_SetResult( itp, "1", TCL_STATIC );

	return( TCL_OK );
}

/* ARGSUSED */
int double_click_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	static struct timeval last = { -1, -1 };

	struct timeval tmp;

	int diff;

	gettimeofday( &tmp, (struct timezone *) NULL );

	diff = ( ( tmp.tv_sec - last.tv_sec ) * 1000000 )
		+ tmp.tv_usec - last.tv_usec;

	if ( diff < 500000 )
		Tcl_SetResult( itp, "1", TCL_STATIC );

	else
		Tcl_SetResult( itp, "0", TCL_STATIC );

	last.tv_sec = tmp.tv_sec;
	last.tv_usec = tmp.tv_usec;

	return( TCL_OK );
}

