/* PVM testing routines version 1.0 */

#include <stdio.h>
#include <pvm3.h>
#include <sys/time.h>
#include "inc.h"

char *strtst(s1, s2)
char *s1,*s2;
{


  char *tmp;
  int i = 0, j = 0, k, l;

  tmp = (char *)malloc((strlen(s2)+1)*sizeof(char));

  if (strlen(s1) < strlen(s2))
    return NULL;

  for (i = 0; i < strlen(s1); i++)
  {
    if (s1[i] == s2[j] && j < strlen(s2))
    {
      l = i;
      for (k = 0; k < strlen(s2); k++)
      {      
         tmp[k] = s1[l];
         l++;
       }

      if (strcmp(tmp, s2) == 0)
        return s1+i;
    }
  }

  return NULL;
}

void chk_pool(outfile, hostp, hostpool, nhost, hostcnt)
FILE *outfile;
struct pvmhostinfo *hostp;
char **hostpool;
int *nhost, *hostcnt;
{

  int i, j, k;

  for (i = 1; i < *nhost; i++)
  {
    if (strcmp(hostp[i].hi_arch,"PGON") == 0)
    {
      for (j = 0; j < *hostcnt; j++)
      {
        if (strcmp(hostp[i].hi_name,hostpool[j]) == 0)
	{
          for (k = j; k < *hostcnt; k++)
	  {
            if ((k+1) < *hostcnt)
	    {
              fprintf(outfile,"\n*** %s ignored, invalid PVM configuration entry ***\n",hostpool[k]); 
              hostpool[k] = hostpool[k+1];
            }
            else
              hostpool[k] = NULL;
          }
          *hostcnt = *hostcnt - 1;
        }
      }
    }
  }
}
void gen( me, size, mess, fltres, intres,dblres, lngres, shtres, bytres, 
          cpxres, dcxres, strres, uinres,ushres, ulnres)

int me, size, mess, *intres;
float *fltres, *cpxres;
double *dblres, *dcxres;
long *lngres;
short *shtres;
char *bytres, *strres;
unsigned int *uinres;
unsigned short *ushres;
unsigned long *ulnres;

{

  int i;
  
  /* generate data for the message */
 
  strcpy(strres, "test string");
 
  for (i = 0 ; i<size ; i++)
  {
    *(fltres+i) = (float)(i * mess + me);
    *(intres+i) = (int)(i * mess + me);
    *(dblres+i) = (double)(i * mess + me);
    *(lngres+i) = (long)(i * mess + me);
    *(shtres+i) = (short)(i * mess + me);
    strcpy(bytres+i, "A");
    *(cpxres+i) = (float)(i * mess + me);
    *(dcxres+i) = (double)(i * mess + me);
    *(uinres+i) = (unsigned int)(i * mess + me);
    *(ushres+i) = (unsigned short)(i * mess + me);
    *(ulnres+i) = (unsigned long)(i * mess + me);
  }
} 


int is_mpp()
{
  int i, narch, nhost, info, mppflg = 0;
  struct pvmhostinfo *hostp;
  char loc[256];

  info = pvm_config(&nhost, &narch, &hostp);
  if (info < 0)
  {
    sprintf(loc,"IS_MPP: ERROR OBTAINING PVM CONFIGURATION");
    pvm_perror(loc);
    mppflg = -1;
  }

  for (i = 0; i < nhost; i++)
  {
    if (strcmp(hostp[i].hi_arch, "CM5")  == 0 || 
        strcmp(hostp[i].hi_arch, "PGON") == 0 ||
        strcmp(hostp[i].hi_arch, "I860") == 0)
        mppflg = 1;
  } 
  
  return(mppflg);
}

int test_select( tstmod, code, direct, broad, pack,
                  choice )

int *tstmod, *code, *direct, *broad, choice;
char *pack;

{

  int nhost, narch, screen = 1;
  char test[80], tmp;
  struct pvmhostinfo hostp;

  /* initialize variables based on the user's choice */

  switch(choice)
  {
  case 32:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 33:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 34:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 35:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 36:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 37:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 38:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 39:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 40:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 41:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 42:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 43:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 44:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 45:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 46:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 47:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 48: 
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 49:
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 50:
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 51:
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 52:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 53:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 54:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'y';
     break;
  case 55:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'y';
     break;
  case 56:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 57:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 58:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 59:
    *tstmod  = 1;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 60:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 61:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 62:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 63:
    *tstmod  = 1;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'n';
     break;    
  case 64:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 65:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 66:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 67:
    *tstmod  = 2;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 68:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 69:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 70:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 71:
    *tstmod  = 2;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 72: 
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 73:
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 74:
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 75:
    *tstmod  = 3;
    *code    = PvmDataRaw;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 76:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 77:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmDontRoute;
    *broad   = 2;
    *pack    = 'n';
     break;
  case 78:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 1;
    *pack    = 'n';
     break;
  case 79:
    *tstmod  = 3;
    *code    = PvmDataDefault;
    *direct  = PvmAllowDirect;
    *broad   = 2;
    *pack    = 'n';
     break;

  }



  /* call is_mpp() to determine if an mpp machine is in the PVM 
     configuration */

  if(is_mpp() == 1 && (*direct == PvmAllowDirect && 
     (*tstmod  == 2 || *tstmod == 3) && *broad == 1))
    return(-1);
  else
    return(0);

}


void packdat(size, me, fltres, intres, dblres, lngres, shtres, bytres, cpxres,
             dcxres, strres, uinres, ushres, ulnres, code, nproc, n, mess, 
             sum, crc, pack, broad, direct, tids, tstmod, msgtype, whopk)


int size, me, *intres, code, nproc, n, mess, sum, crc[12], broad, direct;
int *tids, tstmod, msgtype;
float *fltres, *cpxres;
double *dblres, *dcxres;
long *lngres;
short *shtres;
char *bytres, *strres, *pack, whopk[10];
unsigned int *uinres;
unsigned short *ushres;
unsigned long *ulnres;


{

  int i, cnt=0, stat;
  char *buf, loc[256],tmp[200];
  FILE *sout;


   /* pack initialization data if msgtype = 0 */

  if (msgtype == 0)
  {

    stat = pvm_pkint(&nproc, 1, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [# OF PROCESSES] (%s)",whopk);
      pvm_perror( loc );
    }

    stat = pvm_pkstr( pack );
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [DATA PACK FLAG] (%s)",whopk);
      pvm_perror( loc );
    }    
    
    /* note that array size is irrelevant if no data is packed so none will
       be sent if zero string length is chosen as the message */

    if(*pack == 'y' || *pack == 'Y')
    {
      stat = pvm_pkint(&size, 1, 1);
      if (stat < 0)
      {
        sprintf(loc, "ERROR PACKING INIT DATA [MESSAGE SIZE] (%s)",whopk);
        pvm_perror( loc );
      }
    }

    stat = pvm_pkint(&broad, 1, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [BROADCAST METHOD] (%s)",whopk);
      pvm_perror( loc );
    }

    stat = pvm_pkint(&code, 1, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [ENCODING METHOD] (%s)",whopk);
      pvm_perror( loc );
    }

    stat = pvm_pkint(&direct, 1, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [ROUTING OPTION] (%s)",whopk);
      pvm_perror( loc );
    }

    stat = pvm_pkint(tids, nproc, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [TASK ID] (%s)",whopk);
      pvm_perror( loc );
    }

    stat = pvm_pkint(&n, 1, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [# OF MESSAGES] (%s)",whopk);
      pvm_perror( loc );
    }

    stat = pvm_pkint(&tstmod, 1, 1);
    if (stat < 0)
    {
      sprintf(loc, "ERROR PACKING INIT DATA [TEST SELECTION] (%s)",whopk);
      pvm_perror( loc );
    }

  }

  else if ( msgtype == 5 )
  {

    /* allocate space for CRC buffer */

    buf = (char *)malloc(sum);

    /* load buffer with message for CRC calculation */

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%f",*(fltres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[0] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%d",*(intres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);
 
    }

    cnt = strlen(buf);
    crc[1] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%f",*(dblres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);
  
    }

    cnt = strlen(buf);
    crc[2] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%f",*(cpxres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[3] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%f",*(dcxres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[4] = hoot(buf, cnt);
    cnt = 0;


    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%d",*(shtres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[5] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%d",*(lngres+i));        
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[6] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i< size; i++)
    {
      sprintf(tmp,"%d",*(uinres+i));        
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[7] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%d",(int)*(ushres+i)); 
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[8] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%d",*(ulnres+i));
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[9] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%s",strres);
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
       strncat(buf,tmp,cnt);

    }
  
    cnt = strlen(buf);
    crc[10] = hoot(buf, cnt);
    cnt = 0;

    fcstab_init();

    for(i = 0; i < size; i++)
    {
      sprintf(tmp,"%c",*(bytres+i)); 
      cnt = strlen(tmp);

      if (i == 0)
        strcpy(buf,tmp);
      else
        strncat(buf,tmp,cnt);

    }

    cnt = strlen(buf);
    crc[11] = hoot(buf, cnt);
    cnt = 0;

    /* pack message */

    stat = pvm_pkint( &me, 1, 1 );
    if (stat < 0)
    {
      sprintf( loc,"ERROR PACKING PROCESS ID (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkint( &mess, 1, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING MESSAGE ID (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkint( crc, 12, 1 );
    if (stat < 0)
    {
      sprintf( loc,"ERROR PACKING CRC (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkint( intres, size, 1 );
    if ( stat < 0)
    {
      sprintf(loc,"ERROR PACKING INTEGER PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkfloat( fltres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING FLOAT PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkdouble( dblres, size, 1 );
    if (stat < 0)
    {
      sprintf( loc,"ERROR PACKING DOUBLE PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkstr( strres );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING STRING PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pklong( lngres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING LONG PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkshort( shtres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING SHORT PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkbyte( bytres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING BYTE PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkcplx( cpxres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING COMPLEX PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkdcplx( dcxres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING DOUBLE COMPLEX PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkuint( uinres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING UNSIGNED INTEGER PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkushort( ushres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING UNSIGNED SHORT PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
    stat = pvm_pkulong( ulnres, size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PACKING UNSIGNED LONG PART OF MESSAGE (%s)",whopk);
      pvm_perror( loc );
    }
  }
}


/*
 *	fcs.c
 *
 *	generate checksums for messages.
 *
 *	3 Sep 1993  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	FCS code yanked from RFC 1331 - PPP
 */


/*
 * Generate a FCS table for the HDLC FCS.
 *
 * Drew D. Perkins at Carnegie Mellon University.
 *
 * Code liberally borrowed from Mohsen Banan and D. Hugh Redelmeier.
 */

/*
 * The HDLC polynomial: x**0 + x**5 + x**12 + x**16 (0x8408).
 */
#define	P	0x8408

#define PPPINITFCS      0xffff  /* Initial FCS value */

#define	ASSERT(v)	if (!(v)) { fprintf(stderr, "ASSERT failed at %s:%d\n", __FILE__, __LINE__); exit(1); }

typedef unsigned short u16;
static u16 fcstab[256];


/*	fcstab_init()
*
*	call this once to initialize the table.
*/

fcstab_init()
{
	register unsigned int b, v;
	register int i;

	ASSERT(sizeof (u16) == 2);
	ASSERT(((u16) -1) > 0);

	for (b = 0; ; ) {
		v = b;
		for (i = 8; i--; )
			v = v & 1 ? (v >> 1) ^ P : v >> 1;

		fcstab[b] = v;
		if (++b == 256)
			break;
	}
	return 0;
}


/*
 * Calculate a new fcs given the current fcs and the new data.
 */

u16
pppfcs(fcs, cp, len)
	register u16 fcs;
	register unsigned char *cp;
	register int len;
{
	while (len--)
		fcs = (fcs >> 8) ^ fcstab[(fcs ^ *cp++) & 0xff];
	return (fcs);
}


#if  1
int hoot(buf, n)

char *buf;
int n;
{
	char *fmt;
/*        va_list args; */
	int i;
	u16 fcs; 
 

        /* perform CRC calculation */

	fcs = PPPINITFCS;
	fcs = pppfcs(fcs, (unsigned char *)buf, n);
        return((int)fcs);
	 
}
#endif




void error(fltres, intres, dblres, strres, lngres, shtres, bytres, cpxres,
           dcxres, uinres, ushres, ulnres, who, mess, arr, err)

float *fltres, *cpxres;
int *intres, who, mess, arr, *err;
double *dblres, *dcxres;
char *strres, *bytres;
long *lngres;
short *shtres;
unsigned int *uinres;
unsigned short *ushres;
unsigned long *ulnres;



{

  float  flterr, cpxerr;
  int    interr, byterr, strerr;
  double dblerr, dcxerr;
  short  shterr;
  long   lngerr;
  unsigned int uinerr;
  unsigned short usherr;
  unsigned long ulnerr;  

  /* calculate errors by comparing received data with known value */

  flterr = (float)(mess*arr+who) - *(fltres+arr);
  interr =         (mess*arr+who) - *(intres+arr);
  dblerr = (double)(mess*arr+who) - *(dblres+arr);
  strerr = strcmp("test string",strres);
  lngerr = (long)(mess*arr+who) - *(lngres+arr);
  shterr = (short)(mess*arr+who) - *(shtres+arr);
  byterr = strncmp("A",bytres+arr,1);
  cpxerr = (float)(mess*arr+who) - *(cpxres+arr);
  dcxerr = (double)(mess*arr+who) - *(dcxres+arr);
  uinerr = (unsigned int)(mess*arr+who) - *(uinres+arr);
  usherr = (unsigned short)(mess*arr+who) - *(ushres+arr);
  ulnerr = (unsigned long)(mess*arr+who) - *(ulnres+arr);

  /* determine which component of the message is bad and increment 
     error counter */

  if (flterr != 0)
    *err = *err + 1;
  if (interr != 0)
    *err = *err + 1;
  if (dblerr > 1.0e-6)
    *err = *err + 1;
  if (strerr != 0)
    *err++ = *err + 1;
  if (lngerr !=0)
    *err = *err+ 1;
  if (shterr != 0)
    *err = *err + 1;
  if ( byterr != 0)
    *err = *err + 1;
  if (cpxerr != 0)
    *err = *err + 1;
  if (dcxerr > 1.0e-6)
    *err = *err + 1;
  if (uinerr !=0)
    *err = *err+ 1;
  if (usherr !=0)
    *err = *err+ 1;
  if (ulnerr !=0)
    *err = *err+ 1;

}


void unpackdat(size, who, mess, crcr,intres, fltres, dblres, strres, lngres, 
               shtres, bytres, cpxres, dcxres, uinres, ushres, ulnres, nproc, 
               pack, broad, code, direct, tids, n, tstmod, msgtype, whoupk)

int *size, *who, *mess, crcr[12], *intres, *nproc, *broad, *code, *direct;
int *tids, *n, *tstmod, msgtype;
float *fltres, *cpxres;
double *dblres, *dcxres;
char *strres, *bytres, *pack, whoupk[10];
long *lngres;
short *shtres;
unsigned int *uinres;
unsigned short *ushres;
unsigned long *ulnres;

{

  int stat;
  char loc[256];

  /* unpack initial data from master */

  if (msgtype == 0)
  {
    stat = pvm_upkstr(pack);  
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [DATA PACK FLAG] (%s)",whoupk);
      pvm_perror( loc );
    }

    /* unpack array size only if non-zero length messages were sent */

    if (*pack == 'y' || *pack == 'Y')
    {
      stat = pvm_upkint(size, 1, 1);
      if (stat < 0)
      {
        sprintf(loc,"ERROR UNPACKING INIT DATA [MESSAGE SIZE] (%s)",whoupk);
        pvm_perror( loc );
      }
    }
    stat = pvm_upkint(broad, 1, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [BROADCAST METHOD] (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkint(code, 1, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [ENCODING METHOD] (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkint(direct, 1, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [ROUTING OPTION] (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkint(tids, *nproc, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [TASK ID] (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkint(n, 1, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [# OF MESSAGES] (%s)", whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkint(tstmod, 1, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [TEST SELECTION] (%s)",whoupk);
      pvm_perror( loc );
    }
  }

  /* unpack message */

  else if (msgtype == 5)
  {
    stat = pvm_upkint( who, 1, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING PROCESS ID (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkint( mess, 1, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING MESSAGE ID (%s)",whoupk);
      pvm_perror( loc );
    } 
    stat = pvm_upkint( crcr, 12, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING CRC (%s)",whoupk);
      pvm_perror( loc );
    }  
    stat = pvm_upkint( intres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INT PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkfloat( fltres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING FLOAT PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkdouble( dblres, *size, 1 ); 
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING DOUBLE PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkstr( strres );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING STRING PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upklong( lngres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"PROCESS ERROR UNPACKING LONG PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkshort( shtres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"PROCESS ERROR UNPACKING SHORT PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkbyte( bytres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING BYTE PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkcplx( cpxres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING COMPLEX PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkdcplx( dcxres, *size, 1 );   
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING DBL COMPLEX PART OF MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkuint( uinres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"PROCESS ERROR UNPACKING UNSIGNED INT MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkushort( ushres, *size, 1 );
    if (stat < 0)
    {
     sprintf(loc,"PROCESS ERROR UNPACKING UNSIGNED SHORT MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
    stat = pvm_upkulong( ulnres, *size, 1 );
    if (stat < 0)
    {
      sprintf(loc,"PROCESS ERROR UNPACKING UNSIGNED LONG MESSAGE (%s)",whoupk);
      pvm_perror( loc );
    }
  }
}
	  

void msgsend(tstmod, me, tids, msgtype, stime,
             etime, j, master, broad)
int tstmod, me, *tids, msgtype, j, master, broad;
struct timeval stime[2], etime[2];
{

  char loc[256];
  int  stat;
  FILE *dfp;


  if(broad==1)
  {

     /* for the head to head and funneling test then send message to
        master also send to master when the triangle messaging test
        is selected and the current process is # 1.  Also keep track
        of the timing of the messages */

     if (tstmod !=3 || (tstmod == 3 && me == 1))
     {
       gettimeofday(stime,NULL); 
       stat = pvm_send( master, msgtype );
       gettimeofday(etime,NULL); 
     }

     /* if the triangle messaging test is selected and the current 
        process is 0 then send to process 1 */

     else
     {
       gettimeofday(stime,NULL); 
       stat = pvm_send( tids[1], msgtype );
       gettimeofday(etime,NULL);  
     }
     if (stat < 0)
     {
       sprintf(loc,"ERROR SENDING MESSAGE # %d (SLAVE # %d)"
               ,j,me);
       pvm_perror( loc );
     }
        
   }
   else
   {
     if (tstmod != 3 || (tstmod == 3 && me == 1))
     {
       gettimeofday(stime,NULL); 
       stat = pvm_mcast( &master, 1, msgtype );
       gettimeofday(etime,NULL); 
     }
     else
     {
       gettimeofday(stime,NULL);
       stat = pvm_mcast( tids+1, 1, msgtype );
       gettimeofday(etime,NULL);
     }
     if (stat < 0)
     {
       sprintf(loc,"ERROR MCASTING MESSAGE # %d (SLAVE # %d)"
               ,j, me);
       pvm_perror( loc );
     }

   }
}


































