/****************************************/
/*  test_list.c      */
/*  tests masters and slaves  */
/****************************************/

#include "pvm_test.h"

/********** TEST 1 ********/
/* pvm_mstat correct*/
/********************/
short test1(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i=0;
int   mstat;
int   result = 1;

for (i=1;i<length;i++)
  {
  mstat = pvm_mstat(hostpool[array_of_index[i]]);
  if (mstat == PvmSysErr)
    {
    fprintf(outfile,"\tpvm_stat() : Unable to contact local Pvmd\n");
    result = -1;
    continue;
    }
  if ((mstat == PvmNoHost)||(mstat == PvmHostFail))
    {
    fprintf(outfile,"\tpvm_stat() : Unable to detect host %s\n",
      hostpool[array_of_index[i]]);
    result = -1;
    }
  }
return result;
}

void test1_slave()
{}

/********** TEST 2 ********/
/* pvm_mstat incorrect*/
/**********************/
short test2(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int   result = 1;
int   mstat;

for (i=1;i<length;i++)
  {
  mstat = pvm_mstat(hostpool[array_of_index[i]]);
  if (mstat == PvmSysErr)
    {
    fprintf(outfile,"\tpvm_stat() : Unable to contact local Pvmd\n");
    result = -1;
    continue;
    }
  if (mstat == PvmOk)
    {
    fprintf(outfile,"\tpvm_stat() : Detect a not added host (%s)\n",
      hostpool[array_of_index[i]]);
    result = -1;
    }
  }
return result;
}

void test2_slave()
{}

      

/********** TEST 3 ********/
/* pvm_addhosts correct*/
/***********************/
short test3(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int  stat,mstat;
int  info;
int   result=1;

i=1;
while(hostpool[i]!=NULL)
  {
  stat = pvm_addhosts(hostpool+i,1,&info);
  if (stat < 1)
    {
    result = -1;
    if (stat == PvmSysErr)
      fprintf(outfile,"\tpvm_addhosts() : Unable to contact local pvmd\n"); 
    else
      fprintf(outfile,
        "\tpvm_addhosts() : Failed for host %s with error %d\n",
        hostpool+i,info);
    continue;
    }
  info = wait_number_hosts(i);
  if (info <0)
    return -1;
  mstat = pvm_mstat(hostpool[i]);
  if (mstat == PvmSysErr)
    {
    fprintf(outfile,"\tpvm_mstat () : Unable to contact local Pvmd\n");
    result = -1;
    continue;
    }
  if ((mstat == PvmHostFail)||(mstat == PvmNoHost))
    {
    fprintf(outfile,"Host %s just added by pvm_addhosts() is unreachable\n",
      hostpool[i]);
    result = -1;
    }
  i++;
  }
return result;
} 

void test3_slave()
{}

/********** TEST 4 ********/
/* pvm_addhosts incorrect*/
/*************************/
short test4(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  stat,mstat;
int  info;
int  result=1;

i=1;
while(hostpool[i]!=NULL)
  {
  stat = pvm_addhosts(hostpool+i,1,&info);
  if (stat < 1)
    {
    result = -1;
    if (stat == PvmSysErr)
      fprintf(outfile,"\tpvm_addhosts() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,
        "\tpvm_addhosts() : Failed for host %s with error %d\n",
        hostpool[i],info);
    continue;
    }
  info = wait_number_hosts(i);
  if (info <0)
    return -1;

  mstat = pvm_mstat(hostpool[i]);
  if (mstat == PvmSysErr)
           {
    fprintf(outfile,"\tpvm_mstat() : Unable to contact local Pvmd\n");
    result =  -1;
    continue;
    }
  if (mstat == PvmHostFail)
    {
    fprintf(outfile,
      "Host %s just added by pvm_addhosts() is unreachable\n",
      hostpool[i]);
    result = -1;
    }
  i++;
  }
if (result == -1)
  {
  fprintf(outfile,"\tpvm_addhosts() should not have failed yet\n");
  return -1;
  }

i=0;
while(hostpool[i]!=0)
  {
  stat = pvm_addhosts(hostpool+i,1,&info);
  if (info != PvmDupHost)
    {
    fprintf(outfile,
      "\tpvm_addhosts() : Should have returned %d for host %s but returned %d\n",
      PvmDupHost,hostpool[i],info);
    result = -1;
    }
  i++;
  }
return result;
}

void test4_slave()
{}

/********** TEST 5 ********/
/* pvm_delhosts correct */
/************************/
short test5(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i=0;
int  stat,mstat;
int  info;
int  result=1;


for (i=1;i<length;i++)
  {
  stat = pvm_delhosts(&hostpool[array_of_index[i]],1,&info);
  if (stat < 1)
    {
    result = -1;
    fprintf(outfile,"\tpvm_delhosts() : Failed to delete host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    continue;
    }
  info = wait_number_hosts(length-i-1);
  if (info <0)
    return -1;
  mstat = pvm_mstat(hostpool[array_of_index[i]]);
  if (mstat == PvmSysErr)
    {
    fprintf(outfile,"\tpvm_mstat() : Unable to contact local Pvmd\n");
    result =  -1;
    continue;
    }
  if ((mstat != PvmNoHost)&&(mstat != PvmHostFail))
    {
    result = -1;
    fprintf(outfile,"\tpvm_delhosts() : has not correctly deleted host %s\n",
      hostpool[array_of_index[i]]);
    }
  }

return result;
}


void test5_slave()
{}

/********** TEST 6 ********/
/* pvm_delhosts incorrect*/
/*************************/
short test6(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  stat,mstat;
int  info;
int  result=1;

for (i=1;i<length;i++)
  {
  stat = pvm_delhosts(&hostpool[i],1,&info);
  if (stat < 1)
    {
    result = -1;
    fprintf(outfile,"\tpvm_delhosts() : Failed to delete host %s with error %d\n",
      hostpool[i],info);
    continue;
    }
  info = wait_number_hosts(length-i-1);
  if (info <0)
    return -1;
  mstat = pvm_mstat(hostpool[i]);
  if (mstat == PvmSysErr)
    {
    fprintf(outfile,"\tpvm_mstat() : Unable to contact local Pvmd\n");
    result =  -1;
    continue;
    }
  if ((mstat != PvmNoHost)&&(mstat != PvmHostFail))
    {
    result = -1;
    fprintf(outfile,"\tpvm_delhosts() : has not correctly deleted host %s\n",
      hostpool[i]);
    }
  }
if (result == -1)
  {
  fprintf(outfile,"\tpvm_delhosts() : should not have failed yet\n");
  return -1;
  }
for (i=0;i<length;i++)
  {
  stat = pvm_delhosts(&hostpool[i],1,&info);
  if (stat >= 1)
    {
    result = -1;
    fprintf(outfile,
      "\tpvm_delhosts() : Should have returned a negative value  for host %sn", 
      hostpool[i]);
    }
  }
return result;
}

void test6_slave()
{}

/********** TEST 7 ********/
/* Race pvm_config pvm_addhosts*/
/*******************************/
short test7(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  stat;
int  *infos;
int  num_found;
int  narch;
struct  pvmhostinfo *hostp;


i=1;
while(hostpool[i++]!=NULL);
length = i-2;

infos = (int *)malloc(length*sizeof(int));

if (length == 0)
  return 1;

stat = pvm_addhosts(hostpool+1,length,infos);
if (stat < length)
  {
  for (i=0;i<length;i++)
    if (infos[i] < 0)
      fprintf(outfile,"\tpvm_addhosts() : Failed to add host %s, error %d\n",
        hostpool[i],infos[i]);
  free(infos);
  return -1;
  }
sleep(SNOOZ);
stat = pvm_config(&num_found,&narch,&hostp);
if (stat <0)
  {
  fprintf(outfile,"\tpvm_config() : Failed with error %d\n",stat);
  free(infos);
  return -1;
  }
if (num_found != (length+1))
  {
  fprintf(outfile,"\tpvm_config() : Didn't get the up-to-date information in time\n");
  free(infos);
  return -1;
  }
free(infos);
return 1;  
}

void test7_slave()
{}

/********** TEST 8 ********/
/* Race pvm_config pvm_delhosts*/
/*******************************/
short test8(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  stat;
int  *infos;
int  result=1;
int  num_found;
int  ack;
int  narch;
struct  pvmhostinfo *hostp;


if (length == 1)
  return 1;

infos = (int *)malloc((length-1)*sizeof(int));
stat = pvm_delhosts(hostpool+1,length-1,infos);
if (stat <length-1)
  {
  for (i=0;i<length-1;i++)
    if (infos[i] < 0)
      fprintf(outfile,
        "\tpvm_delhosts() : Impossible to delete host %s, error %d\n",
        hostpool[i+1],infos);
  result = -1;
  goto bail;
  }

sleep(SNOOZ);
stat = pvm_config(&num_found,&narch,&hostp);
if (stat <0)
  {
  fprintf(outfile,"\tpvm_config() : Failed with error\n",stat);
  result = -1;
  goto bail;
  }
if (num_found != 1)
  {
  fprintf(outfile,"\tpvm_config() : Didn't get the up-to-date information in time\n");
  result =-1;
  }
bail:
  wait_number_hosts(0);
  free(infos);
  return result;

}

void test8_slave()
{}

/********** TEST 9 ********/
/*pvm_hostsync() */
/*******************************/
short test9(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  info;
int  result=1;
struct  pvmhostinfo *hostp;
struct   timeval clk,delta;
int  nhost;
int  narch;

if (length == 1)
  return 1;

info = pvm_config(&nhost,&narch,&hostp);
if (info <0)
  {
  fprintf(stderr,"\tpvm_config() : Failed with error %d\n",info);
  return -1;
  }

for (i=1;i<length;i++)
  {
  info = pvm_hostsync(hostp[i].hi_tid,&clk,&delta);
  if (info <0)
    {
    result = -1;
    fprintf(outfile,"\tpvm_hostsync() : Failed on host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    }
  }
return result;
}

void test9_slave()
{}



/********** TEST 10 ********/
/* pvm_pstat correct*/
/********************/

short test10(array_of_index,length)
int  *array_of_index;
int  length;
{
int   mytid;
int  pstat;

mytid = pvm_mytid();
if (mytid <0)
  {
  fprintf(outfile,"\tpvm_mytid() : Unable to get my tid.. Pvmd not responding\n");
  return -1;
  }
pstat = pvm_pstat(mytid);

if (pstat == PvmSysErr)
  {
  fprintf(outfile,"\tpvm_pstat() : Local Pvmd not respondif\n");
  return -1;
  }
if (pstat != PvmOk)
  {
  fprintf(outfile,"\tpvm_pstat() : Unable to get my own process status !\n");
  return -1;
  }
return 1;
}

void test10_slave()
{}

/********** TEST 11 ********/
/* pvm_pstat incorrect*/
/**********************/

short test11(array_of_index,length)
int  *array_of_index;
int  length;
{
int   mytid;
int  pstat;

mytid = pvm_mytid();
if (mytid <0)
  {
  fprintf(outfile,"\tpvm_mytid() : Unable to get my tid.. Pvmd not responding\n");
  return -1;
  }
pstat = pvm_pstat(mytid+3);
if (pstat == PvmSysErr)
  {
  fprintf(outfile,"\tpvm_pstat() : Local Pvmd not responding\n");
  return -1;
  }
if (pstat == PvmOk)
  {
  fprintf(outfile,"\tpvm_stat() : Recognizing a non-existing task!\n");
  return -1;
  }
if(pstat == PvmBadParam)
  {
  fprintf(outfile,"\tpvm_stat() : A valid parameter was considered as invalid\n");
  return -1;
  }
return 1;
}

void test11_slave()
{}

  
/********** TEST 12 ********/
/* pvm_spawn sequential */
/************************/
short test12(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int  ack;
int  info;
int  pstat;
int  tid;
int   result = 1;
char   *args[2];
char  *test="12";

args[0]=test;
args[1]=NULL;

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else  
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);   
  if (ack < 0)
    {  
    result = -1;
    continue;
    }
  info = pvm_recv(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    }
  pstat = pvm_pstat(tid);
  if (pstat <0)
    {
    result = -1;
    if (pstat == PvmSysErr)
      fprintf(outfile,"\tpvm_pstat() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_pstat() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],pstat);
    }
  info = pvm_kill(tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }
return result;
}

void test12_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 13 ********/
/* pvm_spawn simulateous*/
/************************/
short test13(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int  info;
int   ack;
int  pstat;
int  *tids;
int   result = 1;
char   *args[2];
char  *test="13";

args[0]=test;
args[1]=NULL;

tids = (int *)malloc(length*sizeof(int));
info = pvm_spawn(TEST_SLAVE,args,0,"",length,tids);
if (info <0 )
  {
  fprintf(outfile,"\tpvm_spawn() : System error %d\n",info);
  result = -1;
  goto end;
  }
if (info < length)
  /* Some tasks haven't been started */
  {
  result = -1;
  for (i=0;i<length;i++)
    if (tids[i]<0)
      {
      fprintf(outfile,"\tpvm_spawn() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],tids[i]);
      }
    else
      {
      info = pvm_kill(tids[i]);
      if (info <0)
        fprintf(outfile,
        "\tpvm_kill() : Unable to kill slave on host %s with error %d\n",
          hostpool[array_of_index[i]],info);
      }
  goto end;
  }  

for(i=0;i<length;i++)
  {
  ack = timeout_wait_message(-1,ACKNOLEDGE,-1);   
  if (ack <0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(-1,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);  
    result = -1;
    }
  }

for (i=0;i<length;i++)
  {
  pstat = pvm_pstat(tids[i]);
  if (pstat <0)
    {  
    result = -1;
    if (pstat == PvmSysErr)
          fprintf(outfile,"\tpvm_pstat() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_pstat() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],pstat);
    }
  info = pvm_kill(tids[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }
end:
  free(tids);
  return result;
}

void test13_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}


/********** TEST 14 ********/
/* pvm_kill correct */ 
/********************/
short test14(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int  ack;
int  info;
int  pstat;
int  tid;
int   result = 1;
char   *args[2];
char  *test="14";

args[0]=test;
args[1]=NULL;

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,PvmTaskHost,
    hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(-1,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
         result = -1;
    pvm_kill(tid);
    }
  else
    {
    pstat = pvm_pstat(tid);
    if (pstat <0)
             {
      result = -1;
             if (pstat == PvmSysErr)
        fprintf(outfile,"\tpvm_pstat() : Unable to contact local pvmd\n");
      else
        fprintf(outfile,
          "\tpvm_pstat() : Failed for host %s with error %d\n",
          hostpool[array_of_index[i]],pstat);
      }
    info = pvm_recv(-1,ACKNOLEDGE);
    if (info <0)
      {
      fprintf(outfile,"\tpvm_recv() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],info);
      result = -1;
      }  
    }
  info = pvm_kill(tid);
  if (info <0)
         {
         result = -1;
         fprintf(outfile,"\tpvm_kill() : Unable to kill slave on host %s with error %s\n",
      hostpool[array_of_index[i]],info);
         }
  }
return result;
}

void test14_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 15 ********/
/* pvm_kill incorrect */
/********************/
short test15(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  ack;
int  info;
int  pstat;
int  tid;
int  result = 1;
char  *args[2];
char  *test="15";

args[0]=test;
args[1]=NULL;

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
        ack = timeout_wait_message(-1,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid);
    continue;
    }
  pstat = pvm_pstat(tid);
  if (pstat <0)
           {
    result = -1;
    if (pstat == PvmSysErr)
      fprintf(outfile,"\tpvm_pstat() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_pstat() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],pstat);
    }
  info = pvm_recv(-1,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed for host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    }
      info = pvm_kill(tid);
  if (info <0)
    {
    result = -1;
    fprintf(outfile,
      "\tpvm_kill() : Unable to kill slave on host %s with error %s\n",
      hostpool[array_of_index[i]],info);
    }
  info = pvm_kill(tid);
  if (info >0)
    {
    result = -1;
    fprintf(outfile,
    "\tpvm_kill() : Has killed a non-existent slave without error on host %s\n",
      hostpool[array_of_index[i]]);
    }  
  }
  
return result;
}

void test15_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 16 ********/
/*pvm_tidtohost()   */
/********************/
short test16(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  ack;
int  info;
int  tid;
int  result = 1;
char  *args[2];
struct   pvmhostinfo *hostp;
int  dtid;
int  pstat;
int  narch;
int  nhost;
char  *test="16";

args[0]=test;
args[1]=NULL;

info = pvm_config(&nhost,&narch,&hostp);
if (info <0)
  {
  fprintf(outfile,"\tpvm_config() : Failed with error %d\n",info);
  return -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,PvmTaskHost,
    hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_recv(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    }
  pstat = pvm_pstat(tid);
  if (pstat <0)
    {
    result = -1;
    if (pstat == PvmSysErr)
      fprintf(outfile,"\tpvm_pstat() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_pstat() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],pstat);
    }
  dtid = pvm_tidtohost(tid);
  if (dtid <0)
    {
    result = -1;
    fprintf(outfile,"\tpvm_tidtohost() : Failed with error %d for host %s\n",
      dtid,hostpool[array_of_index[i]]);
    }
  else
    {
    if (dtid != hostp[i].hi_tid)
      {
      result = -1;
      fprintf(outfile,
      "\tpvm_tidtohost() : Didn't return the correct host tid for host %s\n",
        hostpool[array_of_index[i]]);
      }
    }
  info = pvm_kill(tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }
return result;
}

void test16_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 17 ********/
/*pvm_parent()   */
/********************/
short test17(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  ack;
int  info;
int  tid;
int  result = 1;
char  *args[2];
int  bufid;
int  response;
int   mytid;
char  *test="17";

args[0]=test;
args[1]=NULL;

mytid = pvm_mytid();
if (mytid <0)
  {
  fprintf(outfile,"\tpvm_mytid() : Failed with error %d\n",mytid);
  return -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid);
    continue;
    }
  bufid = pvm_recv(tid,ACKNOLEDGE);
  if (bufid <0)
      {
    fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_upkint(&response,1,1);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_upkint() : Failed with error %d\n",info);
    result = -1;
    pvm_kill(tid);
    continue;
    }
  if (response != mytid)
    {
    fprintf(outfile,
    "\tpvm_parent() : Failed on slave, should have return t%x but return t%x, from host %s\n",
      mytid,response,hostpool[array_of_index[i]]);
    result = -1;
    }
  info = pvm_kill(tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result;
}

void test17_slave()
{
int  par_tid;

par_tid =pvm_parent();
pvm_initsend(PvmDataDefault);
pvm_pkint(&par_tid,1,1);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}


/********** TEST 18 ********/
/*pvm_sendsig()   */
/********************/
short test18(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  ack;
int  info;
int  tid;
int  result = 1;
char  *args[2];
int  sig=SIGINT;
char  *test="18";

args[0]=test;
args[1]=NULL;

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    pvm_kill(tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
          result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_recv(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    pvm_kill(tid);
    continue;  
    }
  info = pvm_sendsig(tid,sig);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_sendsig() : Failed on host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    pvm_kill(tid);
    continue;
    }
  ack = timeout_wait_message(tid,SIGNAL,i);
  if (ack <0)
    {
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_recv(tid,SIGNAL);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_kill(tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }
pvm_kill(tid);
return result;
}

void test18_slave()
{
void extern   handler();

pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
signal(SIGINT,handler);
pvm_recv(-1,ENDLESS);
}

void handler()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),SIGNAL);
}

/********** TEST 19 ********/
/* pvm_tasks*/
/************************/
short test19(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  info;
int  ack;
int  *tids;
int  result = 1;
char  *args[2];
struct  pvmtaskinfo *taskp;
int   ntask;
char  *test="13";

args[0]=test;
args[1]=NULL;

tids = (int *)malloc(length*sizeof(int));
info = pvm_spawn(TEST_SLAVE,args,0,"",length,tids);
if (info <0 )
  {
  fprintf(outfile,"\tpvm_spawn() : System error %d\n",info);
  return -1;
  }
if (info < length)
  /* Some tasks haven't been started */
  {
  for (i=0;i<length;i++)
    {
    if (tids[i]<0)
      {
      result = -1;
      fprintf(outfile,"\tpvm_spawn() : Failed for host %s with error %d\n",
        hostpool[array_of_index[i]],tids[i]);
      continue;
      }
    pvm_kill(tids[i]);
    }
  free(tids);
  return -1;
  }

for(i=0;i<length;i++)
  {
  ack = timeout_wait_message(-1,ACKNOLEDGE,-1);
  if (ack <0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(-1,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    }
  }

if (result == -1)
  {
  free(tids);
  for (i=0;i<length;i++)
    pvm_kill(tids[i]);
  return -1;
  }


info = pvm_tasks(0,&ntask,&taskp);
if (info <0)
  {
  fprintf(outfile,"\tpvm_tasks() : Failed with error %d\n",info);
  result = -1;
  }
if (ntask != length+3)
  {
  fprintf(outfile,"\tpvm_task() : Didn't return the actual number of tasks :\n\
    \tShould have been %d but is %d\n",length+3,ntask);
  result = -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_tasks(tids[i],&ntask,&taskp);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_tasks() : Failed for task on host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    continue;
    }
  if ((taskp[0].ti_tid != tids[i])||
      (taskp[0].ti_host != pvm_tidtohost(tids[i])))
    {
    result = -1;
    fprintf(outfile,
      "\tpvm_tasks() : Didn't return correct information about the task\n");
    }
  info = pvm_kill(tids[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }
free(tids);
return result;
}

void test19_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 20 ********/
/* pvm_kill */
/************************/
short test20(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int  ack;
int  info;
int  tid;
int   result = 1;
char   *args[2];
char  *test="20";

args[0]=test;
args[1]=NULL;

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,PvmTaskHost,
    hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmdn"); else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_recv(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    }
  info = timeout_wait_kill(tid,array_of_index[i]);
  if (info <0)
    {
    fprintf(outfile,
      "\tpvm_exit() : The slave process has not exited in time on host %s\n",
      hostpool[array_of_index[i]]);
    result = -1;
    pvm_kill(tid);
    }
  /* The child will be killed anyway with the deletion of the host */
  }
return result;
}

void test20_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_exit();
}

/********** TEST 21 ********/
/* several group started */
/************************/
short test21(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  ack;
int  info;
int  *tid;
int  result = 1;
char  *args[2];
struct  pvmtaskinfo *taskp;
int  ntask;
int  num_msg=0;
char  *test="21";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));
for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    result = -1;
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed on %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    }
  }

if (result == -1)
  goto fail;

info = pvm_tasks(0,&ntask,&taskp);
if (info <0)
  {
  fprintf(outfile,"\tpvm_task() : Failed with error %d\n",info);
  goto fail;
  }
for (i=0;i<ntask;i++)
  if (strcmp(taskp[i].ti_a_out,"pvmgs") == 0)
      num_msg++;

for (i=0;i<length;i++)
  {
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with eror %d\n");
    result = -1;
    }
  ack = timeout_wait_kill(tid[i],-1);
  if (ack <0)
    result = -1;
  }
if (result == -1)
  goto fail;
  
if (num_msg ==0)
  {
  fprintf(outfile,"No group server started\n");
  result = -1;
  }
if (num_msg > 1)
  {
  fprintf(outfile,"%d group servers started !\n",num_msg);
  result = -1;
  }

return result;

fail :
  for(i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;

}

void test21_slave()
{
char *group="testgr21";

pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 22 ********/
/* pvm_joingroup incorrect*/
/************************/
short test22(array_of_index,length)
int  *array_of_index;
int  length;
{
int   info;
int   result = 1;
char  *group="testgr22";


info = pvm_joingroup(NULL);
if (info != PvmNullGroup)
  {
  fprintf(outfile,"\tpvm_joingroup() : Should have return %d but return %d\n",
    PvmBadParam,info);
  result = -1;
  }
info = pvm_joingroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_joingroup(group);
if (info != PvmDupGroup)
  {
  fprintf(outfile,"\tpvm_joingroup() : Should have return %d but return %d\n",
    PvmDupGroup,info);
  return -1;
  }
info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed to leave the group\n");
  fprintf(outfile,"*** May affect the future behaviour ***\n");
  return -1;
  }
    
return result;
}

void test22_slave()
{}

/********** TEST 23 ********/
/* pvm_lvgroup incorrect*/
/************************/
short test23(array_of_index,length)
int  *array_of_index;
int  length;
{
int   info;
char   *group="testgr23";

info = pvm_joingroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_lvgroup(group);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Should have returne %d but returned %d\n",
    PvmNotInGroup,info);
  return -1;
  }
return 1;
}

void test23_slave()
{}

/********** TEST 24 ********/
/* pvm_joingroup pvm_gsize()*/
/************************/
short test24(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char   *group="testgr24";
char  *test="24";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

info = pvm_gsize(group);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_gsize() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  result = -1;
  }
info = pvm_joingroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",info);
  return -1;
  }

info = pvm_gsize(group);
if (info != 1)
  {
  fprintf(outfile,"\tpvm_gsize() : Should have returned 1, but returned %d\n",info);
  pvm_lvgroup(group);
  return -1;
  }

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {  
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    }
  }

if (result == -1)
  {
  pvm_lvgroup(group);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_gsize(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_gsize() : Failed with error %d\n",info);
  pvm_lvgroup(group);
   for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
if (info != (length+1))
  {
  fprintf(outfile,"\tpvm_gsize() : Should have returned %d but returned %d\n",
    length+1,info);
  pvm_lvgroup(group);
   for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  ack = timeout_wait_kill(tid[i],-1);
  if (ack <0)
    {
    result = -1;
    }
  }
info = pvm_gsize(group);
if (info != 1)
  {
  fprintf(outfile,"\tpvm_gsize() : Should have returned 1, but returned %d\n",info);
  pvm_lvgroup(group);
  return -1;
  }
info = pvm_lvgroup(group);
if (info<0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_gsize(group);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_gsize() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  return -1;
  }

return 1;

}

void test24_slave()
{
char  *group="testgr24";

pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}



/********** TEST 25 ********/
/* group completion */
/************************/
short test25(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char   *group="testgr25";
char  *test="25";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

info = pvm_gsize(group);
if (info != PvmNoGroup)
  {
  fprintf(outfile,
    "\tpvm_gsize() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  result = -1;
  }

info = pvm_joingroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",info);
  return -1;
  }

info = pvm_gsize(group);
if (info != 1)
  {
  fprintf(outfile,"\tpvm_gsize() : Shouldhave returned 1, but returned %d\n",info);
  pvm_lvgroup(group);
  return -1;
  }

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    }
  }

if (result == -1)
  {
  pvm_lvgroup(group);
  return -1;
  }

for (i=0;i<length;i++)
  {
  ack = timeout_wait_kill(tid[i],array_of_index[i]);
    result = -1;
  }

info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  return -1;
  }

info = pvm_gsize(group);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_gsize() : Returned %d, implying that the group has not exited as it should have\n",info);
  return -1;
  }
return 1;
}

void test25_slave()
{
char   *group="testgr25";

pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_lvgroup(group);
pvm_exit();
}

/********** TEST 26 ********/
/* pvm_getinst() pvm_gettid()*/
/************************/
short test26(array_of_index,length)
int  *array_of_index;
int  length;
{
int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
int  proc_tid;
int  proc_inst;
int  mytid;
char  *group="testgr26";
char  *test="26";

args[0]=test;
args[1]=NULL;

info =pvm_gettid(group,0);
if (info != PvmNoGroup)
  {
  fprintf(outfile,
    "\tpvm_gettid() : should have returned %d but returned %d\n",
    PvmNoGroup,info);
  result = -1;
  }
tid = (int *)malloc(length*sizeof(int));

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    }
  }

if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

mytid = pvm_mytid();
if (mytid <=0)
  {
  fprintf(outfile,"\tpvm_mytid() : Failed with error %d\n",mytid);
  return -1;
  }

info = pvm_getinst(group,mytid);
if (info != PvmNotInGroup)
  {
  fprintf(outfile,"\tpvm_getinst() : Should have returned %d but returned %d\n",
    PvmNotInGroup,info);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

for (i=0;i<length;i++)
  {
  proc_inst = pvm_getinst(group,tid[i]);
  if (proc_inst <0)
    {
    fprintf(outfile,"\tpvm_getinst() : Failed for host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    continue;
    }
  proc_tid = pvm_gettid(group,proc_inst);
  if (proc_tid != tid[i])
    {
    fprintf(outfile,
      "\tpvm_gettid() : Should have returned t%d but returned %d for host %s\n",
      tid[i],proc_tid,hostpool[array_of_index[i]]);
    result = -1;
    continue;
    }
  }

if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_gettid(group,length);
if (info != PvmNoInst)
  {
  fprintf(outfile,"\tpvm_gettid() : Should have returned %d but returned %d\n",
    PvmNoInst,info);
  result = -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  ack = timeout_wait_kill(tid[i],-1);
  if (ack <0)
    result = -1;
  }

info = pvm_gettid(group,0);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_gettid() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  return -1;
  }
return result;
}

void test26_slave()
{
char  *group="testgr26";

pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);

}

/********** TEST 27 ********/
/* pvm_initsend() pvm_getsbuf() pvm_freebuf()*/
/************************/
short test27(array_of_index,length)
int  *array_of_index;
int  length;
{
int  bufid;
int   bufid2;
int  result =1; 
int  info;



bufid = pvm_initsend(PvmDataDefault);
if (bufid <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed to create buffer (PvmDataDefault)\n");
  return -1;
  }
bufid2 = pvm_getsbuf();
if (bufid2 != bufid)
  {
  fprintf(outfile,"\tpvm_getsbuf() : Should have returned %d but returned %d\n",
    bufid,bufid2);
  result = -1;
  }
info = pvm_freebuf(bufid);
if (info <0)
  {
  fprintf(outfile,"\tpvm_freebuf() : Failed with error %d\n",info);
  result -1;
  }
info = pvm_freebuf(bufid);
if (info != PvmNoSuchBuf)
  {
  fprintf(outfile,"\tpvm_freebuf() : Should have returned %d but returned %d\n",
    PvmNoSuchBuf,info);
  result = -1;
  }

return result;
}

void test27_slave()
{}

/********** TEST 28 ********/
/* pvm_pkxx()  pvm_upkxx() */
/************************/
short test28(array_of_index,length)
int  *array_of_index;
int  length;
{
int  ack;
int  tid;
int  narch;
int  nhost;
struct  pvmhostinfo *hostp;
char  *args[2];
int  atid,atag,alen;
char  *test="28";
int  info,info1,info2;
int  result=1;
char  char_in[1];
char  char_out[1];
char  byte_in[1];
char  byte_out[1];
int  int_in[1];
int  int_out[1];
short  short_in[1];
short  short_out[1];
long  long_in[1];
long  long_out[1];
u_int  uint_in[1];
u_int  uint_out[1];
u_short  ushort_in[1];
u_short  ushort_out[1];
u_long  ulong_in[1];
u_long  ulong_out[1];
float  float_in[1];
float  float_out[1];
double  double_in[1];
double  double_out[1];
float  comp_in[2];
float  comp_out[2];
double  dcomp_in[2];
double  dcomp_out[2];

args[0]=test;
args[1]=NULL;
/*  INITIALIZATION  */
char_out[0]='a';
byte_out[0]='a';
int_out[0]=1;
short_out[0]=1;
long_out[0]=1;
uint_out[0]=1;
ushort_out[0]=1;
ulong_out[0]=1;
float_out[0]=1.0E0;
double_out[0]=1.0E0;
comp_out[0]=1.0E0;
comp_out[1]=1.0E0;
dcomp_out[0]=1.0E0;
dcomp_out[1]=1.0E0;

/* SLAVE */
info = pvm_spawn(TEST_SLAVE,args,
  PvmTaskHost,hostpool[array_of_index[length-1]],1,&tid);
if (info <1 )
  {
  if (info == PvmSysErr)
    fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
  else
    fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
      hostpool[array_of_index[length-1]],tid);
  return -1;
  }
/* Acknoledgement from slave */
ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[length-1]);
if (ack < 0)
  {
  pvm_kill(tid);
  return -1;
  }
info  = pvm_recv(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }

/*  CHAR  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }  
info1 = pvm_pkstr(char_out);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkstr() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- CHAR --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkstr(char_in);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkstr() : Failed with error %d\n",info2);
  result = -1;
  }
if (char_out[0]!=char_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkstr() and pvm_upkstr()\n");
  result = -1;
  }
/*  BYTE  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkbyte(byte_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkbyte() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- BYTE --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkbyte(byte_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkbyte() : Failed with error %d\n",info2);
  result = -1;
  }
if (byte_out[0]!=byte_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkbyte() and pvm_upkbyte()\n");
  result = -1;
  }

/*  INT  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkint(int_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- INT --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkint(int_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info2);
  result = -1;
  }
if (int_in[0]!=int_out[0])
  {
  fprintf(outfile,"Data error between pvm_pkint() and pvm_upkint()\n");
  result = -1;
  }
/*  SHORT  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkshort(short_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkshort() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- SHORT --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkshort(short_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkshort() : Failed with error %d\n",info2);
  result = -1;
  }
if (short_out[0]!=short_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkshort() and pvm_upkshort()\n");
  result = -1;
  }
/*  LONG  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pklong(long_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pklong() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- LONG --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upklong(long_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pklong() : Failed with error %d\n",info2);
  result = -1;
  }
if (long_out[0]!=long_in[0])
  {
  fprintf(outfile,"Data error between pvm_pklong() and pvm_upklong()\n");
  result = -1;
  }
/*  U_INT  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkuint(uint_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkuint() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- U_INT --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkuint(uint_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkuint() : Failed with error %d\n",info2);
  result = -1;
  }
if (uint_out[0]!=uint_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkuint() and pvm_upkuint()\n");
  result = -1;
  }
/*      U_SHORT   */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkushort(ushort_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkushort() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- U_SHORT --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkushort(ushort_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkushort() : Failed with error %d\n",info2);
  result = -1;
  }
if (ushort_out[0]!=ushort_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkushort() and pvm_upkushort()\n");
  result = -1;
  }
/*  U_LONG  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkulong(ulong_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkulong() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- U_LONG --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkulong(ulong_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkulong() : Failed with error %d\n",info2);
  result = -1;
  }
if (ulong_out[0]!=ulong_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkulong() and pvm_upkulong()\n");
  result = -1;
  }
/*  FLOAT  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkfloat(float_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkfloat() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- FLOAT --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkfloat(float_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkfloat() : Failed with error %d\n",info2);
  result = -1;
  }
if (float_out[0]!=float_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkfloat() and pvm_upkfloat()\n");
  result = -1;
  }
/*  DOUBLE  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkdouble(double_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkdouble() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- DOUBLE --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkdouble(double_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkdouble() : Failed with error %d\n",info2);
  result = -1;
  }
if (double_out[0]!=double_in[0])
  {
  fprintf(outfile,"Data error between pvm_pkdouble() and pvm_upkdouble()\n");
  result = -1;
  }
/*  CPLX  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkcplx(comp_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkcplx() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- CPLX --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkcplx(comp_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkcplx() : Failed with error %d\n",info2);
  result = -1;
  }
if ((comp_out[0]!=comp_in[0])||(comp_out[1]!=comp_in[1]))
  {
  fprintf(outfile,"Data error between pvm_pkcplx() and pvm_upkcplx()\n");
  result = -1;
  }
/*  DCPLX  */
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info1 = pvm_pkdcplx(dcomp_out,1,1);
if (info1<0)
  {
  fprintf(outfile,"\tpvm_pkdcplx() : Failed with error %d\n",info1);
  result = -1;
  }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t -- DCPLX --\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info2 = pvm_upkdcplx(dcomp_in,1,1);
if (info2<0)
  {
  fprintf(outfile,"\tpvm_pkdcplx() : Failed with error %d\n",info2);
  result = -1;
  }
if ((dcomp_out[0]!=dcomp_in[0])||(dcomp_out[1]!=dcomp_in[1]))
  {
  fprintf(outfile,"Data error between pvm_pkdcplx() and pvm_upkdcplx()\n");
  result = -1;
  }
pvm_kill(tid);
return result;
}
void test28_slave()
{
char  char_in[1];
char  byte_in[1];
int  int_in[1];
short  short_in[1];
long  long_in[1];
u_int  uint_in[1];
u_short  ushort_in[1];
u_long  ulong_in[1];
float  float_in[1];
double  double_in[1];
float  comp_in[2];
double  dcomp_in[2];

pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);

/* CHAR */
pvm_recv(-1,TEST_VALUE);
pvm_upkstr(char_in);
pvm_initsend(PvmDataDefault);
pvm_pkstr(char_in);
pvm_send(pvm_parent(),TEST_VALUE);

/* BYTE */
pvm_recv(-1,TEST_VALUE);
pvm_upkbyte(byte_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkbyte(byte_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  INT  */
pvm_recv(-1,TEST_VALUE);
pvm_upkint(int_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkint(int_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  SHORT  */
pvm_recv(-1,TEST_VALUE);
pvm_upkshort(short_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkshort(short_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  LONG  */
pvm_recv(-1,TEST_VALUE);
pvm_upklong(long_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pklong(long_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  U_INT  */
pvm_recv(-1,TEST_VALUE);
pvm_upkuint(uint_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkuint(uint_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*      U_SHORT   */
pvm_recv(-1,TEST_VALUE);
pvm_upkushort(ushort_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkushort(ushort_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  U_LONG  */
pvm_recv(-1,TEST_VALUE);
pvm_upkulong(ulong_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkulong(ulong_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  FLOAT  */
pvm_recv(-1,TEST_VALUE);
pvm_upkfloat(float_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkfloat(float_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  DOUBLE  */
pvm_recv(-1,TEST_VALUE);
pvm_upkdouble(double_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkdouble(double_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  CPLX  */
pvm_recv(-1,TEST_VALUE);
pvm_upkcplx(comp_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkcplx(comp_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

/*  DCPLX  */
pvm_recv(-1,TEST_VALUE);
pvm_upkdcplx(dcomp_in,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkdcplx(dcomp_in,1,1);
pvm_send(pvm_parent(),TEST_VALUE);

pvm_recv(-1,ENDLESS);
}

/********** TEST 29 ********/
/* pvm_getrbuf()*/
/************************/
short test29(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
int  bufid;
char  *args[2];
char  *test="29";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  bufid = pvm_getrbuf();
  if (bufid != info)
    {
    fprintf(outfile,
      "\tpvm_getrbuf() : Should have returned %d but returned %d for host %s\n",
      info,bufid,hostpool[array_of_index[i]]);
    result = -1;
    }
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result;
}

void test29_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/************************/
/* pvm_bufinfo() */
/************************/
short test30(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
int  bufid;
char  *args[2];
int  proc_tid;
int   bytes;
int  msgtag;
char  *test="30";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    pvm_kill(tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(-1,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid[i]);
    continue;
    }
  bufid = pvm_recv(-1,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    pvm_kill(tid[i]);
    continue;
    }
  info = pvm_bufinfo(bufid,&bytes,&msgtag,&proc_tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_bufinfo() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[i]]);
    result = -1;
    pvm_kill(tid[i]);
    continue;
    }
  if (bytes != 4)
    {
    fprintf(outfile,
      "\tpvm_bufinfo() : Erroneous message length (%d instead of 4) for host %s\n",
      bytes,hostpool[array_of_index[i]]);
    pvm_kill(tid[i]);
    result = -1;
    }
  if (msgtag != ACKNOLEDGE)
    {
    fprintf(outfile,
      "\tpvm_bufinfo() : Erroneous message tag (%d instead of %d) for host %s\n",
      msgtag,ACKNOLEDGE,hostpool[array_of_index[i]]);
    pvm_kill(tid[i]);
    result = -1;
    }
  if (proc_tid != tid[i])
    {
    fprintf(outfile,
      "\tpvm_bufinfo() : Erroneous task id (t%x instead of t%x) for host %s\n",
      proc_tid,tid[i],hostpool[array_of_index[i]]);
    pvm_kill(tid[i]);
    result =-1;
    }
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result;
}

void test30_slave()
{
int  message=3;
pvm_initsend(PvmDataDefault);
pvm_pkint(&message,1,1);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}


/************************/
/* pvm_mytid() */
/************************/
short test31(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
int  proc_tid;
int  msgtag;
char  *test="31";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(-1,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid[i]);
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    pvm_kill(tid[i]);
    continue;
    }
  info = pvm_upkint(&proc_tid,1,1);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_upkint() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[i]]);
    result = -1;
    pvm_kill(tid[i]);
    continue;
    }
  if (proc_tid != tid[i])
    {
    fprintf(outfile,
      "\tpvm_mytid() : Should have returned %d on host %s but returned %d\n",
      tid[i],hostpool[array_of_index[i]],proc_tid);
    result =-1;
    }
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result;
}

void test31_slave()
{
int  message;
pvm_initsend(PvmDataDefault);
message = pvm_mytid();
pvm_pkint(&message,1,1);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 32 ********/
/* pvm_mkbuf() */
/************************/
short test32(array_of_index,length)
int  *array_of_index;
int  length;
{
int  bufid;
int  info;
int  dummy=1;
int  result=1;

bufid = pvm_mkbuf(PvmDataDefault);
if (bufid <0)
  {
  fprintf(outfile,"\tpvm_mkbuf() : Failed with error %d\n",bufid);
  result = -1;
  }
info = pvm_setsbuf(bufid);
if (info <0)
  {
  fprintf(outfile,"\tpvm_setsbuf() : Failed with error %d\n",info);
  result = -1;
   }
info = pvm_pkint(&dummy,1,1);
if (info <0)
  {
  fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
  result = -1;
  }
info = pvm_freebuf(bufid);
if (info <0)
  {
  fprintf(outfile,"\tpvm_freebuf() : Failed with error %d\n",info);
  result = -1;
  }
  
return result;
}

void test32_slave()
{}


/************************/
/* send() recv() psend() precv() coherency */
/************************/
short test33(array_of_index,length)
int  *array_of_index;
int  length;
{

int  ack;
int  tid;
int  info;
int  narch;
int  nhost;
struct  pvmhostinfo *hostp;
int  result = 1;
int  i;
char  *args[2];
double  dummy[10];
double  res_dummy[10];
int  atid,atag,alen;
char  *test="33";

args[0]=test;
args[1]=NULL;

/* Initialization */
for (i=0;i<10;i++)
  dummy[i]=0.1;

info = pvm_spawn(TEST_SLAVE,args,
  PvmTaskHost,hostpool[array_of_index[length-1]],1,&tid);
if (info <1 )
  {
  if (info == PvmSysErr)
    fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
  else
    fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
      hostpool[array_of_index[length-1]],tid);
  return -1;
  }
/* Acknoledgement from slave */
ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[length-1]);
if (ack < 0)
  {
  pvm_kill(tid);
  return -1;
  }
info  = pvm_recv(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }

/* SEND  RECV */

info = pvm_initsend(PvmDataDefault);
if (info <0)
  {  
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_pkdouble(dummy,10,1);
if (info <0)
  {  
  fprintf(outfile,"\tpvm_pkdouble() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
         }
info = pvm_send(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack<0)
  {
  fprintf(outfile,"\t( pvm_send() - pvm_recv())\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,TEST_VALUE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_upkdouble(res_dummy,10,1);
if (info<0)
  {
  fprintf(outfile,"\tpvm_upkdouble() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
for (i=0;i<10;i++)
  if (res_dummy[i] != dummy[i])
    {
    fprintf(outfile,"\tValue #%d received different from value sent for host %s\n",
                    i,hostpool[array_of_index[length-1]]);
    fprintf(outfile,"\tSould be %f but is %f\n",dummy[i],res_dummy[i]);
    result = -1;
    }

/*  PSEND  PRECV  */

info = pvm_config(&nhost,&narch,&hostp);
if (info <0)
  {
  fprintf(outfile,"\tpvm_config() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
if (narch >1)
  {
  pvm_kill(tid);
  return result;
  }

info = pvm_psend(tid,TEST_VALUE,dummy,10,PVM_DOUBLE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_psend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[length-1]);
if (ack <0)
  {  
  fprintf(outfile,"\t( psend() - precv())\n");
  pvm_kill(tid);
  return -1;
  }
info = pvm_precv(tid,TEST_VALUE,res_dummy,10,PVM_DOUBLE,&atid,&atag,&alen);
if (info <0)
  {
  fprintf(outfile,"\tpvm_precv() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
for (i=0;i<10;i++)
  if (res_dummy[i]!=dummy[i])
    {
    fprintf(outfile,"\tValue #%d received different from value sent for host %s\n",
                    i,hostpool[array_of_index[length-1]]);
    fprintf(outfile,"\tSould be %f but is %f\n",dummy[i],res_dummy[i]);
    result = -1;
    }
if (atid!=tid)
  {
  fprintf(outfile,"\tpvm_precv() : Didn't determined the correct tid of source\n");
  result = -1;
  }
if (alen!=10*sizeof(double))
  {
  fprintf(outfile,"\tpvm_precv() : Didn't determined the correct length of message\n");
  result = -1;
  }
if (atag != TEST_VALUE)
  {
  fprintf(outfile,"\tpvm_precv() : Didn't determined the correct tag of message\n");
  result = -1;
  }
 
pvm_kill(tid);
return result;
}

void test33_slave()
{
double  message[10];
int  atid,atag,alen;  

pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_VALUE);
pvm_upkdouble(message,10,1);
pvm_initsend(PvmDataDefault);
pvm_pkdouble(message,10,1);
pvm_send(pvm_parent(),TEST_VALUE);
pvm_precv(pvm_parent(),TEST_VALUE,message,10,PVM_DOUBLE,&atid,&atag,&alen);
pvm_psend(pvm_parent(),TEST_VALUE,message,10,PVM_DOUBLE);
pvm_exit();
}

/************************/
/* pvm_setsbuf() */
/************************/
short test34(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  tid;
int  info;
int  result = 1;
int  bufid;
char  *args[2];
int  dummy=12;
int  res_dummy;
char  *test="34";

args[0]=test;
args[1]=NULL;

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]], tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info  = pvm_recv(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    pvm_kill(tid);
    continue;
    }
  bufid = pvm_mkbuf(PvmDataDefault);
  if (bufid<0)
    {
    fprintf(outfile,"\tpvm_mkbuf() : Failed with error %d\n",bufid);
    result =-1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_setsbuf(bufid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_setsbuf() : Failed with error %d\n",info);
    pvm_freebuf(bufid);
    result = -1;
    pvm_kill(tid);
    continue;
    }
  info = pvm_pkint(&dummy,1,1);
  if (info <0)
    {  
    fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
    pvm_freebuf(bufid);
    result = -1;
    pvm_kill(tid);
    continue;
           }
  info = pvm_send(tid,TEST_VALUE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    pvm_freebuf(bufid);
    pvm_kill(tid);
    result = -1;
    continue;
    }
  ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[i]);
  if (ack<0)
    {
    result = -1;
    pvm_freebuf(bufid);
    pvm_kill(tid);
    continue;
    }
  info = pvm_recv(tid,TEST_VALUE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
    result = -1;
    pvm_freebuf(bufid);
    pvm_kill(tid);
    continue;
    }
  info = pvm_upkint(&res_dummy,1,1);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_upkint() : Failed with error %d\n",info);
    result = -1;
    pvm_freebuf(bufid);
    pvm_kill(tid);
    continue;
    }
  if (res_dummy != dummy)
    {
    fprintf(outfile,"Value received different from value sent for host %s\n",
      hostpool[array_of_index[i]]);
    result = -1;
    }
  info = pvm_kill(tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result;
}

void test34_slave()
{
int  message;

pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_VALUE);
pvm_upkint(&message,1,1);
pvm_initsend(PvmDataDefault);
pvm_pkint(&message,1,1);
pvm_send(pvm_parent(),TEST_VALUE);
pvm_recv(-1,ENDLESS);
}


/************************/
/* pvm_setrbuf() */
/************************/
short test35(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  tid;
int  info;
int  result = 1;
int  bufid;
char  *args[2];
int  res_dummy;
char  *test="35";

args[0]=test;
args[1]=NULL;


for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info  = pvm_recv(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  bufid = pvm_mkbuf(PvmDataDefault);
  if (bufid<0)
    {
    fprintf(outfile,"\tpvm_mkbuf() : Failed with error %d\n",bufid);
    result =-1;
    continue;
    }
  info = pvm_setrbuf(bufid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_setsbuf() : Failed with error %d\n",info);
    pvm_freebuf(bufid);
    result = -1;
    continue;
    }
  ack = timeout_wait_message(tid,TEST_VALUE,array_of_index[i]);
  if (ack<0)
    {
    result = -1;
    pvm_freebuf(bufid);
    continue;
    }
  info = pvm_recv(tid,TEST_VALUE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed withe error %d\n",info);
    result = -1;
    pvm_freebuf(bufid);
    continue;
    }
  info = pvm_upkint(&res_dummy,1,1);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_upkint() : Failed with error %d\n",info);
    result = -1;
    pvm_freebuf(bufid);
    continue;
    }
  if (res_dummy != tid)
    {
    fprintf(outfile,"Value received different from value sent from host %s\n",
      hostpool[array_of_index[i]]);
    result = -1;
    }
  info = pvm_kill(tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result;
}

void test35_slave()
{
int  message;

pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_initsend(PvmDataDefault);
message = pvm_mytid();
pvm_pkint(&message,1,1);
pvm_send(pvm_parent(),TEST_VALUE);
pvm_recv(-1,ENDLESS);
}

/********** TEST 36 ********/
/* pvm_set?buf() incorrect*/
/************************/
short test36(array_of_index,length)
int  *array_of_index;
int  length;
{
int  bufid;
int  info;
int  result=1;


bufid = pvm_mkbuf(PvmDataDefault);
if (bufid <0)
  {
  fprintf(outfile,"\tpvm_mkbuf() : Failed with error %d\n",bufid);
  result = -1;
  }
info = pvm_freebuf(bufid);
if (info <0)
  {
  fprintf(outfile,"\tpvm_freebuf() : Failed with error %d\n",info);
  result = -1;
  }
info = pvm_setsbuf(bufid);
if (info != PvmNoSuchBuf)
  {
  fprintf(outfile,"\tpvm_setsbuf() : Should have returned %d but returned %d\n",
    PvmNoSuchBuf,info);
  result = -1;
  }
info = pvm_setrbuf(bufid);
if (info != PvmNoSuchBuf)    
  {
  fprintf(outfile,"\tpvm_setrbuf() : Should have returned %d but returned %d\n",
    PvmNoSuchBuf,info);
  result = -1;
  }


return result;
}

void test36_slave()
{}


/********** TEST 37 ********/
/* pvm_bcast() */
/************************/
short test37(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char  *group="testgr37";
char  *test="37";

args[0]=test;
args[1]=NULL;

info = pvm_bcast(group,TEST_CAST);
if (info != PvmNoGroup)
  {
  fprintf(outfile,
    "\tpvm_bcast() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  return -1;
  }
tid = (int *)malloc(length*sizeof(int));

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  }

if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
info = pvm_bcast(group,TEST_CAST);
if (info <0)
  {
  fprintf(outfile,"\tpvm_bcast() : Failed with error %d\n",info);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
for (i=0;i<length;i++)
  {
  ack= timeout_wait_message(tid[i],TEST_CAST,array_of_index[i]);
  if (ack <0)
    {
    result = -1;
    continue;
    }
  info =pvm_recv(tid[i],TEST_CAST);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    }
  }

return result; 
}

void test37_slave()
{
char  *group="testgr37";

pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_CAST);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),TEST_CAST);
pvm_lvgroup(group);
pvm_exit();
}


/********** TEST 38 ********/
/* pvm_barrier() */
/************************/
short test38(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char  *group="testgr38";
char  *test="38";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

info = pvm_joingroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",info);
  return -1;
  }

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_initsend(PvmDataDefault);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_pkint(&length,1,1);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid[i],TEST_BARRIER);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    result = -1;
    }
  }

if (result == -1)
  {
  pvm_lvgroup(group);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_barrier(group,length+1);
if (info <0)
  {
  fprintf(outfile,"\tpvm_bcast() : Failed with error %d\n",info);
  pvm_lvgroup(group);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
for (i=0;i<length;i++)
  {
  ack = timeout_wait_message(tid[i],TEST_BARRIER,array_of_index[i]);
  if (ack<0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],TEST_BARRIER);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[i]]);
    result = -1;
    continue;
    }
  ack = timeout_wait_kill(tid[i],array_of_index[i]);
  if (ack <0)
    result = -1;
  }

info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  result = -1;
  }
return result; 
}

void test38_slave()
{
int number;
char  *group="testgr38";

pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_BARRIER);
pvm_upkint(&number,1,1);
pvm_barrier(group,number+1);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),TEST_BARRIER);
pvm_lvgroup(group);
pvm_exit();
}



/********** TEST 39 ********/
/* pvm_reduce() */
/************************/
short test39(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char  *group="testgr39";
int  *data;
int  count = 10;
int  root;
char  *test="39";
int  op = (int)PvmSum;

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));
data = (int *)malloc(count*sizeof(int));
for (i=0;i<count;i++)
  data[i]=i;

pvm_setopt(PvmAutoErr,0);
info = pvm_reduce(op,data,count,PVM_INT,TEST_REDUCE,group,0);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_reduce() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  result = -1;
  }

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  }
if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
info = pvm_reduce(op,data,count,PVM_INT,TEST_REDUCE,group,0);
if (info != PvmNotInGroup)
  {
  fprintf(outfile,
    "\tpvm_reduce() : Should have returned %d but returned %d\n",
    PvmNotInGroup,info);
  result = -1;
  }

root = pvm_joingroup(group);
if (root <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",root);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
for (i=0;i<length;i++)
  {
  info = pvm_initsend(PvmDataDefault);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_pkint(&root,1,1);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid[i],TEST_REDUCE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    result = -1;
    }
  }


if (result == -1)
  {
  pvm_lvgroup(group);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_reduce(op,data,count,PVM_INT,TEST_REDUCE,group,root);
if (info <0)
  {
  fprintf(outfile,"\tpvm_reduce() : Failed with error %d\n",info);
  result = -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  ack = timeout_wait_kill(tid[i],array_of_index[i]);
  if (ack <0)
    result = -1;
  }

/*  Check result*/
for (i=0;i<count;i++)
  if (data[i]!=(length+1)*i)
    {
    fprintf(outfile,"\tpvm_reduce() : incorrect result of reduction at rank %d.\
      (should have been %d but is %d)\n",
      i,(length+1)*i,data[i]);
    result = -1;
    }
info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  result = -1;
  }
return result; 
}

void test39_slave()
{
char  *group="testgr39";
int  *data;
int   count = 10;
int  i;
int  root;
int  op = (int)PvmSum;

data = (int *)malloc(count*sizeof(int));
for (i=0;i<count;i++)
  data[i]=i;
pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_REDUCE);
pvm_upkint(&root,1,1);
pvm_reduce(op,data,count,PVM_INT,TEST_REDUCE,group,root);
pvm_recv(-1,ENDLESS);
}



/********** TEST 40 ********/
/* pvm_gather() */
/************************/
short test40(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i,j;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char  *group="testgr40";
int  *data;
int  *results;
int  count = 10;
int  root;
char  *test="40";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));
data = (int *)malloc(count*sizeof(int));
results = (int *)malloc(count*(length+1)*sizeof(int));

for (i=0;i<count;i++)
  data[i]=i;

info = pvm_gather(results,data,count,PVM_INT,TEST_GATHER,group,0);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_gather() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  result = -1;
  }

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  }

if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_gather(results,data,count,PVM_INT,TEST_GATHER,group,0);
if (info != PvmNotInGroup)
  {
  fprintf(outfile,"\tpvm_gather() : Should have returned %d but returned %d\n",
    PvmNotInGroup,info);
  result = -1;
  }


root = pvm_joingroup(group);
if (root <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",root);
  return -1;
  }
for (i=0;i<length;i++)
  {
  info = pvm_initsend(PvmDataDefault);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_pkint(&root,1,1);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid[i],TEST_GATHER);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    result = -1;
    }
  }

if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  pvm_lvgroup(group);
  return -1;
  }

info = pvm_gather(results,data,count,PVM_INT,TEST_GATHER,group,root);
if (info <0)
  {
  fprintf(outfile,"\tpvm_gather() : Failed with error %d\n",info);
  result = -1;
  }
for (i=0;i<length;i++)
  {
  info = pvm_kill(tid[i]);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_kill() : Failed with error %d\n",info);
    result = -1;
    }
  }

/*  Check result*/
for (i=0;i<(length+1);i++)
  for (j=0;j<count;j++)
    if (results[i*count+j]!=j)
      {
      fprintf(outfile,"\tpvm_gather() : Incoherent data (is %d should be %d)\n",
        results[i*count+j],j);
      result = -1;
      }  
info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  result = -1;
  }
return result; 
}

void test40_slave()
{
char  *group="testgr40";
int  *data;
int   count = 10;
int  i;
int  root;
int  result;

data = (int *)malloc(sizeof(int)*count);
for (i=0;i<count;i++)
  data[i]=i;
pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_GATHER);
pvm_upkint(&root,1,1);
pvm_gather(&result,data,count,PVM_INT,TEST_GATHER,group,root);
pvm_recv(-1,ENDLESS);
}




/********** TEST 41 ********/
/* pvm_scatter() */
/************************/
short test41(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i,j;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char  *group="testgr41";
int  *data;
int  *results;
int  count = 5;
int  root;
char  *test="41";

args[0]=test;
args[1]=NULL;


tid = (int *)malloc(length*sizeof(int));
results = (int *)malloc(count*sizeof(int));
data = (int *)malloc(count*(length+1)*sizeof(int));

for (i=0;i<(length+1);i++)
  for (j=0;j<count;j++)
    data[i*(count)+j]=j;

info = pvm_scatter(results,data,count,PVM_INT,TEST_SCATTER,group,0);
if (info != PvmNoGroup)
  {
  fprintf(outfile,"\tpvm_scatter() : Should have returned %d but returned %d\n",
    PvmNoGroup,info);
  result = -1;
  }

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  }

if (result == -1)
  {
  for(i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

info = pvm_scatter(results,data,count,PVM_INT,TEST_SCATTER,group,0);
if (info != PvmNotInGroup)
  {
  fprintf(outfile,"\tpvm_scatter() : Should have returned %d but returned %d\n",
    PvmNotInGroup,info);
  result = -1;
  }


root = pvm_joingroup(group);
if (root <0)
  {
  fprintf(outfile,"\tpvm_joingroup() : Failed with error %d\n",root);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_initsend(PvmDataDefault);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_pkint(&root,1,1);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid[i],TEST_SCATTER);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    result = -1;
    }
  }


if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  pvm_lvgroup(group);
  return -1;
  }

info = pvm_scatter(results,data,count,PVM_INT,TEST_SCATTER,group,root);
if (info <0)
  {
  fprintf(outfile,"\tpvm_scatter() : Failed with error %d\n",info);
  result = -1;
  }

for (i=0;i<length;i++)
  {
  info = pvm_initsend(PvmDataDefault);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid[i],TEST_SCATTER);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[i]]);
    result = -1;
    }
  }

/*  Check result*/
for (i=0;i<length;i++)
  {
  ack = timeout_wait_message(tid[i],TEST_SCATTER,array_of_index[i]);
  if (ack <0)
    {
    result = -1;
    continue;  
    }
  info = pvm_recv(tid[i],TEST_SCATTER);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed to receive from host %s with error %d\n",
      hostpool[array_of_index[i]],info);
    result = -1;
    continue;
    }
  info = pvm_upkint(results,count,1);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_upkint() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  for (j=0;j<count;j++)
    if (data[j]!=j)
      {
      fprintf(outfile,
      "\tpvm_scatter() : erroneous value scattered, should have been %d but is %d\n",
        j,data[j]);
      result = -1;
      }
  }
 

info = pvm_lvgroup(group);
if (info <0)
  {
  fprintf(outfile,"\tpvm_lvgroup() : Failed with error %d\n",info);
  result = -1;
  }
return result; 
}

void test41_slave()
{
char  *group="testgr41";
int  *data;
int   count = 5;
int  root;
int  result;

data = (int *)malloc(count*sizeof(int));
pvm_joingroup(group);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_SCATTER);
pvm_upkint(&root,1,1);
pvm_scatter(data,&result,count,PVM_INT,TEST_SCATTER,group,root);
pvm_recv(pvm_parent(),TEST_SCATTER);
pvm_initsend(PvmDataDefault);
pvm_pkint(data,count,1);
pvm_send(pvm_parent(),TEST_SCATTER);
pvm_lvgroup(group);
pvm_exit();
}



/************************/
/* pvm_mcast() */
/************************/
short test42(array_of_index,length)
int  *array_of_index;
int  length;
{

int  i;
int  ack;
int  *tid;
int  info;
int  result = 1;
char  *args[2];
char  *test="42";

args[0]=test;
args[1]=NULL;

tid = (int *)malloc(length*sizeof(int));

for(i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&(tid[i]));
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid[i]);
    continue;
    }
  /* Acknoledgement from slave */
  ack = timeout_wait_message(tid[i],ACKNOLEDGE,array_of_index[i]);
  if (ack < 0)
    {
    result = -1;
    continue;
    }
  info  = pvm_recv(tid[i],ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  }
if (result == -1)
  {
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_mcast(tid,length,TEST_MCAST);
if (info <0)
  {
  fprintf(outfile,"\tpvm_mcast() : Failed with error %d\n",info);
  for (i=0;i<length;i++)
    pvm_kill(tid[i]);
  return -1;
  }
for (i=0;i<length;i++)
  {
  ack = timeout_wait_message(tid[i],TEST_MCAST,array_of_index[i]);
  if (ack<0)
    result = -1;
  }

return result;
}

void test42_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),TEST_MCAST);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),TEST_MCAST);
pvm_exit();
}


/********** TEST 43 ********/
/* pvm_trecv() */
/************************/
short test43(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i;
int  info;
int  tid;
int  bufid;
int   result = 1;
char   *args[2];
char  *test="43";
struct  timeval timeout;

timeout.tv_sec = SEC_TRECV;
timeout.tv_usec = 0;
args[0]=test;
args[1]=NULL;

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else  
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  bufid = pvm_trecv(tid,ACKNOLEDGE,&timeout);
  if (bufid <0)
    {
    fprintf(outfile,"\tpvm_trecv() : Failed with error %d for host %s\n",
      bufid,hostpool[array_of_index[i]]);
    result = -1;
    continue;
    }
  if (bufid!=0)
    {
    fprintf(outfile,"\tpvm_trecv() : Should have returned 0 but returned %d\n",bufid);
    result = -1;
    }
  info = pvm_initsend(PvmDataDefault);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  bufid = pvm_trecv(tid,ACKNOLEDGE,&timeout);
  if (bufid <0)
    {
    fprintf(outfile,"\tpvm_trecv() : Failed with error %d for host %s\n",
      bufid,hostpool[array_of_index[i]]);
    result = -1;
    continue;
    }
  if (bufid == 0)
    {
    fprintf(outfile,"\tpvm_trecv() : Didn't received the message in time ?\n");
    }
  }

return result;
}

void test43_slave()
{
pvm_initsend(PvmDataDefault);
pvm_recv(pvm_parent(),ACKNOLEDGE);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_exit();
}


/********** TEST 44 ********/
/* pvm_nrecv() */
/************************/
short test44(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i,j;
int  info;
int  tid;
int  bufid;
int   result = 1;
char   *args[2];
char  *test="44";

args[0]=test;
args[1]=NULL;

for (i=0;i<length;i++)
  {
  info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[i]],1,&tid);
  if (info <1 )
    {
    result = -1;
    if (info == PvmSysErr)
      fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
    else  
      fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
        hostpool[array_of_index[i]],tid);
    continue;
    }
  /* Acknoledgement from slave */
  bufid = pvm_nrecv(tid,ACKNOLEDGE);
  if (bufid <0)
    {
    fprintf(outfile,"\tpvm_nrecv() : Failed with error %d for host %s\n",
      bufid,hostpool[array_of_index[i]]);
    result = -1;
    continue;
    }
  if (bufid!=0)
    {
    fprintf(outfile,"\tpvm_trecv() : Should have returned 0 but returned %d\n",bufid);
    result = -1;
    }
  info = pvm_initsend(PvmDataDefault);
  if (info<0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  info = pvm_send(tid,ACKNOLEDGE);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  for (j=0;j<SEC_NRECV;j++)
    {
    bufid = pvm_nrecv(tid,ACKNOLEDGE);
    if (bufid <0)
      {
      fprintf(outfile,"\tpvm_nrecv() : Failed with error %d for host %s\n",
        bufid,hostpool[array_of_index[i]]);
      result = -1;
      continue;
      }
    if (bufid > 0)
      break;
    sleep(1);
    }
  if (j==SEC_NRECV)
    fprintf(outfile,"\tpvm_nrecv() : Didn't receive the message in time ?\n");
  }

return result;
}

void test44_slave()
{
pvm_initsend(PvmDataDefault);
pvm_recv(pvm_parent(),ACKNOLEDGE);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_exit();
}


/********** TEST 45 ********/
/* Latency Bandwidth send_recv PvmDataDefault */
/************************/
short test45(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i,j,count;
int  ack;
int  info;
int  tid;
int   result = 1;
char   *args[2];
struct  timeval t1,t2;
double  Total_time=0;
double  Average_time;
double  Total_size;
double  Average_band;
int  data[3];
int  inbuf[MAX_MESSAGE_LENGTH];
int  outbuf[MAX_MESSAGE_LENGTH];
char  *test="45";


data[0]=max_size;
data[1]=start_size;
data[2]=incr;
args[0]=test;
args[1]=NULL;

fprintf(out45,"\n %s(%s)<--> %s(%s)\n",hostpool[0],hostarch[0],
  hostpool[array_of_index[length-1]],hostarch[array_of_index[length-1]]);
info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[length-1]],1,&tid);
if (info <1 )
  {
  if (info == PvmSysErr)
    fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
  else  
    fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
      hostpool[array_of_index[length-1]],tid);
  return -1;
  }
/* Acknoledgement from slave */
ack = timeout_wait_message(-1,-1,array_of_index[length-1]);
if (ack < 0)
  {
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
    hostpool[array_of_index[length-1]],info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_initsend(PvmDataDefault);
if (info<0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_pkint(data,3,1);
if (info <0)
  {
  fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_send(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }

/* Latency */
for (i=0;i<TRIALS;i++)
  {
  gettimeofday(&t1,NULL);
  if ((info = pvm_initsend(PvmDataDefault)) <0)
    {
    fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
    result = -1;
    continue;
    }
  if ((info=pvm_send(tid,LATENCY))<0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[length-1]]);
    result = -1;
    continue;
    }
  /****** Busy loop ? *****/
  for (count=0;count<BUSY_LOOP_PERF;count++)
    if (pvm_probe(tid,LATENCY)>0)
      break;
  if (count== BUSY_LOOP_PERF)
    {
    fprintf(outfile,"\tTimeout expired from host %s\n",
      hostpool[array_of_index[length-1]]);
    result = -1;
    continue;
    }
  if ((info = pvm_recv(tid,LATENCY))<0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[length-1]]);
    result = -1;
    continue;
    }
  gettimeofday(&t2,NULL);
  Total_time += TIME_ELAPSED;
  }
Average_time = ((double)Total_time / (double)TRIALS);
fprintf(out45,"Average Latency = %1.3f msec\n\n",1000*Average_time/2);
fprintf(out45,"Message Size(byte) | Bandwith (Mbyte/sec)\n\n");

/* Bandwidth */
info = pvm_setopt(PvmRoute,PvmAllowDirect);
if (info <0)
  {
  fprintf(outfile,"\tpvm_setopt() : Failed with error %d\n",info);
  result = -1;
  }
fprintf(out45,"Daemon routing\n");
for (i=start_size;i<max_size;i+=incr)
  {
  Total_time = 0;
  for (j=0;j<TRIALS;j++)
    {
    gettimeofday(&t1,NULL);
    if ((info = pvm_initsend(PvmDataDefault)) <0)
      {
      fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
      result = -1;
      continue;
      }
    if ((info = pvm_pkint(outbuf,i,1))<0)
      {
      fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
      result = -1;
      continue;
      }
    if ((info=pvm_send(tid,BANDWIDTH))<0)
      {
      fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    /****** Busy loop ? *****/
    for (count=0;count<BUSY_LOOP_PERF;count++)
      if (pvm_probe(tid,BANDWIDTH)>0)
        break;
    if (count== BUSY_LOOP_PERF)
      {
      fprintf(outfile,"\tTimeout expired from host %s\n",
        hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    if ((info = pvm_recv(tid,BANDWIDTH))<0)
      {
      fprintf(outfile,"\tpvm_recv() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    if ((info = pvm_upkint(inbuf,i,1))<0)
      {
      fprintf(outfile,"\tpvm_upkint() : Failed with error %d\n",info);
      result = -1;
      continue;
      }
    gettimeofday(&t2,NULL);
    Total_time += TIME_ELAPSED;
    }
  Total_size   = (double)(sizeof(int)*i*TRIALS*2)/(1024.*1024.);
  Average_band = Total_size/Total_time;
  fprintf(out45,"%d\t| %1.3f\n",i*sizeof(int),Average_band);
  }
fprintf(out45,"\n");
info = pvm_setopt(PvmRoute,PvmRouteDirect);
if (info <0)
  {
  fprintf(outfile,"\tpvm_setopt() : Failed with error %d\n",info);
  result = -1;
  }
fprintf(out45,"Direct routing\n");
for (i=start_size;i<max_size;i+=incr)
  {
  Total_time = 0;
  for (j=0;j<TRIALS;j++)
    {
    gettimeofday(&t1,NULL);
    if ((info = pvm_initsend(PvmDataDefault)) <0)
      {
      fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
      result = -1;
      continue;
      }
    if ((info = pvm_pkint(outbuf,i,1))<0)
      {
      fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
      result = -1;
      continue;
      }
    if ((info=pvm_send(tid,BANDWIDTH))<0)
      {
      fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    /****** Busy loop ? *****/
    for (count=0;count<BUSY_LOOP_PERF;count++)
      if (pvm_probe(tid,BANDWIDTH)>0)
        break;
    if (count== BUSY_LOOP_PERF)
      {
      fprintf(outfile,"\tTimeout expired from host %s\n",
        hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    if ((info = pvm_recv(tid,BANDWIDTH))<0)
      {
      fprintf(outfile,"\tpvm_recv() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    if ((info = pvm_upkint(inbuf,i,1))<0)
      {
      fprintf(outfile,"\tpvm_upkint() : Failed with error %d\n",info);
      result = -1;
      continue;
      }
    gettimeofday(&t2,NULL);
    Total_time += TIME_ELAPSED;
    }
  Total_size   = (double)(sizeof(int)*i*TRIALS*2)/(1024.*1024.);
  Average_band = Total_size/Total_time;
  fprintf(out45,"%d\t | %1.3f\n",i*sizeof(int),Average_band);
  }
fprintf(out45,"\n");
info =pvm_setopt(PvmRoute,PvmAllowDirect);
if (info<0)
  {
  fprintf(outfile,"\tpvm_setopt() : Failed with error %d\n",info);
  result = -1;
  }

pvm_kill(tid);
return result;
}

void test45_slave()
{
int i,j;
int  inbuf[MAX_MESSAGE_LENGTH];
int  outbuf[MAX_MESSAGE_LENGTH];
int  data[3];  

pvm_setopt(PvmRoute,PvmAllowDirect);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),ACKNOLEDGE);
pvm_upkint(data,3,1);
for (i=0;i<TRIALS;i++)
  {
  pvm_recv(pvm_parent(),LATENCY);
  pvm_initsend(PvmDataDefault);
  pvm_send(pvm_parent(),LATENCY);
  }
for (i=data[1];i<data[0];i+=data[2])
  for (j=0;j<TRIALS;j++)
    {
    pvm_recv(pvm_parent(),BANDWIDTH);
    pvm_upkint(inbuf,i,1);
    pvm_initsend(PvmDataDefault);
    pvm_pkint(outbuf,i,1);
    pvm_send(pvm_parent(),BANDWIDTH);
    }
pvm_setopt(PvmRoute,PvmRouteDirect);
for (i=data[1];i<data[0];i+=data[2])
  for (j=0;j<TRIALS;j++)
    {
    pvm_recv(pvm_parent(),BANDWIDTH);
    pvm_upkint(inbuf,i,1);
    pvm_initsend(PvmDataDefault);
    pvm_pkint(outbuf,i,1);
    pvm_send(pvm_parent(),BANDWIDTH);
    }

pvm_exit();
}


/********** TEST 46 ********/
/* Latency Bandwidth psend_precv PvmDataDefault */
/************************/
short test46(array_of_index,length)
int  *array_of_index;
int  length;
{
int   i,j,count;
int  ack;
int  info;
int  tid;
int   result = 1;
char   *args[2];
struct  timeval t1,t2;
double  Total_time=0;
double  Average_time;
double  Total_size;
double  Average_band;
int  inbuf[MAX_MESSAGE_LENGTH];
int  outbuf[MAX_MESSAGE_LENGTH];
int  narch;
int  data[3];
int     atid,atag,alen;
int  nhost;
struct  pvmhostinfo *hostp;
char  *test="46";


data[0]=max_size;
data[1]=start_size;
data[2]=incr;
args[0]=test;
args[1]=NULL;

info = pvm_config(&nhost,&narch,&hostp);
if (info <0)
  {
  fprintf(outfile,"\tpvm_config() : Failed with error %d\n",info);
  return -1;
  }
if (narch >1)
  return NOT_POSSIBLE;

fprintf(out46,"\n %s(%s)<--> %s(%s)\n",hostpool[0],hostarch[0],
  hostpool[array_of_index[length-1]],hostarch[array_of_index[length-1]]);
info = pvm_spawn(TEST_SLAVE,args,
    PvmTaskHost,hostpool[array_of_index[length-1]],1,&tid);
if (info <1 )
  {
  if (info == PvmSysErr)
    fprintf(outfile,"\tpvm_spawn() : Unable to contact local pvmd\n");
  else  
    fprintf(outfile,"\tpvm_spawn() : Failed on host %s with error %d\n",
      hostpool[array_of_index[length-1]],tid);
  return -1;
  }

info = pvm_initsend(PvmDataDefault);
if(info<0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_pkint(data,3,1);
if (info<0)
  {
  fprintf(outfile,"\tpvm_pkint() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
info = pvm_send(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  pvm_kill(tid);
  return -1;
  }
/* Acknoledgement from slave */
ack = timeout_wait_message(tid,ACKNOLEDGE,array_of_index[length-1]);   
if (ack < 0)
  {
  pvm_kill(tid);
  return -1;
  }
info = pvm_recv(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_recv() : Failed of host %s with error %d\n",
    hostpool[array_of_index[length-1]],info);
  pvm_kill(tid);
  return -1;
  }

/*   Latency  */
Total_time = 0;
for (j=0;j<TRIALS;j++)
  {
  gettimeofday(&t1,NULL);
  if ((info=pvm_psend(tid,LATENCY,outbuf,0,PVM_INT))<0)
    {
    fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[length-1]]);
    result = -1;
    continue;
    }
    /****** Busy loop ? *****/
    for (count=0;count<BUSY_LOOP_PERF;count++)
      if (pvm_probe(tid,LATENCY)>0)
        break;
    if (count== BUSY_LOOP_PERF)
      {
      fprintf(outfile,"\tTimeout expired from host %s\n",
        hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }

  if ((info = pvm_precv(-1,LATENCY,inbuf,0,PVM_INT,&atid,&atag,&alen))<0)
    {
    fprintf(outfile,"\tpvm_precv() : Failed with error %d for host %s\n",
      info,hostpool[array_of_index[length-1]]);
    result = -1;
    continue;
    }
  gettimeofday(&t2,NULL);
  Total_time += TIME_ELAPSED;
  }
Average_time = ((double)Total_time / (double)TRIALS);
fprintf(out46,"Average Latency = %1.3f msec\n\n",1000*Average_time/2);
fprintf(out46,"Message Size(byte) | Bandwith (Mbyte/sec)\n\n");

/* Bandwidth */
info = pvm_setopt(PvmRoute,PvmAllowDirect);
if (info <0)
  {
  fprintf(outfile,"\tpvm_setopt() : Failed with error %d\n",info);
  result = -1;
  }
fprintf(out46,"Daemon routing\n");
for (i=start_size;i<max_size;i+=incr)
  {
  Total_time = 0;
  for (j=0;j<TRIALS;j++)
    {
    gettimeofday(&t1,NULL);
    if ((info=pvm_psend(tid,BANDWIDTH,outbuf,i,PVM_INT))<0)
      {
      fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    /****** Busy loop ? *****/
    for (count=0;count<BUSY_LOOP_PERF;count++)
      if (pvm_probe(tid,BANDWIDTH)>0)
        break;
    if (count== BUSY_LOOP_PERF)
      {
      fprintf(outfile,"\tTimeout expired from host %s\n",
        hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }

    if ((info = pvm_precv(-1,BANDWIDTH,inbuf,i,PVM_INT,&atid,&atag,&alen))<0)
      {
      fprintf(outfile,"\tpvm_precv() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    gettimeofday(&t2,NULL);
    Total_time += TIME_ELAPSED;
    }
  Total_size   = (double)(sizeof(int)*i*TRIALS*2)/(1024.*1024.);
  Average_band = Total_size/Total_time;
  fprintf(out46,"%d\t| %1.3f\n",i*sizeof(int),Average_band);
  }

fprintf(out46,"\n");
info = pvm_setopt(PvmRoute,PvmRouteDirect);
if (info <0)
  {
  fprintf(outfile,"\tpvm_setopt() : Failed with error %d\n",info);
  result = -1;
  }
fprintf(out46,"Direct routing\n");
for (i=start_size;i<max_size;i+=incr)
  {
  Total_time = 0;
  for (j=0;j<TRIALS;j++)
    {
    gettimeofday(&t1,NULL);
    if ((info=pvm_psend(tid,BANDWIDTH,outbuf,i,PVM_INT))<0)
      {
      fprintf(outfile,"\tpvm_send() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    for (count=0;count<BUSY_LOOP_PERF;count++)
      if (pvm_probe(tid,BANDWIDTH)>0)
        break;
    if (count== BUSY_LOOP_PERF)
      {
      fprintf(outfile,"\tTimeout expired from host %s\n",
        hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }

    if ((info = pvm_precv(-1,BANDWIDTH,inbuf,i,PVM_INT,&atid,&atag,&alen))<0)
      {
      fprintf(outfile,"\tpvm_recv() : Failed with error %d for host %s\n",
        info,hostpool[array_of_index[length-1]]);
      result = -1;
      continue;
      }
    gettimeofday(&t2,NULL);
    Total_time += TIME_ELAPSED;
    }
  Total_size   = (double)(sizeof(int)*i*TRIALS*2)/(1024.*1024.);
  Average_band = Total_size/Total_time;
  fprintf(out46,"%d\t| %1.3f\n",i*sizeof(int),Average_band);
  }

fprintf(out46,"\n");
info = pvm_setopt(PvmRoute,PvmAllowDirect);
if (info <0)
  {
  fprintf(outfile,"\tpvm_setopt() : Failed with error %d\n",info);
  result = -1;
  }
pvm_kill(tid);
return result;
}

void test46_slave()
{
int i,j;
int  inbuf[MAX_MESSAGE_LENGTH];
int  outbuf[MAX_MESSAGE_LENGTH];
int  data[3];
int   atid,atag,alen;

pvm_setopt(PvmRoute,PvmAllowDirect);
pvm_recv(pvm_parent(),ACKNOLEDGE);
pvm_upkint(data,3,1);
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
for (j=0;j<TRIALS;j++)
  {
  pvm_precv(-1,LATENCY,inbuf,0,PVM_INT,&atid,&atag,&alen);
  pvm_psend(pvm_parent(),LATENCY,outbuf,0,PVM_INT);
  }
for (i=data[1];i<data[0];i+=data[2])
  for (j=0;j<TRIALS;j++)
    {
    pvm_precv(-1,BANDWIDTH,inbuf,i,PVM_INT,&atid,&atag,&alen);
    pvm_psend(pvm_parent(),BANDWIDTH,outbuf,i,PVM_INT);
    }
pvm_setopt(PvmRoute,PvmRouteDirect);
for (i=data[1];i<data[0];i+=data[2])
  for (j=0;j<TRIALS;j++)
    {
    pvm_precv(-1,BANDWIDTH,inbuf,i,PVM_INT,&atid,&atag,&alen);
    pvm_psend(pvm_parent(),BANDWIDTH,outbuf,i,PVM_INT);
    }
pvm_exit();
}


/********** TEST 47 ********/
/* pvm_notify() */
/************************/

short test47(array_of_index,length)
int     *array_of_index;
int     length;
{
int     ack;
int     info;
int     tid;
char    *args[2];
struct  pvmhostinfo *hostp;
int     host_tid;
int     infos;
int     tids;
int     narch;
int     nhost; 
char    *test="47";

args[0]=test;
args[1]=NULL;

if (hostpool[1]!=NULL)
  {
  /* We can do the add/del test */
  info = pvm_notify(PvmHostAdd,NOTIFY,1,&tids);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_notify() : Failed with error %d\n",info);
    return -1;
    }
  info = pvm_addhosts(hostpool+1,1,&infos);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_addhosts() : Failed with error %d for host %s\n",
      info,hostpool[0]);
    return -1;
    }
  ack = timeout_wait_message(-1,NOTIFY,-1);
  if (ack <0)
    {
    fprintf(outfile,"\t Didn't receive the notification in time for host add\n");
    return -1;
    }
  info = pvm_recv(-1,NOTIFY);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_recv() : Failed with error %d\n",info);
    return -1;
    }
  info = pvm_config(&nhost,&narch,&hostp);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_config() : Failed with error %d\n",info);
    return -1;
    }
  host_tid = (hostp[1]).hi_tid;
  info = pvm_notify(PvmHostDelete,NOTIFY,1,&host_tid);
  if (info <0)
    {
    fprintf(outfile,"\tpvm_notify() : Failed with error %d\n",info);
    return -1;
    }
  info = pvm_delhosts(hostpool+1,1,&infos);
  if (info <0)
    {
    fprintf(outfile,
      "\tpvm_delhosts() : Failed with error %d for host %s\n",
      infos,hostpool[0]);
    return -1;
    }
  ack = timeout_wait_message(-1,NOTIFY,-1);
  if (ack <0)
    {
    fprintf(outfile,"\t Didn't receive the notification in time for host deletion\n");
    return -1;
    }
  }
info = pvm_spawn(TEST_SLAVE,args,PvmTaskDefault,"",1,&tid);
if (info <1)
  {
  fprintf(outfile,"\tpvm_spawn() : Failed with error %d\n",tid);
  return -1;
  }
info = pvm_notify(PvmTaskExit,NOTIFY,1,&tid);
if (info <0)
  {
  fprintf(outfile,"\tpvm_notify() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_initsend(PvmDataDefault);
if (info <0)
  {
  fprintf(outfile,"\tpvm_initsend() : Failed with error %d\n",info);
  return -1;
  }
info = pvm_send(tid,ACKNOLEDGE);
if (info <0)
  {
  fprintf(outfile,"\tpvm_send() : Failed with error %d\n",info);
  return -1;
  }
ack = timeout_wait_message(-1,NOTIFY,-1);
if (ack <0)
  {
  fprintf(outfile,"\t Didn't received the notification in time\n");
  return -1;
  }
return 1;
}


void test47_slave()
{
pvm_initsend(PvmDataDefault);
pvm_send(pvm_parent(),ACKNOLEDGE);
pvm_recv(pvm_parent(),ACKNOLEDGE);
pvm_exit();
}






/********** TEST 48 ********/
/* Empty Send PvmAllowDirect PvmDataDefault*/
/************************/
short test48(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="48";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,SEND,PvmAllowDirect,PvmDataDefault));
}
void test48_slave()
{head_head_slave(EMPTY,SEND,PvmAllowDirect,PvmDataDefault);}


/********** TEST 49 ********/
/* Empty Send PvmAllowDirect PvmDataRaw*/
/************************/
short test49(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="49";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,SEND,
  PvmAllowDirect,PvmDataRaw));
}
void test49_slave()
{head_head_slave(EMPTY,SEND,PvmAllowDirect,PvmDataRaw);}

/********** TEST 50 ********/
/* Empty Send PvmAllowDirect PvmDataInPlace*/
/************************/
short test50(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="50";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,SEND,
  PvmAllowDirect,PvmDataInPlace));
}
void test50_slave()
{head_head_slave(EMPTY,SEND,PvmAllowDirect,PvmDataInPlace);}


/********** TEST 51 ********/
/* Empty Send PvmRouteDirect PvmDataDefault*/
/************************/
short test51(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="51";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,SEND,
  PvmRouteDirect,PvmDataDefault));
}
void test51_slave()
{head_head_slave(EMPTY,SEND,PvmRouteDirect,PvmDataDefault);}


/********** TEST 52 ********/
/* Empty Send PvmRouteDirect PvmDataRaw*/
/************************/
short test52(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="52";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,SEND,
  PvmRouteDirect,PvmDataRaw));
}
void test52_slave()
{head_head_slave(EMPTY,SEND,PvmRouteDirect,PvmDataRaw);}

/********** TEST 53 ********/
/* Empty Send PvmRouteDirect PvmDataInPlace*/
/************************/
short test53(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="53";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,SEND,
  PvmRouteDirect,PvmDataInPlace));
}
void test53_slave()
{head_head_slave(EMPTY,SEND,PvmRouteDirect,PvmDataInPlace);}

/********** TEST 54 ********/
/* Empty PSend PvmAllowDirect */
/************************/
short test54(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="54";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,PSEND,
  PvmAllowDirect,0));
}
void test54_slave()
{head_head_slave(EMPTY,PSEND,PvmAllowDirect,0);}

/********** TEST 55 ********/
/* Empty PSend PvmRouteDirect */
/************************/
short test55(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="55";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],EMPTY,PSEND,
  PvmRouteDirect,0));
}
void test55_slave()
{head_head_slave(EMPTY,PSEND,PvmRouteDirect,0);}


/********** TEST 56 ********/
/* NOT_Empty Send PvmAllowDirect PvmDataDefault*/
/************************/
short test56(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="56";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataDefault));
}
void test56_slave()
{head_head_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataDefault);}


/********** TEST 57 ********/
/* NOT_Empty Send PvmAllowDirect PvmDataRaw*/
/************************/
short test57(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="57";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataRaw));
}
void test57_slave()
{head_head_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataRaw);}

/********** TEST 58 ********/
/* Empty Send PvmAllowDirect PvmDataInPlace*/
/************************/
short test58(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="58";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataInPlace));
}
void test58_slave()
{head_head_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataInPlace);}


/********** TEST 59 ********/
/* NOT_Empty Send PvmRouteDirect PvmDataDefault*/
/************************/
short test59(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="59";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataDefault));
}
void test59_slave()
{head_head_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataDefault);}


/********** TEST 60 ********/
/* NOT_Empty Send PvmRouteDirect PvmDataRaw*/
/************************/
short test60(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="60";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataRaw));
}
void test60_slave()
{head_head_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataRaw);}

/********** TEST 61 ********/
/* NOT_Empty Send PvmRouteDirect PvmDataInPlace*/
/************************/
short test61(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="61";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataInPlace));
}
void test61_slave()
{head_head_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataInPlace);}

/********** TEST 62 ********/
/* NOT_Empty PSend PvmAllowDirect */
/************************/
short test62(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="62";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,PSEND,
  PvmAllowDirect,0));
}
void test62_slave()
{head_head_slave(NOT_EMPTY,PSEND,PvmAllowDirect,0);}

/********** TEST 63 ********/
/* NOT_Empty PSend PvmRouteDirect */
/************************/
short test63(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
char  *test="63";

args[0]=test;
args[1]=NULL;
return (head_head(args,array_of_index[length-1],NOT_EMPTY,PSEND,
  PvmRouteDirect,0));
}
void test63_slave()
{head_head_slave(NOT_EMPTY,PSEND,PvmRouteDirect,0);}

/********** TEST 64 ********/
/* T Empty Send PvmAllowDirect Default */
/************************/
short test64(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int  a,b;
char  *test="64";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }
return (triangle(args,a,b,EMPTY,SEND,
  PvmAllowDirect,PvmDataDefault));
}
void test64_slave()
{triangle_slave(EMPTY,SEND,PvmAllowDirect,PvmDataDefault);}

/********** TEST 65 ********/
/* T Empty Send PvmAllowDirect Raw */
/************************/
short test65(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int  a,b;
char  *test="65";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,EMPTY,SEND,
  PvmAllowDirect,PvmDataRaw));
}
void test65_slave()
{triangle_slave(EMPTY,SEND,PvmAllowDirect,PvmDataRaw);}

/********** TEST 66 ********/
/* T Empty Send PvmAllowDirect InPlace */
/************************/
short test66(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="66";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,EMPTY,SEND,
  PvmAllowDirect,PvmDataInPlace));
}
void test66_slave()
{triangle_slave(EMPTY,SEND,PvmAllowDirect,PvmDataInPlace);}

/********** TEST 67 ********/
/* T Empty Send PvmRouteDirect Default */
/************************/
short test67(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="67";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,EMPTY,SEND,
  PvmRouteDirect,PvmDataDefault));
}
void test67_slave()
{triangle_slave(EMPTY,SEND,PvmRouteDirect,PvmDataDefault);}

/********** TEST 68 ********/
/* T Empty Send PvmRouteDirect Raw */
/************************/
short test68(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="68";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,EMPTY,SEND,
  PvmRouteDirect,PvmDataRaw));
}
void test68_slave()
{triangle_slave(EMPTY,SEND,PvmRouteDirect,PvmDataRaw);}

/********** TEST 69 ********/
/* T Empty Send PvmRouteDirect InPlace */
/************************/
short test69(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="69";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }
return (triangle(args,a,b,EMPTY,SEND,
  PvmRouteDirect,PvmDataInPlace));
}
void test69_slave()
{triangle_slave(EMPTY,SEND,PvmRouteDirect,PvmDataInPlace);}

/********** TEST 70 ********/
/* T Empty PSend PvmAllowDirect */
/************************/
short test70(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="70";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,EMPTY,PSEND,
  PvmAllowDirect,0));
}
void test70_slave()
{triangle_slave(EMPTY,PSEND,PvmAllowDirect,0);}

/********** TEST 71 ********/
/* T Empty PSend PvmRouteDirect */
/************************/
short test71(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="71";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,EMPTY,PSEND,
  PvmRouteDirect,0));
}
void test71_slave()
{triangle_slave(EMPTY,PSEND,PvmRouteDirect,0);}


/********** TEST 72 ********/
/* T NEmpty Send PvmAllowDirect Default */
/************************/
short test72(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="72";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }
return (triangle(args,a,b,NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataDefault));
}
void test72_slave()
{triangle_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataDefault);}

/********** TEST 73 ********/
/* T NEmpty Send PvmAllowDirect Raw */
/************************/
short test73(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="73";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataRaw));
}
void test73_slave()
{triangle_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataRaw);}

/********** TEST 74 ********/
/* T NEmpty Send PvmAllowDirect InPlace */
/************************/
short test74(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="74";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataInPlace));
}
void test74_slave()
{triangle_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataInPlace);}

/********** TEST 75 ********/
/* T NEmpty Send PvmRouteDirect Default */
/************************/
short test75(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="75";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataDefault));
}
void test75_slave()
{triangle_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataDefault);}

/********** TEST 76 ********/
/* T NEmpty Send PvmRouteDirect Raw */
/************************/
short test76(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="76";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataRaw));
}
void test76_slave()
{triangle_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataRaw);}

/********** TEST 77 ********/
/* T NEmpty Send PvmRouteDirect InPlace */
/************************/
short test77(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="77";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataInPlace));
}
void test77_slave()
{triangle_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataInPlace);}

/********** TEST 78 ********/
/* T NEmpty PSend PvmAllowDirect */
/************************/
short test78(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="78";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,PSEND,
  PvmAllowDirect,0));
}
void test78_slave()
{triangle_slave(NOT_EMPTY,PSEND,PvmAllowDirect,0);}

/********** TEST 79 ********/
/* T NEmpty PSend PvmRouteDirect */
/************************/
short test79(array_of_index,length)
int  *array_of_index;
int  length;
{
char  *args[2];
int     a,b;
char  *test="79";

args[0]=test;
args[1]=NULL;
if (length == 1)
  {
  a = array_of_index[length-1];
  b = a;
  }
else
  {       
  a=array_of_index[length-2];
  b=array_of_index[length-1];
  }

return (triangle(args,a,b,NOT_EMPTY,PSEND,
  PvmRouteDirect,0));
}
void test79_slave()
{triangle_slave(NOT_EMPTY,PSEND,PvmRouteDirect,0);}

/********** TEST 80 ********/
/* F Empty Send PvmAllowDirect PvmDataDefault*/
/************************/
short test80(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="80";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,SEND,
  PvmAllowDirect,PvmDataDefault));
}
void test80_slave()
{funneling_slave(EMPTY,SEND,PvmAllowDirect,PvmDataDefault);}

/********** TEST 80 ********/
/* F Empty Send PvmAllowDirect PvmRawDefault*/
/************************/
short test81(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="81";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,SEND,
  PvmAllowDirect,PvmDataRaw));
}
void test81_slave()
{funneling_slave(EMPTY,SEND,PvmAllowDirect,PvmDataRaw);}

/********** TEST 82 ********/
/* F Empty Send PvmAllowDirect PvmDataInPlace*/
/************************/
short test82(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="82";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,SEND,
  PvmAllowDirect,PvmDataInPlace));
}
void test82_slave()
{funneling_slave(EMPTY,SEND,PvmAllowDirect,PvmDataInPlace);}

/********** TEST 83 ********/
/* F Empty Send PvmRouteDirect PvmDataDefault*/
/************************/
short test83(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="83";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,SEND,
  PvmRouteDirect,PvmDataDefault));
}
void test83_slave()
{funneling_slave(EMPTY,SEND,PvmRouteDirect,PvmDataDefault);}

/********** TEST 84*******/
/* F Empty Send PvmRouteDirect PvmRawDefault*/
/************************/
short test84(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="84";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,SEND,
  PvmRouteDirect,PvmDataRaw));
}
void test84_slave()
{funneling_slave(EMPTY,SEND,PvmRouteDirect,PvmDataRaw);}

/********** TEST 85 ********/
/* F Empty Send PvmRouteDirect PvmDataInPlace*/
/************************/
short test85(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="85";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,SEND,
  PvmRouteDirect,PvmDataInPlace));
}
void test85_slave()
{funneling_slave(EMPTY,SEND,PvmRouteDirect,PvmDataInPlace);}


/********** TEST 86 ********/
/* F Empty Cast PvmAllowDirect PvmDataDefault*/
/************************/
short test86(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="86";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,MCAST,
  PvmAllowDirect,PvmDataDefault));
}
void test86_slave()
{funneling_slave(EMPTY,MCAST,PvmAllowDirect,PvmDataDefault);}

/********** TEST 87 ********/
/* F Empty Cast PvmAllowDirect PvmRawDefault*/
/************************/
short test87(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="87";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,MCAST,
  PvmAllowDirect,PvmDataRaw));
}
void test87_slave()
{funneling_slave(EMPTY,MCAST,PvmAllowDirect,PvmDataRaw);}

/********** TEST 88 ********/
/* F Empty Cast PvmAllowDirect PvmDataInPlace*/
/************************/
short test88(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="88";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,MCAST,
  PvmAllowDirect,PvmDataInPlace));
}
void test88_slave()
{funneling_slave(EMPTY,MCAST,PvmAllowDirect,PvmDataInPlace);}

/********** TEST 89 ********/
/* F Empty Cast PvmRouteDirect PvmDataDefault*/
/************************/
short test89(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="89";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,MCAST,
  PvmRouteDirect,PvmDataDefault));
}
void test89_slave()
{funneling_slave(EMPTY,MCAST,PvmRouteDirect,PvmDataDefault);}

/********** TEST 90*******/
/* F Empty Cast PvmRouteDirect PvmRawDefault*/
/************************/
short test90(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="90";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,MCAST,
  PvmRouteDirect,PvmDataRaw));
}
void test90_slave()
{funneling_slave(EMPTY,MCAST,PvmRouteDirect,PvmDataRaw);}

/********** TEST 91 ********/
/* F Empty Cast PvmRouteDirect PvmDataInPlace*/
/************************/
short test91(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="91";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,MCAST,
  PvmRouteDirect,PvmDataInPlace));
}
void test91_slave()
{funneling_slave(EMPTY,MCAST,PvmRouteDirect,PvmDataInPlace);}

/********** TEST 92*******/
/* F Empty Psend PvmAllowDirect*/
/************************/
short test92(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="92";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,PSEND,
  PvmAllowDirect,0));
}
void test92_slave()
{funneling_slave(EMPTY,PSEND,PvmAllowDirect,0);}

/********** TEST 93 ********/
/* F Empty Psend PvmRouteDirect*/
/************************/
short test93(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="93";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,EMPTY,PSEND,
  PvmRouteDirect,0));
}
void test93_slave()
{funneling_slave(EMPTY,PSEND,PvmRouteDirect,0);}


/********** TEST 94 ********/
/* F Nempty Send PvmAllowDirect PvmDataDefault*/
/************************/
short test94(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="94";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataDefault));
}
void test94_slave()
{funneling_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataDefault);}

/********** TEST 95 ********/
/* F Nempty Send PvmAllowDirect PvmRawDefault*/
/************************/
short test95(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="95";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataRaw));
}
void test95_slave()
{funneling_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataRaw);}

/********** TEST 96 ********/
/* F Nempty Send PvmAllowDirect PvmDataInPlace*/
/************************/
short test96(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="96";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,SEND,
  PvmAllowDirect,PvmDataInPlace));
}
void test96_slave()
{funneling_slave(NOT_EMPTY,SEND,PvmAllowDirect,PvmDataInPlace);}

/********** TEST 97 ********/
/* F Nempty Send PvmRouteDirect PvmDataDefault*/
/************************/
short test97(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="97";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataDefault));
}
void test97_slave()
{funneling_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataDefault);}

/********** TEST 98*******/
/* F Nempty Send PvmRouteDirect PvmRawDefault*/
/************************/
short test98(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="98";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataRaw));
}
void test98_slave()
{funneling_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataRaw);}

/********** TEST 99 ********/
/* F Nempty Send PvmRouteDirect PvmDataInPlace*/
/************************/
short test99(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="99";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,SEND,
  PvmRouteDirect,PvmDataInPlace));
}
void test99_slave()
{funneling_slave(NOT_EMPTY,SEND,PvmRouteDirect,PvmDataInPlace);}


/********** TEST 100 ********/
/* F Nempty Cast PvmAllowDirect PvmDataDefault*/
/************************/
short test100(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="100";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,MCAST,
  PvmAllowDirect,PvmDataDefault));
}
void test100_slave()
{funneling_slave(NOT_EMPTY,MCAST,PvmAllowDirect,PvmDataDefault);}

/********** TEST 101 ********/
/* F Nempty Cast PvmAllowDirect PvmRawDefault*/
/************************/
short test101(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="101";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,MCAST,
  PvmAllowDirect,PvmDataRaw));
}
void test101_slave()
{funneling_slave(NOT_EMPTY,MCAST,PvmAllowDirect,PvmDataRaw);}

/********** TEST 102 ********/
/* F Nempty Cast PvmAllowDirect PvmDataInPlace*/
/************************/
short test102(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="102";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,MCAST,
  PvmAllowDirect,PvmDataInPlace));
}
void test102_slave()
{funneling_slave(NOT_EMPTY,MCAST,PvmAllowDirect,PvmDataInPlace);}

/********** TEST 103 ********/
/* F Nempty Cast PvmRouteDirect PvmDataDefault*/
/************************/
short test103(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="103";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,MCAST,
  PvmRouteDirect,PvmDataDefault));
}
void test103_slave()
{funneling_slave(NOT_EMPTY,MCAST,PvmRouteDirect,PvmDataDefault);}

/********** TEST 104*******/
/* F Nempty Cast PvmRouteDirect PvmRawDefault*/
/************************/
short test104(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="104";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,MCAST,
  PvmRouteDirect,PvmDataRaw));
}
void test104_slave()
{funneling_slave(NOT_EMPTY,MCAST,PvmRouteDirect,PvmDataRaw);}

/********** TEST 105 ********/
/* F Nempty Cast PvmRouteDirect PvmDataInPlace*/
/************************/
short test105(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="105";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,MCAST,
  PvmRouteDirect,PvmDataInPlace));
}
void test105_slave()
{funneling_slave(NOT_EMPTY,MCAST,PvmRouteDirect,PvmDataInPlace);}

/********** TEST 106*******/
/* F Nempty Psend PvmAllowDirect*/
/************************/
short test106(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="106";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,PSEND,
  PvmAllowDirect,0));
}
void test106_slave()
{funneling_slave(NOT_EMPTY,PSEND,PvmAllowDirect,0);}

/********** TEST 107 ********/
/* F Nempty Psend PvmRouteDirect*/
/************************/
short test107(array_of_index,length)
int     *array_of_index;
int     length;
{
char    *args[2];
char  *test="107";

args[0]=test;
args[1]=NULL;
return (funneling(args,array_of_index,length,NOT_EMPTY,PSEND,
  PvmRouteDirect,0));
}
void test107_slave()
{funneling_slave(NOT_EMPTY,PSEND,PvmRouteDirect,0);}

