
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	hostc.h
 *
 *	Host cache definitions.
 *
$Log$
 */


struct hostc {
	struct hostc *link, *rlink;
	int pvmd_tid;
	char *name;
	char *alias;
	char *arch;
	int speed;
	struct timeval delta;
};


int host_init __ProtoGlarp__(( int atag, int dtag, int (*acb)(), int (*dcb)() ));

int host_add __ProtoGlarp__(( void ));

int host_delete __ProtoGlarp__(( void ));

struct hostc *host_findtid __ProtoGlarp__(( int tid ));

struct hostc *host_findname __ProtoGlarp__(( char *name ));

struct hostc *host_next __ProtoGlarp__(( struct hostc *hp ));

int host_show __ProtoGlarp__(( void ));

