
/*
*	pvm_fork.c
*
*	In the spirit of fork(), fork a process and enroll it as a new PVM task.
*	If parent, returns task id (>0) of child, or error (<0).
*	If child, returns 0.
*/


#ifdef	IMA_TITN
#include <sys/socket.h>
#endif
#include <pvm3.h>

int
pvm_fork(cpid)
	int *cpid;		/* cpid returns child pid if nonnull */
{
	int tid;		/* tid to return (child tid or 0) */
	int pid;
	int pfd[2];

	if ((tid = pvm_mytid()) > 0) {
		if (
#ifdef	IMA_TITN
		socketpair(AF_UNIX, SOCK_STREAM, 0, pfd)
#else
		pipe(pfd)
#endif
		== -1)
			tid = PvmOutOfRes;
		else
			if (pid = fork()) {				/* parent */
				close(pfd[1]);
				if (cpid)
					*cpid = pid;
				if (pid == -1)
					tid = PvmOutOfRes;
				else
					if (read(pfd[0], (char *)&tid, sizeof(tid)) != sizeof(tid))
						tid = PvmOutOfRes;
				close(pfd[0]);

			} else {						/* child */
				close(pfd[0]);
				pvmendtask();
				tid = pvm_mytid();
				write(pfd[1], (char *)&tid, sizeof(tid));
				close(pfd[1]);
				tid = 0;
			}
	}
	return tid;
}


