      SUBROUTINE DRLTR(A,B,N,ISN)
C
C THIS SUBROUTINE COMPLETES THE FOURIER TRANSFORM OF 2*N REAL
C DATA VALUES.
C IT PERFORMS A RADIX-2 TRANSFORM ON THE FOURIER COEFFICIENTS WHICH
C RESULT FROM INITIAL TRANSFORM OF THE 2*N REAL DATA VALUES BY AN
C N DIMENSIONAL COMPLEX FOURIER TRANSFORM.
C THIS PROGRAM MUST BE USED IN CONJUNCTION WITH DFFT.
C
C THIS IS SINGLETON S PROGRAM, WHICH USES THE SANDE FACTORING.
C
C
C   ISN  -DETERMINES BY SIGN THE TYPE OF TRANSFORM BEING COMPUTED,
C         FORWARD OR INVERSE.
C        -INDICATES BY ABSOLUTE VALUE THE VECTOR ARRANGEMENT OF
C         INPUT DATA (AND TRANSFORM RESULTS).
C
C
C   IF ISN=1    CALLING SEQUENCE IS-
C                CALL DFFT(A,B,N,N,N,1)
C                CALL DRLTR(A,B,N,1).
C
C        THE 2*N REAL INPUT VALUES TO DFFT ARE STORED ALTERNATELY IN TWO
C        VECTORS, A AND B-  A(1),B(1),A(2),B(2),...,A(N),B(N).
C
C        SINCE 2(N+1) COEFFICIENTS RESULT FROM THE TRANSFORM
C        OF THE ORIGINAL 2N DATA POINTS, THE COSINE COEFFICIENTS
C        WILL BE IN A(1),A(2),...,A(N+1) - NOTE THAT A MUST BE
C        DIMENSIONED APPROPRIATELY, AND THE SINE COEFFICIENTS WILL
C        BE IN B(1),B(2),...,B(N+1), BUT B(N+1) = 0.
C
C
C   IF ISN=2    CALLING SEQUENCE IS-
C                CALL DFFT(A,A(2),N,N,N,2)
C                CALL DRLTR(A,A(2),N,2).
C
C        THE 2*N REAL INPUT VALUES TO DFFT ARE STORED IN A SINGLE
C        VECTOR, A.
C        THE OUTPUT WILL BE STORED ALTERNATELY IN A,
C        COSINE COEFFICIENTS IN A(1),A(3),...,A(2N+1) AND
C        SINE COEFFICIENTS IN A(2),A(4),...,A(2N+2).
C
C
C IF ISN=1   DIVIDE OUTPUT BY 2*N FOR UNIT MAGNITUDE.
C IF ISN=2   DIVIDE OUTPUT BY N FOR UNIT MAGNITUDE.
C
C
C   IF ISN=-1   CALLING SEQUENCE IS-
C                CALL DRLTR(A,B,N,-1)
C                CALL DFFT(A,B,N,N,N,-1).
C
C        THE OUTPUT OF REAL VALUES ALTERNATES IN TWO VECTORS, A AND B-
C        A(1),B(1),A(2),B(2),...,A(N),B(N).
C
C
C   IF ISN=-2   CALLING SEQUENCE IS-
C                CALL DRLTR(A,A(2),N,-2)
C                CALL DFFT(A,A(2),N,N,N,-2).
C
C        THE OUTPUT OF REAL VALUES IS IN A SINGLE VECTOR, A AND
C        SHOULD BE DIVIDED BY 2 FOR PROPER SCALING.
C
C
C REFERENCE-  SINGLETON, R. C.,  AN ALGORITHM FOR COMPUTING THE MIXED
C             RADIX FAST FOURIER TRANSFORM , IEEE TRANSACTIONS ON
C             AUDIO AND ELECTROACOUSTICS, VOL. AU-17, NO. 2,
C             JUNE, 1969, PP. 93-103.
C
C
      DOUBLE PRECISION A(1),B(1)
      DOUBLE PRECISION CD,SD,CN,SN
      DOUBLE PRECISION AA,AB,BA,BB,RE,IM
      DOUBLE PRECISION DATAN,DSIN
C
      INC=IABS(ISN)
      NK=N*INC+2
      NH=NK/2
      SD=FLOAT(N)
      SD=2.0D0*DATAN(1.0D0)/SD
      CD=2.0D0*DSIN(SD)**2
      SD=DSIN(SD+SD)
      SN=0.0D0
      IF(ISN .LT. 0) GO TO 30
      CN=1.0D0
      A(NK-1)=A(1)
      B(NK-1)=B(1)
   10 DO 20 J=1,NH,INC
      K=NK-J
      AA=A(J)+A(K)
      AB=A(J)-A(K)
      BA=B(J)+B(K)
      BB=B(J)-B(K)
      RE=CN*BA+SN*AB
      IM=SN*BA-CN*AB
      B(K)=IM-BB
      B(J)=IM+BB
      A(K)=AA-RE
      A(J)=AA+RE
      AA=CN-(CD*CN+SD*SN)
      SN=(SD*CN-CD*SN)+SN
C    THE FOLLOWING 3 STATEMENTS COMPENSATE FOR TRUNCATION
C    ERROR. IF ROUNDED ARITHMETIC IS USED, SUBSTITUTE
C 20 CN=AA FOR THE FOLLOWING THREE STATEMENTS.
      CN=0.5D0/(AA**2+SN**2)+0.5D0
      SN=CN*SN
   20 CN=CN*AA
      RETURN
   30 CN=-1.0D0
      SD=-SD
      GO TO 10
       END
