      SUBROUTINE BESCJ(XR, XI, NB, BR, BI)
C
C THIS ROUTINE CALCULATES BESSEL FUNCTIONS J OF COMPLEX
C ARGUMENT AND INTEGER ORDER.
C
C      EXPLANATION OF VARIABLES IN THE CALLING SEQUENCE -
C
C XR -  REAL PART OF THE COMPLEX ARGUMENT
C       FOR WHICH THE J*S ARE TO BE CALCULATED.
C
C XI -  REAL IMAGINARY PART OF THE COMPLEX ARGUMENT
C       FOR WHICH THE J*S ARE TO BE CALCULATED.
C
C NB -  INTEGER TYPE.  1 + HIGHEST ORDER TO BE CALCULATED.
C       IT MUST BE POSITIVE.
C
C BR -  REAL VECTOR OF LENGTH NB, NEED NOT BE
C       INITIALIZED BY USER.  IF THE ROUTINE TERMINATES
C       NORMALLY IT RETURNS THE REAL PART OF J-SUB-ZERO
C       THROUGH J-SUB-NB-MINUS-ONE OF Z IN THIS
C       VECTOR.
C
C BI -  IMAGINARY ANALOG OF BR.
C
C                  ACCURACY OF THE COMPUTED VALUES -
C
C       IN CASE OF AN ERROR, NOT ALL J*S
C       ARE CALCULATED TO THE DESIRED ACCURACY.
C
C       THE SUBPROGRAM CALLED BY BESCJ, B1SLC,
C       RETURNS IN THE VARIABLE, NCALC, THE NUMBER CALCULATED CORRECTLY.
C
C       LET NTEN BE THE LARGEST INTEGER K SUCH THAT 10**K IS MACHINE-
C       REPRESENTABLE IN SINGLE PRECISION.
C       THEN NB.GT.NCALC.GT.0 WILL OCCUR IF NB.GT.MAGZ AND ABS(J-
C       SUB-NB-OF-Z/J-SUB-MAGZ+NP-OF-Z).LT.10.**(NTEN/2), I.E. NB
C       IS MUCH GREATER THAN MAGZ.  IN THIS CASE, BR(N) AND BI(N)
C       ARE CALCULATED TO THE DESIRED ACCURACY FOR N.LE.NCALC, BUT FOR
C       NCALC.LT.N.LE.NB, PRECISION IS LOST.  IF N.GT.NCALC AND
C       ABS(B(NCALC-1)/B(N-1)).EQ.10**-K, THEN THE LAST K SIGNIFICANT
C       FIGURES OF B(N-1) (HERE B(N)=BR(N)+BI(N)) ARE ERRONEOUS.
C       IF THE USER WISHES TO CALCULATE B(N) TO HIGHER ACCURACY,
C       HE SHOULD USE AN ASYMPTOTIC FORMULA FOR LARGE ORDER.
C
      REAL XR,XI,BR(1),BI(1)
C
C CHECK INPUT VALUES
C
C       AN UPPER LIMIT OF 10000 IS SET ON THE MAGNITUDE OF Z.
C       BEAR IN MIND THAT IF ABS(Z)=N, THEN AT LEAST N ITERATIONS
C       OF THE BACKWARD RECURSION WILL BE EXECUTED.
C
      MAGZ = SQRT(XR*XR+XI*XI)
      MEXP = ALOG(R1MACH(2))
C
C/6S
C     IF  (MAGZ .GT. 10000 .OR. IFIX(ABS(XI)) .GT. MEXP) CALL SETERR(
C    1    33H BESCJ - Z IS TOO BIG (MAGNITUDE),33,1,2)
C/7S
      IF  (MAGZ .GT. 10000 .OR. IFIX(ABS(XI)) .GT. MEXP) CALL SETERR(
     1    ' BESCJ - Z IS TOO BIG (MAGNITUDE)',33,1,2)
C/
C
C/6S
C     IF  (NB .LT. 1) CALL SETERR(
C    1    28H BESCJ - NB SHOULD = ORDER+1,28,2,2)
C/7S
      IF  (NB .LT. 1) CALL SETERR(
     1    ' BESCJ - NB SHOULD = ORDER+1',28,2,2)
C/
C
C BESCJ CALLS ON THE SUBPROGRAM,B1SLC,
C WHICH IS SOOKNES  ORIGINAL BESLCI.
C
C THE ADDITIONAL INPUT ARGUMENTS REQUIRED FOR IT ARE -
C
C IZE   INTEGER TYPE.  ZERO IF J*S ARE TO BE CALCULATED, 1
C       IF I*S ARE TO BE CALCULATED.(FOURTH ARGUMENT BELOW)
C
C NCALC INTEGER TYPE, NEED NOT BE INITIALIZED BY USER.
C       BEFORE USING THE RESULTS, IT SHOULD BE CHECKED THAT
C       NCALC=NB, I.E. ALL ORDERS HAVE BEEN CALCULATED TO
C       THE DESIRED ACCURACY.
C
      CALL  B1SLC (XR, XI, NB, 0, BR, BI, NCALC)
C
C TEST IF ALL GOT COMPUTED OK
C (SINCE SOME VALUES MAY BE OK, THIS IS A RECOVERABLE ERROR.)
C
      IF (NB .EQ. NCALC) RETURN
C
      NCALC = NCALC+10
C/6S
C     CALL SETERR(
C    1    38H BESCJ - ONLY THIS MANY ANSWERS ARE OK,38,NCALC,1)
C/7S
      CALL SETERR(
     1    ' BESCJ - ONLY THIS MANY ANSWERS ARE OK',38,NCALC,1)
C/
C
      RETURN
      END
