#include <sys/types.h>
#include <stdio.h>

#define TRUE 1
#define FALSE 0

/* 
** This program gives the user a nice front end to manipulate the
** trace buffer written with the monitor macros trace package
**
** The main layout is a query loop and buffer manipulation functions.
*/

struct zz_trace_entry {
    int id;
    int typ;
    int data;
};
struct zz_trace_struct {
    int next_entry;
    struct zz_trace_entry trace_table[400];
};

struct xp_display_process {
    int id;
    char name[50];
};
struct xp_display_event {
    int typ;
    char name[50];
};
struct xp_display_struct {
    int display_entry;
    int num_processes;
    int num_events;
    int window;
    int end_of_buffer;
    int display_count;
    int current_id;
    int current_typ;
    char process_file[255];
    char event_file[255];
    struct xp_display_process display_process[100];
    struct xp_display_event display_event[100];
};

struct zz_trace_struct *trace_data;
struct xp_display_struct *display_data;

char xp_command[56];
int xp_cont;
int nxtv;

main()
{
    trace_data = (struct zz_trace_struct *) 
        malloc(sizeof(struct zz_trace_struct));
    trace_data->next_entry = 0;
    for (nxtv=0; nxtv < 400; nxtv++)
    {
        trace_data->trace_table[nxtv].id = -1;
    }
    display_data = ( struct xp_display_struct *)
        malloc(sizeof(struct xp_display_struct));
    display_data->display_entry = 0;
    display_data->num_processes = 0;
    display_data->num_events = 0;
    display_data->current_id = 999;
    display_data->current_typ = 999;
    display_data->window = 20;
    strcpy(display_data->process_file,"process_defs");
    strcpy(display_data->event_file,"event_defs");

    xp_read_process(display_data);
    xp_read_event(display_data);
    xp_read(trace_data,display_data);   

    xp_cont = TRUE;
    while (xp_cont == TRUE) { 
        printf("Forward Backward Process Event Write Read Display Skip Change Quit : ");
        scanf("%s",xp_command);
        switch (xp_command[0]) {
        case 'F' : 
        case 'f' :
            {
                xp_forward(trace_data,display_data);
                break;
            }
        case 'B' : 
        case 'b' :
            {
                xp_backward(trace_data,display_data);
                break;
            }
        case 'P' : 
        case 'p' :
            {
                xp_process(display_data);
                break;
            }
        case 'E' : 
        case 'e' :
            {
                xp_event(display_data);
                break;
            }
        case 'W' : 
        case 'w' :
            {
                xp_write(trace_data,display_data);
                break;
            }
        case 'R' : 
        case 'r' :
            {
                xp_read(trace_data,display_data);
                break;
            }
        case 'D' : 
        case 'd' :
            {
                xp_size(display_data);
                break;
            }
        case 'S' :
        case 's' :
            {
                xp_skip(display_data);
                break;
            }
        case 'C' : 
        case 'c' :
            {
                xp_change(display_data);
                break;
            }
        case 'Q' : 
        case 'q' :
            {
                xp_cont = FALSE;
                break;
            }
        default : 
            printf("Undefined Command \n");
        }
    } 
}
xp_forward(trace_data,display_data)
register struct zz_trace_struct *trace_data;
register struct xp_display_struct *display_data;
{
    register int i,j;
    display_data->display_count = 0;
   
    j = display_data->display_entry;
    
    for (i=0; display_data->display_count < display_data->window; i++)
    {
        if (trace_data->trace_table[j].id != -1)
        {
            if(display_data->current_id == 999 &&
                display_data->current_typ == 999 ) {
                xp_print_table(trace_data,display_data,j);
            } 
            else if (display_data->current_id != 999 &&
                display_data->current_typ == 999 ) {
                if (display_data->current_id ==
                    trace_data->trace_table[j].id)
                    xp_print_table(trace_data,display_data,j);
            } 
            else if (display_data->current_id == 999 &&
                display_data->current_typ != 999 ) {
                if (display_data->current_typ ==
                    trace_data->trace_table[j].typ)
                    xp_print_table(trace_data,display_data,j);
            } 
            else {
                if (display_data->current_id ==
                    trace_data->trace_table[j].id &&
                    display_data->current_typ ==
                    trace_data->trace_table[j].typ )
                    xp_print_table(trace_data,display_data,j);
            }

        }
        ++j;
        if ( j == display_data->end_of_buffer) {
			j = 0;
            printf("\n**** End of Event Buffer ****\n\n");
            display_data->display_count = display_data->window;
        }
        display_data->display_entry = j;
    }
    return(FALSE);
}

xp_backward(trace_data,display_data)
register struct zz_trace_struct *trace_data;
register struct xp_display_struct *display_data;
{
    register int i,j;
    display_data->display_count = 0;
   
    j = --display_data->display_entry;
    
	if ( j < 0 ) j = display_data->end_of_buffer - 1;

    for (i=0; display_data->display_count < display_data->window; i++)
    {
        if (trace_data->trace_table[j].id != -1)
        {
            if(display_data->current_id == 999 &&
                display_data->current_typ == 999 ) {
                xp_print_table(trace_data,display_data,j);
            } 
            else if (display_data->current_id != 999 &&
                display_data->current_typ == 999 ) {
                if (display_data->current_id ==
                    trace_data->trace_table[j].id)
                    xp_print_table(trace_data,display_data,j);
            } 
            else if (display_data->current_id == 999 &&
                display_data->current_typ != 999 ) {
                if (display_data->current_typ ==
                    trace_data->trace_table[j].typ)
                    xp_print_table(trace_data,display_data,j);
            } 
            else {
                if (display_data->current_id ==
                    trace_data->trace_table[j].id &&
                    display_data->current_typ ==
                    trace_data->trace_table[j].typ )
                    xp_print_table(trace_data,display_data,j);
            }

        }
        --j;
        if ( j == -1) {
			j = display_data->end_of_buffer - 1;
            printf("\n**** End of Event Buffer ****\n\n");
            display_data->display_count = display_data->window;
        }
        display_data->display_entry = j;
    }

	(display_data->display_entry)++;

	if (display_data->display_entry == display_data->end_of_buffer)
		display_data->display_entry = 0;

    return(FALSE);
}

xp_process(display_data)
register struct xp_display_struct *display_data;
{
    register int i,j;
    int current_id;

    printf("Defined Processes 0 - %0d\n\n",
    (display_data->num_processes-1));

    j = display_data->num_processes;
    for(i=0;i<j;i++) {
        printf(" %d %s\n",
        display_data->display_process[i].id,
        display_data->display_process[i].name);
    }

    printf("\n");
    printf("Enter Process ( <999> for all ) : ");
    scanf("%d",&current_id);
    display_data->current_id = current_id;
    return(FALSE);
}

xp_event(display_data)
register struct xp_display_struct *display_data;
{
    register int i,j;
    int current_typ;

    printf("Defined Events 0 - %0d\n\n",
    (display_data->num_events-1));

    j = display_data->num_events;
    for(i=0;i<j;i++) {
        printf("%d %s\n",
        display_data->display_event[i].typ,
        display_data->display_event[i].name);
    }
    printf("\n");
    printf("Enter Event ( <999> for all ) : ");
    scanf("%d",&current_typ);
    display_data->current_typ = current_typ;

    return(FALSE);
}


xp_write(trace_data,display_data)
register struct zz_trace_struct *trace_data;
register struct xp_display_struct *display_data;
{
    FILE *fp;
    register int i,j;
    int temp_display;
    char filename[255];

    printf("Enter filename to write trace report : ");
    scanf("%s",filename);

    if  ((fp = fopen(filename,"w")) == NULL)
        printf("*** failed to open %\n",filename);
    else
    {
		j = 0;
        temp_display = display_data->display_count;
        display_data->display_count = 0;

        for (i=0; display_data->display_count < display_data->end_of_buffer; i++)
        {
            if (trace_data->trace_table[j].id != -1)
            {
                if(display_data->current_id == 999 &&
                    display_data->current_typ == 999 ) {
                    xp_fprint_table(fp,trace_data,display_data,j);
                } 
                else if (display_data->current_id != 999 &&
                    display_data->current_typ == 999 ) {
                    if (display_data->current_id ==
                        trace_data->trace_table[j].id)
                        xp_fprint_table(fp,trace_data,display_data,j);
                } 
                else if (display_data->current_id == 999 &&
                    display_data->current_typ != 999 ) {
                    if (display_data->current_typ ==
                        trace_data->trace_table[j].typ)
                        xp_fprint_table(fp,trace_data,display_data,j);
                } 
                else {
                    if (display_data->current_id ==
                        trace_data->trace_table[j].id &&
                        display_data->current_typ ==
                        trace_data->trace_table[j].typ )
                        xp_fprint_table(fp,trace_data,display_data,j);
                }

            }
            ++j;
            if ( j == display_data->end_of_buffer) {
		      j = 0;
              fprintf(fp,"\n**** End of Event Buffer ****\n\n");
              display_data->display_count = display_data->end_of_buffer;
            }
            display_data->display_entry = j;
        }
        display_data->display_count = temp_display;
    }
    fclose(fp);
	return(FALSE);
}

xp_read(trace_data,display_data)
register struct zz_trace_struct *trace_data;
register struct xp_display_struct *display_data;
{
FILE *fp;
register int i,j;
int  id,typ,data;
int next_entry;

if  ((fp = fopen("tracefile","r")) == NULL)
printf("*** failed to open tracefile\n");
else
{
    /*
                    fscanf(fp,"%d",&next_entry);
                    trace_data->next_entry = next_entry;
                    j = trace_data->next_entry;
                    */
    j = 0;
    for(i=0;i<400 && feof(fp) == 0 ;i++)
    {
        fscanf(fp,"%d %d %d",&id,&typ,&data);
        trace_data->trace_table[j].id= id;
        trace_data->trace_table[j].typ = typ;
        trace_data->trace_table[j].data = data;
        if (++j > 399)
            j = 0;
    }
    if ( j == 0 ) display_data->end_of_buffer = 400;
    else display_data->end_of_buffer = j-1;
}
fclose(fp);
return(FALSE);
}
xp_skip(display_data)
register struct xp_display_struct *display_data;
{
int num;
printf("Enter number of events to skip (+/-) : ");
scanf("%d",&num);
display_data->display_entry = display_data->display_entry + num;
return(FALSE);
}

xp_size(display_data)
register struct xp_display_struct *display_data;
{
int val;

printf("Current Window Size = %d  Enter New Value : "
,display_data->window);
scanf("%d",&val);
display_data->window = val;

return(FALSE);
}
xp_change(display_data)
register struct xp_display_struct *display_data;
{
int cont;
char xp_input[52];
char process_file[255];
char event_file[255];

cont = TRUE;
printf("Logged Item Definition Files \n\n");
printf(" Process File : %s\n",display_data->process_file);
printf("   Event File : %s\n\n",display_data->event_file);
while ( cont == TRUE ) {
    printf("Process Event Done : ");
    scanf("%s",xp_input);
    switch (xp_input[0]) {
    case 'P' :
    case 'p' :
        {
            printf("Enter New Process Definition filename : ");
            scanf("%s",process_file);
            strcpy(display_data->process_file,process_file);
            xp_read_process(display_data);
            break;
        }
    case 'E' :
    case 'e' :
        {
            printf("Enter New Event Definition filename : ");
            scanf("%s",event_file);
            strcpy(display_data->event_file,event_file);
            xp_read_event(display_data);
            break;
        }
    case 'D' :
    case 'd' :
        {
            cont = FALSE;
            break;
        }
    default :
        {
            printf("ERROR");
            break;
        }
    }
}

return(FALSE);
}
xp_read_process(display_data)
register struct xp_display_struct *display_data;
{
FILE *fp;
register int i,j;
int id;
char name[255];

if  ((fp = fopen(display_data->process_file,"r")) == NULL)
printf("*** failed to open process defs file \n");
else
{
    j = 0;
    for (i=0; i < 100 && feof(fp) == 0; i++)
    {
        fscanf(fp,"%d",&id);
        fgets(name,50,fp);
        rm_newline(&name[0]);
        display_data->display_process[j].id = id;
        strcpy(display_data->display_process[j].name,name);
        display_data->num_processes++;
        j++;
    }
    display_data->num_processes--;
    /* this is because fgets does not get to eof */
    fclose(fp);
    return(FALSE);
}

}
xp_read_event(display_data)
register struct xp_display_struct *display_data;
{
FILE *fp;
register int i,j;
int typ;
char name[255];

if  ((fp = fopen(display_data->event_file,"r")) == NULL)
printf("*** failed to open event defs file \n");
else
{
    j = 0;
    for (i=0; i < 100 && feof(fp) == 0; i++) {  
        fscanf(fp,"%d ",&typ);
        fgets(name,50,fp);
        rm_newline(&name[0]);
        display_data->display_event[j].typ = typ;
        strcpy(display_data->display_event[j].name,name);
        display_data->num_events++;
        j++;
    }
    display_data->num_events--;
    /* this is because fgets never gets to eof */
}
fclose(fp);
return(FALSE);
}

xp_print_table(trace_data,display_data,j)
register struct zz_trace_struct *trace_data;
register struct xp_display_struct *display_data;
int j;
{
display_data->display_count++;
printf("%d -- ",j+1);
printf("%s %s %d\n",
display_data->display_process[
trace_data->trace_table[j].id].name,
display_data->display_event[
trace_data->trace_table[j].typ].name,
trace_data->trace_table[j].data);
}

xp_fprint_table(fp,trace_data,display_data,j)
FILE *fp;
register struct zz_trace_struct *trace_data;
register struct xp_display_struct *display_data;
int j;
{
display_data->display_count++;
fprintf(fp,"%d -- ",j+1);
fprintf(fp,"%s %s %d\n",
display_data->display_process[
trace_data->trace_table[j].id].name,
display_data->display_event[
trace_data->trace_table[j].typ].name,
trace_data->trace_table[j].data);
}

rm_newline(name)
char *name;
{
int i;
for(i=0;i <50;i++) {
    if (name[i] == 10) name[i]= 0;
}
return(FALSE);
}

