      SUBROUTINE INFOG2L( GRINDX, GCINDX, DESC, NPROW, NPCOL, MYROW,
     $                    MYCOL, LRINDX, LCINDX, RSRC, CSRC )
*
*  -- ScaLAPACK tools routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            CSRC, GCINDX, GRINDX, LRINDX, LCINDX, MYCOL,
     $                   MYROW, NPCOL, NPROW, RSRC
*     ..
*     .. Array Arguments ..
      INTEGER            DESC( 8 )
*     ..
*
*  Purpose
*  =======
*
*  INFOG2L computes the starting local indexes LRINDX, LCINDX corres-
*  ponding to the distributed submatrix starting globally at the entry
*  pointed by GRINDX, GCINDX. This routine returns the coordinates in
*  the grid of the process owning the matrix entry of global indexes
*  GRINDX, GCINDX, namely RSRC and CSRC.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  GRINDX    (global input) INTEGER
*            The global row starting index of the submatrix.
*
*  GCINDX    (global input) INTEGER
*            The global column starting index of the submatrix.
*
*  DESC      (input) INTEGER array of dimension 8.
*            The array descriptor for the underlying distributed matrix.
*
*  NPROW     (global input) INTEGER
*            The total number of process rows over which the distributed
*            matrix is distributed.
*
*  NPCOL     (global input) INTEGER
*            The total number of process columns over which the
*            distributed matrix is distributed.
*
*  MYROW     (local input) INTEGER
*            The row coordinate of the process calling this routine.
*
*  MYCOL     (local input) INTEGER
*            The column coordinate of the process calling this routine.
*
*  LRINDX    (local output) INTEGER
*            The local rows starting index of the submatrix.
*
*  LCINDX    (local output) INTEGER
*            The local columns starting index of the submatrix.
*
*  RSRC      (global output) INTEGER
*            The row coordinate of the process that possesses the first
*            row and column of the submatrix.
*
*  CSRC      (global output) INTEGER
*            The column coordinate of the process that possesses the
*            first row and column of the submatrix.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            CBLK, GCCPY, GRCPY, RBLK
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
      GRCPY = GRINDX-1
      GCCPY = GCINDX-1
*
      RBLK = GRCPY / DESC(3)
      CBLK = GCCPY / DESC(4)
      RSRC = MOD( RBLK + DESC(5), NPROW )
      CSRC = MOD( CBLK + DESC(6), NPCOL )
*
      LRINDX = ( RBLK / NPROW + 1 ) * DESC(3) + 1
      LCINDX = ( CBLK / NPCOL + 1 ) * DESC(4) + 1
*
      IF( MOD( MYROW+NPROW-DESC(5), NPROW ).GE.MOD( RBLK, NPROW ) ) THEN
         IF( MYROW.EQ.RSRC )
     $      LRINDX = LRINDX + MOD( GRCPY, DESC(3) )
         LRINDX = LRINDX - DESC(3)
      END IF
*
      IF( MOD( MYCOL+NPCOL-DESC(6), NPCOL ).GE.MOD( CBLK, NPCOL ) ) THEN
         IF( MYCOL.EQ.CSRC )
     $      LCINDX = LCINDX + MOD( GCCPY, DESC(4) )
         LCINDX = LCINDX - DESC(4)
      END IF
*
      RETURN
*
*     End of INFOG2L
*
      END
