      SUBROUTINE PDLASWP( DIREC, ROWCOL, N, A, IA, JA, DESCA, K1, K2,
     $                    IPIV )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          DIREC, ROWCOL
      INTEGER            IA, JA, K1, K2, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), IPIV( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  Purpose:
*  ========
*
*  PDLASWP performs a series of row or column interchanges on
*  the distributed matrix sub( A ) = A(IA:IA+M-1,JA:JA+N-1).  One
*  interchange is initiated for each of rows or columns K1 trough K2 of
*  sub( A ). This routine assumes that the pivoting information has
*  already been broadcast along the process row or column.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  DIREC   (global input) CHARACTER
*          Specifies in which order the permutation is applied:
*          = 'F' (Forward)
*          = 'B' (Backward)
*
*  ROWCOL  (global input) CHARACTER
*          Specifies if the rows or columns are permuted:
*          = 'R' (Rows)
*          = 'C' (Columns)
*
*  N       (global input) INTEGER
*          If ROWCOL = 'R', the length of the rows of the distributed
*          matrix A(*,JA:JA+N-1) to be permuted;
*          If ROWCOL = 'C', the length of the columns of the distributed
*          matrix A(IA:IA+N-1,*) to be permuted.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A, * ).
*          On entry, this array contains the local pieces of the distri-
*          buted matrix to which the row/columns interchanges will be
*          applied. On exit the permuted distributed matrix.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  K1      (global input) INTEGER
*          The first element of IPIV for which a row or column inter-
*          change will be done.
*
*  K2      (global input) INTEGER
*          The last element of IPIV for which a row or column inter-
*          change will be done.
*
*  IPIV    (local input) INTEGER array, dimension LOCp(M_A)+MB_A for
*          row pivoting and LOCq(N_A)+NB_A for column pivoting.  This
*          array is tied to the matrix A, IPIV(K) = L implies rows
*          (or columns) K and L are to be interchanged.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, ICURCOL, ICURROW, IIA, IP, J, JJA, JP,
     $                   MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, PDSWAP
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
      CALL BLACS_GRIDINFO( DESCA( 7 ), NPROW, NPCOL, MYROW, MYCOL )
*
      IF( LSAME( ROWCOL, 'R' ) ) THEN
         IF( LSAME( DIREC, 'F' ) ) THEN
            CALL INFOG2L( K1, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                    IIA, JJA, ICURROW, ICURCOL )
            DO 10 I = K1, K2
               IP = IPIV( IIA+I-K1 )
               IF( IP.NE.I )
     $            CALL PDSWAP( N, A, I, JA, DESCA, DESCA( 1 ), A, IP,
     $                         JA, DESCA, DESCA( 1 ) )
   10       CONTINUE
         ELSE
            CALL INFOG2L( K2, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                    IIA, JJA, ICURROW, ICURCOL )
            DO 20 I = K2, K1, -1
               IP = IPIV( IIA+I-K1 )
               IF( IP.NE.I )
     $            CALL PDSWAP( N, A, I, JA, DESCA, DESCA( 1 ), A, IP,
     $                         JA, DESCA, DESCA( 1 ) )
   20       CONTINUE
         END IF
      ELSE
         IF( LSAME( DIREC, 'F' ) ) THEN
            CALL INFOG2L( IA, K1, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                    IIA, JJA, ICURROW, ICURCOL )
            DO 30 J = K1, K2
               JP = IPIV( JJA+J-K1 )
               IF( JP.NE.J )
     $            CALL PDSWAP( N, A, IA, J, DESCA, 1, A, IA, JP,
     $                         DESCA, 1 )
   30       CONTINUE
         ELSE
            CALL INFOG2L( IA, K2, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                    IIA, JJA, ICURROW, ICURCOL )
            DO 40 J = K2, K1, -1
               JP = IPIV( JJA+J-K1 )
               IF( JP.NE.J )
     $            CALL PDSWAP( N, A, IA, J, DESCA, 1, A, IA, JP,
     $                         DESCA, 1 )
   40       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End PDLASWP
*
      END
