      SUBROUTINE PDLASET( UPLO, M, N, ALPHA, BETA, A, IA, JA, DESCA )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, JA, M, N
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLASET initializes an M-by-N distributed matrix sub( A ) denoting
*  A(IA:IA+M-1,JA:JA+N-1) to BETA on the diagonal and ALPHA on the
*  offdiagonals.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          Specifies the part of the distributed matrix sub( A ) to be
*          set:
*          = 'U':      Upper triangular part is set; the strictly lower
*                      triangular part of sub( A ) is not changed;
*          = 'L':      Lower triangular part is set; the strictly upper
*                      triangular part of sub( A ) is not changed;
*          Otherwise:  All of the matrix sub( A ) is set.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  ALPHA   (global input) DOUBLE PRECISION
*          The constant to which the offdiagonal elements are to be
*          set.
*
*  BETA    (global input) DOUBLE PRECISION
*          The constant to which the diagonal elements are to be set.
*
*  A       (local output) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_A,LOCq(JA+N-1)).  This array
*          contains the local pieces of the distributed matrix sub( A )
*          to be set.  On exit, the leading M-by-N submatrix sub( A )
*          is set as follows:
*
*          if UPLO = 'U', A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=j-1, 1<=j<=N,
*          if UPLO = 'L', A(IA+i-1,JA+j-1) = ALPHA, j+1<=i<=M, 1<=j<=N,
*          otherwise,     A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=M, 1<=j<=N,
*                                                   IA+i.NE.JA+j,
*          and, for all UPLO, A(IA+i-1,JA+i-1) = BETA, 1<=i<=min(M,N).
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IAA, IBLK, IN, ITMP, J, JAA, JBLK, JN, JTMP
*     ..
*     .. External Subroutines ..
      EXTERNAL           PDLASE2
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      IF( M.LE.( DESCA( 3 ) - MOD( IA-1, DESCA( 3 ) ) ) .OR.
     $    N.LE.( DESCA( 4 ) - MOD( JA-1, DESCA( 4 ) ) ) ) THEN
         CALL PDLASE2( UPLO, M, N, ALPHA, BETA, A, IA, JA, DESCA )
      ELSE
*
         IF( LSAME( UPLO, 'U' ) ) THEN
            IN = MIN( ICEIL( IA, DESCA( 3 ) ) * DESCA( 3 ), IA+M-1 )
            CALL PDLASE2( UPLO, IN-IA+1, N, ALPHA, BETA, A, IA, JA,
     $                    DESCA )
            DO 10 I = IN+1, IA+M-1, DESCA( 3 )
               ITMP = I-IA
               IBLK = MIN( DESCA( 3 ), M-ITMP )
               JAA = JA + ITMP
               CALL PDLASE2( UPLO, IBLK, N-ITMP, ALPHA, BETA,
     $                       A, I, JAA, DESCA )
   10       CONTINUE
         ELSE IF( LSAME( UPLO, 'L' ) ) THEN
            JN = MIN( ICEIL( JA, DESCA( 4 ) ) * DESCA( 4 ), JA+N-1 )
            CALL PDLASE2( UPLO, M, JN-JA+1, ALPHA, BETA, A, IA, JA,
     $                    DESCA )
            DO 20 J = JN+1, JA+N-1, DESCA( 4 )
               JTMP = J-JA
               JBLK = MIN( DESCA( 4 ), N-JTMP )
               IAA = IA + JTMP
               CALL PDLASE2( UPLO, M-JTMP, JBLK, ALPHA, BETA, A, IAA,
     $                       J, DESCA )
   20       CONTINUE
         ELSE
            IF( M.LE.N ) THEN
               IN = MIN( ICEIL( IA, DESCA( 3 ) ) * DESCA( 3 ), IA+M-1 )
               CALL PDLASE2( UPLO, IN-IA+1, N, ALPHA, BETA, A, IA,
     $                       JA, DESCA )
               DO 30 I = IN+1, IA+M-1, DESCA( 3 )
                  ITMP = I-IA
                  IBLK = MIN( DESCA( 3 ), M-ITMP )
                  CALL PDLASE2( UPLO, IBLK, I-IA, ALPHA, ALPHA, A, I,
     $                          JA, DESCA )
                  CALL PDLASE2( UPLO, IBLK, N-I+IA, ALPHA, BETA, A, I,
     $                          JA+I-IA, DESCA )
   30          CONTINUE
            ELSE
               JN = MIN( ICEIL( JA, DESCA( 4 ) ) * DESCA( 4 ), JA+N-1 )
               CALL PDLASE2( UPLO, M, JN-JA+1, ALPHA, BETA, A, IA,
     $                       JA, DESCA )
               DO 40 J = JN+1, JA+N-1, DESCA( 4 )
                  JTMP = J-JA
                  JBLK = MIN( DESCA( 4 ), N-JTMP )
                  CALL PDLASE2( UPLO, J-JA, JBLK, ALPHA, ALPHA, A, IA,
     $                          J, DESCA )
                  CALL PDLASE2( UPLO, M-J+JA, JBLK, ALPHA, BETA, A,
     $                          IA+J-JA, J, DESCA )
   40          CONTINUE
            END IF
         END IF
*
      END IF
*
      RETURN
*
*     End of PDLASET
*
      END
