      SUBROUTINE PDLAPIV( DIREC, ROWCOL, PIVROC, M, N, A, IA, JA,
     $                    DESCA, IPIV, IP, JP, DESCIP, IWORK )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER*1        DIREC, PIVROC, ROWCOL
      INTEGER            IA, IP, JA, JP, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCIP( * ), IPIV( * ), IWORK( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLAPIV applies either P (permutation matrix indicated by IPIV)
*  or inv( P ) to a general M-by-N distributed matrix
*  sub( A ) = A(IA:IA+M-1,JA:JA+N-1), resulting in row or column
*  pivoting. The pivot vector may be distributed across a process row
*  or a column. The pivot vector should be aligned with the distributed
*  matrix A. This routine will transpose the pivot vector if necessary.
*  For example if the row pivots should be applied to the columns of
*  sub( A ), pass ROWCOL='C' and PIVROC='C'.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Restrictions
*  ============
*
*  IPIV must always be a distributed vector (not a matrix).  Thus:
*  IF( ROWPIV .EQ. 'C' ) THEN
*     JP must be 1
*  ELSE
*     IP must be 1
*  END IF
*
*  The following restrictions apply when IPIV must be transposed:
*  IF( ROWPIV.EQ.'C' .AND. PIVROC.EQ.'C') THEN
*      DESCIP(3) must equal DESCA(4)
*  ELSE IF( ROWPIV.EQ.'R" .AND. PIVROC.EQ.'R') THEN
*      DESCIP(4) must equal DESCA(3)
*  END IF
*
*  Arguments
*  =========
*
*  DIREC   (global input) CHARACTER*1
*          Specifies in which order the permutation is applied:
*            = 'F' (Forward) Applies pivots Forward from top of matrix.
*                  Computes P*sub( A ).
*            = 'B' (Backward) Applies pivots Backward from bottom of
*                  matrix. Computes inv( P )*sub( A ).
*
*  ROWCOL  (global input) CHARACTER*1
*          Specifies if the rows or columns are to be permuted:
*             = 'R' Rows will be permuted,
*             = 'C' Columns will be permuted.
*
*  PIVROC  (global input) CHARACTER*1
*          Specifies whether IPIV is distributed over a process row
*          or column:
*          = 'R' IPIV distributed over a process row
*          = 'C' IPIV distributed over a process column
*
*  M       (global input) INTEGER
*          The number of rows to be operated on, i.e. the number of
*          rows of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on, i.e. the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A, LOCq(JA+N-1)).
*          On entry, this array contains the local pieces of the
*          distributed submatrix sub( A ) to which the row or column
*          interchanges will be applied. On exit, the local pieces
*          of the permuted distributed submatrix.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  IPIV    (local input) INTEGER array, dimension >= LOCp(M_A)+MB_A
*          if ROWCOL='R', otherwise LOCq(N_A)+NB_A. It contains the
*          pivoting information. IPIV(i) is the global row (column),
*          local row (column) i was swapped with.  The last piece of the
*          array of size MB_A (resp. NB_A) is used as workspace.
*          This array is tied to the distributed matrix A.
*
*  IWORK   (local workspace) INTEGER array, dimension (LDW)
*          where LDW is equal to the workspace necessary for
*          transposition, and the storage of the tranposed IPIV:
*
*          Let LCM be the least common multiple of NPROW and NPCOL.
*          IF( ROWCOL.EQ.'R' .AND. PIVROC.EQ.'R' ) THEN
*             IF( NPROW.EQ.NPCOL ) THEN
*                LDW = LOCp( N_P + MOD(JP-1, NB_P) ) + NB_P
*             ELSE
*                LDW = LOCp( N_P + MOD(JP-1, NB_P) ) +
*                      NB_P * CEIL( CEIL(LOCq(N_P)/NB_P) / (LCM/NPCOL) )
*             END IF
*          ELSE IF( ROWCOL.EQ.'C' .AND. PIVROC.EQ.'C' ) THEN
*             IF( NPROW.EQ.NPCOL ) THEN
*                LDW = LOCq( M_P + MOD(IP-1, MB_P) ) + MB_P
*             ELSE
*                LDW = LOCq( M_P + MOD(IP-1, MB_P) ) +
*                      MB_P * CEIL( CEIL(LOCp(M_P)/MB_P) / (LCM/NPROW) )
*             END IF
*          ELSE
*             IWORK is not referenced.
*          END IF
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            ROWPVT
      INTEGER            I, ICTXT, ICURCOL, ICURROW, IIP, ITMP, IPT,
     $                   JJP, JPT, MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. Local Arrays ..
      INTEGER            DESCPT( 8 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, IGEBR2D, IGEBS2D,
     $                   INFOG2L, PDLAPV2, PICOL2ROW, PIROW2COL
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC, INDXG2P
      EXTERNAL           LSAME, NUMROC, INDXG2P
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
      ROWPVT = LSAME( ROWCOL, 'R' )
*
*     If we're pivoting the rows of sub( A )
*
      IF( ROWPVT ) THEN
         IF( M.LE.1 .OR. N.LT.1 )
     $      RETURN
*
*        If the pivot vector is already distributed correctly
*
         IF( LSAME( PIVROC, 'C' ) ) THEN
            CALL PDLAPV2( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IPIV,
     $                    IP, JP, DESCIP )
*
*        Otherwise, we must redistribute IPIV to match PDLAPV2
*
         ELSE
*
*           Take IPIV distributed over row 0, and store it in
*           iwork, distributed over column 0
*
            IPT = MOD( JP-1, DESCIP(4) )
            DESCPT(1) = N + IPT + NPROW*DESCIP(4)
            DESCPT(2) = 1
            DESCPT(3) = DESCIP(4)
            DESCPT(4) = 1
            DESCPT(5) = INDXG2P( IA, DESCA(3), IA, DESCA(5), NPROW )
            DESCPT(6) = MYCOL
            DESCPT(7) = ICTXT
            DESCPT(8) = NUMROC( DESCPT(1), DESCPT(3), MYROW, DESCPT(5),
     $                          NPROW )
            ITMP = NUMROC( DESCIP(2), DESCIP(4), MYCOL, DESCIP(6),
     $                     NPCOL )
            CALL INFOG2L( IP, JP-IPT, DESCIP, NPROW, NPCOL, MYROW,
     $                    MYCOL, IIP, JJP, ICURROW, ICURCOL )
            CALL PIROW2COL( ICTXT, N+IPT, 1, DESCIP(4), IPIV(JJP), ITMP,
     $                      IWORK, DESCPT(8), 0, ICURCOL, DESCPT(5),
     $                      MYCOL, IWORK(DESCPT(8)-DESCPT(3)+1) )
*
*           Send column-distributed pivots to all columns
*
            ITMP = DESCPT(8) - DESCPT(3)
            IF( MYCOL.EQ.0 ) THEN
               CALL IGEBS2D( ICTXT, 'Row', ' ', ITMP, 1, IWORK, ITMP )
            ELSE
               CALL IGEBR2D( ICTXT, 'Row', ' ', ITMP, 1, IWORK, ITMP,
     $                       MYROW, 0 )
            END IF
*
*           Adjust pivots so they are relative to the start of IWORK,
*           not IPIV
*
            IPT = IPT + 1
            DO 10 I = 1, ITMP
               IWORK(I) = IWORK(I) - JP + IPT
   10       CONTINUE
            CALL PDLAPV2( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IWORK,
     $                    IPT, 1, DESCPT )
         END IF
*
*     Otherwise, we're pivoting the columns of sub( A )
*
      ELSE
         IF( M.LT.1 .OR. N.LE.1 )
     $      RETURN
*
*        If the pivot vector is already distributed correctly
*
         IF( LSAME( PIVROC, 'R' ) ) THEN
            CALL PDLAPV2( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IPIV,
     $                    IP, JP, DESCIP )
*
*        Otherwise, we must redistribute IPIV to match PDLAPV2
*
         ELSE
*
*           Take IPIV distributed over column 0, and store it in
*           iwork, distributed over row 0
*
            JPT = MOD( IP-1, DESCIP(3) )
            DESCPT(1) = 1
            DESCPT(2) = M + JPT + NPCOL*DESCIP(3)
            DESCPT(3) = 1
            DESCPT(4) = DESCIP(3)
            DESCPT(5) = MYROW
            DESCPT(6) = INDXG2P( JA, DESCA(4), JA, DESCA(6), NPCOL )
            DESCPT(7) = ICTXT
            DESCPT(8) = 1
            CALL INFOG2L( IP-JPT, JP, DESCIP, NPROW, NPCOL, MYROW,
     $                    MYCOL, IIP, JJP, ICURROW, ICURCOL )
            ITMP = NUMROC( M+JPT, DESCPT(4), MYCOL, DESCPT(6),
     $                     NPCOL )
            CALL PICOL2ROW( ICTXT, M+JPT, 1, DESCIP(3), IPIV(IIP),
     $                      DESCIP(8), IWORK, MAX(1, ITMP), ICURROW, 0,
     $                      0, DESCPT(6), IWORK(ITMP+1) )
*
*           Send row-distributed pivots to all rows
*
            IF( MYROW.EQ.0 ) THEN
               CALL IGEBS2D( ICTXT, 'Column', ' ', ITMP, 1, IWORK,
     $                       ITMP )
            ELSE
               CALL IGEBR2D( ICTXT, 'Column', ' ', ITMP, 1, IWORK,
     $                       ITMP, 0, MYCOL )
            END IF
*
*           Adjust pivots so they are relative to the start of IWORK,
*           not IPIV
*
            JPT = JPT + 1
            DO 20 I = 1, ITMP
               IWORK(I) = IWORK(I) - IP + JPT
   20       CONTINUE
            CALL PDLAPV2( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IWORK,
     $                    1, JPT, DESCPT )
         END IF
      END IF
*
      RETURN
*
*     End of PDLAPIV
*
      END
