      SUBROUTINE PBDDZRO1( M, N, NZ, A, LDA, MINT, NINT, NEN )
*
*  -- PB-BLAS auxiliary routine (version 2.0) --
*     Oak Ridge National Laboratory and University of Tennessee
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER              LDA, M, N, NZ, MINT, NINT, NEN
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION     A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*     PBDDZRO1 selects diagonal elements and makes them ZERO.
*
*     ..
*     .. Parameters ..
      DOUBLE PRECISION   ZERO
      PARAMETER        ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, J, JP, MN
*     ..
*     .. External Functions ..
      INTEGER            ICEIL
      EXTERNAL           ICEIL
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      JP = 0
      MN = M
*
      DO 10 J = 1, N-NZ
         A( MN+J, JP+J ) = ZERO
   10 CONTINUE
      MN = MN + MINT - NZ
      JP = JP + NINT - NZ
*
      DO 30 I = 2, ICEIL( NEN+NZ, NINT )
         DO 20 J = 1, MIN( N, NEN-JP )
            A( MN+J, JP+J ) = ZERO
   20    CONTINUE
         MN = MN + MINT
         JP = JP + NINT
   30 CONTINUE
*
      RETURN
*
*     End of PBDDZRO1
*
      END
