      SUBROUTINE LSTSQ(K,XN,TN,RINF,XN12,PER)
C
C **********************************************************************
C
C   forms least squares fit of straight line to data received so far.
C        input data in pairs (n,tn). graph is drawn of tn (ordinate)
C        against n (abscissa).  best straight line fitted described
C        by the output parameters rinf and xn12
C
C        k - =0 to initialize, =1 to fit line
C        xn - vector length
C        tn - time per vector operation of above length
C        rinf - inverse slope of best line using all data received
C        xni2 - negative intercept of best line on n-axis
C        per - percentage error
C
C ----------------------------------------------------------------------
C
      INTEGER K
      DOUBLE PRECISION XN,TN,RINF,XN12,PER
C
      DOUBLE PRECISION SI,STI,STI2,SNI,SNI2,STINI,XB,YB
      SAVE SI,STI,STI2,SNI,SNI2,STINI,XB,YB
      DOUBLE PRECISION TI,RMSE,DENOM,ARG,XNI
      INTEGER MODE,KBPNT,NSI
C
      MODE=0
C
C  mode=0  for least squares fit of all data
C      =1  least squres forced through the kbpntth data point received
C
      KBPNT=1
C
C  values at the kbpnt point are stored in (xb,yb) in double precision
C
      IF( K.EQ.0 )THEN
         SI=0.0d0
         STI=0.0d0
         STI2=0.0d0
         SNI=0.0d0
         SNI2=0.0d0
         STINI=0.0d0
         PER=0.0d0
         RETURN
      ENDIF
C
C     /* Take new data and update sums */
C
      XNI=XN
      TI=TN
      SI=SI+1
      NSI=SI
      STI=STI+TI
      STI2=STI2+TI*TI
      SNI=SNI+XNI
      SNI2=SNI2+XNI*XNI
      STINI=STINI+TI*XNI
C
C
C
      IF( NSI.EQ.KBPNT )THEN
C
C        /* Save values of (xb,yb) */
C
         XB=XNI
         YB=TI
      ENDIF
C
C
C
      IF( NSI.LT.2 )THEN
         RINF=0.0d0
         XN12=0.0d0
         RMSE=0.0d0
      ELSE
C
C        /* Calculate new rinf and n1/2 */
C
         DENOM=SI*STINI-STI*SNI
         IF( DENOM.EQ.0.0d0 )THEN
            RINF=0.0d0
            XN12=0.0d0
            RMSE=0.0d0
         ELSE
            IF( MODE.EQ.0 )THEN
               RINF=(SI*SNI2-SNI*SNI)/DENOM
               XN12=(STI*SNI2-STINI*SNI)/DENOM
            ELSEIF( MODE.EQ.1 )THEN
               RINF=(SNI2-2.0D0*XB*SNI+XB*XB*SI)/
     &               (STINI-XB*STI-YB*SNI+YB*XB*SI)
               XN12=YB*RINF-XB
            ENDIF
C
C
C
            ARG=(STI2-(STINI+XN12*STI)/RINF)/SI
            IF( ARG.GE.0 )THEN
               RMSE=DSQRT(ARG)
            ELSE
               RMSE=-DSQRT(-ARG)
            ENDIF
         ENDIF
      ENDIF
C
C     /* Update percentage errors */
C
      IF( NSI.GT.2 )THEN
         PER=100.0*RMSE/TI
      ENDIF
C
      RETURN
      END
