      SUBROUTINE GETOPT(IOUNIT,INFILE,NP,NSLAVE,NSBYTE,USE0,MTIME,
     &     MAXLEN,INFO)
C
      CHARACTER*20  INFILE

C     /* Get user's options: slave process, length of short messages */
C     /* The number of processes is an input parameter in this */
C
      INTEGER IOUNIT,MAXLEN,NP,NSLAVE,NSBYTE,INFO
C
C     /* Ignore zero length messages in least squares fitting? */
C
      LOGICAL USE0
C
C     /* Measurement time desired for each test case */
C
      DOUBLE PRECISION MTIME
C
      PRINT *
      PRINT *,'           General Pingpong Test'
      PRINT *,'           ---------------------'
      PRINT *
      PRINT *,'Number of processes =',NP
      INFO = 0 
C
C     Get parameters from input file
C
      OPEN( UNIT=IOUNIT, FILE=INFILE, STATUS='OLD' )
C
      READ( IOUNIT,FMT = * ) 
C
      READ( IOUNIT,FMT = * )NSLAVE
      IF( NP.EQ.2 )THEN
         NSLAVE = 1
      ELSE
         PRINT *
         PRINT *,'The master process, number 0, communicates with a'
         PRINT *,'slave with a number in the range 1 to ',NP-1,'.'
         PRINT *,'Number 1 is the nearest neighbour.'
         IF( NSLAVE.LT.1 .OR. NSLAVE.GT.NP-1 )THEN
            PRINT *,'The slave process value ',NSLAVE,' is invalid.'
            PRINT *,'Try again:  1 <= slave number <= ',NP-1
            INFO = -1
            RETURN
         ENDIF
      ENDIF
      PRINT *,'Slave number = ',NSLAVE
      PRINT *
      PRINT *,'On some systems short and long messages are treated',
     &        ' differently.'
      READ( IOUNIT,FMT = * )NSBYTE
      IF( NSBYTE.LT.0 .OR. NSBYTE.GT.MAXLEN )THEN
         PRINT *,'The number of bytes value ', NSBYTE, ' is invalid.'
         PRINT *,'Try again: 0 <= short message length <= ',MAXLEN
         INFO = -1
         RETURN
      ENDIF
      IF( NSBYTE.NE.0 )THEN
         PRINT *,'The longest short message is ',NSBYTE,' bytes.'
      ELSE
         PRINT *,'No distinction will be made between long and short',
     &           ' messages.'
      ENDIF
C
      PRINT *
      READ( IOUNIT,FMT = * )USE0
      IF( USE0 )THEN
         PRINT *,'Zero length messages will be used in least ',
     &           'squares fitting.'
      ELSE
         PRINT *,'Zero length messages will be ignored in least ',
     &           'squares fitting.'
      ENDIF
C
      PRINT *
      READ( IOUNIT,FMT = * )MTIME
      PRINT *,'Loop overhead and communication time are both measured'
      PRINT *,'per test case, so run time is twice the measured time.'
      PRINT *
      PRINT *,'Run time per test case is approx ',MTIME*2,' seconds.'
      PRINT *
C
      CLOSE( IOUNIT )
C
      RETURN
      END
