#include "Bdef.h"


#if (INTFACE == C_CALL)
void Ccgsum2d(ConTxt, scope, top, m, n, A, lda, rdest, cdest)
int  ConTxt;
char  *scope;
char  *top;
int  m;
int  n;
float  *A;
int  lda;
int  rdest;
int  cdest;
#else
void cgsum2d_(ConTxt, scope, top, m, n, A, lda, rdest, cdest)
int  *ConTxt;
char  *scope;
char  *top;
int  *m;
int  *n;
float  *A;
int  *lda;
int  *rdest;
int  *cdest;
#endif
/*
 *  -- V1.0 BLACS routine --
 *  University of Tennessee, February 28, 1995
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Combine sum operation for complex rectangular matrices.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination of the sum.
 *          If rdest == -1, then result is left on all processes in scope.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination of the sum.
 *          If rdest == -1, then CDEST ignored.
 *
 * ------------------------------------------------------------------------
 */
{
   void tree_comb();
   void BE_comb();
   void cgpk4op();
   void cgupk4op();
   void cgupk_sum();
   void cpack00();
   void cunpack00();
   char *getbuff();
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
/*
 *  Variable Declarations
 */
   MATINFO MatInf;
   char *buff;
   BLACSCONTEXT *ctxt;
   char ttop, tscope;
   int length, tlda, trdest;

   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);

   if (Mpval(cdest) == -1) trdest = -1;
   else trdest = Mpval(rdest);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_COMB, __FILE__, tscope, 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, &trdest, Mpaddress(cdest));
#endif
   if (Mpval(lda) >= Mpval(m)) tlda = Mpval(lda);
   else tlda = Mpval(m);

   MatInf.M = Mpval(m);
   MatInf.N = Mpval(n);
   MatInf.A = (char *) A;
   MatInf.lda = tlda;
   if (Mpval(m) != 1) length = Mpval(m) * sizeof(SCOMPLEX);
   else length = Mpval(n) * sizeof(SCOMPLEX);
   buff = getbuff(length);


   switch(ttop)
   {
   case ' ':
      tree_comb(ctxt, tscope, 2, &MatInf, buff, trdest, Mpval(cdest),
                cgpk4op, cgupk4op, cgupk_sum);
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      tree_comb(ctxt, tscope, ttop-47, &MatInf, buff, trdest, Mpval(cdest),
                cgpk4op, cgupk4op, cgupk_sum);
      break;
   case 'f':
      tree_comb(ctxt, tscope, FULLCON, &MatInf, buff, trdest, Mpval(cdest),
                cgpk4op, cgupk4op, cgupk_sum);
      break;
   case 't':
      tree_comb(ctxt, tscope, ctxt->nbranches, &MatInf, buff, trdest,
                Mpval(cdest), cgpk4op, cgupk4op, cgupk_sum);
      break;
   case 'h':
/*
 *    Use bidirectional exchange if everyone wants answer
 */
      if (trdest == -1)
         BE_comb(ctxt, tscope, &MatInf, buff, cgpk4op, cgupk4op, cgupk_sum);
      else
         tree_comb(ctxt, tscope, 2, &MatInf, buff, trdest, Mpval(cdest),
                   cgpk4op, cgupk4op, cgupk_sum);
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

}
