      integer function pvmtype(mpitype)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer mpitype

      if ( mpitype .eq. MPI_INTEGER )          THEN 
         PVMTYPE = INTEGER4
      else if ( mpitype .eq. MPI_DOUBLE_PRECISION ) THEN 
         PVMTYPE = REAL8 
      else if ( mpitype .eq. MPI_DOUBLE_COMPLEX )   THEN 
         PVMTYPE = COMPLEX16
      else if ( mpitype .eq. MPI_BYTE )             THEN 
         PVMTYPE = BYTE1
      else if ( mpitype .eq. MPI_REAL )             THEN 
         PVMTYPE = REAL4
      else if ( mpitype .eq. MPI_COMPLEX )          THEN 
         PVMTYPE = COMPLEX8
      else 
         write(6,*) ' ERROR: do not know pvm data type for: ', mpitype
      endif

      return
      end

      subroutine BUFFCOPY(INBUF,OUTBUF,NITEMS,DATATYPE)

      INCLUDE 'mpi2pvm.h'

      integer nitems, datatype, length, ibyte

      integer inbuf(*), outbuf(*)

      if ( DATATYPE .eq. MPI_DOUBLE_PRECISION ) THEN 
         LENGTH = 2
      else if ( DATATYPE .eq. MPI_DOUBLE_COMPLEX )   THEN 
         LENGTH = 4 
      else if ( DATATYPE .eq. MPI_INTEGER )   THEN 
         LENGTH = 1 
      else 
         write(6,*) ' ERROR: do not know how to copy data type: ',
     f        datatype
      ENDIF
CDEBUG2      write(6,*) ' Buffercopy, Length : ',length
CDEBUG3      write(6,*) ' Buffercopy, type ,dp,dc : ',
CDEBUG3     f     datatype, MPI_double_precision, MPI_double_complex

      do 100 ibyte=1,nitems*LENGTH
         outbuf(ibyte) = inbuf(ibyte)
 100  continue

      return
      end


      subroutine mpi_isend(BUF, COUNT, DATATYPE, 
     f                     DEST, TAG, COMM, REQUEST, IERROR)

      INCLUDE 'mpi2pvm.h'

      INTEGER BUF(*)
      INTEGER COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR, INFO
 
      INTEGER PVMTYPE, PVMTAG
      EXTERNAL PVMTYPE

CDEBUG1      write (6,*) ' begin of mpi_send , me, dest: ',me(comm),dest
CDEBUG2      write (6,*) ' mpi_send: count,dt,dest,tag,comm : ',
CDEBUG2     f     count,PVMTYPE(datatype),dest,tag,comm
CDEBUG3      write (6,*) ' send: buffer ',(buf(i),i=1,4)
CDEBUG1      call flush(6)

      PVMTAG = maxcom*tag + comm

      CALL PVMFPSEND (TIDS(DEST,comm), PVMTAG, BUF, COUNT,
     f     PVMTYPE(DATATYPE), INFO)

Cnop      CALL PVMFINITSEND (PVMDEFAULT, INFO)
Cnop      CALL PVMFPACK (PVMTYPE(DATATYPE), BUF, COUNT, 1, INFO)
Cnop      CALL PVMFSEND (TIDS(DEST,comm), PVMTAG, INFO)

      request = 0
      
CDEBUG1      write (6,*) ' mpi_isend end: '
CDEBUG1      call flush(6)

      return
      end  

      subroutine mpi_irecv(BUF, COUNT, DATATYPE, 
     f                     SOURCE, TAG, COMM, REQUEST, IERROR)

      INCLUDE 'mpi2pvm.h'

      INTEGER BUF(*)
      INTEGER COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR 
 
Cnop      INTEGER PVMTAG, ibuf
      INTEGER PVMTYPE, i
      EXTERNAL PVMTYPE

cnop      PVMTAG = maxcom*tag + comm

cnop      CALL PVMFRECV (TIDS(SOURCE,comm), PVMTAG, ibuf)
cnop      CALL PVMFUNPACK (PVMTYPE(DATATYPE), BUF, COUNT, 1, INFO)
cnop      CALL PVMFFREEBUF (ibuf, INFO)

      request=0
      do 100 i=1,maxreq
         if (req_buf(1,i) .eq. 0) then
            request = i
            goto 101
         endif
 100  Continue

      write(6,*) 'Error:  IRECV out of req_buf '
CDEBUG1      call flush(6)
      stop
 101  continue

      req_buf(1,request) = 1
      req_buf(2,request) = COUNT
      req_buf(3,request) = DATATYPE
      req_buf(4,request) = SOURCE
      req_buf(5,request) = TAG
      req_buf(6,request) = COMM

CDEBUG1      write (6,*) ' irecv: count,dt,source,tag,comm : ',
CDEBUG1     f     count,datatype,source,tag,comm
CDEBUG2      write (6,*) ' irecv begin: buf(1) ',buf(1)
CDEBUG1      call flush(6)

      call fpointer_set (buf,request)

CDEBUG2      write (6,*) ' irecv end  : buf(1) ',buf(1)
CDEBUG2      call flush(6)

      return
      end

      subroutine mpi_comm_split(COMM,color,node,comm_setup,ierror)
      implicit none

C     Creates only one second communicator=1!

      INCLUDE 'mpi2pvm.h'

      INTEGER COMM, color, node, comm_setup, ierror, ibuf
      INTEGER gid, info, oldcomm, newcomm, i

      oldcomm = numcom 
      numcom = numcom + 1
      newcomm = numcom

      group(newcomm) = 'ACTIVE'

      if (color .eq. 0) then
         comm_setup = 1
         CALL PVMFJOINGROUP(GROUP(newcomm),ME(newcomm))
         IF( ME(newcomm) .LT. 0 ) 
     f        WRITE(6,*) ' joingroup error, INUM <0, INUM=',ME(newcomm)
      endif

CDEBUG1      Write (6,*) ' comm_split: ',me(0),me(newcomm),color
CDEBUG1      call flush(6)


C     ======================
C     Now the group should be established
C     We synchronise using WORLD!

      CALL PVMFBARRIER(GROUP(0),NNODES,INFO)
      IF( INFO.LT.0 ) WRITE(6,*) 'ERROR: pvmfbarrier returned ',INFO  

      if (color .ne. 0) return

      me(newcomm) = me(oldcomm)
      mastid(newcomm) = mastid(oldcomm)

      IF( ME(newcomm) .EQ. 0 ) THEN
  
         CALL PVMFGSIZE( GROUP(newcomm), gsize(newcomm))
         CALL PVMFPACK (ITYPE, gsize(newcomm), 1, 1, INFO)
         CALL PVMFMCAST (gsize(newcomm), TIDS(0,oldcomm), 6, INFO)

      ELSE

         CALL PVMFRECV(MASTID(newcomm),6,ibuf)
         CALL PVMFUNPACK(ITYPE,gsize(newcomm),1,1,INFO)
         CALL PVMFFREEBUF (ibuf, INFO)

      ENDIF

      do 100 i=-1,gsize(newcomm)-1
         tids(i,newcomm) =  tids(i,oldcomm)
 100  continue

CDEBUG1      write(6,*) ' mpi_comm_dup end: newcomm, me ',
CDEBUG1     f      newcomm, me(newcomm)
CDEBUG1      call flush(6)

CC     Collect TIDS from other processes.
C      
C      IF( ME(1) .EQ. 0 ) THEN  
C
C         MASTID(1) = MYTID
C         CALL PVMFGSIZE( GROUP(1), gsize(1))
CCDEBUG1       Write (6,*) ' comm_split: gsize(1)  ' ,gsize(1)
CCDEBUG1      call flush(6)
C        DO 100 GID=0,gsize(1)-1   
C            CALL PVMFGETTID(GROUP(1), GID, TIDS(GID,1))
CCDEBUG1       Write (6,*) ' comm_split: tids ', TIDS(gid,1)
CCDEBUG1      call flush(6)
C               IF (INFO .LT. 0) THEN
C               WRITE(6,*) ' pvmgettid error, INFO < 0, INFO = ',INFO
C               CALL PVMFLVGROUP(GROUP(1),INFO)
C               CALL PVMFEXIT(INFO)
C               STOP
C            ENDIF
C 100     CONTINUE
C
CC     /* Send all processor ids to each node */
C         
C         CALL PVMFINITSEND (PVMDEFAULT, INFO)
C         CALL PVMFPACK (ITYPE, gsize(1), 1, 1, INFO)
C         CALL PVMFPACK (ITYPE, TIDS(0,1), gsize(1), 1, INFO)
C         CALL PVMFMCAST (gsize(1), TIDS(0,1), 6, INFO)
C
C      ELSE
C
C         CALL PVMFGETTID(GROUP(1), 0, MASTID(1))
C         IF (MASTID(1) .LT. 0) THEN
C            WRITE(6,*) ' pvmgettid error, MASTID < 0, MASTID = ',
C     f           MASTID(1)
C            CALL PVMFLVGROUP(GROUP(1),INFO)
C            CALL PVMFEXIT(INFO)
C            STOP
C         ENDIF
C
C         CALL PVMFRECV(MASTID(1),6,ibuf)
C         CALL PVMFUNPACK(ITYPE,gsize(1),1,1,INFO)
C         CALL PVMFUNPACK(ITYPE,TIDS(0,1),gsize(1),1,INFO)
C         CALL PVMFFREEBUF (ibuf, INFO)
C
C      ENDIF
C
C      TIDS(-1,1) = -1
C      NUMCOM = NUMCOM + 1

      return
      end

      subroutine mpi_comm_rank(comm, rank)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer comm, rank

      rank = ME(COMM)
CDEBUG1      write (6,*) ' end of mpi_comm_rank , rank = ',rank
CDEBUG1      call flush(6)

      return
      end

      subroutine mpi_comm_size(comm, size)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer comm, size

      size = gsize(comm)
CDEBUG1      write (6,*) ' end of mpi_comm_size , size = ',size
CDEBUG1      call flush(6)

      return
      end

      double precision function mpi_wtime()
      implicit none
      double precision dwalltime00
      EXTERNAL dwalltime00
c This function must measure wall clock time, not CPU time. 
c Since there is no portable timer in Fortran (77)
c we call a routine compiled in C (though the C source may have
c to be tweaked). 
CC      call wtime(t)
c The following is not ok for "official" results because it reports
c CPU time not wall clock time. It may be useful for developing/testing
c on timeshared Crays, though. 
c     call second(t)

      mpi_wtime = dwalltime00()

      return
      end


      subroutine mpi_barrier(comm, info)
      implicit none
      
      INCLUDE 'mpi2pvm.h'

      INTEGER comm, info, size

CDEBUG1      write (6,*) ' MPI_BARRIER reached, me :',me(comm)
CDEBUG1      call flush(6)

      call pvmfbarrier( group(comm), gsize(comm), info)

CDEBUG1      WRITE(6,*) ' end of mpi_barrier, comm, group, size: ',
CDEBUG1     f     comm, group(comm), gsize(comm)
CDEBUG1      call flush(6)

      return
      end

      subroutine mpi_bcast(buf, nitems, datatype, root, comm, ierr)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer buf(*), nitems, datatype, root, comm, ierr, info

      INTEGER  PVMTYPE, ibuf, dest, atid, atag, alen
      EXTERNAL PVMTYPE

CDEBUG1      write(6,*) ' mpi_bcast begin: ', me(comm),nitems,root,comm
CDEBUG1      call flush(6)

      IF( ME(comm) .EQ. root ) THEN  

Cnop         CALL PVMFINITSEND (PVMDEFAULT, INFO)
Cnop         CALL PVMFPACK (PVMTYPE(DATATYPE), BUF, nitems, 1, INFO)
Cnop         CALL PVMFMCAST (gsize(comm), TIDS(0,comm), 7, INFO)

         do 100 dest=0,me(comm)-1
            CALL PVMFPSEND (TIDS(DEST,comm), 7, BUF, nitems,
     f           PVMTYPE(DATATYPE), INFO)
 100     continue
         do 120 dest=me(comm)+1,gsize(comm)-1
            CALL PVMFPSEND (TIDS(DEST,comm), 7, BUF, nitems,
     f           PVMTYPE(DATATYPE), INFO)
 120     continue


      ELSE

Cnop         CALL PVMFRECV (TIDS(root,comm), 7, ibuf)
Cnop         CALL PVMFUNPACK (PVMTYPE(DATATYPE), BUF, nitems, 1, INFO)
Cnop         CALL PVMFFREEBUF (ibuf, INFO)

         CALL PVMFPRECV (TIDS(root,comm), 7, BUF, nitems,
     f        PVMTYPE(DATATYPE), atid, atag, alen, INFO)


      ENDIF

CDEBUG1      write(6,*) ' mpi_bcast end: ', me(comm)
CDEBUG2      write (6,*) ' mpi_bcast end, me, buf ', me(comm), buf(1)
CDEBUG1      call flush(6)
CDEBUG1      call pvmfbarrier( group(comm), gsize(comm), info)


      return
      end

      subroutine mpi_comm_dup(oldcomm, newcomm, ierror)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer oldcomm, newcomm, ierror, i

      numcom = numcom + 1
      newcomm = numcom

      group(newcomm) = group(oldcomm)

      gsize(newcomm) = gsize(oldcomm)
      me(newcomm) = me(oldcomm)
      mastid(newcomm) = mastid(oldcomm)
      do 100 i=-1,gsize(newcomm)-1
         tids(i,newcomm) =  tids(i,oldcomm)
 100  continue

CDEBUG1      write(6,*) ' mpi_comm_dup end: newcomm, me ',
CDEBUG1     f      newcomm, me(newcomm)
CDEBUG1      call flush(6)

      return
      end

      subroutine mpi_abort(comm, errcode, ierr)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer comm, errcode, ierr, i

      write(6,*)  'mpi_abort called'
CDEBUG1      call flush(6)

      do 100 i=0,gsize(comm)-1
         if (me(comm) .ne. i) call pvmfkill(tids(i,comm),ierr)
 100  continue

      call pvmfexit()
      stop

      end

      subroutine mpi_finalize(info)

      INCLUDE 'mpi2pvm.h'

      integer info

CDEBUG1      call flush(6)
      CALL PVMFBARRIER(GROUP(0), gsize(0), INFO)

      call pvmfexit(info)

      return
      end

      subroutine mpi_init(ierr)

      INCLUDE 'mpi2pvm.h'

      integer  ierr, i

      INTEGER  GID

      INTEGER  INFO, ibuf

C     Get the number of processes
      CALL NUMPROC(NNODES)
      gsize(0) = nnodes
      group(0) = 'WORLD'
CDEBUG1      WRITE(6,*) ' nnodes = ',nnodes
CDEBUG1      call flush(6)

C      CALL PVMFCATCHOUT(1)

C     ======================
C     Register process to PVM.

      CALL PVMFMYTID( MYTID )
      IF( MYTID .LT. 0 ) Then
         WRITE(6,*) ' MYTID failed, MYTID <0, MYTID=',MYTID
         WRITE(6,*) ' Please check if pvmd is running!'
         stop
      endif
CDEBUG1      WRITE(6,*) ' MYTID = ',MYTID
CDEBUG1      call flush(6)
      CALL PVMFJOINGROUP(GROUP(0),ME(0))
      IF (ME(0) .LT. 0) WRITE(6,*) ' joingroup error, INUM <0, INUM=',ME(0)
CDEBUG1      WRITE(6,*) ' ME(0) = ',ME(0)
CDEBUG1      call flush(6)

C     ======================
C     Now the group should be established

      CALL PVMFBARRIER(GROUP(0),NNODES,INFO)
      IF( INFO.LT.0 ) WRITE(6,*) 'ERROR: pvmfbarrier returned ',INFO  

C     Collect TIDS from other processes.
      
      IF( ME(0) .EQ. 0 ) THEN  

         MASTID(0) = MYTID
         DO 100 GID=0,NNODES-1   
            CALL PVMFGETTID(GROUP(0), GID, TIDS(GID,0))
            IF (INFO .LT. 0) THEN
               WRITE(6,*) ' pvmgettid error, INFO < 0, INFO = ',INFO
               CALL PVMFLVGROUP(GROUP(0),INFO)
               CALL PVMFEXIT(INFO)
               STOP
            ENDIF
 100     CONTINUE

C     /* Send all processor ids to each node */

         CALL PVMFINITSEND(PVMDEFAULT,INFO )
         CALL PVMFPACK(ITYPE,NNODES,1,1,INFO)
         CALL PVMFPACK(ITYPE,TIDS(0,0),NNODES,1,INFO)
         CALL PVMFMCAST(NNODES,TIDS(0,0),5,INFO)

      ELSE

         CALL PVMFGETTID(GROUP(0), 0, MASTID(0))
         IF (MASTID(0) .LT. 0) THEN
            WRITE(6,*) ' pvmgettid error, MASTID < 0, MASTID = ',
     f           MASTID(0)
            CALL PVMFLVGROUP(GROUP(0),INFO)
            CALL PVMFEXIT(INFO)
            STOP
         ENDIF

CDEBUG2         write(6,*) ' ready to receive init data: ', me(0)
CDEBUG2         call flush(6)

         CALL PVMFRECV(MASTID(0),5,ibuf)
         CALL PVMFUNPACK(ITYPE,NNODES,1,1,INFO)
         CALL PVMFUNPACK(ITYPE,TIDS(0,0),NNODES,1,INFO)
         CALL PVMFFREEBUF (ibuf, INFO)

CDEBUG2         write(6,*) ' received init data: ', me(0)
CDEBUG2         call flush(6)

      ENDIF

      TIDS(-1,0) = -1
      NUMCOM = 0

      do 200 i=1,maxreq
 200     req_buf(1,i) = 0

CDEBUG1      WRITE(6,*) ' end of mpi_init '
CDEBUG1      call flush(6)

      return
      end


      subroutine mpi_reduce(inbuf, outbuf, nitems, 
     $                      datatype, op, root, comm, ierr)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer nitems, datatype, op, root, comm, ierr, tag
      double precision inbuf(*), outbuf(*)

      INTEGER  PVMTYPE, info
      EXTERNAL PvmSum, PvmMax, PvmMin, PVMTYPE

Cxxxxx      CALL PVMFBARRIER(GROUP(comm), gsize(comm), INFO)

CDEBUG1      write (6,*) ' mpi_reduce beg me(comm) : ', me(comm)
CDEBUG2      write (6,*) ' mpi_reduce beg, inbuf, oubuf 1; ',inbuf(1),outbuf(1)
CDEBUG2      write (6,*) ' mpi_reduce beg, inbuf, oubuf 2; ',inbuf(2),outbuf(2)
CDEBUG2      write (6,*) ' datatype ' ,datatype
CDEBUG1      call flush(6)
      CALL BUFFCOPY(INBUF,OUTBUF,NITEMS,DATATYPE)
CDEBUG2      write (6,*) ' mpi_reduce buf, inbuf, oubuf 1; ',inbuf(1),outbuf(1)
CDEBUG2      write (6,*) ' mpi_reduce buf, inbuf, oubuf 2; ',inbuf(2),outbuf(2)

      tag = 111 + op*maxcom

CDEBUG2      write (6,*) '  mpi_reduce , op, mpi-sum, mpi_max = ',
CDEBUG2     f     op, MPI_SUM, MPI_MAX
CDEBUG2      call flush(6)
      if ( OP .eq. MPI_SUM )          THEN 
         CALL PVMFREDUCE(PvmSum, OUTBUF, nitems, PVMTYPE(DATATYPE), 
     f        tag, group(comm), root, ierr) 
CDEBUG3      write (6,*) '  mpi_reduce , op, mpi-sum '
CDEBUG3      call flush(6)
      else if ( OP .eq. MPI_MAX ) THEN 
CDEBUG3      write (6,*) '  mpi_reduce , op, mpi-max '
CDEBUG3      call flush(6)
         CALL PVMFREDUCE(PvmMax, OUTBUF, nitems, PVMTYPE(DATATYPE), 
     f        tag, group(comm), root, ierr) 
      else if ( OP .eq. MPI_MIN ) THEN 
         CALL PVMFREDUCE(PvmMin, OUTBUF, nitems, PVMTYPE(DATATYPE), 
     f        tag, group(comm), root, ierr) 
CDEBUG3      write (6,*) '  mpi_reduce , op, mpi-min '
CDEBUG3      call flush(6)
      else 
         write(6,*) ' ERROR: do not know pvm operation  for: ', op
      endif
CDEBUG2      write (6,*) ' mpi_reduce end, inbuf, oubuf 1; ',inbuf(1),outbuf(1)
CDEBUG2      write (6,*) ' mpi_reduce end, inbuf, oubuf 2; ',inbuf(2),outbuf(2)
CDEBUG1      write (6,*) ' mpi_reduce end me(comm) : ', me(comm)
CDEBUG1      call flush(6)

Cxxxxx      CALL PVMFBARRIER(GROUP(comm), gsize(comm), INFO)

      return
      end

      subroutine mpi_allreduce(inbuf, outbuf, nitems, 
     $                      datatype, op, comm, ierr)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer nitems, datatype, op, comm, ierr, info
      double precision inbuf(*), outbuf(*)

      integer  PVMTYPE, ibuf, dest, atid, atag, alen
      EXTERNAL PVMTYPE

CDEBUG1      write (6,*) ' mpi_allreduce beg, me(comm) ; ', me(comm)
CDEBUG1      call flush(6)

      call mpi_reduce(inbuf, outbuf, nitems, 
     $                      datatype, op, 0, comm, ierr)

      if (me(comm) .eq. 0) then
Cnop         CALL PVMFINITSEND(PVMDEFAULT,INFO )
Cnop         CALL PVMFPACK(PVMTYPE(DATATYPE),outbuf,nitems,1,INFO)
Cnop         CALL PVMFMCAST(gsize(comm),TIDS(0,comm),0,INFO)

         do 120 dest=1,gsize(comm)-1
            CALL PVMFPSEND (TIDS(DEST,comm), 7, outbuf, nitems,
     f           PVMTYPE(DATATYPE), INFO)
 120     continue


      ELSE
Cnop         CALL PVMFRECV (MASTID(comm), 0, ibuf)
Cnop         CALL PVMFUNPACK (PVMTYPE(DATATYPE), outbuf, nitems, 1, INFO)
Cnop         CALL PVMFFREEBUF (ibuf, INFO)

         CALL PVMFPRECV (MASTID(comm), 7, outbuf, nitems,
     f        PVMTYPE(DATATYPE), atid, atag, alen, INFO)


      ENDIF

CDEBUG1      write (6,*) ' mpi_allreduce end, inbuf, oubuf 1; ',
CDEBUG1     f     inbuf(1),outbuf(1)
CDEBUG1      call flush(6)

      return
      end

      subroutine mpi_alltoall(inbuf, nitems, type, outbuf, nitems_dum, 
     $                        type_dum, comm, ierr)
      implicit none

      INCLUDE 'mpi2pvm.h'

      integer nitems, type, comm, ierr, nitems_dum, type_dum, 
     f     tag, i, status
      double complex  inbuf(*), outbuf(*)

      tag = 77
      
CDEBUG1      write (6,*) ' begin of alltoall , me: ',me(comm)
CDEBUG1      call flush(6)
      do 100 i=0,me(comm)-1
         call MPI_SEND(inbuf(i*nitems+1), nitems, type, 
     f        i, tag, comm, ierr)
 100  continue

      do 120 i=me(comm)+1,gsize(comm)-1
         call MPI_SEND(inbuf(i*nitems+1), nitems, type, 
     f        i, tag, comm, ierr)
 120  continue


CDEBUG2      write (6,*) ' send done in alltoall , me: ',me(comm)
CDEBUG2      call flush(6)
      do 110 i=1,nitems
         outbuf(me(comm)*nitems+i) = inbuf(me(comm)*nitems+i)
 110  continue
      

      do 200 i=0,me(comm)-1
         call MPI_RECV(outbuf(i*nitems+1), nitems, type, 
     f        i, tag, comm, status, ierr)
 200  continue
      
      do 220 i=me(comm)+1,gsize(comm)-1
         call MPI_RECV(outbuf(i*nitems+1), nitems, type, 
     f        i, tag, comm, status, ierr)
 220  continue
CDEBUG1      write (6,*) ' end of alltoall , me: ',me(comm)
CDEBUG1      call flush(6)
      
      return
      end

      subroutine mpi_send(BUF, COUNT, DATATYPE, 
     f                     DEST, TAG, COMM, IERROR)
      implicit none

      INCLUDE 'mpi2pvm.h'

      double complex   BUF(*)
      INTEGER COUNT, DATATYPE, DEST, TAG, COMM, IERROR , INFO, i
 
      INTEGER PVMTYPE, PVMTAG
      EXTERNAL PVMTYPE

CDEBUG1      write (6,*) ' begin of mpi_send , me, dest: ',me(comm),dest
CDEBUG2      write (6,*) ' mpi_send: count,dt,dest,tag,comm : ',
CDEBUG2     f     count,PVMTYPE(datatype),dest,tag,comm
CDEBUG3      write (6,*) ' send: buffer ',(buf(i),i=1,4)
CDEBUG1      call flush(6)

      PVMTAG = maxcom*tag + comm

      CALL PVMFPSEND (TIDS(DEST,comm), PVMTAG, BUF, COUNT,
     f     PVMTYPE(DATATYPE), INFO)

Cnop      CALL PVMFINITSEND (PVMDEFAULT, INFO)
Cnop      CALL PVMFPACK (PVMTYPE(DATATYPE), BUF, COUNT, 1, INFO)
Cnop      CALL PVMFSEND (TIDS(DEST,comm), PVMTAG, INFO)

CDEBUG1      write (6,*) ' mpi_send end: '
CDEBUG1      call flush(6)

      return
      end
      
      subroutine mpi_recv(BUF, COUNT, DATATYPE, 
     f                     SOURCE, TAG, COMM, status, IERROR)
      implicit none

      INCLUDE 'mpi2pvm.h'

      double complex   BUF(*)
      INTEGER COUNT, DATATYPE, SOURCE, TAG, COMM, status, IERROR 
      INTEGER info, ibuf, atid, atag, alen, i
 
      INTEGER PVMTYPE, PVMTAG
      EXTERNAL PVMTYPE

CDEBUG1      write (6,*) ' begin of mpi_recv , me, source: ',me(comm),source
CDEBUG2      write (6,*) ' mpi_recv: count,dt,source,tag,comm : ',
CDEBUG2     f     count,PVMTYPE(datatype),source,tag,comm
CDEBUG1      call flush(6)

      PVMTAG = maxcom*tag + comm

      CALL PVMFPRECV (TIDS(SOURCE,comm), PVMTAG, BUF, COUNT,
     f     PVMTYPE(DATATYPE), atid, atag, alen, INFO)

Cnop      CALL PVMFRECV (TIDS(SOURCE,comm), PVMTAG, ibuf)
Cnop      CALL PVMFUNPACK (PVMTYPE(DATATYPE), BUF, COUNT, 1, INFO)
Cnop      CALL PVMFFREEBUF (ibuf, INFO)

CDEBUG1      write (6,*) ' mpi_recv end : alen,dt,atid,atag,comm : ',
CDEBUG1     f     count,PVMTYPE(datatype),source,tag,comm
CDEBUG3      write (6,*) ' receive end: alen, buf ', alen, (buf(i),i=1,4)
CDEBUG1      call flush(6)

      return
      end
      
      subroutine mpi_wait(request, status, ierror)
      implicit none

      INCLUDE 'mpi2pvm.h'

      INTEGER BUF(4), status
      INTEGER COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR 
 
      INTEGER PVMTYPE, PVMTAG, ibuf
      EXTERNAL PVMTYPE

      if (request .eq. 0) return

      req_buf(1,request) = 0
      COUNT  = req_buf(2,request) 
      DATATYPE = req_buf(3,request) 
      SOURCE = req_buf(4,request) 
      TAG    = req_buf(5,request) 
      COMM   = req_buf(6,request)

CDEBUG1      write (6,*) ' wait begin : me(comm), comm : ',me(comm), comm
CDEBUG2      write (6,*) ' wait: count,dt,source,tag,comm : ',
CDEBUG2     f     count,datatype,source,tag,comm
CDEBUG1      call flush(6)

      call fpointer_get (request, count, datatype,
     f     source, tag, comm, status, ierror)

CDEBUG1      write (6,*) ' wait end   : me(comm) : ',me(comm)
CDEBUG1      call flush(6)

Cxxxxx      call MPI_RECV(buf, count, datatype, 
Cxxxxx     f     source, tag, comm, status, ierror)

      return
      end

      subroutine mpi_waitall(count, requests, statuses, ierror)
      implicit none

      INCLUDE 'mpi2pvm.h'
      
      INTEGER count, requests(*), statuses(*), ierror , i

CDEBUG1      write (6,*) ' mpi_waitall : me(0) : ',me(0)
CDEBUG1      call flush(6)

      do 100 i =1,count
         call mpi_wait(requests(i), statuses(i), ierror)
 100  continue

      return
      end
