C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C sendrecv.f                                                           C
C                                                                      C
C The following routines implement the following low level             C
C interprocessor communication commands used in PSTSWM using           C
C PVM interprocessor communication commands:                           C
C                                                                      C
C SENDRECV - used in algorithms where sends and receives come in       C
C            logical pairs, for example, when shifting data around a   C
C            ring.                                                     C
C SRBEGIN  - used when initiating a SENDRECV                           C
C SREND    - used when completing a SENDRECV initiated by              C
C            SRBEGIN                                                   C
C SR1      - first of three routines which implement SENDRECV          C
C SRSAFE   - optional companion to SR1 that allows SAFEFORCE           C
C            handshaking to be postponed                               C
C SR2      - second of three routines which implement SENDRECV         C
C SR3      - third of three routines which implement SENDRECV          C
C                                                                      C
C These routines all have the following communication options:         C
C  if (COMMOPT .EQ. 0) simple                                          C
C  if (COMMOPT .EQ. 1) ordered                                         C
C They also have the following communication protocol options:         C
C  if (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send                 C
C  if (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive              C
C  if (PROTOPT .EQ. 4 .OR. 5)         forcetype                        C
C  if (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous                C
C PVM does not provide nonblocking communication commands. Protocol    C
C options involving nonblocking commands will cause the program to     C
C abort.                                                               C
C                                                                      C
C SRBEGIN/SREND and SR1(/SRSAFE)/SR2/SR3 represent different ways of   C
C partitioning the basic SENDRECV routine                              C
C                                                                      C
C Use of SRBEGIN/SREND and SR1/SR2/SR3 allows sends and/or receives    C
C to be completed just before they are needed.                         C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SENDRECV(COMMOPT, PROTOPT, ORDER, ME, MTAG,
     &                    SNDDST, SNDLTH, SNDMSG, RCVSRC, RCVLTH,
     &                    RCVMSG)
C
C This subroutine sends the message in the SNDMSG buffer to SNDDST,
C and receives a message into RCVMSG. 
C
C Communication options (COMMOPT) for SENDRECV include:
C  if (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  if (COMMOPT .EQ. 1) ordered SENDRECV: [send/recv]|[recv/send]
C Communication protocol options (PROTOPT) for SENDRECV include:
C  if (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  if (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  if (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  if (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: RING1, SRTRNS1
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
#     include "fpvm3.h"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C Communication algorithm option
      INTEGER COMMOPT
C communication protocol option 
      INTEGER PROTOPT
C order of send/recv
      INTEGER ORDER
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C message destination
      INTEGER SNDDST
C length of message to be sent
      INTEGER SNDLTH
C message to be sent
      INTEGER SNDMSG(*)
C source of message to be received
      INTEGER RCVSRC
C length of message to be received
      INTEGER RCVLTH
C
C     Output
C
C message received
      INTEGER RCVMSG(*)
C
C---- Local Variables --------------------------------------------------
C
C error return variable
      INTEGER F
C data description parameters
      INTEGER DATATYPE, DATALTH
C
C---- Executable Statements --------------------------------------------
C
C     Get datatype and data length
      CALL DATADESC(DATATYPE, DATALTH)
C
C     Choose communication algorithm.
      IF (COMMOPT .EQ. 0) THEN
C***********************************************************************
C       simple SENDRECV: send/recv
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         simple SENDRECV
          CALL PVMFINITSEND(PVMDEFAULT, F)
          CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
          CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
          CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
          CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
C
        ELSE
C
          WRITE (0,901) COMMOPT, PROTOPT
  901     FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SENDRECV:',/,
     &             ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &             ' COMMOPT = ',I3, ' PROTOPT = ',I3)
          STOP                                                   
C
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 1) THEN
C***********************************************************************
C       ordered SENDRECV:
C       IF (ORDER .EQ. 1) send/recv
C       IF (ORDER .NE. 1) recv/send
C       (Deadlock avoidance is the responsibility of the calling
C        program.)
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         ordered SENDRECV
          IF (ORDER .EQ. 1) THEN
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ELSE
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ENDIF
C
        ELSEIF (PROTOPT .EQ. 6) THEN
C
C         synchronous ordered SENDRECV 
          IF (ORDER .EQ. 1) THEN
            CALL PVMFRECV(TIDS(SNDDST), MTAG, F)
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            IF (SNDDST .NE. RCVSRC) THEN
              CALL PVMFINITSEND(PVMDEFAULT, F)
              CALL PVMFSEND(TIDS(RCVSRC), MTAG, F)
            ENDIF
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ELSE
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFSEND(TIDS(RCVSRC), MTAG, F)
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            IF (SNDDST .NE. RCVSRC)
     &        CALL PVMFRECV(TIDS(SNDDST), MTAG, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ENDIF
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSE
C***********************************************************************
C       undefined SENDRECV option
C***********************************************************************
C
        WRITE (0,900) COMMOPT
  900   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SENDRECV:',/,
     &           ' UNKNOWN COMMUNICATION OPTION SPECIFIED',/, 
     &           ' COMMOPT = ',I3)                                 
        STOP                                                   
C
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SRBEGIN(COMMOPT, PROTOPT, ORDER, ME, MTAG, 
     &                   SNDDST, SNDLTH, SNDMSG, RCVSRC, RCVLTH, 
     &                   RCVMSG)
C
C This subroutine begins a SENDRECV operation that will be completed by
C a SREND. It initiates the sending of the message in the SNDMSG 
C buffer to SNDDST, and the receiving of a message into RCVMSG. 
C Everything is completed except the sendend in the nonblocking
C send option, and the recv or recvend in the delayed-recv option.
C
C Communication options (COMMOPT) for SRBEGIN/END include:
C  IF (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  IF (COMMOPT .EQ. 1) ordered SENDRECV: [send/recv]|[recv/send]
C  IF (COMMOPT .EQ. 2) delayed-recv SENDRECV: send ... recv
C Communication protocol options (PROTOPT) for SRBEGIN/END include:
C  IF (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  IF (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  IF (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  IF (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: SHIFTCAST, SHIFTSUM
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
#     include "fpvm3.h"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C communication algorithm option
      INTEGER COMMOPT
C communication protocol option 
      INTEGER PROTOPT
C order of send/recv
      INTEGER ORDER
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C message destination
      INTEGER SNDDST
C length of message to be sent
      INTEGER SNDLTH
C message to be sent
      INTEGER SNDMSG(*)
C source of message to be received
      INTEGER RCVSRC
C length of message to be received
      INTEGER RCVLTH
C
C     Output
C
C message received
      INTEGER RCVMSG(*)
C
C---- Local Variables --------------------------------------------------
C
C error return variable
      INTEGER F
C data description parameters
      INTEGER DATATYPE, DATALTH
C
C---- Executable Statements --------------------------------------------
C
C     Get datatype and data length
      CALL DATADESC(DATATYPE, DATALTH)
C
C     Choose communication algorithm.
      IF (COMMOPT .EQ. 0) THEN
C***********************************************************************
C       simple SENDRECV: send/recv
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         simple SENDRECV
          CALL PVMFINITSEND(PVMDEFAULT, F)
          CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
          CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
          CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
          CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
C
        ELSE
C
          WRITE (0,901) COMMOPT, PROTOPT
  901     FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SRBEGIN:',/,
     &             ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &             ' COMMOPT = ',I3, ' PROTOPT = ',I3)
          STOP                                                   
C
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 1) THEN
C***********************************************************************
C       ordered SENDRECV:
C       IF (ORDER .EQ. 1) send/recv
C       IF (ORDER .NE. 1) recv/send
C       (Deadlock avoidance is the responsibility of the calling
C        program.)
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         ordered SENDRECV
          IF (ORDER .EQ. 1) THEN
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ELSE
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ENDIF
C
        ELSEIF (PROTOPT .EQ. 6) THEN
C
C         synchronous ordered SENDRECV 
          IF (ORDER .EQ. 1) THEN
            CALL PVMFRECV(TIDS(SNDDST), MTAG, F)
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            IF (SNDDST .NE. RCVSRC) THEN
              CALL PVMFINITSEND(PVMDEFAULT, F)
              CALL PVMFSEND(TIDS(RCVSRC), MTAG, F)
            ENDIF
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ELSE
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFSEND(TIDS(RCVSRC), MTAG, F)
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            IF (SNDDST .NE. RCVSRC)
     &        CALL PVMFRECV(TIDS(SNDDST), MTAG, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ENDIF
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 2) THEN
C***********************************************************************
C       delayed-recv SENDRECV: send ... recv/send ... recv
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         delaying receive of SENDRECV
          CALL PVMFINITSEND(PVMDEFAULT, F)
          CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
          CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSE
C***********************************************************************
C       undefined SENDRECV option
C***********************************************************************
C
        WRITE (0,900) COMMOPT
  900   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SRBEGIN:',/,
     &           ' UNKNOWN COMMUNICATION OPTION SPECIFIED',/, 
     &           ' COMMOPT = ',I3)                                 
        STOP                                                   
C
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SREND(COMMOPT, PROTOPT, ORDER, ME, MTAG, 
     &                 SNDDST, RCVSRC, RCVLTH, RCVMSG)
C
C This subroutine completes the operation started in SRBEGIN. It
C completes any outstanding send and receive requests.
C
C Communication options (COMMOPT) for SRBEGIN/END include:
C  IF (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  IF (COMMOPT .EQ. 1) ordered SENDRECV: [send/recv]|[recv/send]
C  IF (COMMOPT .EQ. 2) delayed-recv SENDRECV: send ... recv
C Communication protocol options (PROTOPT) for SRBEGIN/END include:
C  IF (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  IF (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  IF (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  IF (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: SHIFTCAST, SHIFTSUM
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
#     include "fpvm3.h"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C communication algorithm option
      INTEGER COMMOPT
C communication protocol option 
      INTEGER PROTOPT
C order of send/recv
      INTEGER ORDER
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C message destination
      INTEGER SNDDST
C source of message to be received
      INTEGER RCVSRC
C length of message to be received
      INTEGER RCVLTH
C
C     Output
C
C message received
      INTEGER RCVMSG(*)
C
C---- Local Variables --------------------------------------------------
C
C error return variable
      INTEGER F
C data description parameters
      INTEGER DATATYPE, DATALTH
C
C---- Executable Statements --------------------------------------------
C
C     Get datatype and data length
      CALL DATADESC(DATATYPE, DATALTH)
C
C     Choose communication algorithm.
C
      IF (COMMOPT .EQ. 0) THEN
C***********************************************************************
C       simple SENDRECV: send/recv
C***********************************************************************
C
C       Choose communication protocol.
C
C       Complete send for nonblocking send protocols.
        IF (PROTOPT .EQ. 0) THEN
C         Nothing to do in PVM implementation.
        ELSE
          WRITE (0,901) COMMOPT, PROTOPT
  901     FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SREND:',
     &             ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &             ' COMMOPT = ',I3, ' PROTOPT = ',I3)
          STOP                                                   
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 1) THEN
C***********************************************************************
C       ordered SENDRECV:
C       IF (ORDER .EQ. 1) send/recv
C       IF (ORDER .NE. 1) recv/send
C       (Deadlock avoidance is the responsibility of the calling
C        program.)
C***********************************************************************
C
C       Choose communication protocol.
C
C       Complete send for nonblocking send protocols.
        IF ((PROTOPT .EQ. 0) .OR. (PROTOPT .EQ. 6)) THEN
C         Nothing to do in PVM implementation.
        ELSE
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 2) THEN
C***********************************************************************
C       delayed-recv SENDRECV: send ... recv/send ... recv
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         Delay receive of SENDRECV.
          CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
          CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSE
C***********************************************************************
C       undefined SENDRECV option
C***********************************************************************
C
        WRITE (0,900) COMMOPT
  900   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SREND:',/,
     &           ' UNKNOWN COMMUNICATION OPTION SPECIFIED',/, 
     &           ' COMMOPT = ',I3)                                 
        STOP                                                   
C
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SR1(PROTOPT, SAFEFORCE, ME, MTAG, RCVSRC, 
     &               RCVLTH, RCVMSG)
C
C This subroutine begins a SENDRECV operation which will be completed 
C by SR2 and SR3. It posts a receive and sends handshaking messages 
C when forcetypes are used.
C
C Communication options (COMMOPT) for SR1/SR2/SR3 include:
C  IF (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  IF (COMMOPT .EQ. 1) ordered SENDRECV: 
C    IF (ORDER .EQ. 1) recv/send
C    IF (ORDER .NE. 1) recv/send
C  IF (COMMOPT .EQ. 2) delayed-recv SENDRECV: send ... recv
C Communication protocol options (PROTOPT) for SR1/SR2/SR3 include:
C  IF (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  IF (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  IF (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  IF (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: RING2, SHIFTCAST, SHIFTSUM, SRTRNS2
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C Communication protocol option 
      INTEGER PROTOPT
C Send handshaking message to guarantee correctness of using forcetype
C protocol?  (not used in PVM implementation)
      LOGICAL SAFEFORCE
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C source of message to be received
      INTEGER RCVSRC
C length of message to be received
      INTEGER RCVLTH
C
C     Output
C
C message received (eventually)
      INTEGER RCVMSG(*)
C
C---- Executable Statements --------------------------------------------
C
C     (All communication algorithm options share the same code.)
C
C     Choose communication protocol.
      IF ((PROTOPT .EQ. 0) .OR. (PROTOPT .EQ. 6)) THEN
C       Nothing to do in PVM implementation.
      ELSE
        WRITE (0,901) PROTOPT
  901   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SR1:',
     &           ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &           ' PROTOPT = ',I3)
        STOP                                                   
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SRSAFE(PROTOPT, ME, MTAG, RCVSRC)
C
C This subroutine sends the SAFEFORCE message, completing a call to SR1
C in which SAFEFORCE was set to .FALSE. but a handshake is still needed.
C
C Communication options (COMMOPT) for SR1/SR2/SR3 include:
C  IF (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  IF (COMMOPT .EQ. 1) ordered SENDRECV: 
C    IF (ORDER .EQ. 1) recv/send
C    IF (ORDER .NE. 1) recv/send
C  IF (COMMOPT .EQ. 2) delayed-recv SENDRECV: send ... recv
C Communication protocol options (PROTOPT) for SR1/SR2/SR3 include:
C  IF (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  IF (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  IF (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  IF (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: RING2, SHIFTCAST, SHIFTSUM, SRTRNS2
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C Communication protocol option 
      INTEGER PROTOPT
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C source of message to be received
      INTEGER RCVSRC
C
C---- Executable Statements --------------------------------------------
C
C     (All communication algorithm options share the same code.)
C
C     Choose communication protocol.
      IF ((PROTOPT .EQ. 0) .OR. (PROTOPT .EQ. 6)) THEN
C       Nothing to do in PVM implementation.
      ELSE
        WRITE (0,901) PROTOPT
  901   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SRSAFE:',
     &           ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &           ' PROTOPT = ',I3)
        STOP                                                   
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SR2(COMMOPT, PROTOPT, SAFEFORCE, ORDER, ME, 
     &               MTAG, SNDDST, SNDLTH, SNDMSG, RCVSRC, RCVLTH,
     &               RCVMSG)
C
C This subroutine continues the SENDRECV operation begun in SR1.
C It initiates the send and (sometimes) waits for the receive
C to complete.
C
C Communication options (COMMOPT) for SR1/SR2/SR3 include:
C  IF (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  IF (COMMOPT .EQ. 1) ordered SENDRECV: 
C    IF (ORDER .EQ. 1) send/recv
C    IF (ORDER .NE. 1) recv/send
C  IF (COMMOPT .EQ. 2) delayed-recv SENDRECV: send ... recv
C Communication protocol options (PROTOPT) for SR1/SR2/SR3 include:
C  IF (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  IF (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  IF (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  IF (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: RING2, SHIFTCAST, SHIFTSUM, SRTRNS2
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
#     include "fpvm3.h"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C Communication algorithm option
      INTEGER COMMOPT
C communication protocol option 
      INTEGER PROTOPT
C Using handshaking message to guarantee correctness of using forcetype
C protocol? (not used in PVM implementation)
      LOGICAL SAFEFORCE
C order of send/recv
      INTEGER ORDER
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C message destination
      INTEGER SNDDST
C length of message to be sent
      INTEGER SNDLTH
C message to be sent
      INTEGER SNDMSG(*)
C source of message to be received
      INTEGER RCVSRC
C length of message to be received
      INTEGER RCVLTH
C
C     Output
C
C message received
      INTEGER RCVMSG(*)
C
C---- Local Variables --------------------------------------------------
C
C error return variable
      INTEGER F
C data description parameters
      INTEGER DATATYPE, DATALTH
C
C---- Executable Statements --------------------------------------------
C
C     Get datatype and data length
      CALL DATADESC(DATATYPE, DATALTH)
C
C     Choose communication algorithm.
      IF (COMMOPT .EQ. 0) THEN
C***********************************************************************
C       simple SENDRECV: send/recv
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         simple SENDRECV
          CALL PVMFINITSEND(PVMDEFAULT, F)
          CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
          CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
          CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
          CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
C
        ELSE
C
          WRITE (0,901) COMMOPT, PROTOPT
  901     FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SR2:',
     &             ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &             ' COMMOPT = ',I3, ' PROTOPT = ',I3)
          STOP                                                   
C
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 1) THEN
C***********************************************************************
C       ordered SENDRECV:
C       IF (ORDER .EQ. 1) send/recv
C       IF (ORDER .NE. 1) recv/send
C       (Deadlock avoidance is the responsibility of the calling
C        program.)
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         ordered SENDRECV
          IF (ORDER .EQ. 1) THEN
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ELSE
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ENDIF
C
        ELSEIF (PROTOPT .EQ. 6) THEN
C
C         synchronous ordered SENDRECV 
          IF (ORDER .EQ. 1) THEN
            CALL PVMFRECV(TIDS(SNDDST), MTAG, F)
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            IF (SNDDST .NE. RCVSRC) THEN
              CALL PVMFINITSEND(PVMDEFAULT, F)
              CALL PVMFSEND(TIDS(RCVSRC), MTAG, F)
            ENDIF
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ELSE
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFSEND(TIDS(RCVSRC), MTAG, F)
            CALL PVMFINITSEND(PVMDEFAULT, F)
            CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
            IF (SNDDST .NE. RCVSRC)
     &        CALL PVMFRECV(TIDS(SNDDST), MTAG, F)
            CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
            CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
            CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
          ENDIF
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 2) THEN
C***********************************************************************
C       delayed-recv SENDRECV: send ... recv
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         send of SENDRECV
          CALL PVMFINITSEND(PVMDEFAULT, F)
          CALL PVMFPACK(DATATYPE, SNDMSG, SNDLTH/DATALTH, 1, F)
          CALL PVMFSEND(TIDS(SNDDST), MTAG, F)
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSE
C***********************************************************************
C       undefined SENDRECV option
C***********************************************************************
C
        WRITE (0,900) COMMOPT
  900   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SR2:',/,
     &           ' UNKNOWN COMMUNICATION OPTION SPECIFIED',/, 
     &           ' COMMOPT = ',I3)                                 
        STOP                                                   
C
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE SR3(COMMOPT, PROTOPT, ME, MTAG, SNDDST,
     &               RCVSRC, RCVLTH, RCVMSG)
C
C This subroutine completes the SENDRECV operation begun in SR1 and
C SR2. It waits until the message requested in SR1 has arrived and
C the send request in SR2 has completed.
C
C Communication options (COMMOPT) for SR1/SR2/SR3 include:
C  IF (COMMOPT .EQ. 0) simple SENDRECV: send/recv
C  IF (COMMOPT .EQ. 1) ordered SENDRECV: 
C    IF (ORDER .EQ. 1) send/recv
C    IF (ORDER .NE. 1) recv/send
C  IF (COMMOPT .EQ. 2) delayed-recv SENDRECV: send ... recv
C Communication protocol options (PROTOPT) for SR1/SR2/SR3 include:
C  IF (PROTOPT .EQ. 1, 3, .OR. 5)     nonblocking send   
C  IF (PROTOPT .EQ. 2, 3, 4, .OR. 5)  nonblocking receive
C  IF (PROTOPT .EQ. 4 .OR. 5)         forcetype          
C  IF (PROTOPT .EQ. 6 .AND. COMMOPT .EQ. 1) synchronous  
C PVM does not provide nonblocking communication commands. Protocol 
C options involving nonblocking commands will cause the program to     
C abort.                                                               
C
C called by: RING2, SHIFTCAST, SHIFTSUM, SRTRNS2
C calls: PVM routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
#     include "fpvm3.h"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C communication algorithm option
      INTEGER COMMOPT
C communication protocol option 
      INTEGER PROTOPT
C processor id
      INTEGER ME
C message tag
      INTEGER MTAG
C message destination
      INTEGER SNDDST
C source of message to be received
      INTEGER RCVSRC
C length of message to be received
      INTEGER RCVLTH
C
C     Output
C
C message received
      INTEGER RCVMSG(*)
C
C---- Local Variables --------------------------------------------------
C
C error return variable
      INTEGER F
C data description parameters
      INTEGER DATATYPE, DATALTH
C
C---- Executable Statements --------------------------------------------
C
C     Get datatype and data length
      CALL DATADESC(DATATYPE, DATALTH)
C
C     Choose communication algorithm.
C
      IF (COMMOPT .EQ. 0) THEN
C***********************************************************************
C       simple SENDRECV: send/recv
C***********************************************************************
C
C       Choose communication protocol.
C
C       Complete send for nonblocking send protocols.
        IF (PROTOPT .EQ. 0) THEN
C         Nothing to do in PVM implementation.
        ELSE
          WRITE (0,901) COMMOPT, PROTOPT
  901     FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SR3:',
     &             ' COMMUNICATION PROTOCOL UNSUPPORTED IN PVM',/,
     &             ' COMMOPT = ',I3, ' PROTOPT = ',I3)
          STOP                                                   
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 1) THEN
C***********************************************************************
C       ordered SENDRECV:
C       IF (ORDER .EQ. 1) send/recv
C       IF (ORDER .NE. 1) recv/send
C       (Deadlock avoidance is the responsibility of the calling
C        program.)
C***********************************************************************
C
C       Choose communication protocol.
C
C       Complete send for nonblocking send protocols.
        IF ((PROTOPT .EQ. 0) .OR. (PROTOPT .EQ. 6)) THEN
C         Nothing to do in PVM implementation.
        ELSE
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
        ENDIF
C
      ELSEIF (COMMOPT .EQ. 2) THEN
C***********************************************************************
C       delayed-recv SENDRECV: recvbegin ... send ... recvend
C***********************************************************************
C
C       Choose communication protocol.
        IF (PROTOPT .EQ. 0) THEN
C
C         Receive message.
          CALL PVMFRECV(TIDS(RCVSRC), MTAG, F)
          CALL PVMFUNPACK(DATATYPE, RCVMSG, RCVLTH/DATALTH, 1, F)
C
        ELSE
C
C         protocol error
          WRITE (0,901) COMMOPT, PROTOPT
          STOP                                                   
C
        ENDIF
C
      ELSE
C***********************************************************************
C       undefined SENDRECV option
C***********************************************************************
C
        WRITE (0,900) COMMOPT
  900   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE SR3:',/,
     &           ' UNKNOWN COMMUNICATION OPTION SPECIFIED',/, 
     &           ' COMMOPT = ',I3)                                 
        STOP                                                   
C
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
