C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE ITRNPE(ALP, PHISC, WS, PHIFC)
C                                                                              
C This subroutine transforms geopotential from spectral space to Fourier
C space by computing the inverse Legendre transform (i.e., evaluating
C the Legendre expansion) 
C                                                                              
C called by: ADVECT
C calls: ILTCAST, ITRNPE2
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C parallel algorithm information
#     include "algorithm.i"
C domain decomposition information
#     include "spectral.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C associated Legendre polynomials
      REAL ALP(NFSPEC_S,NLLATH_S)
C geopotential spectral coefficients
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)                        
C
C     Work Space
C
C work array for communicating spectral data
      COMPLEX WS(MXLSPEC_S,NLVER_S,BUFSILT)
C
C     Work Space/Output
C
C geopotential field in Fourier space
      COMPLEX PHIFC(MXLFC_S,NLVER_S,NLLAT_S)
C
C---- Local Variables --------------------------------------------------
C
C polynomial degree transition index
      INTEGER JNTRNS
C flag array to indicate whether a given Fourier coefficient
C has been "visited" in previous stages of the computation
      INTEGER JMFLAG(MMX+1)
C parallel stage / index of active buffer in multiple buffer algorithm
      INTEGER P, PM
C
C---- Executable Statements --------------------------------------------
C
C     Determine Fourier coefficients by inverse Legendre transform.
C     Vary M and N so procedure moves along columns denoted by
C     index JM.  M is given by (JM-1) while N is given by (JN+M-1).
C
      IF (NLMM_S .GT. 0) THEN
C
C       Send local segment of data array on and get the next segment.
        CALL ILTCAST(1, NLTSTEPS, MXLSPEC_S*NLVER_S, PHISC, WS, PM)
C
C       Calculate using local data.
        CALL ITRNPE2(1, JNTRNS, JMFLAG, ALP, PHISC, PHIFC)
C
C       Finish calculation using external data.
        DO P=2,NLTSTEPS
C
C         Send current segment of data array on and get the next
C         segment. 
          CALL ILTCAST(P, NLTSTEPS, MXLSPEC_S*NLVER_S, PHISC, WS, PM)
C
C         Calculate using new data.
          CALL ITRNPE2(P, JNTRNS, JMFLAG, ALP, WS(1,1,PM), PHIFC)
C
        ENDDO
C
      ENDIF
C
      IF (NLMM_S .LT. NLFC_S) THEN
C       Zero the tail of the complex coefficient spectrum.
        CALL ZEROFC(NLMM_S, NLFC_S, MXLFC_S, NLVER_S*NLLAT_S,
     &              JMLTRUE_S, PHIFC)
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE ITRNPE2(P, JNTRNS, JMFLAG, ALP, PHISC, PHIFC)
C                                                                              
C This routine computes contributions to the Fourier coefficients 
C of geopotential using a segment of the geopotential spectral 
C coefficients.
C                                                                              
C called by: ITRNPE
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C domain decomposition information
#     include "spectral.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C parallel stage
      INTEGER P
C associated Legendre polynomials
      REAL ALP(NFSPEC_S,NLLATH_S)
C geopotential spectral coefficients
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)                        
C
C     Input/Output
C
C current polynomial degree transition index
      INTEGER JNTRNS
C flag array to indicate whether a given Fourier coefficient
C has been "visited" in previous stages of the computation
      INTEGER JMFLAG(MMX+1)
C
C     Work Space/Output
C
C geopotential field
      COMPLEX PHIFC(MXLFC_S,NLVER_S,NLLAT_S)
C
C---- Local Variables --------------------------------------------------
C
C even and odd contributions to PHIFC
      COMPLEX PTMP1, PTMP2
C latitude (northern and southern) indices
      INTEGER NL, SL
C untruncated and truncated wavenumber indices
      INTEGER IM, JM
C polynomial degree index and index bounds
      INTEGER JN, JNFIRST, JNLAST
C vertical layer and spectral coefficient indices
      INTEGER JV, L
C spectral coefficient offset for wavenumber index JM
      INTEGER IS
C
C---- Executable Statements --------------------------------------------
C
C     Determine Fourier coefficients by inverse Legendre transform.          
C     Vary M and N so procedure moves along columns denoted by             
C     index JM.  M is given by (JM-1) while N is given by (JN+M-1).            
C
C     Initialize/update polynomial degree transition index and flag
C     array.
      IF (P .EQ. 1) THEN
C
C       First call in this transform: initialize offset
        JNTRNS = 1 - JMB_S(P)
C
C       and flag array.
        DO JM=1,NLMM_S
          JMFLAG(JM) = 0
        ENDDO
C
      ELSE
C
C       Update offset
        JNTRNS = JNTRNS + (JME_S(P-1)+1) - JMB_S(P)     
C
C       and flag array.
        DO JM=JMB_S(P-1),JME_S(P-1)
          JMFLAG(JM) = 1
        ENDDO
C
      ENDIF
C
C     Compute contribution to Fourier coefficients.
      DO NL=1,NLLATH_S
        SL = NLLAT_S-NL+1
C
        DO JV=1,NLVER_S
C
          L = 1
          DO JM=JMB_S(P),JME_S(P)
            IS = LLCOL_S(JM,2)
            IM = JMLTRUE_S(JM)
C
            JNFIRST = JNB_S(JNTRNS+JM)
            JNLAST = JNE_S(JNTRNS+JM)
            L = L - JNFIRST
C
C           Initialize temporaries.
            IF (MOD(JNFIRST,2) .EQ. 0) THEN
              PTMP1 =  (0.0,0.0)
              PTMP2 =  PHISC(L+JNFIRST,JV)*ALP(IS+JNFIRST,NL) 
              JNFIRST = JNFIRST + 1
            ELSE
              PTMP1 = (0.0,0.0)
              PTMP2 = (0.0,0.0)
            ENDIF
C
C           Compute contributions for paired JNs.
            DO JN=JNFIRST,JNLAST-1,2
              PTMP1 = PTMP1 + PHISC(L+JN,JV)*ALP(IS+JN,NL)
              PTMP2 = PTMP2 + PHISC(L+JN+1,JV)*ALP(IS+JN+1,NL)
            ENDDO
C
            IF (MOD((JNLAST-JNFIRST),2) .EQ. 0) THEN
C             Compute contributions for last JN.
              PTMP1 = PTMP1 + PHISC(L+JNLAST,JV)*ALP(IS+JNLAST,NL)
            ENDIF
C
C           Combine contributions of even and odd wavenumbers to obtain
C           Fourier coefficients.
            IF (JMFLAG(JM) .EQ. 0) THEN
              PHIFC(IM,JV,NL)  = PTMP1 + PTMP2
              PHIFC(IM,JV,SL)  = PTMP1 - PTMP2
            ELSE
              PHIFC(IM,JV,NL)  = PHIFC(IM,JV,NL)  + PTMP1 + PTMP2
              PHIFC(IM,JV,SL)  = PHIFC(IM,JV,SL)  + PTMP1 - PTMP2
            ENDIF
C
C           Update local spectral coefficient offset index.
            L = L + JNLAST + 1
C
          ENDDO
C
        ENDDO
C
      ENDDO
C
      RETURN
      END
