C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE FORCE(J, DIVFCG, ETAFCG, PHIFCG)
C
C This procedure computes vorticity, divergence and geopotential forcing 
C for test case 4 on a single latitude in the local portion of the 
C physical grid. Alternatively, it computes U/V/H-momentum forcing.
C The type of forcing computed is determined by logical variable MOMENT:
C If (MOMENT .EQ. .TRUE.) then use U/V momentum forcing.
C If (MOMENT .EQ. .FALSE.) then use vorticity/divergence forcing.
C
C called by: COMP1
C calls: GLAT_P, GLON_P
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C constants & timesteps
#     include "consts.i"
C domain decomposition information
#     include "physical.i"
C initial conditions 
#     include "finit.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C index of latitude calculating forcing for
      INTEGER J
C
C     Output
C
C divergence forcing / v-momentum*cos(phi) forcing
      REAL DIVFCG(NLLON_P,NLVER_P)
C vorticity forcing / u-momentum*cos(phi) forcing
      REAL ETAFCG(NLLON_P,NLVER_P)
C geopotential forcing / h-momentum*g forcing
      REAL PHIFCG(NLLON_P,NLVER_P)         
C
C---- Local Variables --------------------------------------------------
C
C longitude and vertical layer indices
      INTEGER I, JV
C longitude
      REAL RLON
C latitude and sine, cosine, and tangent of latitude
      REAL RLAT, SNJ, CSJ, TNJ
C various powers and scaled powers of CSJ. See code for definitions.
      REAL CSJ2, CSJ2I, CSJ3I, CSJ4I, ACSJ2I, A2CSJ2I, A2CSJ4I
C sine and cosine of initial location for feature being advected 
      REAL SNJ0, CSJ0
C Coriolis parameter
      REAL COR
C steady zonal flow BUB and its two derivatives
      REAL BUB, DBUB, D2BUB	
C C (= SNJ0*SNJ + CSJ0*CSJ*COS(RLON-TMSHFT-RLON0)) and all of its
C derivatives for a given timestep and longitude
      REAL C, DCDM, DCDL, D2CDM, D2CDL, D3CDM , D3CDL, DMDCDL, 
     &     DMD2CL, DLD2CM
C PSI bar (= ALFA*EXP(-SIGMA*((1.0-C)/(1.0+C)))) and all of its 
C derivatives 
      REAL PSIB, DKDM, DKDL, D2KDM, D2KDL, D3KDM, D3KDL, DLDKDM, 
     &     DLD2KM, DMD2KL
C commonly utilized terms in forcing (U and V tilde) and their
C derivatives
      REAL UT, VT, DUTDL, DUTDM, DVTDL, DVTDM
C temporaries used in computing partial sums or factors in complicated
C expressions  
      REAL TMP1, TMP2, TMP3
C other local variables used to compute forcing efficiently. See 
C code for definitions.
      REAL TMSHFT, DFDM, AI, A2I
C
C---- External Functions -----------------------------------------------
C
C spatial latitude/longitude grid
      EXTERNAL GLAT_P, GLON_P
      REAL GLAT_P, GLON_P
C     
C---- Statement Functions ----------------------------------------------
C
C steady zonal flow BUB and its two derivatives
#     include "bubfnc.i"
C
C---- Executable Statements --------------------------------------------
C
C     latitude = rlat = glat_p(j)
      RLAT   = GLAT_P(J)
      SNJ    = SIN(RLAT)
      CSJ    = COS(RLAT)
      TNJ    = TAN(RLAT)
C
C     initial location for feature being advected
      SNJ0    = SIN(RLAT0)
      CSJ0    = COS(RLAT0)
C
C     steady zonal flow BUB and its two derivatives
      BUB    = CSJ*BUBFNC(SNJ,CSJ)
      DBUB   = DBUBF(SNJ,CSJ)
      D2BUB  = D2BUBF(SNJ,CSJ)
C
C     Coriolis parameter
      COR    = 2.0*OMEGA*SNJ
C
C     other longitude independent factors
      TMSHFT  = (SU0*(NSTEP-1)*DT)/A
      DFDM    = 2.0*OMEGA
      AI      = 1.0/A
      A2I     = 1.0/(A*A)
      CSJ2    = CSJ*CSJ
      CSJ2I   = 1.0/CSJ2
      CSJ3I   = 1.0/(CSJ2*CSJ)
      CSJ4I   = 1.0/(CSJ2*CSJ2)
      ACSJ2I  = 1.0/(A*CSJ2)
      A2CSJ2I = 1.0/((A*A)*CSJ2)
      A2CSJ4I = 1.0/((A*A)*(CSJ2*CSJ2))
C
      DO JV=1,NLVER_P
        DO I=1,NLLON_P
C
C         longitude = rlon = glon_p(i)
          RLON = GLON_P(I)
C
C         Calculate C and all of its derivatives for this time step
C         and longitude.
C (a.28)
          C      = SNJ0*SNJ + CSJ0*CSJ*COS(RLON-TMSHFT-RLON0)
C (a.38)
          DCDM   = SNJ0 - COS(RLON-TMSHFT-RLON0)*CSJ0*TNJ
C (a.39)
          DCDL   = -CSJ0*CSJ*SIN(RLON-TMSHFT-RLON0)
C (a.40) (simplified term)
          D2CDM  = -CSJ0*COS(RLON-TMSHFT-RLON0)*CSJ3I
C (a.41)
          D2CDL  = -CSJ0*CSJ*COS(RLON-TMSHFT-RLON0)
C (a.42) (simplified term)
          D3CDM  = D2CDM*3.0*SNJ*CSJ2I
C (a.43)
          D3CDL  = -DCDL
C (a.44)
          DMDCDL = +CSJ0*SIN(RLON-TMSHFT-RLON0)*TNJ
C (a.45)
          DLD2CM = +CSJ0*SIN(RLON-TMSHFT-RLON0)*CSJ3I
C (a.46)
          DMD2CL = +CSJ0*COS(RLON-TMSHFT-RLON0)*TNJ
C
C         Calculate PSI bar and all of its derivatives (DKDM, etc.).
C (a.27)
          PSIB   = ALFA*EXP(-SIGMA*((1.0-C)/(1.0+C)))
          TMP1   = 2.0*SIGMA*PSIB/((1.0 + C)**2)
          TMP2   = (SIGMA - (1.0 + C))/((1.0 + C)**2)
          TMP3   = (((1.0+C)**2)-2.0*SIGMA*(1.0+C))/((1.0 + C)**4)
C (a.29)
          DKDM   = TMP1*DCDM
C (a.30)
          DKDL   = TMP1*DCDL
C (a.31)
          D2KDM  = TMP1*(D2CDM + 2.0*(DCDM**2)*TMP2)
C (a.32)
          D2KDL  = TMP1*(D2CDL + 2.0*(DCDL**2)*TMP2)
C (a.33)
          D3KDM  = TMP1*(D3CDM + 2.0*(DCDM**3)*TMP3
     &           + 2.0*DCDM*TMP2*(3.0*D2CDM + 2.0*(DCDM**2)*TMP2))
C (a.34)
          D3KDL  = TMP1*(D3CDL + 2.0*(DCDL**3)*TMP3
     &           + 2.0*DCDL*TMP2*(3.0*D2CDL + 2.0*(DCDL**2)*TMP2))
C (a.35)
          DLDKDM = TMP1*(DMDCDL + 2.0*DCDL*DCDM*TMP2)
C (a.37)
          DMD2KL = TMP1*(DMD2CL + 2.0*(DCDL**2)*DCDM*TMP3
     &           + 2.0*DCDM*TMP2*(D2CDL + 2.0*(DCDL**2)*TMP2)
     &           + 4.0*DCDL*DMDCDL*TMP2)
C (a.36)
          DLD2KM = TMP1*(DLD2CM + 2.0*(DCDM**2)*DCDL*TMP3
     &           + 2.0*DCDL*TMP2*(D2CDM + 2.0*(DCDM**2)*TMP2)
     &           + 4.0*DCDM*DMDCDL*TMP2)
C                                                                              
C         Compute commonly utilized terms in forcing (U and V tilde).
          UT     = BUB - CSJ2*DKDM*AI
          VT     = DKDL*AI
          DUTDL  = -CSJ2*DLDKDM*AI
          DVTDL  = D2KDL*AI
          DUTDM  = DBUB - (CSJ2*D2KDM - 2.0*SNJ*DKDM)*AI
          DVTDM  = DLDKDM*AI
C                                                                              
C         Compute forcing terms.
          IF (MOMENT) THEN
C
C           u-momentum forcing
            ETAFCG(I,JV) = (CSJ2*SU0)/(A*A)*DLDKDM 
     &                   + UT*ACSJ2I*DUTDL 
     &                   + VT*AI*DUTDM 
     &                   + COR*(AI*DKDL-VT)
C
          ELSE
C
C           Compute forcing on vorticity equation.
C (a.16, a.17)
            TMP1  = (UT*ACSJ2I - (SU0*AI))
     &            * (D3KDL*A2CSJ2I + (CSJ2*DLD2KM - 2.0*SNJ*DLDKDM)*A2I)
C (a.18)
            TMP2  = (DMD2KL*CSJ2I + 2.0*SNJ*D2KDL*CSJ4I + CSJ2*D3KDM
     &               - 4.0*SNJ*D2KDM - 2.0*DKDM)*A2I
     &            + DFDM - D2BUB*AI
C (a.13)
            ETAFCG(I,JV) = TMP1 + TMP2*VT*AI
C
          ENDIF
C                                                                              
C         Compute forcing on geopotential equation.
C (a.25)
          PHIFCG(I,JV) = (-SU0*AI + UT*ACSJ2I)*COR*DKDL
     &                 + AI*VT*(PSIB*DFDM + COR*DKDM)
C
C         Add term to balance zonal flow.
          PHIFCG(I,JV) = PHIFCG(I,JV) 
     &                 - VT*BUB*CSJ2I*(COR+BUB*ACSJ2I*SNJ)
C                                                                              
          IF (MOMENT) THEN
C
C           Compute V-momentum forcing.
            DIVFCG(I,JV) = - SU0*A2I*D2KDL 
     &                   + UT*ACSJ2I*DVTDL 
     &                   + VT*AI*DVTDM 
     &                   + (UT*UT+VT*VT)*SNJ*ACSJ2I 
     &                   + CSJ2*AI*(COR*DKDM + PSIB*DFDM)
     &                   + COR*(UT-BUB)
     &                   - ACSJ2I*SNJ*BUB*BUB
C
          ELSE
C          
C           Compute forcing on divergence equation (most messy!).
C           Calculate Laplacian of PHI first.
C (a.19)
            DIVFCG(I,JV) = COR*D2KDL*A2CSJ2I 
     &                   + (CSJ2*(COR*D2KDM + 2.0*DFDM*DKDM) 
     &                      - 2.0*SNJ*(PSIB*DFDM + COR*DKDM))*A2I
C                                                                              
C           Calculate ETA_F next.
C           DIVFCG(I,JV) = DIVFCG(I,JV) 
     &                   - (ACSJ2I*DVTDL-AI*DUTDM)*COR 
     &                   + UT*AI*DFDM
C                                                                              
C           Finally, add Laplacian of U**2/(2*CSJ2) and V**2/(2*CSJ2).
C           DIVFCG(I,JV) = DIVFCG(I,JV) 
     &                   + 2.0*SNJ*A2CSJ2I
     &                     *(UT*CSJ2I*DVTDL-VT*CSJ2I*DUTDL
     &                       + UT*DUTDM + VT*DVTDM)
C                                                                              
C           DIVFCG(I,JV) = DIVFCG(I,JV) 
     &                   + 2.0*A2CSJ2I*(DUTDM*DVTDL - DUTDL*DVTDM)
C
C           DIVFCG(I,JV) = DIVFCG(I,JV)
     &                   + (UT*UT + VT*VT)*(1.0+SNJ*SNJ)*A2CSJ4I
C                                                                              
C           Add term to balance zonal flow.
C           DIVFCG(I,JV) = DIVFCG(I,JV) 
     &                   - COR*AI*DBUB
     &                   - BUB*AI*DFDM 
     &                   - A2CSJ4I*(BUB*BUB*(1+SNJ*SNJ)
     &                              + 2.0*SNJ*CSJ2*BUB*DBUB)
C
          ENDIF
C
        ENDDO
      ENDDO
C
      RETURN
      END
