C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE ERRANL(PHICON, UCON, VCON, MOUNT, DIC12, EIC12, PIC12,
     &                  UIC12, VIC12, DIV, ZETA, PHI, U, V, L2CTR, ANL,
     &                  GBSUM)
C
C This routine computes various forms of scalar error estimates by 
C comparison with the analytic solutions.
C                                                                              
C called by: PSTSWM
C calls: ANLYTC, GLOBALMAX, GLOBALMIN, PGRIDSUM, WEIGHT_P
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C machine architecture information
#     include "machine.i"
C problem resolution information
#     include "problem.i"
C domain decomposition definition variables
#     include "physical.i"
C constants
#     include "consts.i"
C initial conditions (test case 4 special treatment)
#     include "finit.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C balanced PHI (PHICON), UCON, VCON (used in ANLYTC for geopotential 
C that balances steady zonal flow)
      REAL PHICON(NLLAT_P)
      REAL UCON(NLLAT_P)
      REAL VCON(NLLAT_P)
C mountain height
      REAL MOUNT(NLLON_P,NLLAT_P)
C initial divergence and vorticity
      REAL DIC12(NLLON_P,NLLAT_P)
      REAL EIC12(NLLON_P,NLLAT_P)
C initial height
      REAL PIC12(NLLON_P,NLLAT_P)
C initial U, V wind
      REAL UIC12(NLLON_P,NLLAT_P)
      REAL VIC12(NLLON_P,NLLAT_P)
C divergence
      REAL DIV(NLLON_P,NLLAT_P)
C vorticity
      REAL ZETA(NLLON_P,NLLAT_P)
C height
      REAL PHI(NLLON_P,NLLAT_P)
C U wind velocity
      REAL U(NLLON_P,NLLAT_P)
C V wind velocity
      REAL V(NLLON_P,NLLAT_P)
C array location to store errors for later plotting
      INTEGER L2CTR
C
C     Work Space
C
C work array for holding analytic solution:
C  DANL(NLLON_P,NLLAT_P): ANL(1,1,1)
C  ZANL(NLLON_P,NLLAT_P): ANL(1,1,2)
C  PANL(NLLON_P,NLLAT_P): ANL(1,1,3)
C  UANL(NLLON_P,NLLAT_P): ANL(1,1,4)
C  VANL(NLLON_P,NLLAT_P): ANL(1,1,5),
C and work storage for ANLYTC and plots: (starting at) ANL(1,1,6)
      REAL ANL(NLLON_P,NLLAT_P,6)
C work array for computing global error sums using a reproducible 
C ordering
      REAL GBSUM(10,NLLON_P,NLLAT_P+1)
C
C---- Local Variables --------------------------------------------------
C
C longitude and latitude loop indices
      INTEGER I, J
C grid weight
      REAL WTS
C analytic velocity, computed velocity, velocity error, and
C absolute value of computed PHI
      REAL VLEN, VLENT, VDIFF, PABS
C normalization constants
C (Initial values of analytic solution are saved so that can plot 
C  errors as relative errors.)
      REAL MINN, MAXN, MEANN, VARN
      SAVE MINN, MAXN, MEANN, VARN
C
C work storage for computing global statistics
      REAL STSUM(12), STMAX(7), STMIN(2)
C indices into statistics arrays for analytic solution:
C min. PHI, max. PHI, max velocity, mean of PHI, variance of PHI, 
      INTEGER MINP, MAXP, MAXV, MEAN, VAR
      PARAMETER (MINP=1)
      PARAMETER (MAXP=1, MAXV=2)
      PARAMETER (MEAN=1, VAR=11)
C indices into statistics arrays for computed solution:
C min. PHI, max. PHI, max ABS(PHI), max velocity, mean of PHI, 
C mean ABS(PHI), mean velocity, mean squared PHI, 
C mean squared velocity, variance of PHI
      INTEGER MINT, MAXT, PINFT, VMAXT, MEANT, PL1T, VL1T, 
     &        PL2T, VL2T, VART
      PARAMETER (MINT=2)
      PARAMETER (MAXT=3, PINFT=4, VMAXT=5)
      PARAMETER (MEANT=2, PL1T=3, VL1T=4, PL2T=5, VL2T=6, VART=12)
C indices into statistics arrays for error: max. velocity error,
C max PHI error, mean velocity error, mean PHI error, mean squared 
C velocity error, mean squared PHI error
      INTEGER VMAX, PINF, VL1, PL1, VL2, PL2
      PARAMETER (VMAX=6, PINF=7)
      PARAMETER (VL1=7, PL1=8, VL2=9, PL2=10)
C
C (Storage arrays for error measures are sufficient for up to NGRPHS 
C  entries. Error measures are saved in arrays to support the
C  future (re)introduction of a graphics option into PSTSWM.)
C
C L1, L2 and L(infinity) errors for height and vector velocity, time
      REAL PL1G(NGRPHSX), VL1G(NGRPHSX), VL2G(NGRPHSX), 
     &     PL2G(NGRPHSX), PINFG(NGRPHSX), VINFG(NGRPHSX), TME(NGRPHSX)
      SAVE PL1G, VL1G, PL2G, VL2G, PINFG, VINFG, TME
C minimum, maximum, mean and variance statistics
      REAL PMING(NGRPHSX), PMAXG(NGRPHSX), PAVGG(NGRPHSX), 
     &     PVARG(NGRPHSX)
      SAVE PMING, PMAXG, PAVGG, PVARG
C
C---- External Functions -----------------------------------------------
C
C     Gaussian weights
      EXTERNAL WEIGHT_P
      REAL WEIGHT_P
C
C---- Executable Statements --------------------------------------------
C
C     Do error analysis on model grid:
C     1) Get analytic solution. Call routine for time dependent analytic
C        solutions, which will returned in UANL, VANL, PANL, DANL and
C        ZANL.
      CALL ANLYTC(NSTEP*DT, ICOND, PHICON, UCON, MOUNT, UIC12, VIC12, 
     &            PIC12, DIC12, EIC12, ANL(1,1,1), ANL(1,1,2),
     &            ANL(1,1,3), ANL(1,1,4), ANL(1,1,5))
C
C     2) Initialize error variables.
      STMAX(VMAX)  = 0.0
      STMAX(VMAXT) = 0.0
      STMAX(PINF)  = 0.0
      STMAX(PINFT) = 0.0
      STMIN(MINP)  = PHI(1,1)
      STMAX(MAXP)  = PHI(1,1)
      STMAX(MAXV)  = 0.0
      STMIN(MINT)  = ANL(1,1,3)
      STMAX(MAXT)  = ANL(1,1,3)
C
C     3) Calculate components of L2 norm, and other measures of error
C        for small U, small V, and height.
      DO J=1,NLLAT_P
C
C       weight independent of longitude
        WTS = WEIGHT_P(1,J)
C
        DO I=1,NLLON_P                                                         
C
C         magnitude of wind field and wind field error
          VLEN  = SQRT(U(I,J)**2+V(I,J)**2)
          VDIFF = SQRT((U(I,J)-ANL(I,J,4))**2 +
     &            (V(I,J)-ANL(I,J,5))**2)
C
C         L1 errors
          GBSUM(VL1,I,J) = VDIFF*WTS
          GBSUM(PL1,I,J) = ABS(PHI(I,J)-ANL(I,J,3))*WTS
C
C         L2 errors
          GBSUM(VL2,I,J) = VDIFF**2*WTS
          GBSUM(PL2,I,J) = (PHI(I,J)-ANL(I,J,3))**2*WTS
C
C         L(infinity) errors
          IF (VDIFF .GT. STMAX(VMAX)) THEN
            STMAX(VMAX)  = VDIFF
          ENDIF
          IF (ABS(ANL(I,J,3)-PHI(I,J)) .GT. STMAX(PINF)) THEN
            STMAX(PINF)  = ABS(ANL(I,J,3)-PHI(I,J))
          ENDIF
C
C         minimum/maximum computed solution
          IF (PHI(I,J) .LT. STMIN(MINP)) THEN
            STMIN(MINP) = PHI(I,J)
          ENDIF
C
          IF (PHI(I,J) .GT. STMAX(MAXP)) THEN
            STMAX(MAXP) = PHI(I,J)
          ENDIF
          IF (VLEN .GT. STMAX(MAXV)) THEN
            STMAX(MAXV) = VLEN
          ENDIF
C
C         minimum/maximum analytic solution
          IF (ANL(I,J,3) .LT. STMIN(MINT)) THEN
            STMIN(MINT) = ANL(I,J,3)
          ENDIF
          IF (ANL(I,J,3) .GT. STMAX(MAXT)) THEN
            STMAX(MAXT) = ANL(I,J,3)
          ENDIF
C
C         mean values
          GBSUM(MEAN,I,J) = PHI(I,J)*WTS
          GBSUM(MEANT,I,J)= ANL(I,J,3)*WTS
C
C         error normalization
          IF (ICOND .NE. 4) THEN
            PABS  = ABS(ANL(I,J,3))
            VLENT = SQRT(ANL(I,J,4)**2+ANL(I,J,5)**2)
          ELSE
C           Special handling for case 4: subtract mean flow to compute
C           error relative to forcing. (See paper by Browning et. al.: A
C           Comparison of Three Numerical Methods for ... p. 1072.)
            PABS  = ABS(ANL(I,J,3) - PHICON(J))
            VLENT = SQRT((ANL(I,J,4) - UCON(J))**2 
     &            + (ANL(I,J,5) - VCON(J))**2)
          ENDIF
C
          GBSUM(PL1T,I,J) = PABS*WTS
          GBSUM(VL1T,I,J) = VLENT*WTS
          GBSUM(PL2T,I,J) = PABS**2*WTS
          GBSUM(VL2T,I,J) = VLENT**2*WTS
C     
          IF (VLENT .GT. STMAX(VMAXT)) THEN 
            STMAX(VMAXT)  = VLENT
          ENDIF
          IF (PABS .GT. STMAX(PINFT)) THEN 
            STMAX(PINFT)  = PABS 
          ENDIF
C
        ENDDO
C     
      ENDDO
C     
C     Finish min and max statistics calculations with global combines.
      CALL GLOBALMAX(7, STMAX)     
      CALL GLOBALMIN(2, STMIN)     
C
C     Finish calculation of global error norms by summing using a 
C     processor-independent summation ordering.
      CALL PGRIDSUM(10, 10, NLLON_P, NLLAT_P, GBSUM, 
     &              GBSUM(1,1,NLLAT_P+1), STSUM)
C     
C     Compute variances.
      DO J=1,NLLAT_P
        WTS = WEIGHT_P(1,J)
        DO I=1,NLLON_P
          GBSUM(1,I,J) = (PHI(I,J)-STSUM(MEAN))**2*WTS
          GBSUM(2,I,J) = (ANL(I,J,3)-STSUM(MEANT))**2*WTS
        ENDDO
      ENDDO
C
C     Finish calculation of variances using a processor-independent 
C     ordering.
      CALL PGRIDSUM(2, 10, NLLON_P, NLLAT_P, GBSUM, 
     &              GBSUM(1,1,NLLAT_P+1), STSUM(VAR))
C     
C     Finish error estimates and output results.
      IF (ME .EQ. 0) THEN
C     
C       Calculate L1 errors.
        IF (STSUM(VL1T) .NE. 0.0) THEN
          VL1G(L2CTR) = STSUM(VL1)/STSUM(VL1T)
        ELSE
          VL1G(L2CTR) = STSUM(VL1)
        ENDIF
C     
        IF (STSUM(PL1T) .NE. 0.0) THEN
          PL1G(L2CTR) = STSUM(PL1)/STSUM(PL1T)
        ELSE
          PL1G(L2CTR) = STSUM(PL1)
        ENDIF
C
C       Calculate L2 errors.
        IF (STSUM(VL2T) .NE. 0.0) THEN
          VL2G(L2CTR) = SQRT(STSUM(VL2)/STSUM(VL2T)) 
        ELSE
          VL2G(L2CTR) = SQRT(STSUM(VL2))
        ENDIF
C
        IF (STSUM(PL2T) .NE. 0.0) THEN
          PL2G(L2CTR) = SQRT(STSUM(PL2)/STSUM(PL2T))
        ELSE
          PL2G(L2CTR) = SQRT(STSUM(PL2))
        ENDIF
C
C       Calculate L(infinity) errors.
        IF (STMAX(VMAXT) .NE. 0.0) THEN
          VINFG(L2CTR) = STMAX(VMAX)/STMAX(VMAXT)
        ELSE
          VINFG(L2CTR) = STMAX(VMAX)
        ENDIF
C
        IF (STMAX(PINFT) .NE. 0.0) THEN
          PINFG(L2CTR) = STMAX(PINF)/STMAX(PINFT)
        ELSE
          PINFG(L2CTR) = STMAX(PINF)
        ENDIF
C
C       height min, max, mean and variance
        IF (L2CTR .EQ. 1) THEN
C         Save initial values for time-independent normalization.
C
          MINN  = STMIN(MINT)
          MAXN  = STMAX(MAXT)
          MEANN = STSUM(MEANT)
          VARN  = STSUM(VART)
          WRITE(6,986) MINN,MAXN,STSUM(MEANT),STSUM(VART)
  986     FORMAT (/, ' ERRANL: INITIAL VALUES FOR NORMALIZ',
     &               'ATION OF RELATIVE ERRORS',/,
     &               ' (SLIGHTLY GRID DEPENDENT!)',/,
     &               ' HEIGHT MIN./MAX. = ',1PE16.9,'/',1PE16.9,/,
     &               ' HEIGHT AVG./VAR. = ',1PE16.9,'/',1PE16.9)
C
        ELSEIF (L2CTR .GT. 1) THEN
C         Print results.
C
          WRITE (6,987) NSTEP, TAU
  987     FORMAT (/, ' ERRANL: ERROR ESTIMATES FOR NSTEP = ', I4, 
     &               ', TAU = ', 0PF6.2, ' HRS') 
C
          WRITE (6,122) PL1G(L2CTR),PL2G(L2CTR),PINFG(L2CTR)
  122     FORMAT (' HEIGHT ERROR',/,
     &            ' L1 = ', 1PE16.9, ', L2 = ', 1PE16.9,
     &            ' L(INF) = ', 1PE16.9)
C
          WRITE (6,123) VL1G(L2CTR),VL2G(L2CTR),VINFG(L2CTR)
  123     FORMAT (' VECTOR WIND ERROR',/,
     &            ' L1 = ', 1PE16.9, ', L2 = ', 1PE16.9,
     &            ' L(INF) = ', 1PE16.9)
C
          WRITE (6,124) STMIN(MINP),STMAX(MAXP)
  124     FORMAT (' HEIGHT MIN./MAX.  = ',1PE16.9,'/',1PE16.9)
C
          WRITE (6,126) STSUM(MEAN),STSUM(VAR)
  126     FORMAT (' HEIGHT AVG./VAR.  = ',1PE16.9,'/',1PE16.9,/)
C
C         Check for array overflow.
          IF (L2CTR .GE. NGRPHS) THEN 
            WRITE (0,905) L2CTR 
  905       FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE ERRANL ',  
     &             /,' ARGUMENT L2CTR EXCEEDS ALLOCATED ',          
     &               'STORAGE FOR VARIABLES L2CTR = ',I4, /)           
            STOP
          ENDIF
C
        ENDIF
C
C       Save relative errors (for later plotting).
        PMING(L2CTR) = (STMIN(MINP)-STMIN(MINT))/(MAXN-MINN)
        PMAXG(L2CTR) = (STMAX(MAXP)-STMAX(MAXT))/(MAXN-MINN)
        PAVGG(L2CTR) = (STSUM(MEAN)-STSUM(MEANT))/MEANN
        PVARG(L2CTR) = (STSUM(VAR)-STSUM(VART))/VARN
C
C       Save time point.
        TME(L2CTR) = TAU
C
      ENDIF
C
      RETURN
      END
