C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'spectral.i'                                           *
C***********************************************************************
C* Common Block /SPECTRAL/ contains the variables defining the data    *
C* decomposition of the Fourier space (MM x NLAT x NVER) and           *
C* spectral space (NALP (MM x NN) x NVER) when transforming between    *
C* the two spaces.                                                     *
C*                                                                     *
C*    NPFC_S    - number of processors used to partition Fourier       *
C*                wavenumber dimension                                 *
C*    NPSPEC_S  - number of processors used to partition spectral      *
C*                coefficients associated with local set of Fourier    *
C*                wavenumbers and to partition the latitude dimension  *
C*    NPVER_S   - number of processors used to partition vertical      *
C*                dimension                                            *
C*    MAPFC_S   - an array mapping "virtual processors" to physical    *
C*                processors for the set over which the wavenumber     *
C*                dimension is partitioned                             *
C*    MAPSPEC_S - an array mapping "virtual processors" to physical    *
C*                processors for the set over which the spectral       *
C*                coefficients associated with local set of Fourier    *
C*                wavenumbers is partitioned                           *
C*    MAPVER_S  - an array mapping "virtual processors" to physical    *
C*                processors for the set over which the vertical       *
C*                dimension is partitioned                             *
C*    FCDEX_S   - index of processor in MAPFC_S array                  *
C*    SPECDEX_S - index of processor in MAPSPEC_S array                *
C*    VERDEX_S  - index of processor in MAPVER_S array                 *
C*    MXLFC_S   - declared number of local Fourier coefficients, used  *
C*                to make sure that enough space is allocated to allow *
C*                physical, Fourier, and spectral partitions of both   *
C*                gridpoint fields and Fourier coefficients will fit   *
C*                into the same memory.                                *
C*    NLFC_S    - number of local wavenumbers (before truncation for   *
C*                distributed algorithms, after truncation for         *
C*                transpose algorithms).                               *
C*    NDFC_S    - array containing number of local Fourier wavenumbers *
C*                for each processor in MAPFC_S (NDFC_S(FCDEX_S) .EQ.  *
C*                NLFC_S)                                              *
C*    NLMM_S    - number of local wavenumbers after truncation         *
C*    ORDFWD_S  - arrays defining reordering used to load balance      *
C*    ORDINV_S    decomposition of spectral domain (used in transpose/ *
C*                transpose algorithm)                                 *
C*    IM0_S     - local index of wavenumber 0 in untruncated Fourier   *
C*                grid                                                 *
C*    IMNFC_S   - local index of wavenumber NFC-1 in untruncated       *
C*                Fourier grid                                         *
C*    MTINV_S   - array mapping Fourier wavenumbers to (truncated)     *
C*                local indices                                        *
C*    MTRUE_S   - array mapping (truncated) local indices to Fourier   *
C*                wavenumbers                                          *
C*    JMLTRUE_S - array mapping local indices for truncated wavenumber *
C*                sequence to local indices for untruncated sequence   *
C*    LLCOL_S   - an array containing column lengths and cumulative    *
C*                displacements for ordering of spectral coefficients  *
C*                associated with local Fourier wavenumbers            *
C*    NFSPEC_S  - number of spectral coefficients associated with the  *
C*                local Fourier wavenumbers                            *
C*    NLSPEC_S  - an array containing the number of local spectral     *
C*                coefficients for each processor "sharing" the same   *
C*                set of Fourier wavenumbers                           *
C*    MXLSPEC_S - maximum number of local spectral coefficients        *
C*                indicated in the array NLSPEC_S                      *
C*    JMB_S     - arrays containing beginning and ending Fourier       *
C*    JME_S       wavenumber indices for each processor in the set     *
C*                sharing the same Fourier wavenumbers                 *
C*    JNB_S,    - arrays containing beginning and ending degree        *
C*    JNE_S       (N) for each wavenumber and for each processor in the*
C*                set sharing the same Fourier wavenumbers             *
C*    NTRNS_S   - size of JNB_S, JNE_S arrays (number of spectral      *
C*                "transitions")                                       *
C*    NLTSTEPS  - number of steps required to compute forward and      *
C*                inverse Legendre transforms                          *
C*    P01_S     - step index where the spectral coefficient            *
C*                corresponding to wave m=0, n=1 is "resident" during  *
C*                the spectral to physical transform                   *
C*    L01_S     - spectral index for wave m=0, n=1 during step P01_S   *
C*    P11_S     - step index where the spectral coefficient            *
C*                corresponding to wave m=1, n=1 is "resident" during  *
C*                the spectral to physical transform                   *
C*    L11_S     - spectral index for wave m=1, n=1 during step P11_S   *
C*    MXLLAT_S - declared number of local latitudes for work arrays,   *
C*               used to make sure that enough space is allocated to   *
C*               allow for transposition of data arrays.               *
C*    NLLAT_S   - number of local latitudes                            *
C*    NLLATH_S  - NLLAT_S/2                                            *
C*    LATTRUE_S - array mapping local latitude indices to global       * 
C*                latitude indices                                     *
C*    NDLAT_S   - array containing number of local latitudes for each  *
C*                processor in MAPLAT_S (NDLAT_S(SPECDEX_S) .EQ.       *
C*                NLLAT_S)                                             *
C*    MXLVER_S - declared number of local vertical levels for work     *
C*               arrays, used to make sure that enough space is        *
C*               allocated to allow for transposition of data arrays.  *
C*    NLVER_S   - number of local vertical levels                      *
C*    NDVER_S   - array containing number of local vertical levels for *
C*                each processor in MAPVER_S (NDVER_S(VERDEX_S) .EQ.   *
C*                NLVER_S)                                             *
C***********************************************************************
      INTEGER NPFC_S, NPSPEC_S, NPVER_S, MAPFC_S(0:NPROCSX-1),
     &        MAPSPEC_S(0:NPROCSX-1), MAPVER_S(0:NPROCSX-1), FCDEX_S,
     &        SPECDEX_S, VERDEX_S, MXLFC_S, NLFC_S, NDFC_S(0:NPROCSX-1),
     &        NLMM_S, ORDFWD_S(NFCX), ORDINV_S(NFCX), IM0_S, IMNFC_S,
     &        MTINV_S(0:NLONX+1), MTRUE_S(NLONX+2), JMLTRUE_S(NLONX+2), 
     &        LLCOL_S(MMX+1,2), NFSPEC_S, NLSPEC_S(NPROCSX), MXLSPEC_S, 
     &        JMB_S(NPROCSX), JME_S(NPROCSX), JNB_S(NPROCSX+MMX+1), 
     &        JNE_S(NPROCSX+MMX+1), NTRNS_S, NLTSTEPS, P01_S, L01_S, 
     &        P11_S, L11_S, MXLLAT_S, NLLAT_S, NLLATH_S, 
     &        LATTRUE_S(NLATX), NDLAT_S(0:NPROCSX-1), 
     &        MXLVER_S, NLVER_S, NDVER_S(0:NPROCSX-1)
      COMMON  / SPECTRAL / 
     &        NPFC_S, NPSPEC_S, NPVER_S, MAPFC_S,
     &        MAPSPEC_S, MAPVER_S, FCDEX_S,
     &        SPECDEX_S, VERDEX_S, MXLFC_S, NLFC_S, NDFC_S, 
     &        NLMM_S, ORDFWD_S, ORDINV_S, IM0_S, IMNFC_S,
     &        MTINV_S, MTRUE_S, JMLTRUE_S, 
     &        LLCOL_S, NFSPEC_S, NLSPEC_S, MXLSPEC_S, 
     &        JMB_S, JME_S, JNB_S, 
     &        JNE_S, NTRNS_S, NLTSTEPS, P01_S, L01_S, 
     &        P11_S, L11_S, MXLLAT_S, NLLAT_S, NLLATH_S, 
     &        LATTRUE_S, NDLAT_S, 
     &        MXLVER_S, NLVER_S, NDVER_S
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
