C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'problem.i'                                            *
C***********************************************************************
C* Common Block /PROBLEM/ contains the variables defining spectral     *
C* parameterization:                                                   *
C*                                                                     *       
C* DEFINITION OF ARRAY SIZES                                           *       
C* SPECTRAL SPACE TRUNCATION:                                          *
C*                                                                     *       
C*         |                                                           *       
C*         |                                                           *       
C*      KK |- - - - - - - - + + + + + + + + +                          *       
C*         |              + + + + + + + + + +   ^ NORTH-SOUTH          *       
C*         |            + + + + + + + + + + +   | LEGENDRE FUNCTION    *       
C*         |          + + + + + + + + + + + +                          *       
C*         |        + + + + + + + + + + + + .                          *       
C*         |      + + + + + + + + + + + +   .                          *       
C*         |    + + + + + + + + + + + +     .                          *       
C*         |  + + + + + + + + + + + +       .                          *       
C*   ^  NN |+ + + + + + + + + + + +         .                          *       
C*   |     |+ + + + + + + + + + +           .                          *       
C*   |     |+ + + + + + + + + +             .                          *       
C*   N     |+ + + + + + + + +               .                          *       
C*         |+ + + + + + + +                 .                          *       
C*         |+ + + + + + +                   .                          *       
C*       . |+ + + + + +                     .                          *       
C*       . |+ + + + +                       .                          *       
C*       . |+ + + +                         .                          *       
C*       2 |+ + +                           .                          *       
C*       1 |+ +                             .                          *       
C*       0 |+_______________________________._________________         *       
C*          0 1 2 ...                      MM                          *       
C*                                                                     *       
C*                                M --->                               *       
C*              (EAST-WEST FOURIER WAVENUMBER)                         *
C*                                                                     *       
C*    PRBINPUT- name of file containing problem parameters             *
C*    MM    - spectral truncation parameters illustrated               *
C*    NN                                                               *
C*    KK                                                               *
C*    NLAT  - number of gaussian latitudes. For reasons of efficiency  *
C*            NLAT is required to be an even number.                   *
C*    NLON  - number of longitudes. For the current FFT transform,     *
C*            NLON must be a power of 2.                               *
C*    NVER  - number of (simulated) vertical layers. The same          *
C*            computation is done in all layers.                       *
C*    NALP  - number of Associated Legendre Polynomials.               *
C*    NFC   - number of complex Fourier coefficients.                  *
C*    LRM   - length of the Belousov recurrence coefficient matrices   *
C*    NGRPHS- amount of storage allocated for energetics graphs (for   *
C*            future (re)introduction of a graphics option in pstswm)  *
C***********************************************************************
      INTEGER MM, NN, KK, NLAT, NLON, NVER, NFC, NALP, LRM, NGRPHS
      COMMON  / PROBLEM / 
     &        MM, NN, KK, NLAT, NLON, NVER, NFC, NALP, LRM, NGRPHS
C*                                                                     *
      CHARACTER*32 PRBINPUT
      COMMON  / PROBLEM /
     &        PRBINPUT
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
