C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'bubfnc.i'                                             *
C***********************************************************************
C* Statement functions for zonal flow functions and derivatives        *
C*                                                                     *
C*    SINLAT - arguments for statement functions, required to be       *
C*    COSLAT   SIN(RLAT) and COS(RLAT), respectively, for some latitude*
C*             RLAT                                                    *
C*    BUBFNC - functional form of U BAR. (See paper by                 *
C*             Browning et. al., A Comparison of Three Numerical       *
C*             Methods ... (equation 5.10a)*COS(RLAT))                 *
C*    DBUBF  - functional form of 1st derivative of big U BAR (BUBFNC) *
C*    D2BUBF - functional form of 2nd derivative of big U BAR (BUBFNC) *
C***********************************************************************
      REAL SINLAT, COSLAT
      REAL BUBFNC, DBUBF, D2BUBF
C*                                                                     *
      BUBFNC(SINLAT,COSLAT) = SU0*(2.0*SINLAT*COSLAT)**NPWR      
      DBUBF(SINLAT,COSLAT)  = 2.0*SU0*(2.0*SINLAT*COSLAT)**(NPWR-1)
     &                        *((NPWR)-(2*NPWR+1)*SINLAT*SINLAT)
      D2BUBF(SINLAT,COSLAT) = 
     &  8.0*SU0*(2.0*SINLAT*COSLAT)**(NPWR-3)*SINLAT*
     &  (((NPWR-1)*NPWR)+SINLAT*SINLAT*((NPWR-1)-
     &  (2*NPWR*(2*NPWR+1))*COSLAT*COSLAT))
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************
