MODULE qmrpack
  INTERFACE uqmr
     SUBROUTINE DUQMR (NDIM,NLEN,NLIM,MAXVW,M,NORM,DWK,IDX,IWK,VECS,TOL,INFO)
       INTEGER, INTENT(in) :: ndim, nlen, m
       INTEGER, INTENT(inout) :: nlim, maxvw
       REAL(KIND(1.d0)), INTENT(inout) :: norm
       REAL(KIND(1.d0)), DIMENSION(m,*), INTENT(out) :: dwk
       INTEGER, DIMENSION(4,*), INTENT(out) :: idx
       INTEGER, DIMENSION(m,4), INTENT(out) :: iwk
       REAL(KIND(1.d0)), DIMENSION(ndim,*), INTENT(inout) :: vecs
       REAL(KIND(1.d0)), INTENT(inout) :: tol
       INTEGER, DIMENSION(4), INTENT(inout) :: info
     END SUBROUTINE duqmr
     SUBROUTINE SUQMR (NDIM,NLEN,NLIM,MAXVW,M,NORM,DWK,IDX,IWK,VECS,TOL,INFO)
       INTEGER, INTENT(in) :: ndim, nlen, m
       INTEGER, INTENT(inout) :: nlim, maxvw
       REAL(KIND(1.e0)), INTENT(inout) :: norm
       REAL(KIND(1.e0)), DIMENSION(m,*), INTENT(out) :: dwk
       INTEGER, DIMENSION(4,*), INTENT(out) :: idx
       INTEGER, DIMENSION(m,4), INTENT(out) :: iwk
       REAL(KIND(1.e0)), DIMENSION(ndim,*), INTENT(inout) :: vecs
       REAL(KIND(1.e0)), INTENT(inout) :: tol
       INTEGER, DIMENSION(4), INTENT(inout) :: info
     END SUBROUTINE suqmr
     SUBROUTINE CUQMR (NDIM,NLEN,NLIM,MAXVW,M,NORM,ZWK,DWK,IDX,IWK,VECS,&
                      & TOL,INFO)
       INTEGER, INTENT(in) :: ndim, nlen, m
       INTEGER, INTENT(inout) :: nlim, maxvw
       REAL(KIND(1.e0)), INTENT(inout) :: norm
       COMPLEX(KIND(1.e0)), DIMENSION(m,*), INTENT(out) :: zwk
       REAL(KIND(1.e0)), DIMENSION(m,*), INTENT(out) :: dwk
       INTEGER, DIMENSION(3,*), INTENT(out) :: idx
       INTEGER, DIMENSION(m,4), INTENT(out) :: iwk
       COMPLEX(KIND(1.e0)), DIMENSION(ndim,*), INTENT(inout) :: vecs
       REAL(KIND(1.e0)), INTENT(inout) :: tol
       INTEGER, DIMENSION(4), INTENT(inout) :: info
     END SUBROUTINE cuqmr
     SUBROUTINE ZUQMR (NDIM,NLEN,NLIM,MAXVW,M,NORM,ZWK,DWK,IDX,IWK,VECS,&
                      & TOL,INFO)
       INTEGER, INTENT(in) :: ndim, nlen, m
       INTEGER, INTENT(inout) :: nlim, maxvw
       REAL(KIND(1.d0)), INTENT(inout) :: norm
       COMPLEX(KIND(1.d0)), DIMENSION(m,*), INTENT(out) :: zwk
       REAL(KIND(1.d0)), DIMENSION(m,*), INTENT(out) :: dwk
       INTEGER, DIMENSION(3,*), INTENT(out) :: idx
       INTEGER, DIMENSION(m,4), INTENT(out) :: iwk
       COMPLEX(KIND(1.d0)), DIMENSION(ndim,*), INTENT(inout) :: vecs
       REAL(KIND(1.d0)), INTENT(inout) :: tol
       INTEGER, DIMENSION(4), INTENT(inout) :: info
     END SUBROUTINE zuqmr
  END INTERFACE
END MODULE qmrpack
