import odeToJava.*;
import odeToJava.modules.*;
import odeToJava.functions.*;

/*
   class containing the main method that tests out the Implicit-Explicit
   Runge-Kutta /w Step Doubling solver, and several other modules of the
   package
*/
public class ImexSDTest
{
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] u = new double[20];

          u[0] = 0.0;
          u[1] = 0.2;
          u[2] = 0.0;
          u[3] = 0.04;
          u[4] = 0.0;
          u[5] = 0.0;
          u[6] = 0.1;
          u[7] = 0.3;
          u[8] = 0.01;
          u[9] = 0.0;
          u[10] = 0.0;
          u[11] = 0.0;
          u[12] = 0.0;
          u[13] = 0.0;
          u[14] = 0.0;
          u[15] = 0.0;
          u[16] = 0.007;
          u[17] = 0.0;
          u[18] = 0.0;
          u[19] = 0.0;

          // run an Imex Step Doubling scheme with the desired parameters

          /*
             Here we run an Imex /w step doubling scheme with the parameters we
             have created above.  Here is an explanation of the parameters/arguments:

             1) new Pollution() -> the function (a stiff ODE)

             2) new Span(0.0, 60.0) -> the Span object: the Imex /w step doubling solver
             can take in the 2 types of enhanced Span objects, but it will not do
             interpolation (so you might as well use only basic Span objects with
             this solver)

             3) u -> the initial value to the IVP (a stiff IVP)

             4) 1.0E-4 -> this is the intial stepsize, but if this argument is less
             than or equal to 0 an error will be produced (becuase even though this
             routine has automatic stepsize control, it doesn't have an initial
             stepsize selection routine

             5) new Btableau("imex443") -> this is the pre-defined IMEX443 Butcher tableau,
             found in the Btableau module of the modules folder, which determines the scheme.
             This solver can only handle RK schemes in autonomous form that are not embedded
             and have no interpolant.  As this is a stiff solver it is recommended that
             it be used for stiff schemes for maximum efficiency

             6) 1.0E-12 -> this is the absolute tolerance value.  Note that this is one
             of the solvers that takes in a scalar tolerance for automatic stepsize
             control as opposed to a vector

             8) 1.0E-6 -> this is the relative tolerance value (this one is also a scalar
             as opposed to a vector)

             9) "" -> placeholder for a filename for solution to be written to

             10) "Stats_On" -> stats output is turned off
 
             Note that this solver does not take in a highOrder argument or the String
             options for stiffness detection and event location.  This is because this
             is a basic solver with no embedded schemes (has a different kind of stepsize
             control known as step doubling) and no stiffness detection or event location
          */

          ImexSD.imex_sd(new Pollution(), new Span(0.0, 60.0), u, 1.0E-4, new Btableau("imex443"), 1.0E-12, 1.0E-6, "", "Stats_Off");
     }
}
