import odeToJava.modules.*;

/*
   Here is how you would write an ODE function that you would want to solve
   with the solvers in this package.  Any function that you write has to
   implement the class ODE, so you always have to have:
   public class [something] implements ODE.  ODE is the base class that is
   used in all of these solvers and you have to associate all functions
   with this one to run it properly (it's an object oriented thing).  Since
   all ODE's can be expressed as x' = f(t,x), that is exactly the function
   you need.  It takes in the time t, and the vector x, and returns x',
   simple as that.  ODE has this function in its interface (as a dummy
   function), so when you go to write an ODE function, you have to overload
   this function with one that is meaningful, and again, the function must be:
   public double[] f(double t, double[] x), then inside this function
   (method) body, something that represents an ODE.  This one below is the
   implementation of Pleiades problem.  This problem will be used in
   conjunction with the ErkTriple tester (for more information refer to
   erkTriple.java).  Note that the few pre-defined ODE functions in the
   functions directory can be looked at to learn more about implementing
   functions, and also note that all of these implement the ODE class, and
   overload the public double[] f method.  Note also that all functions that
   are implemented also overload the g method.  The g method must be:
   public double[] g(double t, double[] x).  The g method is used for event
   location, so it is only used with solvers with event location.  How the
   g function works, is that the user can define g so that its return value
   is zero at a cerain t and x.  The user can then solve an ODE with
   a solver that does event location and the solver will halt the integration
   when g equals zero, when an event has occured.  Most functions pre-defined
   for use with this package have an empty implementation of g (as does this
   function), as most do not have events associated with them
*/
public class PlFTest implements ODE
{
     // constructors
	
     // methods
	
     public double[] f(double t, double[] x)
     {
          final int PRIME_OFFSET = 14;   // offsets for section partitions
          final int Y_OFFSET = 7;   // (x0 - y0 - x0' - y0')

          double[][] R = new double[Y_OFFSET][Y_OFFSET];   // the R matrix:
          for(int i= 0; i< Y_OFFSET; i++)   // (R[i][j] = r[i][j]^(3/2)), all values
               for(int j= 0; j< Y_OFFSET; j++)   // default to -1
                    R[i][j] = -1;

          double[] xp = new double[x.length];

          for(int i= 0; i< PRIME_OFFSET; i++)   // set up z' (x' and y')
               xp[i] = x[i + PRIME_OFFSET];
	
          for(int i= 0; i< Y_OFFSET; i++)   // set up x"
          {			
               double sum = 0.0;
               for(int j= 0; j< Y_OFFSET; j++)
               {
                    // for efficiency we only compute each R[i][j] once, then we just
                    // refer to R[i][j] in the R matrix if we need it again
                    if(R[i][j] == -1)
                         R[i][j] = Math.pow((Math.pow((x[i] - x[j]),2) + Math.pow((x[i + Y_OFFSET] - x[j + Y_OFFSET]),2)),((3.0)/(2.0)));
				
                    // f[i] = sigma(j=1:7;j!=i){m[j]*(x[j] - x[i])/r[i][j]^(3/2)}
                    if(j != i)
                         sum += (j+1)*(x[j] - x[i])/R[i][j];
               }

               xp[i + PRIME_OFFSET] = sum;
               sum = 0.0;   // reset sum for the next term
          }

          for(int i= Y_OFFSET; i< PRIME_OFFSET; i++)   // set up y" very similar
          {   // setup as that for x''
               double sum = 0.0;
               for(int j= 0; j< Y_OFFSET; j++)
               {
                    if(R[i - Y_OFFSET][j] == -1)
                         R[i - Y_OFFSET][j] = Math.pow((Math.pow((x[i - Y_OFFSET] - x[j]),2) + Math.pow((x[i] - x[j + Y_OFFSET]),2)),((3.0)/(2.0)));
			
                    if(j != (i - Y_OFFSET))
                         sum += (j+1)*(x[j + Y_OFFSET] - x[i])/R[i - Y_OFFSET][j];
               }

               xp[i + PRIME_OFFSET] = sum;
               sum = 0.0;
          }

          return(xp);
     }

     public double[] g(double t, double[] x)
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this function
          return(event);
     }
}