import odeToJava.*;
import odeToJava.modules.*;
import odeToJava.functions.*;

/*
   class containing the main method that tests out the Explicit Runge-Kutta
   /w Step Doubling solver, and several other modules of the package
*/
public class ErkSDTest
{
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[28];
		
          x[0] = 3.0;
          x[1] = 3.0;
          x[2] = -1.0;
          x[3] = -3.0;
          x[4] = 2.0;
          x[5] = -2.0;
          x[6] = 2.0;

          x[7] = 3.0;
          x[8] = -3.0;
          x[9] = 2.0;
          x[10] = 0.0;
          x[11] = 0.0;
          x[12] = -4.0;
          x[13] = 4.0;

          x[14] = 0.0;
          x[15] = 0.0;
          x[16] = 0.0;
          x[17] = 0.0;
          x[18] = 0.0;
          x[19] = 1.75;
          x[20] = -1.5;

          x[21] = 0.0;
          x[22] = 0.0;
          x[23] = 0.0;
          x[24] = -1.25;
          x[25] = 1.0;
          x[26] = 0.0;
          x[27] = 0.0;

          // run an Explicit Runge-Kutta /w Step Doubling scheme with
          // the desired parameters

          /*
             Here we run an Explicit RK /w step doubling scheme with the
             parameters we've created above.  Here's an explanation of the
             parameters/arguments:

             1) new Pleiades() -> the function

             2) new Span(0.0, 3.0) -> the Span object: the Erk /w step doubling solver
             can take in the 2 types of enhanced Span objects, but it will not do
             interpolation (so you might as well use only basic Span objects with
             this solver)

             3) x -> the initial value to the IVP

             4) 1.0E-2 -> this is the intial stepsize, but if this argument is less
             than or equal to 0 an error will be produced (becuase even though this
             routine has automatic stepsize control, it doesn't have an initial
             stepsize selection routine)

             5) new Btableau("erk4") -> this is the pre-defined classic ERK4 Butcher
             tableau, found in the Btableau module of the modules folder, which
             determines the scheme.  This solver can only handle RK schemes that are
             not embedded and have no interpolant

             6) 1.0E-12 -> this is the absolute tolerance value.  Note that this is one
             of the solvers that takes in a scalar tolerance for automatic stepsize
             control as opposed to an array

             8) 1.0E-6 -> this is the relative tolerance value (this one is also a scalar
             as opposed to an array)

             9) "" -> placeholder for a filename for solution to be written to

             10) "Stats_On" -> statistics output is turned off
 
             Note that this solver does not take in a highOrder argument or the String
             options for stiffness detection and event location.  This is because this
             is a basic solver with no embedded schemes (has a different kind of stepsize
             control known as step doubling) and no stiffness detection or event location
          */

          ErkSD.erk_sd(new Pleiades(), new Span(0.0, 3.0), x, 1.0E-2, new Btableau("erk4"), 1.0E-12, 1.0E-6, "", "Stats_Off");
     }
}
