import odeToJava.*;   // imports to allow use of package components
import odeToJava.modules.*;
import odeToJava.functions.*;
import odeToJava.plotter.*;

public class F5_dopr
{
     /*
        main
     */
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[1];

          x[0] = 1.0;

          // the tolerances

          double[] atol = new double[1];
          for(int i= 0; i< 1; i++)
               atol[i] = 1.0E-6;   // absolute tolerance 1E-6

          double[] rtol = new double[1];
          for(int i= 0; i< 1; i++)
               rtol[i] = 1.0E-4;   // relative tolerance 1E-4

          // solution interval

          double t0 = 0.0;
          double tf = 20.0;

          // call the DormandPrince routine to solve from [t0, tf]

          double start = System.currentTimeMillis();   // start the timer

          // *note that we do not solve this problem with event location because
          // it's easier to just solve it through with one call

          DormandPrince.dormand_prince(new F5(), new Span(t0, tf), x, -1.0, atol, rtol, "f5_dopr.txt", "StiffDetect_Off", "EventLoc_Off", "Stats_Off");

          double stop = System.currentTimeMillis();   // stop the timer

          System.out.println();
          System.out.println("time in milliseconds:");   // output the time
          System.out.println(stop - start);

          Plotter.showPlotter();
     }
}
