import odeToJava.*;   // imports to allow use of package components
import odeToJava.modules.*;
import odeToJava.functions.*;
import odeToJava.plotter.*;

public class F2_dopr_locOn
{
     /*
        main
     */
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[1];

          x[0] = 110.0;

          // the tolerances

          double[] atol = new double[1];
          for(int i= 0; i< 1; i++)
               atol[i] = 1.0E-6;   // absolute tolerance 1E-6

          double[] rtol = new double[1];
          for(int i= 0; i< 1; i++)
               rtol[i] = 1.0E-4;   // relative tolerance 1E-4

          // solution interval

          double t0 = 0.0;
          double tf = 20.0;

          // a few variables used in the loop, some initialized to prime the loop

          double hInit = -1.0;
          double tStar = t0;

          ODE function;   // function used for small forward Euler step
          double hfe = 1.0E-14;   // stepsize for small forward Euler step

          // here's where we start timing the solution

          double start = System.currentTimeMillis();   // start the timer

          for(int i= 0; i< 10; i++)
          {               
               // we do one call to the DormandPrince solver to solve the first
               // piece of the function until we hit an event

               double[] profile = DormandPrince.dormand_prince(new F2(1), new Span(tStar, tf), x, hInit, atol, rtol, "f2_dopr_locOn.txt", "StiffDetect_Off", "EventLoc_Halt", "Stats_Off", "Append");

               // we then get some stats from this routine to use in the second call to dopr

               hInit = profile[0];   // get h (avg)
               tStar = profile[1];   // get t*

               x[0] = profile[2];   // get y*

              // we then do a small forward Euler step to avoid any event location discrepencies

               function = new F2(2);   // note that we do FE with the function that will
                  // be used in the next DormandPrince call
               
               x[0] = x[0] + hfe * function.f(tStar, x)[0];   // update y* with y* + h*f(t*, y*)
               
               tStar = tStar + hfe;   // update t* with t* + h

               // we make a second DormandPrince solver call to solve the second
               // piece of the function until we hit an event

               double[] profile2 = DormandPrince.dormand_prince(new F2(2), new Span(tStar, tf), x, hInit, atol, rtol, "f2_dopr_locOn.txt", "StiffDetect_Off", "EventLoc_Halt", "Stats_Off", "Append");

               // we then get some stats from this scheme to use in the first call to dopr of
               // the next loop iteration

               hInit = profile2[0];   // get h (average)
               tStar = profile2[1];   // get t*
               
               x[0] = profile2[2];   // get y*

               // we then do a small forward euler step to avoid any event location discrepencies

               function = new F2(1);   // note that we do FE with the function that will
                  // be used in the next Dormand-Prince call
               
               x[0] = x[0] + hfe * function.f(tStar, x)[0];   // update y* with y* + h*f(t*, y*)
               
               tStar = tStar + hfe;   // update t* with t* + h
          }

          double stop = System.currentTimeMillis();   // stop the timer

          System.out.println();
          System.out.println("time in milliseconds:");   // output the time
          System.out.println(stop - start);

          Plotter.showPlotter();
     }
}
