import odeToJava.*;   // imports to allow use of package components
import odeToJava.functions.*;
import odeToJava.modules.*;
import odeToJava.plotter.*;

public class Ball_ODE_dopr_locBounce
{
     /*
        main
     */
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[4];

          x[0] = 0.0;   // starting at x position 0
          x[1] = 10.0;   // starting at y postion 10 (10 meters above ground)
          x[2] = 40.0;   // ball has initial x velocity of 40 m/s
          x[3] = 0.0;   // ball has initial y velocity of 0 m/s (throwing sideways)

          // the tolerances

          double[] atol = new double[4];
          for(int i= 0; i< 4; i++)
               atol[i] = 1.0E-6;   // absolute tolerance 1E-6

          double[] rtol = new double[4];
          for(int i= 0; i< 4; i++)
               rtol[i] = 1.0E-4;   // relative tolerance 1E-4

          // solution interval

          double t0 = 0.0;
          double tf = 60.0;   // tracking the ball for a minute

          // a few variables used in the loop which are initialized to prime the loop

          double hInit = -1.0;
          double tStar = t0;

          ODE function;   // function used for small forward Euler step
          double hfe = 1.0E-14;   // stepsize for small forward Euler step

          // here's where we start timing the integration

          double start = System.currentTimeMillis();   // start the timer

          for(int i= 0; i< 8; i++)
          {               
               // we do one call to the DormandPrince solver to solve the
               // function until we hit an event (until the ball hits the floor)

               double[] profile = DormandPrince.dormand_prince(new Ball_ODE(), new Span(tStar, tf, 0.01), x, hInit, atol, rtol, "Ball_ODE_dopr_locBounce.txt", "StiffDetect_Off", "EventLoc_Halt", "Stats_Off", "Append");

               // we then get some stats from this scheme to use in the next call to dopr (after
               // the ball bounces off of the floor)

               hInit = profile[0];   // get h (average)
               tStar = profile[1];   // get t*

               // positions are not affected by events (ball hitting things), so we don't
               // modify these upon events

               x[0] = profile[2];
               x[1] = profile[3];

               // velocities are affected by events, so we modify these, depending on event

               if((x[0] <= 305.0) && (x[0] >= 295.0))   // if the ball
               {   // has hit the wall:
                    x[2] = profile[4] * -0.9;   // reverse x velocity, as ball hits wall
                    x[3] = profile[5];
               }
               else   // else the ball has hit the floor:
               {
                    x[2] = profile[4];
                    x[3] = profile[5] * -0.9;   // reverse y velocity, as ball bounces
               }

               // we then do a small forward Euler step to avoid any event location discrepencies

               function = new Ball_ODE();   // note that we do FE with the function that will
                  // be used in the next Dormand-Prince call
               
               x[0] = x[0] + hfe * function.f(tStar, x)[0];   // update y* with y* + h*f(t*, y*)
               x[1] = x[1] + hfe * function.f(tStar, x)[1];
               x[2] = x[2] + hfe * function.f(tStar, x)[2];
               x[3] = x[3] + hfe * function.f(tStar, x)[3];
               
               tStar = tStar + hfe;   // update t* with t* + h
          }

          double stop = System.currentTimeMillis();   // stop the timer

          System.out.println();
          System.out.println("time in milliseconds:");   // output the time
          System.out.println(stop - start);

          Plotter.showPlotter();   // call up the plotter to plot result
     }
}
