import odeToJava.*;   // import for use of package components
import odeToJava.modules.*;
import odeToJava.functions.*;
import odeToJava.plotter.*;
import odeToJava.interpolants.*;

/*
   the template class (this template covers most problems this solver can solve except
   for piecewise functions with event location.  To see info on those go to the
   discontinuous_problems in the testers directory)
*/
public class ErkTripleTemplate
{
     /*
        main
     */
     public static void main(String[] args)
     {

          /*
             this is where the template essentially starts
          */

          // the function
          
          ODE function = new FunctionTemplate();   // define function in FunctionTemplate.java

          // the span
          
          Span span = new Span(/*"here"*/);   // put in "here" one of the 3 span constructor schemes

          // the initial vector value(s)

          int n =   // indicate the dimension of the problem

          double[] x = new double[n];   // initialize array object

          x[0] =   // fill the array with the initial values
          // etc . . .

          // initial stepsize
          
          double h0 = -1.0;   // set -1 as default (initial stepsize selection routine will be used)

          // the Butcher tableau

          int s =   // specify the stage of the method

          double[][] a = new double[s][s];   // initialize components
          double[] b = new double[s];
          double[] bEmb = new double[s];
          Btheta btheta;   // the interpolant
          double[] c = new double[s];
          String FSAL;   // whether to enable first same as last (if the scheme has this property)

          a[0][0] =   // fill in tableau's a matrix
          // etc . . .
      		
          b[0] =   // fill in tableau's b array
          // etc . . .

          bEmb[0] =   // fill in tableau's embedded part
          // etc . . .

          btheta =   // initialize tableau's Btheta object to some interpolant
		
          c[0] =   // fill in tableau's c array

          FSAL =   // choose 1) "FSALenabled or 2) "FSALdisabled"

          Btableau butcher = new Btableau(a, b, bEmb, btheta, c, FSAL);   // initialize object with components

          // the highOrder argument
          
          double highOrder = 5.0;   // set 5 as default (is highOrder of dopr)

          // absolute tolerance vector

          double[] atol = new double[n];

          atol[0] =   // fill in values
          // etc . . .

          for(int i= 0; i< n; i++)   // or use a for loop to
               atol[i] =   // assign the same value to all elements

          // relative tolerance vector

          double[] rtol = new double[n];
          
          rtol[0] =   // fill in values
          // etc . . .

          for(int i= 0; i< n; i++)   // or use a for loop to
               rtol[i] =   // assign the same value to all elements

          // the file name
          
          String fileName = "";   // default to no file writing

          // stiffness detection option
          
          String stiffnessDetection =   // choose 1) "StiffDetect_Halt" or 2) "StiffDetect_Off"
          
          // event location option
          
          String eventLocation =   // choose 1) "EventLoc_Halt" or 2) "EventLoc_Off"

          // stats option
          
          String stats =   // choose 1) "Stats_On" 2) "Stats_Intermediate or 3) "Stats_Off"

          /*
             this is where the template essentially ends
          */

          // run the Erk Triple scheme with above parameters

          ErkTriple.erk_triple(function, span, x, h0, butcher, highOrder, atol, rtol, fileName, stiffnessDetection, eventLocation, stats);
     }
}
