package odeToJava.plotter;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.*;
import java.awt.*;

/*
   class is the main frame that holds the main graph panel, it also
   self terminates when the window is closed
*/
public class Plotter extends JFrame
{
     //call this to run the plotter
	public static void showPlotter()
	{
		Plotter plotterFrame = new Plotter();
		plotterFrame.show();
	}
	
	//call this to run the plotter with a
	//file initially chosen
	public static void showPlotter(String fileName)
	{
		Plotter plotterFrame = new Plotter();
		plotterFrame.selectFile(fileName);
		plotterFrame.show();
	}
	
	// constructors
     public Plotter()
     {
          try   // change the look and feel to that of the system
          {
               UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
          }
          catch(Exception e)
          {
               System.err.println("Error loading L&F: " + e);
          }

          this.setSize(WIDTH, HEIGHT);   // set dimensions and title of frame
          this.setTitle(TITLE);
      
          main = new MainPanel();   // initialize the panels

          Container contentPane = getContentPane();   // add the panels to the
          contentPane.add(main, "Center");   // windows

          this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);   // make it so that the swing
             // window closes when the user clicks on the "X" in the upper right corner
     }
	
	public void selectFile(String fileName)
	{
		main.selectFile(fileName);
	}
	
     /*
        the main method is also defined in this class in case the user just wants to
        to run the plotter alone (then he or she does not have to make a program just
        to run the plotter) 
	   Usage: java odeToJava.plotter.Plotter [filename]
     */
     public static void main(String[] args)
     {
		//Special code to show the plotter, and make the program close
		//when the plotter is closed. Normally, to run the plotter,
		//one only needs to call:
		//Plotter.showPlotter(); 
		// or
		//Plotter.showPlotter("filename");
		
		Plotter thePlotter = new Plotter();
		thePlotter.setDefaultCloseOperation(Plotter.EXIT_ON_CLOSE);
		
		if(args.length > 0)
			thePlotter.selectFile(args[0]);
		thePlotter.show();
     }

     // instance variables
   
     private final int WIDTH = 750;
     private final int HEIGHT = 550;
     private final String TITLE = "Plotter";
	
	public final static boolean DEBUG = false;
	
	private MainPanel main;
}