package odeToJava.plotter;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/*
   class contains all of the contents of the plotter:
   it is the panel that is just inside the outside frame
*/
public class MainPanel extends JPanel
{
     // constructors

     public MainPanel()
     {
          mainLayout = new GraphPaperLayout(new Dimension(6,1), 4,4);
          this.setLayout(mainLayout);   // initialize and add layout to main
             // panel

          // initialize parameter panel, set up the layout, and add it to main panel

          paramPanel = new JPanel();

          paramLayout = new GraphPaperLayout(new Dimension(5,16), 4,4);
          paramPanel.setLayout(paramLayout);   // initialize and add layout to
             // parameter panel

          this.add(paramPanel, new Rectangle(0,0,2,1));   // add parameter panel to
             // the main panel

		listener = new UIListener();   // initialize button action listener

          // initialize all the pairs of labels and fields

          fileLabel = new JLabel("file name");
          fileField = new JTextField(5);
		fileButton = new JButton("Choose...");
		fileButton.setActionCommand(CHOOSE_FILE_EVENT);
		fileButton.addActionListener(listener);
		

          tVectorLabel = new JLabel("Index for x (or t for time)");
          tVectorField = new JTextField(2);      
          yVectorLabel = new JLabel("Index for y (or t for time)");
          yVectorField = new JTextField(2);
      
          titleLabel = new JLabel("title");
          titleField = new JTextField(5);
          xAxisLabel = new JLabel("x label");
          xAxisField = new JTextField(5);
          yAxisLabel = new JLabel("y label");
          yAxisField = new JTextField(5);

          xlBoundLabel = new JLabel("x axis        from");
          xlBoundField = new JTextField(2);
          xuBoundLabel = new JLabel("       to");
          xuBoundField = new JTextField(2);
          xTickLabel = new JLabel("x tick");
          xTickField = new JTextField(2);

          ylBoundLabel = new JLabel("y axis        from");
          ylBoundField = new JTextField(2);
          yuBoundLabel = new JLabel("       to");
          yuBoundField = new JTextField(2);
          yTickLabel = new JLabel("y tick");
          yTickField = new JTextField(2);

          // add labels and fields to the panel

          paramPanel.add(fileLabel, new Rectangle(0,0,3,1));
          paramPanel.add(fileField, new Rectangle(2,0,2,1));
		paramPanel.add(fileButton, new Rectangle(1,1,3,1));
      
          paramPanel.add(tVectorLabel, new Rectangle(0,3,4,1));
          paramPanel.add(tVectorField, new Rectangle(4,3,1,1));
          paramPanel.add(yVectorLabel, new Rectangle(0,4,4,1));
          paramPanel.add(yVectorField, new Rectangle(4,4,1,1));
      
          paramPanel.add(titleLabel, new Rectangle(0,5,2,1));
          paramPanel.add(titleField, new Rectangle(2,5,2,1));
          paramPanel.add(xAxisLabel, new Rectangle(0,6,2,1));
          paramPanel.add(xAxisField, new Rectangle(2,6,1,1));
          paramPanel.add(yAxisLabel, new Rectangle(0,7,2,1));
          paramPanel.add(yAxisField, new Rectangle(2,7,1,1));

          paramPanel.add(xlBoundLabel, new Rectangle(0,9,2,1));
          paramPanel.add(xlBoundField, new Rectangle(2,9,1,1));
          paramPanel.add(xuBoundLabel, new Rectangle(3,9,1,1));
          paramPanel.add(xuBoundField, new Rectangle(4,9,1,1));
          paramPanel.add(xTickLabel, new Rectangle(0,10,1,1));
          paramPanel.add(xTickField, new Rectangle(1,10,1,1));
      
          paramPanel.add(ylBoundLabel, new Rectangle(0,11,2,1));
          paramPanel.add(ylBoundField, new Rectangle(2,11,1,1));
          paramPanel.add(yuBoundLabel, new Rectangle(3,11,1,1));
          paramPanel.add(yuBoundField, new Rectangle(4,11,1,1));
          paramPanel.add(yTickLabel, new Rectangle(0,12,1,1));
          paramPanel.add(yTickField, new Rectangle(1,12,1,1)); 

          // initialize the button panel and add it to parameter panel
      
          JPanel buttonPanel = new JPanel();   // the button panel
      
          JButton updateButton = new JButton("update");   // the button

		updateButton.setActionCommand(UPDATE_EVENT); //set its command
          updateButton.addActionListener(listener);   // and add it to button
		
		
          buttonPanel.add(updateButton);   // add the button to the button panel

          paramPanel.add(buttonPanel, new Rectangle(0,14,5,2));   // add the button
             // panel to parameter panel
     }

     // methods

     public void upDateStatus() throws Exception
     {
          file = fileField.getText();   // assign all String variables their
             // respective values
          tVector = tVectorField.getText();
          yVector = yVectorField.getText();
		
		if(file.trim().equals(""))
			throw new Exception("Please enter a filename.");
		
		int col1 = 0,col2= 0;
		try
		{
			if(tVector.trim().equalsIgnoreCase("t"))
				col1 = 0;
			else
				col1 = Integer.parseInt(tVector) + 1;
			
			if(yVector.trim().equalsIgnoreCase("t"))
				col2 = 0;
			else
				col2 = Integer.parseInt(yVector) + 1;
		}
		catch(Exception e)
		{
			throw new Exception("Unknown variables. Enter variable index or t.");
		}

          title = titleField.getText();
          xAxis = xAxisField.getText();
          yAxis = yAxisField.getText();
   
          xlBound = xlBoundField.getText();
          xuBound = xuBoundField.getText();
          xTick = xTickField.getText();

          ylBound = ylBoundField.getText();
          yuBound = yuBoundField.getText();
          yTick = yTickField.getText();

          intake = new FileIntake(file);   // get the sets of points from
          intake.vectorize(col1, col2);   // files and make them arrays
      
          // initialize and add the plot panel to this panel

          if(graphPanel != null)   // remove the previous panel and add the updated one
               this.remove(graphPanel);

          graphPanel = new GraphPanel(intake.getVectorX(), intake.getVectorY(), xlBound, xuBound, ylBound, yuBound, title, xAxis, yAxis, xTick, yTick);
          this.add(graphPanel, new Rectangle(2,0,4,1));
          graphPanel.updateUI();   // update it so it will paint it now
     }
	
	
	public void chooseFileDialog()
	{
		JFileChooser chooser;
		
		try
		{
			//this may throw a NullPtr. Exception
			//if there is no text.
			chooser = new JFileChooser(fileField.getText());
		}
		catch(NullPointerException e)
		{
			//start at home directory otherwise
			chooser = new JFileChooser();
		}
		int fileStatus = chooser.showOpenDialog(this);
		if(fileStatus == JFileChooser.APPROVE_OPTION)
			selectFile(chooser.getSelectedFile().getPath());//select chosen file
	}
	
	public void selectFile(String fileName)
	{
		fileField.setText(fileName);
	}
   
     // instance variables

     private GraphPaperLayout mainLayout;

     private GraphPanel graphPanel;   // the panel of the actual plot (handled in
        // the upDateStatus method)
     private JPanel paramPanel;   // panel that holds all the plot parameters

     private GraphPaperLayout paramLayout;   // layout scheme for parameter panel
   
     private JLabel fileLabel;   // the label and field pairs
     private JTextField fileField;
	private JButton fileButton;
   
     private JLabel tVectorLabel;
     private JTextField tVectorField;      
     private JLabel yVectorLabel;
     private JTextField yVectorField;

     private JLabel titleLabel;
     private JTextField titleField;
     private JLabel xAxisLabel;
     private JTextField xAxisField;
     private JLabel yAxisLabel;
     private JTextField yAxisField;

     private JLabel xlBoundLabel;
     private JTextField xlBoundField;
     private JLabel xuBoundLabel;
     private JTextField xuBoundField;
     private JLabel xTickLabel;
     private JTextField xTickField;

     private JLabel ylBoundLabel;
     private JTextField ylBoundField;
     private JLabel yuBoundLabel;
     private JTextField yuBoundField;
     private JLabel yTickLabel;
     private JTextField yTickField;

     private JPanel radioButtonPanel;   // the radio button panel

     private JRadioButton linearButton;   // the radio buttons that go on the
     private JRadioButton semilogButton;   // radio button panel
     private JRadioButton loglogButton;

     private ButtonGroup typeGroup;   // the radio button group

     private JPanel buttonPanel;   // the button panel
   
     private JButton updateButton;   // the button that goes on button panel

     private ActionListener listener;   // listener for the update button

     private String file;   // Strings to store all of the text field contents
     private String tVector;
     private String yVector;
   
     private String title;
     private String xAxis;
     private String yAxis;
   
     private String xlBound;
     private String xuBound;
     private String xTick;

     private String ylBound;
     private String yuBound;
     private String yTick;
   
     private FileIntake intake;   // object reads in the files with the solutions and
        // puts them in arrays
	
	private static final String UPDATE_EVENT = "UPDATE_EVENT";
	private static final String CHOOSE_FILE_EVENT = "CHOOSE_FILE_EVENT";
	
     // private class
     private class UIListener implements ActionListener
     {
          public void actionPerformed(ActionEvent event)
          {
			String command = event.getActionCommand();
			if(command.equals(UPDATE_EVENT))
				try
				{
					upDateStatus();
				}
				catch(Exception e)
				{
					 JOptionPane.showMessageDialog(null, e.getMessage(),"Alert", JOptionPane.ERROR_MESSAGE);
					 if(Plotter.DEBUG)
						e.printStackTrace();//for debugging purposes
				}
			else if(command.equals(CHOOSE_FILE_EVENT))
				chooseFileDialog();
          }
     }
}