package odeToJava.plotter;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.lang.Double;

/*
   class creates a panel with cartesian coordinates for the plotter,
   given the parameters it takes in
*/
public class CoordPanel extends JPanel
{
     // constructors

     public CoordPanel(double aMin, double aMax, double aTick, String axis) throws Exception
     {
          // initializations
		this.min = aMin;
		this.max = aMax;
		this.tick = aTick;
		
          // the axis String parameter

          this.axis = axis.toString();
      
          if(!axis.equals("x") && !axis.equals("y"))//this should never happen, but just in case.
          {
               throw new Exception("Internal Error: Axis neither x or y.");
          }

          // calculations
      
          this.range = max - min;

          if((range/tick) > 50.0)   // if number of ticks is over 50, cut it back to 50
	         tick = range / 50.0;   // ticks so it does not overload computer with work
     }
      
     // methods

     public void paintComponent(Graphics g)
     {
          super.paintComponent(g);
          Graphics2D g2 = (Graphics2D)g;

          if(axis.equals("x"))
          {
               this.increment = min;

               mid = (double)this.getHeight()/2.0;
               high = (double)this.getHeight()/8.0;
               low = (double)this.getHeight();
               cFactor = (double)this.getHeight()/(3.5);

               graphMax = (double)this.getWidth()*(999.0/1000.0);
               graphTick = (tick/range)*(double)this.getWidth();
               graphInc = 0;

               stringEnd = (float)(this.getWidth()*0.04);

               this.nTicks = Math.floor(range/tick) + 1;
               this.skip = (int)Math.ceil(nTicks/8.0);
               this.count = 0;

               g2.draw(new Line2D.Double(0, cFactor, graphMax, cFactor));
               g2.draw(new Line2D.Double(graphMax, cFactor, graphMax, high));

               while(graphInc <= graphMax)
               {
                    g2.draw(new Line2D.Double(graphInc, cFactor, graphInc, high));

                    temp = String.valueOf(increment);

                    if(temp.length() > 5)
                         temp = temp.substring(0,4);

                    if((count % skip) == 0)
                         g2.drawString(temp, (float)graphInc, (float)low);

                    graphInc += graphTick;
                    increment += tick;
                    count++;
               }

               if((graphInc - graphTick) < (graphMax - 2*stringEnd))
               g2.drawString(String.valueOf(max), (float)(graphMax - stringEnd), (float)low);
          }
          else
          {
               this.increment = min;

               mid = (double)this.getWidth()/2.0;
               high = (double)this.getWidth()*(7.0/8.0);
               low = 0.0;
               cFactor = (double)(3.0)*this.getWidth()/4.0;

               graphMax = (double)this.getHeight()*(999.0/1000.0);
               graphTick = (tick/range)*(double)this.getHeight();
               graphInc = 0;
         
               stringEnd = (float)(this.getHeight()*0.04);

               this.nTicks = Math.floor(range/tick) + 1;
               this.skip = (int)Math.ceil(nTicks/10.0);
               this.count = 0;

               g2.draw(new Line2D.Double(cFactor, 0, cFactor, graphMax));
               g2.draw(new Line2D.Double(cFactor, graphMax, high, graphMax));

               while(graphInc <= graphMax)
               {
                    g2.draw(new Line2D.Double(cFactor, graphInc, high, graphInc));

                    temp = String.valueOf(increment);

                    if(temp.length() > 5)
                         temp = temp.substring(0,4);

                    if((count % skip) == 0)
                    {
                         g2.rotate((3.0)*Math.PI/(2.0), mid, (graphMax - graphInc));
                         g2.drawString(temp, (float)mid, (float)(graphMax - graphInc));
                         g2.rotate(Math.PI/(2.0), mid, (graphMax - graphInc));
                    }

                    graphInc += graphTick;
                    increment += tick;
                    count++;
               }

               if((graphInc - graphTick) < (graphMax - 2*stringEnd))
               {
                    g2.rotate((3.0)*Math.PI/(2.0), mid, stringEnd);
                    g2.drawString(String.valueOf(max), (float)mid, (float)(stringEnd));
                    g2.rotate((3.0)*Math.PI/(2.0), mid, stringEnd);
               }
          }
     }

     // instance variables

     private double min;
     private double max;
     private double tick;
     private String axis;
   
     private double range;
     private double increment;

     private double mid;
     private double high;
     private double low;
     private double cFactor;

     private double graphTick;
     private double graphMax;
     private double graphInc; 
     private float stringEnd;
     private String temp;
   
     private double nTicks;
     private int skip;
     private int count;
}
