package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE function for the van der Pol problem, a stiff ODE
*/
public class VanDerPol implements ODE
{
     // constructors

     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] xp = new double[x.length];

          xp[0] = x[1];
          xp[1] = ((1 - x[0]*x[0]) * x[1] - x[0])/ eps;

          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     // instance variables

     /*
        this class has instance variables, but it still properly
        implements Fv as it overloads the f and g methods
     */

     private final double eps = 0.000001;
}