package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE for the ring modulator problem of the CWI test set

   *** WARNING ***

   this problem is very stiff.  It hasn't actually been solved with this
   package of solvers, as it takes too long.  It still has been provided,
   however, as it may have some educational or experimental purpose
*/
public class RingMod implements ODE
{
     // constructors

     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] xp = new double[x.length];   // initialization

          xp[0] = (x[7] - 0.5*x[9] + 0.5*x[10] + x[13] - x[0]/R) / C;
          xp[1] = (x[8] - 0.5*x[11] + 0.5*x[12] + x[14] - x[1]/R) / C;
          xp[2] = (x[9] - q(UD1(t, x)) + q(UD4(t, x))) / Cs;
          xp[3] = (-1*x[10] + q(UD2(t, x)) - q(UD3(t, x))) / Cs;
          xp[4] = (x[11] + q(UD1(t, x)) - q(UD3(t, x))) / Cs;
          xp[5] = (-1*x[12] - q(UD2(t, x)) + q(UD4(t, x))) / Cs;
          xp[6] = (-1*x[6]/Rp + q(UD1(t, x)) + q(UD2(t, x)) - q(UD3(t, x)) - q(UD4(t, x))) / Cp;
          xp[7] = -1*x[0] / Lh;
          xp[8] = -1*x[1] / Lh;
          xp[9] = (0.5*x[0] - x[2] - Rg2*x[9]) / Ls2;
          xp[10] = (-0.5*x[0] + x[3] - Rg3*x[10]) / Ls3;
          xp[11] = (0.5*x[1] - x[4] - Rg2*x[11]) / Ls2;
          xp[12] = (-0.5*x[1] + x[5] - Rg3*x[12]) / Ls3;
          xp[13] = (-1*x[0] + Uin1(t) - (Ri + Rg1)*x[13]) / Ls1;
          xp[14] = (-1*x[1] - (Rc + Rg1)*x[14]) / Ls1;

          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     /*
        this class has auxillary functions and instance variables, but it still
        properly implements Fv as it overloads the f and g methods
     */

     /*
        1st of the 4 voltage equations, dealing with several of the voltages
        and the high frequency signal (Uin2) (a sum of these)
     */
     public double UD1(double t, double[] x)
     {
          return(x[2] - x[4] - x[6] - Uin2(t));
     }

     /*
        2nd of the 4 voltage equations, dealing with several of the voltages
        and the high frequency signal (Uin2) (a sum of these)
     */   
     public double UD2(double t, double[] x)
     {
          return(-1*x[3] + x[5] - x[6] - Uin2(t));
     }

     /*
        3rd of the 4 voltage equations, dealing with several of the voltages
        and the high frequency signal (Uin2) (a sum of these)
     */   
     public double UD3(double t, double[] x)
     {
          return(x[3] + x[4] + x[6] + Uin2(t));
     }

     /*
        4th of the 4 voltage equations, dealing with several of the voltages
        and the high frequency signal (Uin2) (a sum of these)
     */   
     public double UD4(double t, double[] x)
     {
          return(-1*x[2] - x[5] + x[6] + Uin2(t));
     }

     /*
        the diode function: a function of a voltage (exponential)
     */
     public double q(double U)
     {
          return(gamma * (Math.exp(delta * U) - 1));
     }

     /*
        equation for the low frequency signal as a function of time
        (sinusoidal)
     */
     public double Uin1(double t)
     {
          return(0.5 * Math.sin(2000.0 * Math.PI * t));
     }

     /*
        equation for the high frequency signal as a function of time
        (sinusoidal)
     */   
     public double Uin2(double t)
     {
          return(2.0 * Math.sin(20000.0 * Math.PI * t));
     }

     // instance variables

     private static final double C = 1.6 * 0.00000001;   // physical constants
     private static final double Cs = 2.0 * 0.000000000001;   // to be used
     private static final double Cp = 0.00000001;   // in ODE
     private static final double Lh = 4.45;
     private static final double Ls1 = 0.002;
     private static final double Ls2 = 5.0 * 0.0001;
     private static final double Ls3 = 5.0 * 0.0001;
     private static final double gamma = 40.67286402 * 0.000000001;
     private static final double R = 25000.0;
     private static final double Rp = 50.0;
     private static final double Rg1 = 36.3;
     private static final double Rg2 = 17.3;
     private static final double Rg3 = 17.3;
     private static final double Ri = 50.0;
     private static final double Rc = 600.0;
     private static final double delta = 17.7493332;
}