package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE for the pollution problem of the CWI test set
*/
public class Pollution implements ODE
{
     // constructors
	
     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] r = new double[25];   // initializations
          double[] xp = new double[x.length];

          r[0] = k[0]*x[0];   // r array is k's multiplied by reaction concentrations
          r[1] = k[1]*x[1]*x[3];
          r[2] = k[2]*x[4]*x[1];
          r[3] = k[3]*x[6];
          r[4] = k[4]*x[6];
          r[5] = k[5]*x[6]*x[5];
          r[6] = k[6]*x[8];
          r[7] = k[7]*x[8]*x[5];
          r[8] = k[8]*x[10]*x[1];
          r[9] = k[9]*x[10]*x[0];
          r[10] = k[10]*x[12];
          r[11] = k[11]*x[9]*x[1];
          r[12] = k[12]*x[13];
          r[13] = k[13]*x[0]*x[5];
          r[14] = k[14]*x[2];
          r[15] = k[15]*x[3];
          r[16] = k[16]*x[3];
          r[17] = k[17]*x[15];
          r[18] = k[18]*x[15];
          r[19] = k[19]*x[16]*x[5];
          r[20] = k[20]*x[18];
          r[21] = k[21]*x[18];
          r[22] = k[22]*x[0]*x[3];
          r[23] = k[23]*x[18]*x[0];
          r[24] = k[24]*x[19];
		
          xp[0] = -1*r[0] - r[9] - r[13] - r[22] - r[23] + r[1] + r[2] + r[8] + r[10] + r[11] + r[21] + r[24];
          xp[1] = -1*r[1] - r[2] - r[8] - r[11] + r[0] + r[20];   // the matrix
          xp[2] = -1*r[14] + r[0] + r[16] + r[18] + r[21];   // of values (a sum
          xp[3] = -1*r[1] - r[15] - r[16] - r[22] + r[14];   // of r's)
          xp[4] = -1*r[2] + 2*r[3] + r[5] + r[6] + r[12] + r[19];
          xp[5] = -1*r[5] - r[7] - r[13] - r[19] + r[2] + 2*r[17];
          xp[6] = -1*r[3] - r[4] - r[5] + r[12];
          xp[7] = r[3] + r[4] + r[5] + r[6];
          xp[8] = -1*r[6] - r[7];
          xp[9] = -1*r[11] + r[6] + r[8];
          xp[10] = -1*r[8] - r[9] + r[7] + r[10];
          xp[11] = r[8];
          xp[12] = -1*r[10] + r[9];
          xp[13] = -1*r[12] + r[11];
          xp[14] = r[13];
          xp[15] = -1*r[17] - r[18] + r[15];
          xp[16] = -1*r[19];
          xp[17] = r[19];
          xp[18] = -1*r[20] - r[21] - r[23] + r[22] + r[24];
          xp[19] = -1*r[24] + r[23];
		
          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     // instance variables

     /*
        this class has instance variables, but it still properly
        implements Fv as it overloads the f and g methods
     */
   
     private static final double[] k = {   // array of equilibrium constants
          0.350,
          0.266 * 100.0,
          0.123 * 100000.0,
          0.860 * 0.001,
          0.820 * 0.001,
          0.150 * 100000.0,
          0.130 * 0.001,
          0.240 * 100000.0,
          0.165 * 100000.0,
          0.900 * 10000.0,
          0.220 * 0.1,
          0.120 * 100000.0,
          0.188 * 10.0,
          0.163 * 100000.0,
          0.480 * 10000000.0,
          0.350 * 0.001,
          0.175 * 0.1,
          0.100 * 1000000000.0,
          0.444 * 1000000000000.0,
          0.124 * 10000.0,
          0.210 * 10.0,
          0.578 * 10.0,
          0.474 * 0.1,
          0.178 * 10000.0,
          0.312 * 10.0
     };
}