package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE function for a 3 body orbit problem
*/
public class Orbit implements ODE
{
     // constructors
	
     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] xp = new double[x.length];
		
          double d1 = Math.pow(Math.pow((x[0] + mu), 2) + x[1]*x[1], 1.5);
          double d2 = Math.pow(Math.pow((x[0] - muhat), 2) + x[1]*x[1], 1.5);

          xp[0] = x[2];
          xp[1] = x[3];
          xp[2] = x[0] + 2*x[3] - muhat*(x[0] + mu)/d1 - mu*(x[0] - muhat)/d2;
          xp[3] = x[1] - 2*x[2] - muhat*x[1]/d1 - mu*x[1]/d2;
		
          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     // instance variables

     /*
        this class has instance variables, but it still properly
        implements Fv as it overloads the f and g methods
     */

     private final double mu = 0.012277471;   // masses of planet and sun
     private final double muhat = 1.0 - mu;   // respectively
}